/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter.azure;

import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.security.keyvault.secrets.models.SecretProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.parameter.AbstractParameterProvider;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.ParameterGroup;
import org.apache.nifi.parameter.VerifiableParameterProvider;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.services.azure.AzureCredentialsService;

@Tags(value={"azure", "keyvault", "key", "vault", "secrets"})
@CapabilityDescription(value="Fetches parameters from Azure Key Vault Secrets.  Each secret becomes a Parameter, which map to a Parameter Group byadding a secret tag named 'group-name'.")
public class AzureKeyVaultSecretsParameterProvider
extends AbstractParameterProvider
implements VerifiableParameterProvider {
    public static final PropertyDescriptor AZURE_CREDENTIALS_SERVICE = new PropertyDescriptor.Builder().name("azure-credentials-service").displayName("Azure Credentials Service").description("Controller service used to obtain Azure credentials to be used with Key Vault client.").required(true).identifiesControllerService(AzureCredentialsService.class).build();
    public static final PropertyDescriptor KEY_VAULT_URI = new PropertyDescriptor.Builder().name("key-vault-uri").displayName("Key Vault URI").description("Vault URI of the Key Vault that contains the secrets").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor GROUP_NAME_PATTERN = new PropertyDescriptor.Builder().name("group-name-pattern").displayName("Group Name Pattern").description("A Regular Expression matching on the 'group-name' tag value that identifies Secrets whose parameters should be fetched. Any secrets without a 'group-name' tag value that matches this Regex will not be fetched.").addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).required(true).defaultValue(".*").build();
    static final String GROUP_NAME_TAG = "group-name";
    private static final List<PropertyDescriptor> PROPERTIES;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    public List<ParameterGroup> fetchParameters(ConfigurationContext context) throws IOException {
        SecretClient secretClient = this.configureSecretClient(context);
        List<KeyVaultSecret> secrets = this.getAllSecrets(secretClient);
        List<ParameterGroup> groups = this.getParameterGroupsFromSecrets(context, secrets);
        return groups;
    }

    public List<ConfigVerificationResult> verify(ConfigurationContext context, ComponentLog verificationLogger) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        try {
            List<ParameterGroup> parameterGroups = this.fetchParameters(context);
            int parameterCount = 0;
            for (ParameterGroup group : parameterGroups) {
                parameterCount += group.getParameters().size();
            }
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).verificationStepName("Fetch Parameters").explanation(String.format("Fetched secret keys [%d] as parameters, across groups [%d]", parameterCount, parameterGroups.size())).build());
        }
        catch (Exception e) {
            verificationLogger.error("Failed to fetch parameters", (Throwable)e);
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.FAILED).verificationStepName("Fetch Parameters").explanation("Failed to fetch parameters: " + e.getMessage()).build());
        }
        return results;
    }

    private List<KeyVaultSecret> getAllSecrets(SecretClient secretClient) {
        ArrayList<KeyVaultSecret> secrets = new ArrayList<KeyVaultSecret>();
        for (SecretProperties secretProperties : secretClient.listPropertiesOfSecrets()) {
            if (!secretProperties.isEnabled().booleanValue()) continue;
            KeyVaultSecret secretWithValue = secretClient.getSecret(secretProperties.getName(), secretProperties.getVersion());
            secrets.add(secretWithValue);
        }
        return secrets;
    }

    private List<ParameterGroup> getParameterGroupsFromSecrets(ConfigurationContext context, List<KeyVaultSecret> secrets) {
        HashMap<String, List<Parameter>> nameToParametersMap = new HashMap<String, List<Parameter>>();
        for (KeyVaultSecret secret : secrets) {
            String parameterName = secret.getName();
            String parameterValue = secret.getValue();
            Map tags = secret.getProperties().getTags();
            if (tags == null) {
                this.getLogger().debug("Secret with parameter name [{}] not recognized as a valid parameter since it does not have tags");
                continue;
            }
            String parameterGroupName = (String)tags.get(GROUP_NAME_TAG);
            if (parameterGroupName == null) {
                this.getLogger().debug("Secret with parameter name [{}] not recognized as a valid parameter since it does not have the [{}] tag", new Object[]{parameterName, GROUP_NAME_TAG});
                continue;
            }
            Pattern groupNamePattern = Pattern.compile(context.getProperty(GROUP_NAME_PATTERN).getValue());
            if (!groupNamePattern.matcher(parameterGroupName).matches()) {
                this.getLogger().debug("Secret [{}] with tag [{}] does not match the group name pattern {}", new Object[]{parameterName, parameterGroupName, groupNamePattern});
                continue;
            }
            nameToParametersMap.computeIfAbsent(parameterGroupName, groupName -> new ArrayList()).add(this.createParameter(parameterName, parameterValue));
        }
        return this.createParameterGroupFromMap(nameToParametersMap);
    }

    private List<ParameterGroup> createParameterGroupFromMap(Map<String, List<Parameter>> nameToParametersMap) {
        ArrayList<ParameterGroup> parameterGroups = new ArrayList<ParameterGroup>();
        for (Map.Entry<String, List<Parameter>> entry : nameToParametersMap.entrySet()) {
            String parameterGroupName = entry.getKey();
            List<Parameter> parameters = entry.getValue();
            parameterGroups.add(new ParameterGroup(parameterGroupName, parameters));
        }
        return parameterGroups;
    }

    private Parameter createParameter(String parameterName, String parameterValue) {
        ParameterDescriptor parameterDescriptor = new ParameterDescriptor.Builder().name(parameterName).build();
        return new Parameter(parameterDescriptor, parameterValue, null, Boolean.valueOf(true));
    }

    SecretClient configureSecretClient(ConfigurationContext context) {
        AzureCredentialsService credentialsService = (AzureCredentialsService)context.getProperty(AZURE_CREDENTIALS_SERVICE).asControllerService(AzureCredentialsService.class);
        String vaultUrl = context.getProperty(KEY_VAULT_URI).getValue();
        return new SecretClientBuilder().credential(credentialsService.getCredentials()).vaultUrl(vaultUrl).buildClient();
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(AZURE_CREDENTIALS_SERVICE);
        props.add(KEY_VAULT_URI);
        props.add(GROUP_NAME_PATTERN);
        PROPERTIES = Collections.unmodifiableList(props);
    }
}

