/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.ml.transcribe;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.transcribe.AmazonTranscribeClient;
import com.amazonaws.services.transcribe.AmazonTranscribeClientBuilder;
import com.amazonaws.services.transcribe.model.StartTranscriptionJobRequest;
import com.amazonaws.services.transcribe.model.StartTranscriptionJobResult;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.aws.ml.AwsMachineLearningJobStarter;
import org.apache.nifi.processors.aws.ml.transcribe.GetAwsTranscribeJobStatus;

@Tags(value={"Amazon", "AWS", "ML", "Machine Learning", "Transcribe"})
@CapabilityDescription(value="Trigger a AWS Transcribe job. It should be followed by GetAwsTranscribeStatus processor in order to monitor job status.")
@SeeAlso(value={GetAwsTranscribeJobStatus.class})
public class StartAwsTranscribeJob
extends AwsMachineLearningJobStarter<AmazonTranscribeClient, StartTranscriptionJobRequest, StartTranscriptionJobResult> {
    protected AmazonTranscribeClient createClient(ProcessContext context, AWSCredentialsProvider credentialsProvider, ClientConfiguration config) {
        return (AmazonTranscribeClient)((AmazonTranscribeClientBuilder)((AmazonTranscribeClientBuilder)AmazonTranscribeClient.builder().withRegion(context.getProperty(REGION).getValue())).withCredentials(credentialsProvider)).build();
    }

    @Override
    protected AmazonTranscribeClient createClient(ProcessContext context, AWSCredentials credentials, ClientConfiguration config) {
        return (AmazonTranscribeClient)AmazonTranscribeClient.builder().build();
    }

    @Override
    protected StartTranscriptionJobResult sendRequest(StartTranscriptionJobRequest request, ProcessContext context, FlowFile flowFile) {
        return ((AmazonTranscribeClient)this.getClient(context)).startTranscriptionJob(request);
    }

    @Override
    protected Class<? extends StartTranscriptionJobRequest> getAwsRequestClass(ProcessContext context, FlowFile flowFile) {
        return StartTranscriptionJobRequest.class;
    }

    @Override
    protected String getAwsTaskId(ProcessContext context, StartTranscriptionJobResult startTranscriptionJobResult, FlowFile flowFile) {
        return startTranscriptionJobResult.getTranscriptionJob().getTranscriptionJobName();
    }
}

