/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3.encryption;

import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.amazonaws.services.s3.model.UploadPartRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.processors.aws.s3.encryption.S3EncryptionStrategy;

public class ServerSideCEncryptionStrategy
implements S3EncryptionStrategy {
    @Override
    public void configurePutObjectRequest(PutObjectRequest request, ObjectMetadata objectMetadata, String keyValue) {
        SSECustomerKey customerKey = new SSECustomerKey(keyValue);
        request.setSSECustomerKey(customerKey);
    }

    @Override
    public void configureInitiateMultipartUploadRequest(InitiateMultipartUploadRequest request, ObjectMetadata objectMetadata, String keyValue) {
        SSECustomerKey customerKey = new SSECustomerKey(keyValue);
        request.setSSECustomerKey(customerKey);
    }

    @Override
    public void configureGetObjectRequest(GetObjectRequest request, ObjectMetadata objectMetadata, String keyValue) {
        SSECustomerKey customerKey = new SSECustomerKey(keyValue);
        request.setSSECustomerKey(customerKey);
    }

    @Override
    public void configureUploadPartRequest(UploadPartRequest request, ObjectMetadata objectMetadata, String keyValue) {
        SSECustomerKey customerKey = new SSECustomerKey(keyValue);
        request.setSSECustomerKey(customerKey);
    }

    @Override
    public ValidationResult validateKey(String keyValue) {
        byte[] keyMaterial;
        if (StringUtils.isBlank((CharSequence)keyValue)) {
            return new ValidationResult.Builder().subject("Key Material").valid(false).explanation("it is empty").build();
        }
        try {
            if (!Base64.isBase64((String)keyValue)) {
                throw new Exception();
            }
            keyMaterial = Base64.decodeBase64((String)keyValue);
        }
        catch (Exception e) {
            return new ValidationResult.Builder().subject("Key Material").valid(false).explanation("it is not in Base64 encoded form").build();
        }
        if (keyMaterial.length != 32) {
            return new ValidationResult.Builder().subject("Key Material").valid(false).explanation("it is not a Base64 encoded AES-256 key").build();
        }
        return new ValidationResult.Builder().valid(true).build();
    }
}

