/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.aws.s3.AbstractS3Processor;
import org.apache.nifi.processors.aws.s3.DeleteS3Object;
import org.apache.nifi.processors.aws.s3.FetchS3Object;
import org.apache.nifi.processors.aws.s3.ListS3;
import org.apache.nifi.processors.aws.s3.PutS3Object;
import org.apache.nifi.processors.aws.s3.TagS3Object;

@Tags(value={"Amazon", "S3", "AWS", "Archive", "Exists"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Check for the existence of a file in S3 without attempting to download it. This processor can be used as a router for work flows that need to check on a file in S3 before proceeding with data processing")
@SeeAlso(value={PutS3Object.class, DeleteS3Object.class, ListS3.class, TagS3Object.class, DeleteS3Object.class, FetchS3Object.class})
public class GetS3ObjectMetadata
extends AbstractS3Processor {
    static final AllowableValue TARGET_ATTRIBUTES = new AllowableValue("ATTRIBUTES", "Attributes", "When selected, the metadata will be written to FlowFile attributes with the prefix \"s3.\" following the convention used in other processors. For example: the standard S3 attribute Content-Type will be written as s3.Content-Type when using the default value. User-defined metadatawill be included in the attributes added to the FlowFile");
    static final AllowableValue TARGET_FLOWFILE_BODY = new AllowableValue("FLOWFILE_BODY", "FlowFile Body", "Write the metadata to FlowFile content as JSON data.");
    static final PropertyDescriptor METADATA_TARGET = new PropertyDescriptor.Builder().name("Metadata Target").description("This determines where the metadata will be written when found.").addValidator(Validator.VALID).required(true).allowableValues(new AllowableValue[]{TARGET_ATTRIBUTES, TARGET_FLOWFILE_BODY}).defaultValue(TARGET_ATTRIBUTES.getValue()).build();
    static final PropertyDescriptor ATTRIBUTE_INCLUDE_PATTERN = new PropertyDescriptor.Builder().name("Metadata Attribute Include Pattern").description("A regular expression pattern to use for determining which object metadata entries are included as FlowFile attributes. This pattern is only applied to the 'found' relationship and will not be used to filter the error attributes in the 'failure' relationship.").addValidator(Validator.VALID).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue(".*").dependsOn(METADATA_TARGET, new AllowableValue[]{TARGET_ATTRIBUTES}).build();
    private static final List<PropertyDescriptor> properties = Arrays.asList(METADATA_TARGET, ATTRIBUTE_INCLUDE_PATTERN, BUCKET, KEY, AWS_CREDENTIALS_PROVIDER_SERVICE, S3_REGION, TIMEOUT, FULL_CONTROL_USER_LIST, READ_USER_LIST, READ_ACL_LIST, OWNER, SSL_CONTEXT_SERVICE, ENDPOINT_OVERRIDE, SIGNER_OVERRIDE, S3_CUSTOM_SIGNER_CLASS_NAME, S3_CUSTOM_SIGNER_MODULE_LOCATION, PROXY_CONFIGURATION_SERVICE);
    static Relationship REL_FOUND = new Relationship.Builder().name("found").description("An object was found in the bucket at the supplied key").build();
    static Relationship REL_NOT_FOUND = new Relationship.Builder().name("not found").description("No object was found in the bucket the supplied key").build();
    private static final Set<Relationship> relationships = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_FOUND, REL_NOT_FOUND, REL_FAILURE)));
    private static final String ATTRIBUTE_FORMAT = "s3.%s";
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        AmazonS3Client s3;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            s3 = this.getS3Client(context, flowFile.getAttributes());
        }
        catch (Exception e2) {
            this.getLogger().error("Failed to initialize S3 client", (Throwable)e2);
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        String bucket = context.getProperty(BUCKET).evaluateAttributeExpressions(flowFile).getValue();
        String key = context.getProperty(KEY).evaluateAttributeExpressions(flowFile).getValue();
        PropertyValue attributeIncludePatternProperty = context.getProperty(ATTRIBUTE_INCLUDE_PATTERN).evaluateAttributeExpressions(flowFile);
        Pattern attributePattern = attributeIncludePatternProperty.isSet() ? Pattern.compile(attributeIncludePatternProperty.getValue()) : null;
        String metadataTarget = context.getProperty(METADATA_TARGET).getValue();
        try {
            Relationship relationship;
            try {
                ObjectMetadata objectMetadata = s3.getObjectMetadata(bucket, key);
                LinkedHashMap combinedMetadata = new LinkedHashMap(objectMetadata.getRawMetadata());
                combinedMetadata.putAll(objectMetadata.getUserMetadata());
                if (TARGET_ATTRIBUTES.getValue().equals(metadataTarget)) {
                    Map<String, String> newAttributes = combinedMetadata.entrySet().stream().filter(e -> {
                        if (attributePattern == null) {
                            return true;
                        }
                        return attributePattern.matcher((CharSequence)e.getKey()).find();
                    }).collect(Collectors.toMap(e -> String.format(ATTRIBUTE_FORMAT, e.getKey()), e -> {
                        String attributeValue;
                        Object value = e.getValue();
                        if (value instanceof Date) {
                            Date dateValue = (Date)value;
                            attributeValue = Long.toString(dateValue.getTime());
                        } else {
                            attributeValue = value.toString();
                        }
                        return attributeValue;
                    }));
                    flowFile = session.putAllAttributes(flowFile, newAttributes);
                } else if (TARGET_FLOWFILE_BODY.getValue().equals(metadataTarget)) {
                    flowFile = session.write(flowFile, outputStream -> MAPPER.writeValue(outputStream, (Object)combinedMetadata));
                }
                relationship = REL_FOUND;
            }
            catch (AmazonS3Exception e3) {
                if (e3.getStatusCode() == 404) {
                    relationship = REL_NOT_FOUND;
                    flowFile = this.extractExceptionDetails((Exception)((Object)e3), session, flowFile);
                }
                throw e3;
            }
            session.transfer(flowFile, relationship);
        }
        catch (AmazonClientException | IllegalArgumentException e4) {
            this.getLogger().error("Failed to get S3 Object Metadata from Bucket [{}] Key [{}]", new Object[]{bucket, key, e4});
            flowFile = this.extractExceptionDetails((Exception)e4, session, flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }
}

