/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.ml.polly;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.polly.AmazonPollyClient;
import com.amazonaws.services.polly.AmazonPollyClientBuilder;
import com.amazonaws.services.polly.model.GetSpeechSynthesisTaskRequest;
import com.amazonaws.services.polly.model.GetSpeechSynthesisTaskResult;
import com.amazonaws.services.polly.model.TaskStatus;
import com.amazonaws.services.textract.model.ThrottlingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.aws.ml.AwsMachineLearningJobStatusProcessor;
import org.apache.nifi.processors.aws.ml.polly.StartAwsPollyJob;

@Tags(value={"Amazon", "AWS", "ML", "Machine Learning", "Polly"})
@CapabilityDescription(value="Retrieves the current status of an AWS Polly job.")
@SeeAlso(value={StartAwsPollyJob.class})
@WritesAttributes(value={@WritesAttribute(attribute="PollyS3OutputBucket", description="The bucket name where polly output will be located."), @WritesAttribute(attribute="PollyS3OutputKey", description="Object key of polly output."), @WritesAttribute(attribute="outputLocation", description="S3 path-style output location of the result.")})
public class GetAwsPollyJobStatus
extends AwsMachineLearningJobStatusProcessor<AmazonPollyClient> {
    private static final String BUCKET = "bucket";
    private static final String KEY = "key";
    private static final Pattern S3_PATH = Pattern.compile("https://s3.*amazonaws.com/(?<bucket>[^/]+)/(?<key>.*)");
    private static final String AWS_S3_BUCKET = "PollyS3OutputBucket";
    private static final String AWS_S3_KEY = "filename";

    protected AmazonPollyClient createClient(ProcessContext context, AWSCredentialsProvider credentialsProvider, ClientConfiguration config) {
        return (AmazonPollyClient)((AmazonPollyClientBuilder)((AmazonPollyClientBuilder)AmazonPollyClientBuilder.standard().withCredentials(credentialsProvider)).withRegion(context.getProperty(REGION).getValue())).build();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        GetSpeechSynthesisTaskResult speechSynthesisTask;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            speechSynthesisTask = this.getSynthesisTask(context, flowFile);
        }
        catch (ThrottlingException e) {
            this.getLogger().info("Request Rate Limit exceeded", (Throwable)e);
            session.transfer(flowFile, REL_THROTTLED);
            return;
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to get Polly Job status", (Throwable)e);
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        TaskStatus taskStatus = TaskStatus.fromValue((String)speechSynthesisTask.getSynthesisTask().getTaskStatus());
        if (taskStatus == TaskStatus.InProgress || taskStatus == TaskStatus.Scheduled) {
            session.penalize(flowFile);
            session.transfer(flowFile, REL_RUNNING);
        } else if (taskStatus == TaskStatus.Completed) {
            String outputUri = speechSynthesisTask.getSynthesisTask().getOutputUri();
            Matcher matcher = S3_PATH.matcher(outputUri);
            if (matcher.find()) {
                session.putAttribute(flowFile, AWS_S3_BUCKET, matcher.group(BUCKET));
                session.putAttribute(flowFile, AWS_S3_KEY, matcher.group(KEY));
            }
            FlowFile childFlowFile = session.create(flowFile);
            this.writeToFlowFile(session, childFlowFile, speechSynthesisTask);
            childFlowFile = session.putAttribute(childFlowFile, "outputLocation", outputUri);
            session.transfer(flowFile, REL_ORIGINAL);
            session.transfer(childFlowFile, REL_SUCCESS);
            this.getLogger().info("Amazon Polly Task Completed {}", new Object[]{flowFile});
        } else if (taskStatus == TaskStatus.Failed) {
            String failureReason = speechSynthesisTask.getSynthesisTask().getTaskStatusReason();
            flowFile = session.putAttribute(flowFile, "failure.reason", failureReason);
            session.transfer(flowFile, REL_FAILURE);
            this.getLogger().error("Amazon Polly Task Failed {} Reason [{}]", new Object[]{flowFile, failureReason});
        }
    }

    private GetSpeechSynthesisTaskResult getSynthesisTask(ProcessContext context, FlowFile flowFile) {
        String taskId = context.getProperty(TASK_ID).evaluateAttributeExpressions(flowFile).getValue();
        GetSpeechSynthesisTaskRequest request = new GetSpeechSynthesisTaskRequest().withTaskId(taskId);
        return ((AmazonPollyClient)this.getClient(context)).getSpeechSynthesisTask(request);
    }
}

