/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.kinesis.stream;

import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.WorkerStateChangeListener;
import com.amazonaws.services.kinesis.metrics.impl.NullMetricsFactory;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean2;
import org.apache.commons.beanutils.FluentPropertyBeanIntrospector;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperties;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.SystemResourceConsiderations;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.AbstractAWSCredentialsProviderProcessor;
import org.apache.nifi.processors.aws.AbstractAWSProcessor;
import org.apache.nifi.processors.aws.kinesis.stream.AbstractKinesisStreamProcessor;
import org.apache.nifi.processors.aws.kinesis.stream.PutKinesisStream;
import org.apache.nifi.processors.aws.kinesis.stream.record.KinesisRecordProcessorRaw;
import org.apache.nifi.processors.aws.kinesis.stream.record.KinesisRecordProcessorRecord;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.record.RecordFieldType;

@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@TriggerSerially
@Tags(value={"amazon", "aws", "kinesis", "consume", "stream"})
@CapabilityDescription(value="Reads data from the specified AWS Kinesis stream and outputs a FlowFile for every processed Record (raw)  or a FlowFile for a batch of processed records if a Record Reader and Record Writer are configured. At-least-once delivery of all Kinesis Records within the Stream while the processor is running. AWS Kinesis Client Library can take several seconds to initialise before starting to fetch data. Uses DynamoDB for check pointing and CloudWatch (optional) for metrics. Ensure that the credentials provided have access to DynamoDB and CloudWatch (optional) along with Kinesis.")
@WritesAttributes(value={@WritesAttribute(attribute="aws.kinesis.partition.key", description="Partition key of the (last) Kinesis Record read from the Shard"), @WritesAttribute(attribute="aws.kinesis.shard.id", description="Shard ID from which the Kinesis Record was read"), @WritesAttribute(attribute="aws.kinesis.sequence.number", description="The unique identifier of the (last) Kinesis Record within its Shard"), @WritesAttribute(attribute="aws.kinesis.approximate.arrival.timestamp", description="Approximate arrival timestamp of the (last) Kinesis Record read from the stream"), @WritesAttribute(attribute="mime.type", description="Sets the mime.type attribute to the MIME Type specified by the Record Writer (if configured)"), @WritesAttribute(attribute="record.count", description="Number of records written to the FlowFiles by the Record Writer (if configured)"), @WritesAttribute(attribute="record.error.message", description="This attribute provides on failure the error message encountered by the Record Reader or Record Writer (if configured)")})
@DynamicProperties(value={@DynamicProperty(name="Kinesis Client Library (KCL) Configuration property name", description="Override default KCL Configuration properties with required values. Supports setting of values via the \"with\" methods on the KCL Configuration class. Specify the property to be set without the leading prefix, e.g. \"maxInitialisationAttempts\" will call \"withMaxInitialisationAttempts\" and set the provided value. Only supports setting of simple property values, e.g. String, int, long and boolean. Does not allow override of KCL Configuration settings handled by non-dynamic processor properties.", expressionLanguageScope=ExpressionLanguageScope.NONE, value="Value to set in the KCL Configuration property")})
@SystemResourceConsiderations(value={@SystemResourceConsideration(resource=SystemResource.CPU, description="Kinesis Client Library is used to create a Worker thread for consumption of Kinesis Records. The Worker is initialised and started when this Processor has been triggered. It runs continually, spawning Kinesis Record Processors as required to fetch Kinesis Records. The Worker Thread (and any child Record Processor threads) are not controlled by the normal NiFi scheduler as part of the Concurrent Thread pool and are not released until this processor is stopped."), @SystemResourceConsideration(resource=SystemResource.NETWORK, description="Kinesis Client Library will continually poll for new Records, requesting up to a maximum number of Records/bytes per call. This can result in sustained network usage.")})
@SeeAlso(value={PutKinesisStream.class})
public class ConsumeKinesisStream
extends AbstractKinesisStreamProcessor {
    static final AllowableValue TRIM_HORIZON = new AllowableValue(InitialPositionInStream.TRIM_HORIZON.toString(), InitialPositionInStream.TRIM_HORIZON.toString(), "Start reading at the last untrimmed record in the shard in the system, which is the oldest data record in the shard.");
    static final AllowableValue LATEST = new AllowableValue(InitialPositionInStream.LATEST.toString(), InitialPositionInStream.LATEST.toString(), "Start reading just after the most recent record in the shard, so that you always read the most recent data in the shard.");
    static final AllowableValue AT_TIMESTAMP = new AllowableValue(InitialPositionInStream.AT_TIMESTAMP.toString(), InitialPositionInStream.AT_TIMESTAMP.toString(), "Start reading from the position denoted by a specific time stamp, provided in the value Timestamp.");
    public static final PropertyDescriptor APPLICATION_NAME = new PropertyDescriptor.Builder().displayName("Application Name").name("amazon-kinesis-stream-application-name").description("The Kinesis stream reader application name.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).build();
    public static final PropertyDescriptor INITIAL_STREAM_POSITION = new PropertyDescriptor.Builder().displayName("Initial Stream Position").name("amazon-kinesis-stream-initial-position").description("Initial position to read Kinesis streams.").allowableValues(new AllowableValue[]{LATEST, TRIM_HORIZON, AT_TIMESTAMP}).defaultValue(LATEST.getValue()).required(true).build();
    public static final PropertyDescriptor STREAM_POSITION_TIMESTAMP = new PropertyDescriptor.Builder().displayName("Stream Position Timestamp").name("amazon-kinesis-stream-position-timestamp").description("Timestamp position in stream from which to start reading Kinesis Records. Required if " + INITIAL_STREAM_POSITION.getDescription() + " is " + AT_TIMESTAMP.getDisplayName() + ". Uses the Timestamp Format to parse value into a Date.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).dependsOn(INITIAL_STREAM_POSITION, new AllowableValue[]{AT_TIMESTAMP}).required(false).build();
    public static final PropertyDescriptor TIMESTAMP_FORMAT = new PropertyDescriptor.Builder().displayName("Timestamp Format").name("amazon-kinesis-stream-timestamp-format").description("Format to use for parsing the " + STREAM_POSITION_TIMESTAMP.getDisplayName() + " into a Date and converting the Kinesis Record's Approximate Arrival Timestamp into a FlowFile attribute.").addValidator((subject, input, context) -> {
        if (StringUtils.isNotBlank((CharSequence)input)) {
            try {
                DateTimeFormatter.ofPattern(input);
            }
            catch (Exception e) {
                return new ValidationResult.Builder().valid(false).subject(subject).input(input).explanation("Must be a valid java.time.DateTimeFormatter pattern, e.g. " + RecordFieldType.TIMESTAMP.getDefaultFormat()).build();
            }
        }
        return new ValidationResult.Builder().valid(true).subject(subject).build();
    }).defaultValue(RecordFieldType.TIMESTAMP.getDefaultFormat()).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(true).build();
    public static final PropertyDescriptor FAILOVER_TIMEOUT = new PropertyDescriptor.Builder().displayName("Failover Timeout").name("amazon-kinesis-stream-failover-timeout").description("Kinesis Client Library failover timeout").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("30 secs").required(true).build();
    public static final PropertyDescriptor GRACEFUL_SHUTDOWN_TIMEOUT = new PropertyDescriptor.Builder().displayName("Graceful Shutdown Timeout").name("amazon-kinesis-stream-graceful-shutdown-timeout").description("Kinesis Client Library graceful shutdown timeout").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("20 secs").required(true).build();
    public static final PropertyDescriptor CHECKPOINT_INTERVAL = new PropertyDescriptor.Builder().displayName("Checkpoint Interval").name("amazon-kinesis-stream-checkpoint-interval").description("Interval between Kinesis checkpoints").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("3 secs").required(true).build();
    public static final PropertyDescriptor NUM_RETRIES = new PropertyDescriptor.Builder().displayName("Retry Count").name("amazon-kinesis-stream-retry-count").description("Number of times to retry a Kinesis operation (process record, checkpoint, shutdown)").addValidator(StandardValidators.INTEGER_VALIDATOR).defaultValue("10").required(true).build();
    public static final PropertyDescriptor RETRY_WAIT = new PropertyDescriptor.Builder().displayName("Retry Wait").name("amazon-kinesis-stream-retry-wait").description("Interval between Kinesis operation retries (process record, checkpoint, shutdown)").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("1 sec").required(true).build();
    public static final PropertyDescriptor DYNAMODB_ENDPOINT_OVERRIDE = new PropertyDescriptor.Builder().displayName("DynamoDB Override").name("amazon-kinesis-stream-dynamodb-override").description("DynamoDB override to use non-AWS deployments").addValidator(StandardValidators.URL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).build();
    public static final PropertyDescriptor REPORT_CLOUDWATCH_METRICS = new PropertyDescriptor.Builder().displayName("Report Metrics to CloudWatch").name("amazon-kinesis-stream-cloudwatch-flag").description("Whether to report Kinesis usage metrics to CloudWatch.").addValidator(StandardValidators.BOOLEAN_VALIDATOR).allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    public static final PropertyDescriptor RECORD_READER = new PropertyDescriptor.Builder().name("amazon-kinesis-stream-record-reader").displayName("Record Reader").description("The Record Reader to use for reading received messages. The Kinesis Stream name can be referred to by Expression Language '${kinesis.name}' to access a schema. If Record Reader/Writer are not specified, each Kinesis Record will create a FlowFile.").identifiesControllerService(RecordReaderFactory.class).expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).build();
    public static final PropertyDescriptor RECORD_WRITER = new PropertyDescriptor.Builder().name("amazon-kinesis-stream-record-writer").displayName("Record Writer").description("The Record Writer to use for serializing Records to an output FlowFile. The Kinesis Stream name can be referred to by Expression Language '${kinesis.name}' to access a schema. If Record Reader/Writer are not specified, each Kinesis Record will create a FlowFile.").identifiesControllerService(RecordSetWriterFactory.class).expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).build();
    public static final PropertyDescriptor AWS_CREDENTIALS_PROVIDER_SERVICE = new PropertyDescriptor.Builder().fromPropertyDescriptor(AbstractAWSCredentialsProviderProcessor.AWS_CREDENTIALS_PROVIDER_SERVICE).required(true).build();
    public static final Relationship REL_PARSE_FAILURE = new Relationship.Builder().name("parse.failure").description("If a message from Kinesis cannot be parsed using the configured Record Reader or failed to be written by the configured Record Writer, the contents of the message will be routed to this Relationship as its own individual FlowFile.").build();
    public static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = Collections.unmodifiableList(Arrays.asList(KINESIS_STREAM_NAME, APPLICATION_NAME, RECORD_READER, RECORD_WRITER, REGION, ENDPOINT_OVERRIDE, DYNAMODB_ENDPOINT_OVERRIDE, INITIAL_STREAM_POSITION, STREAM_POSITION_TIMESTAMP, TIMESTAMP_FORMAT, FAILOVER_TIMEOUT, GRACEFUL_SHUTDOWN_TIMEOUT, CHECKPOINT_INTERVAL, NUM_RETRIES, RETRY_WAIT, REPORT_CLOUDWATCH_METRICS, TIMEOUT, AWS_CREDENTIALS_PROVIDER_SERVICE, PROXY_CONFIGURATION_SERVICE));
    private static final Map<String, PropertyDescriptor> DISALLOWED_DYNAMIC_KCL_PROPERTIES = new HashMap<String, PropertyDescriptor>(){
        {
            this.put("regionName", AbstractAWSProcessor.REGION);
            this.put("timestampAtInitialPositionInStream", STREAM_POSITION_TIMESTAMP);
            this.put("initialPositionInStream", INITIAL_STREAM_POSITION);
            this.put("dynamoDBEndpoint", DYNAMODB_ENDPOINT_OVERRIDE);
            this.put("kinesisEndpoint", AbstractAWSProcessor.ENDPOINT_OVERRIDE);
            this.put("failoverTimeMillis", FAILOVER_TIMEOUT);
            this.put("gracefulShutdownMillis", GRACEFUL_SHUTDOWN_TIMEOUT);
        }
    };
    private static final Object WORKER_LOCK = new Object();
    private static final String WORKER_THREAD_NAME_TEMPLATE = ConsumeKinesisStream.class.getSimpleName() + "-" + Worker.class.getSimpleName() + "-";
    private static final Set<Relationship> RELATIONSHIPS = Collections.singleton(REL_SUCCESS);
    private static final Set<Relationship> RECORD_RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_PARSE_FAILURE)));
    private static final PropertyUtilsBean PROPERTY_UTILS_BEAN = new PropertyUtilsBean();
    private static final BeanUtilsBean BEAN_UTILS_BEAN;
    private volatile boolean isRecordReaderSet;
    private volatile boolean isRecordWriterSet;
    private volatile Worker worker;
    final AtomicReference<WorkerStateChangeListener.WorkerState> workerState = new AtomicReference<Object>(null);
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return this.isRecordReaderSet && this.isRecordWriterSet ? RECORD_RELATIONSHIPS : RELATIONSHIPS;
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (RECORD_READER.equals((Object)descriptor)) {
            this.isRecordReaderSet = StringUtils.isNotEmpty((CharSequence)newValue);
        } else if (RECORD_WRITER.equals((Object)descriptor)) {
            this.isRecordWriterSet = StringUtils.isNotEmpty((CharSequence)newValue);
        }
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        PropertyDescriptor.Builder builder = new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).dynamic(true).addValidator(StandardValidators.ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR).addValidator(this::validateDynamicKCLConfigProperty).expressionLanguageSupported(ExpressionLanguageScope.NONE);
        return builder.build();
    }

    private ValidationResult validateDynamicKCLConfigProperty(String subject, String input, ValidationContext context) {
        ValidationResult.Builder validationResult = new ValidationResult.Builder().subject(subject).input(input);
        if (!subject.matches("^(?!with)[a-zA-Z]\\w*$")) {
            return validationResult.explanation("Property name must not have a prefix of \"with\", must start with a letter and contain only letters, numbers or underscores").valid(false).build();
        }
        if (DISALLOWED_DYNAMIC_KCL_PROPERTIES.keySet().stream().anyMatch(k -> k.equalsIgnoreCase(subject))) {
            return validationResult.explanation(String.format("Use \"%s\" instead of a dynamic property", DISALLOWED_DYNAMIC_KCL_PROPERTIES.get(subject).getDisplayName())).valid(false).build();
        }
        KinesisClientLibConfiguration kclTemp = new KinesisClientLibConfiguration("validate", "validate", null, "validate");
        try {
            String propName = StringUtils.uncapitalize((String)subject);
            if (!PROPERTY_UTILS_BEAN.isWriteable((Object)kclTemp, propName)) {
                return validationResult.explanation(String.format("Kinesis Client Library Configuration property with name %s does not exist or is not writable", StringUtils.capitalize((String)subject))).valid(false).build();
            }
            BEAN_UTILS_BEAN.setProperty((Object)kclTemp, propName, (Object)input);
        }
        catch (IllegalAccessException e) {
            return validationResult.explanation(String.format("Kinesis Client Library Configuration property with name %s is not accessible", StringUtils.capitalize((String)subject))).valid(false).build();
        }
        catch (InvocationTargetException e) {
            return this.buildDynamicPropertyBeanValidationResult(validationResult, subject, input, e.getTargetException().getLocalizedMessage());
        }
        catch (IllegalArgumentException e) {
            return this.buildDynamicPropertyBeanValidationResult(validationResult, subject, input, e.getLocalizedMessage());
        }
        return validationResult.valid(true).build();
    }

    private ValidationResult buildDynamicPropertyBeanValidationResult(ValidationResult.Builder validationResult, String subject, String input, String message) {
        return validationResult.explanation(String.format("Kinesis Client Library Configuration property with name %s cannot be used with value \"%s\" : %s", StringUtils.capitalize((String)subject), input, message)).valid(false).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        HashSet<ValidationResult> validationResults = new HashSet<ValidationResult>(super.customValidate(validationContext));
        DateTimeFormatter dateTimeFormatter = null;
        try {
            dateTimeFormatter = this.getDateTimeFormatter((PropertyContext)validationContext);
        }
        catch (IllegalArgumentException iae) {
            validationResults.add(new ValidationResult.Builder().valid(false).subject(TIMESTAMP_FORMAT.getName()).explanation(String.format("%s must be a valid java.time.DateTimeFormatter format", TIMESTAMP_FORMAT.getDisplayName())).build());
        }
        if (InitialPositionInStream.AT_TIMESTAMP == this.getInitialPositionInStream((PropertyContext)validationContext)) {
            if (!validationContext.getProperty(STREAM_POSITION_TIMESTAMP).isSet()) {
                validationResults.add(new ValidationResult.Builder().valid(false).subject(STREAM_POSITION_TIMESTAMP.getName()).explanation(String.format("%s must be provided when %s is %s", STREAM_POSITION_TIMESTAMP.getDisplayName(), INITIAL_STREAM_POSITION.getDisplayName(), AT_TIMESTAMP.getDisplayName())).build());
            } else if (dateTimeFormatter != null) {
                try {
                    this.getStartStreamTimestamp((PropertyContext)validationContext, dateTimeFormatter);
                }
                catch (Exception e) {
                    validationResults.add(new ValidationResult.Builder().valid(false).subject(STREAM_POSITION_TIMESTAMP.getName()).explanation(String.format("%s must be parsable by %s", STREAM_POSITION_TIMESTAMP.getDisplayName(), TIMESTAMP_FORMAT.getDisplayName())).build());
                }
            }
        }
        if (this.isRecordReaderSet && !this.isRecordWriterSet) {
            validationResults.add(new ValidationResult.Builder().subject(RECORD_WRITER.getName()).explanation(String.format("%s must be set if %s is set in order to write FlowFiles as Records.", RECORD_WRITER.getDisplayName(), RECORD_READER.getDisplayName())).valid(false).build());
        } else if (this.isRecordWriterSet && !this.isRecordReaderSet) {
            validationResults.add(new ValidationResult.Builder().subject(RECORD_READER.getName()).explanation(String.format("%s must be set if %s is set in order to write FlowFiles as Records.", RECORD_READER.getDisplayName(), RECORD_WRITER.getDisplayName())).valid(false).build());
        }
        return validationResults;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.stopped.set(false);
        this.workerState.set(null);
        super.onScheduled(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) {
        if (this.worker == null) {
            Object object = WORKER_LOCK;
            synchronized (object) {
                if (this.worker == null) {
                    String workerId = this.generateWorkerId();
                    this.getLogger().info("Starting Kinesis Worker {}", new Object[]{workerId});
                    this.worker = this.prepareWorker(context, sessionFactory, workerId);
                    new Thread((Runnable)this.worker, WORKER_THREAD_NAME_TEMPLATE + workerId).start();
                }
            }
        } else {
            context.yield();
            if (!this.stopped.get() && WorkerStateChangeListener.WorkerState.SHUT_DOWN == this.workerState.get()) {
                throw new ProcessException("Worker has shutdown unexpectedly, possibly due to a configuration issue; check logs for details");
            }
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnStopped
    public void stopConsuming(ProcessContext context) {
        if (this.worker != null) {
            Object object = WORKER_LOCK;
            synchronized (object) {
                if (this.worker != null) {
                    this.stopped.set(true);
                    boolean success = this.shutdownWorker(context);
                    this.worker = null;
                    this.workerState.set(null);
                    if (!success) {
                        this.getLogger().warn("One or more problems while shutting down Kinesis Worker, see logs for details");
                    }
                }
            }
        }
    }

    private synchronized Worker prepareWorker(ProcessContext context, ProcessSessionFactory sessionFactory, String workerId) {
        IRecordProcessorFactory factory = this.prepareRecordProcessorFactory(context, sessionFactory);
        KinesisClientLibConfiguration kinesisClientLibConfiguration = this.prepareKinesisClientLibConfiguration(context, workerId);
        Worker.Builder workerBuilder = this.prepareWorkerBuilder(context, kinesisClientLibConfiguration, factory);
        this.getLogger().info("Kinesis Worker prepared for application {} to process stream {} as worker ID {}...", new Object[]{this.getApplicationName((PropertyContext)context), this.getStreamName((PropertyContext)context), workerId});
        return workerBuilder.build();
    }

    private IRecordProcessorFactory prepareRecordProcessorFactory(ProcessContext context, ProcessSessionFactory sessionFactory) {
        return () -> {
            if (this.isRecordReaderSet && this.isRecordWriterSet) {
                return new KinesisRecordProcessorRecord(sessionFactory, this.getLogger(), this.getStreamName((PropertyContext)context), ((AmazonKinesisClient)this.getClient(context)).getEndpointPrefix(), this.getKinesisEndpoint((PropertyContext)context).orElse(null), this.getCheckpointIntervalMillis((PropertyContext)context), this.getRetryWaitMillis((PropertyContext)context), this.getNumRetries((PropertyContext)context), this.getDateTimeFormatter((PropertyContext)context), this.getReaderFactory((PropertyContext)context), this.getWriterFactory((PropertyContext)context));
            }
            return new KinesisRecordProcessorRaw(sessionFactory, this.getLogger(), this.getStreamName((PropertyContext)context), ((AmazonKinesisClient)this.getClient(context)).getEndpointPrefix(), this.getKinesisEndpoint((PropertyContext)context).orElse(null), this.getCheckpointIntervalMillis((PropertyContext)context), this.getRetryWaitMillis((PropertyContext)context), this.getNumRetries((PropertyContext)context), this.getDateTimeFormatter((PropertyContext)context));
        };
    }

    KinesisClientLibConfiguration prepareKinesisClientLibConfiguration(ProcessContext context, String workerId) {
        KinesisClientLibConfiguration kinesisClientLibConfiguration = new KinesisClientLibConfiguration(this.getApplicationName((PropertyContext)context), this.getStreamName((PropertyContext)context), this.getCredentialsProvider(context), workerId).withCommonClientConfig(((AmazonKinesisClient)this.getClient(context)).getClientConfiguration()).withRegionName(this.getRegion(context).getName()).withFailoverTimeMillis(this.getFailoverTimeMillis((PropertyContext)context)).withShutdownGraceMillis(this.getGracefulShutdownMillis((PropertyContext)context));
        InitialPositionInStream initialPositionInStream = this.getInitialPositionInStream((PropertyContext)context);
        if (InitialPositionInStream.AT_TIMESTAMP == initialPositionInStream) {
            kinesisClientLibConfiguration.withTimestampAtInitialPositionInStream(this.getStartStreamTimestamp((PropertyContext)context));
        } else {
            kinesisClientLibConfiguration.withInitialPositionInStream(initialPositionInStream);
        }
        this.getDynamoDBOverride((PropertyContext)context).ifPresent(arg_0 -> ((KinesisClientLibConfiguration)kinesisClientLibConfiguration).withDynamoDBEndpoint(arg_0));
        this.getKinesisEndpoint((PropertyContext)context).ifPresent(arg_0 -> ((KinesisClientLibConfiguration)kinesisClientLibConfiguration).withKinesisEndpoint(arg_0));
        List<PropertyDescriptor> dynamicProperties = context.getProperties().keySet().stream().filter(PropertyDescriptor::isDynamic).collect(Collectors.toList());
        dynamicProperties.forEach(descriptor -> {
            String name = descriptor.getName();
            String value = context.getProperty(descriptor).getValue();
            try {
                BEAN_UTILS_BEAN.setProperty((Object)kinesisClientLibConfiguration, StringUtils.uncapitalize((String)name), (Object)value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ProcessException(String.format("Unable to set Kinesis Client Library Configuration property %s with value %s", StringUtils.capitalize((String)name), value), (Throwable)e);
            }
        });
        return kinesisClientLibConfiguration;
    }

    Worker.Builder prepareWorkerBuilder(ProcessContext context, KinesisClientLibConfiguration kinesisClientLibConfiguration, IRecordProcessorFactory factory) {
        Worker.Builder workerBuilder = new Worker.Builder().config(kinesisClientLibConfiguration).kinesisClient((AmazonKinesis)this.getClient(context)).workerStateChangeListener(this.workerState::set).recordProcessorFactory(factory);
        if (!this.isReportCloudWatchMetrics((PropertyContext)context)) {
            workerBuilder.metricsFactory((IMetricsFactory)new NullMetricsFactory());
        }
        return workerBuilder;
    }

    private boolean shutdownWorker(ProcessContext context) {
        boolean success = true;
        try {
            if (!this.worker.hasGracefulShutdownStarted()) {
                this.getLogger().info("Requesting Kinesis Worker shutdown");
                Future shutdown = this.worker.startGracefulShutdown();
                if (Boolean.FALSE.equals(shutdown.get(this.getGracefulShutdownMillis((PropertyContext)context) + 2000L, TimeUnit.MILLISECONDS))) {
                    this.getLogger().warn("Kinesis Worker shutdown did not complete in time, cancelling");
                    success = false;
                } else {
                    this.getLogger().info("Kinesis Worker shutdown");
                }
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.getLogger().warn("Problem while shutting down Kinesis Worker: {}", new Object[]{e.getLocalizedMessage(), e});
            success = false;
        }
        return success;
    }

    private String generateWorkerId() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName() + ":" + UUID.randomUUID();
        }
        catch (UnknownHostException e) {
            throw new ProcessException((Throwable)e);
        }
    }

    private String getApplicationName(PropertyContext context) {
        return StringUtils.trimToEmpty((String)context.getProperty(APPLICATION_NAME).getValue());
    }

    private String getStreamName(PropertyContext context) {
        return StringUtils.trimToEmpty((String)context.getProperty(KINESIS_STREAM_NAME).getValue());
    }

    private long getFailoverTimeMillis(PropertyContext context) {
        return context.getProperty(FAILOVER_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS);
    }

    private long getGracefulShutdownMillis(PropertyContext context) {
        return context.getProperty(GRACEFUL_SHUTDOWN_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS);
    }

    private long getCheckpointIntervalMillis(PropertyContext context) {
        return context.getProperty(CHECKPOINT_INTERVAL).asTimePeriod(TimeUnit.MILLISECONDS);
    }

    private int getNumRetries(PropertyContext context) {
        return context.getProperty(NUM_RETRIES).asInteger();
    }

    private long getRetryWaitMillis(PropertyContext context) {
        return context.getProperty(RETRY_WAIT).asTimePeriod(TimeUnit.MILLISECONDS);
    }

    private boolean isReportCloudWatchMetrics(PropertyContext context) {
        return context.getProperty(REPORT_CLOUDWATCH_METRICS).asBoolean();
    }

    private Optional<String> getKinesisEndpoint(PropertyContext context) {
        return context.getProperty(ENDPOINT_OVERRIDE).isSet() ? Optional.of(StringUtils.trimToEmpty((String)context.getProperty(ENDPOINT_OVERRIDE).evaluateAttributeExpressions().getValue())) : Optional.empty();
    }

    private Optional<String> getDynamoDBOverride(PropertyContext context) {
        return context.getProperty(DYNAMODB_ENDPOINT_OVERRIDE).isSet() ? Optional.of(StringUtils.trimToEmpty((String)context.getProperty(DYNAMODB_ENDPOINT_OVERRIDE).evaluateAttributeExpressions().getValue())) : Optional.empty();
    }

    private RecordReaderFactory getReaderFactory(PropertyContext context) {
        return (RecordReaderFactory)context.getProperty(RECORD_READER).asControllerService(RecordReaderFactory.class);
    }

    private RecordSetWriterFactory getWriterFactory(PropertyContext context) {
        return (RecordSetWriterFactory)context.getProperty(RECORD_WRITER).asControllerService(RecordSetWriterFactory.class);
    }

    private InitialPositionInStream getInitialPositionInStream(PropertyContext context) {
        return InitialPositionInStream.valueOf((String)StringUtils.trimToEmpty((String)context.getProperty(INITIAL_STREAM_POSITION).getValue()));
    }

    private DateTimeFormatter getDateTimeFormatter(PropertyContext context) {
        return DateTimeFormatter.ofPattern(context.getProperty(TIMESTAMP_FORMAT).evaluateAttributeExpressions().getValue());
    }

    private Date getStartStreamTimestamp(PropertyContext context) {
        return this.getStartStreamTimestamp(context, this.getDateTimeFormatter(context));
    }

    private Date getStartStreamTimestamp(PropertyContext context, DateTimeFormatter dateTimeFormatter) {
        String streamTimestamp = context.getProperty(STREAM_POSITION_TIMESTAMP).getValue();
        return new Date(LocalDateTime.parse(streamTimestamp, dateTimeFormatter).atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneOffset.UTC).toInstant().toEpochMilli());
    }

    static {
        PROPERTY_UTILS_BEAN.addBeanIntrospector((BeanIntrospector)new FluentPropertyBeanIntrospector("with"));
        ConvertUtilsBean2 convertUtilsBean2 = new ConvertUtilsBean2(){

            public Object convert(String value, Class clazz) {
                if (clazz.isEnum()) {
                    return Enum.valueOf(clazz, value);
                }
                return super.convert(value, clazz);
            }
        };
        BEAN_UTILS_BEAN = new BeanUtilsBean((ConvertUtilsBean)convertUtilsBean2, PROPERTY_UTILS_BEAN);
    }
}

