/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.dynamodb;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.document.BatchWriteItemOutcome;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.TableWriteItems;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.ReadsAttributes;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processors.aws.dynamodb.AbstractWriteDynamoDBProcessor;
import org.apache.nifi.processors.aws.dynamodb.DeleteDynamoDB;
import org.apache.nifi.processors.aws.dynamodb.GetDynamoDB;
import org.apache.nifi.processors.aws.dynamodb.ItemKeys;
import org.apache.nifi.processors.aws.dynamodb.PutDynamoDBRecord;

@SupportsBatching
@SeeAlso(value={DeleteDynamoDB.class, GetDynamoDB.class, PutDynamoDBRecord.class})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"Amazon", "DynamoDB", "AWS", "Put", "Insert"})
@CapabilityDescription(value="Puts a document from DynamoDB based on hash and range key.  The table can have either hash and range or hash key alone. Currently the keys supported are string and number and value can be json document. In case of hash and range keys both key are required for the operation. The FlowFile content must be JSON. FlowFile content is mapped to the specified Json Document attribute in the DynamoDB item.")
@WritesAttributes(value={@WritesAttribute(attribute="dynamodb.key.error.unprocessed", description="DynamoDB unprocessed keys"), @WritesAttribute(attribute="dynmodb.range.key.value.error", description="DynamoDB range key error"), @WritesAttribute(attribute="dynamodb.key.error.not.found", description="DynamoDB key not found"), @WritesAttribute(attribute="dynamodb.error.exception.message", description="DynamoDB exception message"), @WritesAttribute(attribute="dynamodb.error.code", description="DynamoDB error code"), @WritesAttribute(attribute="dynamodb.error.message", description="DynamoDB error message"), @WritesAttribute(attribute="dynamodb.error.type", description="DynamoDB error type"), @WritesAttribute(attribute="dynamodb.error.service", description="DynamoDB error service"), @WritesAttribute(attribute="dynamodb.error.retryable", description="DynamoDB error is retryable"), @WritesAttribute(attribute="dynamodb.error.request.id", description="DynamoDB error request id"), @WritesAttribute(attribute="dynamodb.error.status.code", description="DynamoDB error status code"), @WritesAttribute(attribute="dynamodb.item.io.error", description="IO exception message on creating item")})
@ReadsAttributes(value={@ReadsAttribute(attribute="  dynamodb.item.hash.key.value", description="Items hash key value"), @ReadsAttribute(attribute="  dynamodb.item.range.key.value", description="Items range key value")})
@SystemResourceConsideration(resource=SystemResource.MEMORY)
public class PutDynamoDB
extends AbstractWriteDynamoDBProcessor {
    public static final List<PropertyDescriptor> properties = Collections.unmodifiableList(Arrays.asList(TABLE, HASH_KEY_NAME, RANGE_KEY_NAME, HASH_KEY_VALUE, RANGE_KEY_VALUE, HASH_KEY_VALUE_TYPE, RANGE_KEY_VALUE_TYPE, JSON_DOCUMENT, DOCUMENT_CHARSET, BATCH_SIZE, REGION, ACCESS_KEY, SECRET_KEY, CREDENTIALS_FILE, AWS_CREDENTIALS_PROVIDER_SERVICE, TIMEOUT, SSL_CONTEXT_SERVICE, PROXY_CONFIGURATION_SERVICE, PROXY_HOST, PROXY_HOST_PORT, PROXY_USERNAME, PROXY_PASSWORD));
    public static final int DYNAMODB_MAX_ITEM_SIZE = 409600;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        List failedFlowFiles;
        List flowFiles = session.get(context.getProperty(BATCH_SIZE).evaluateAttributeExpressions().asInteger().intValue());
        if (flowFiles == null || flowFiles.size() == 0) {
            return;
        }
        HashMap<ItemKeys, FlowFile> keysToFlowFileMap = new HashMap<ItemKeys, FlowFile>();
        String table = context.getProperty(TABLE).evaluateAttributeExpressions().getValue();
        String hashKeyName = context.getProperty(HASH_KEY_NAME).evaluateAttributeExpressions().getValue();
        String hashKeyValueType = context.getProperty(HASH_KEY_VALUE_TYPE).getValue();
        String rangeKeyName = context.getProperty(RANGE_KEY_NAME).evaluateAttributeExpressions().getValue();
        String rangeKeyValueType = context.getProperty(RANGE_KEY_VALUE_TYPE).getValue();
        String jsonDocument = context.getProperty(JSON_DOCUMENT).evaluateAttributeExpressions().getValue();
        String charset = context.getProperty(DOCUMENT_CHARSET).evaluateAttributeExpressions().getValue();
        TableWriteItems tableWriteItems = new TableWriteItems(table);
        for (FlowFile flowFile : flowFiles) {
            Iterator hashKeyValue = this.getValue(context, HASH_KEY_VALUE_TYPE, HASH_KEY_VALUE, flowFile.getAttributes());
            Object rangeKeyValue = this.getValue(context, RANGE_KEY_VALUE_TYPE, RANGE_KEY_VALUE, flowFile.getAttributes());
            if (!this.isHashKeyValueConsistent(hashKeyName, hashKeyValue, session, flowFile) || !this.isRangeKeyValueConsistent(rangeKeyName, rangeKeyValue, session, flowFile)) continue;
            if (!this.isDataValid(flowFile, jsonDocument)) {
                flowFile = session.putAttribute(flowFile, "dynamodb.item.size.error", "Max size of item + attribute should be 400kb but was " + flowFile.getSize() + jsonDocument.length());
                session.transfer(flowFile, REL_FAILURE);
                continue;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            session.exportTo(flowFile, (OutputStream)baos);
            if (rangeKeyValue == null || StringUtils.isBlank((CharSequence)rangeKeyValue.toString())) {
                tableWriteItems.addItemToPut(new Item().withKeyComponent(hashKeyName, hashKeyValue).withJSON(jsonDocument, IOUtils.toString((byte[])baos.toByteArray(), (String)charset)));
            } else {
                tableWriteItems.addItemToPut(new Item().withKeyComponent(hashKeyName, hashKeyValue).withKeyComponent(rangeKeyName, rangeKeyValue).withJSON(jsonDocument, IOUtils.toString((byte[])baos.toByteArray(), (String)charset)));
            }
            keysToFlowFileMap.put(new ItemKeys(hashKeyValue, rangeKeyValue), flowFile);
        }
        if (keysToFlowFileMap.isEmpty()) {
            return;
        }
        DynamoDB dynamoDB = this.getDynamoDB(context);
        try {
            BatchWriteItemOutcome outcome = dynamoDB.batchWriteItem(new TableWriteItems[]{tableWriteItems});
            this.handleUnprocessedItems(session, keysToFlowFileMap, table, hashKeyName, hashKeyValueType, rangeKeyName, rangeKeyValueType, outcome);
            for (FlowFile flowFile : keysToFlowFileMap.values()) {
                this.getLogger().debug("Successful posted items to dynamodb : " + table);
                session.transfer(flowFile, REL_SUCCESS);
            }
        }
        catch (AmazonServiceException exception) {
            this.getLogger().error("Could not process flowFiles due to service exception : " + exception.getMessage());
            failedFlowFiles = this.processServiceException(session, flowFiles, exception);
            session.transfer((Collection)failedFlowFiles, REL_FAILURE);
        }
        catch (AmazonClientException exception) {
            this.getLogger().error("Could not process flowFiles due to client exception : " + exception.getMessage());
            failedFlowFiles = this.processClientException(session, flowFiles, exception);
            session.transfer((Collection)failedFlowFiles, REL_FAILURE);
        }
        catch (Exception exception) {
            this.getLogger().error("Could not process flowFiles due to exception : " + exception.getMessage());
            failedFlowFiles = this.processException(session, flowFiles, exception);
            session.transfer((Collection)failedFlowFiles, REL_FAILURE);
        }
    }

    private boolean isDataValid(FlowFile flowFile, String jsonDocument) {
        return flowFile.getSize() + (long)jsonDocument.length() < 409600L;
    }

    protected Map<String, AttributeValue> getRequestItem(WriteRequest writeRequest) {
        return writeRequest.getPutRequest().getItem();
    }
}

