/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.dynamodb;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.document.BatchGetItemOutcome;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.TableKeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.ReadsAttributes;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processors.aws.dynamodb.AbstractDynamoDBProcessor;
import org.apache.nifi.processors.aws.dynamodb.DeleteDynamoDB;
import org.apache.nifi.processors.aws.dynamodb.ItemKeys;
import org.apache.nifi.processors.aws.dynamodb.PutDynamoDB;
import org.apache.nifi.processors.aws.dynamodb.PutDynamoDBRecord;

@SupportsBatching
@SeeAlso(value={DeleteDynamoDB.class, PutDynamoDB.class, PutDynamoDBRecord.class})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"Amazon", "DynamoDB", "AWS", "Get", "Fetch"})
@CapabilityDescription(value="Retrieves a document from DynamoDB based on hash and range key.  The key can be string or number.For any get request all the primary keys are required (hash or hash and range based on the table keys).A Json Document ('Map') attribute of the DynamoDB item is read into the content of the FlowFile.")
@WritesAttributes(value={@WritesAttribute(attribute="dynamodb.key.error.unprocessed", description="DynamoDB unprocessed keys"), @WritesAttribute(attribute="dynmodb.range.key.value.error", description="DynamoDB range key error"), @WritesAttribute(attribute="dynamodb.key.error.not.found", description="DynamoDB key not found"), @WritesAttribute(attribute="dynamodb.error.exception.message", description="DynamoDB exception message"), @WritesAttribute(attribute="dynamodb.error.code", description="DynamoDB error code"), @WritesAttribute(attribute="dynamodb.error.message", description="DynamoDB error message"), @WritesAttribute(attribute="dynamodb.error.type", description="DynamoDB error type"), @WritesAttribute(attribute="dynamodb.error.service", description="DynamoDB error service"), @WritesAttribute(attribute="dynamodb.error.retryable", description="DynamoDB error is retryable"), @WritesAttribute(attribute="dynamodb.error.request.id", description="DynamoDB error request id"), @WritesAttribute(attribute="dynamodb.error.status.code", description="DynamoDB status code")})
@ReadsAttributes(value={@ReadsAttribute(attribute="  dynamodb.item.hash.key.value", description="Items hash key value"), @ReadsAttribute(attribute="  dynamodb.item.range.key.value", description="Items range key value")})
public class GetDynamoDB
extends AbstractDynamoDBProcessor {
    public static final List<PropertyDescriptor> properties = Collections.unmodifiableList(Arrays.asList(TABLE, HASH_KEY_NAME, RANGE_KEY_NAME, HASH_KEY_VALUE, RANGE_KEY_VALUE, HASH_KEY_VALUE_TYPE, RANGE_KEY_VALUE_TYPE, JSON_DOCUMENT, BATCH_SIZE, REGION, ACCESS_KEY, SECRET_KEY, CREDENTIALS_FILE, AWS_CREDENTIALS_PROVIDER_SERVICE, TIMEOUT, SSL_CONTEXT_SERVICE, PROXY_CONFIGURATION_SERVICE, PROXY_HOST, PROXY_HOST_PORT, PROXY_USERNAME, PROXY_PASSWORD));
    public static final Relationship REL_NOT_FOUND = new Relationship.Builder().name("not found").description("FlowFiles are routed to not found relationship if key not found in the table").build();
    public static final Set<Relationship> getDynamoDBrelationships = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE, REL_UNPROCESSED, REL_NOT_FOUND)));

    public Set<Relationship> getRelationships() {
        return getDynamoDBrelationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    public List<ConfigVerificationResult> verify(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes) {
        TableKeysAndAttributes tableKeysAndAttributes;
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>(super.verify(context, verificationLogger, attributes));
        String table = context.getProperty(TABLE).evaluateAttributeExpressions().getValue();
        String jsonDocument = context.getProperty(JSON_DOCUMENT).evaluateAttributeExpressions().getValue();
        try {
            tableKeysAndAttributes = this.getTableKeysAndAttributes(context, attributes);
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).verificationStepName("Configure DynamoDB BatchGetItems Request").explanation(String.format("Successfully configured BatchGetItems Request", new Object[0])).build());
        }
        catch (IllegalArgumentException e) {
            verificationLogger.error("Failed to configured BatchGetItems Request", (Throwable)e);
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.FAILED).verificationStepName("Configure DynamoDB BatchGetItems Request").explanation(String.format("Failed to configured BatchGetItems Request: " + e.getMessage(), new Object[0])).build());
            return results;
        }
        if (tableKeysAndAttributes.getPrimaryKeys() == null || tableKeysAndAttributes.getPrimaryKeys().isEmpty()) {
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.SKIPPED).verificationStepName("Get DynamoDB Items").explanation(String.format("Skipped getting DynamoDB items because no primary keys would be included in retrieval", new Object[0])).build());
        } else {
            try {
                DynamoDB dynamoDB = this.getDynamoDB((AmazonDynamoDBClient)this.getClient(context));
                int totalCount = 0;
                int jsonDocumentCount = 0;
                BatchGetItemOutcome result = dynamoDB.batchGetItem(new TableKeysAndAttributes[]{tableKeysAndAttributes});
                List items = (List)result.getTableItems().get(table);
                for (Item item : items) {
                    ++totalCount;
                    if (item.get(jsonDocument) == null) continue;
                    ++jsonDocumentCount;
                }
                results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).verificationStepName("Get DynamoDB Items").explanation(String.format("Successfully retrieved %s items, including %s JSON documents, from DynamoDB", totalCount, jsonDocumentCount)).build());
            }
            catch (Exception e) {
                verificationLogger.error("Failed to retrieve items from DynamoDB", (Throwable)e);
                results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.FAILED).verificationStepName("Get DynamoDB Items").explanation(String.format("Failed to retrieve items from DynamoDB: %s", e.getMessage())).build());
            }
        }
        return results;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        TableKeysAndAttributes tableKeysAndAttributes;
        List flowFiles = session.get(context.getProperty(BATCH_SIZE).evaluateAttributeExpressions().asInteger().intValue());
        if (flowFiles == null || flowFiles.size() == 0) {
            return;
        }
        Map<ItemKeys, FlowFile> keysToFlowFileMap = this.getKeysToFlowFileMap(context, session, flowFiles);
        try {
            tableKeysAndAttributes = this.getTableKeysAndAttributes(context, flowFiles.stream().map(FlowFile::getAttributes).collect(Collectors.toList()).toArray(new Map[0]));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            return;
        }
        String table = context.getProperty(TABLE).evaluateAttributeExpressions().getValue();
        String hashKeyName = context.getProperty(HASH_KEY_NAME).evaluateAttributeExpressions().getValue();
        String rangeKeyName = context.getProperty(RANGE_KEY_NAME).evaluateAttributeExpressions().getValue();
        String jsonDocument = context.getProperty(JSON_DOCUMENT).evaluateAttributeExpressions().getValue();
        if (keysToFlowFileMap.isEmpty()) {
            return;
        }
        DynamoDB dynamoDB = this.getDynamoDB(context);
        try {
            Object flowFile;
            BatchGetItemOutcome result = dynamoDB.batchGetItem(new TableKeysAndAttributes[]{tableKeysAndAttributes});
            List items = (List)result.getTableItems().get(table);
            for (Item item : items) {
                ItemKeys itemKeys = new ItemKeys(item.get(hashKeyName), item.get(rangeKeyName));
                flowFile = keysToFlowFileMap.get(itemKeys);
                if (item.get(jsonDocument) != null) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(item.getJSON(jsonDocument).getBytes());
                    flowFile = session.importFrom((InputStream)bais, (FlowFile)flowFile);
                }
                session.transfer((FlowFile)flowFile, REL_SUCCESS);
                keysToFlowFileMap.remove(itemKeys);
            }
            Map unprocessedKeys = result.getUnprocessedKeys();
            if (unprocessedKeys != null && unprocessedKeys.size() > 0) {
                KeysAndAttributes keysAndAttributes = (KeysAndAttributes)unprocessedKeys.get(table);
                List keys = keysAndAttributes.getKeys();
                for (Map unprocessedKey : keys) {
                    Object hashKeyValue = this.getAttributeValue(context, HASH_KEY_VALUE_TYPE, (AttributeValue)unprocessedKey.get(hashKeyName));
                    Object rangeKeyValue = this.getAttributeValue(context, RANGE_KEY_VALUE_TYPE, (AttributeValue)unprocessedKey.get(rangeKeyName));
                    this.sendUnprocessedToUnprocessedRelationship(session, keysToFlowFileMap, hashKeyValue, rangeKeyValue);
                }
            }
            for (ItemKeys key : keysToFlowFileMap.keySet()) {
                flowFile = keysToFlowFileMap.get(key);
                flowFile = session.putAttribute((FlowFile)flowFile, "dynamodb.key.error.not.found", "DynamoDB key not found : " + key.toString());
                session.transfer((FlowFile)flowFile, REL_NOT_FOUND);
                keysToFlowFileMap.remove(key);
            }
        }
        catch (AmazonServiceException exception) {
            this.getLogger().error("Could not process flowFiles due to service exception : " + exception.getMessage());
            List failedFlowFiles = this.processServiceException(session, flowFiles, exception);
            session.transfer((Collection)failedFlowFiles, REL_FAILURE);
        }
        catch (AmazonClientException exception) {
            this.getLogger().error("Could not process flowFiles due to client exception : " + exception.getMessage());
            List failedFlowFiles = this.processClientException(session, flowFiles, exception);
            session.transfer((Collection)failedFlowFiles, REL_FAILURE);
        }
        catch (Exception exception) {
            this.getLogger().error("Could not process flowFiles due to exception : " + exception.getMessage());
            List failedFlowFiles = this.processException(session, flowFiles, exception);
            session.transfer((Collection)failedFlowFiles, REL_FAILURE);
        }
    }

    private Map<ItemKeys, FlowFile> getKeysToFlowFileMap(ProcessContext context, ProcessSession session, List<FlowFile> flowFiles) {
        HashMap<ItemKeys, FlowFile> keysToFlowFileMap = new HashMap<ItemKeys, FlowFile>();
        String hashKeyName = context.getProperty(HASH_KEY_NAME).evaluateAttributeExpressions().getValue();
        String rangeKeyName = context.getProperty(RANGE_KEY_NAME).evaluateAttributeExpressions().getValue();
        for (FlowFile flowFile : flowFiles) {
            Object hashKeyValue = this.getValue(context, HASH_KEY_VALUE_TYPE, HASH_KEY_VALUE, flowFile.getAttributes());
            Object rangeKeyValue = this.getValue(context, RANGE_KEY_VALUE_TYPE, RANGE_KEY_VALUE, flowFile.getAttributes());
            if (!this.isHashKeyValueConsistent(hashKeyName, hashKeyValue, session, flowFile) || !this.isRangeKeyValueConsistent(rangeKeyName, rangeKeyValue, session, flowFile)) continue;
            keysToFlowFileMap.put(new ItemKeys(hashKeyValue, rangeKeyValue), flowFile);
        }
        return keysToFlowFileMap;
    }

    private TableKeysAndAttributes getTableKeysAndAttributes(ProcessContext context, Map<String, String> ... attributes) {
        String table = context.getProperty(TABLE).evaluateAttributeExpressions().getValue();
        TableKeysAndAttributes tableKeysAndAttributes = new TableKeysAndAttributes(table);
        String hashKeyName = context.getProperty(HASH_KEY_NAME).evaluateAttributeExpressions().getValue();
        String rangeKeyName = context.getProperty(RANGE_KEY_NAME).evaluateAttributeExpressions().getValue();
        for (Map<String, String> attributeMap : attributes) {
            Object hashKeyValue = this.getValue(context, HASH_KEY_VALUE_TYPE, HASH_KEY_VALUE, attributeMap);
            Object rangeKeyValue = this.getValue(context, RANGE_KEY_VALUE_TYPE, RANGE_KEY_VALUE, attributeMap);
            this.validateHashKeyValue(hashKeyValue);
            this.validateRangeKeyValue(rangeKeyName, rangeKeyValue);
            if (rangeKeyValue == null || StringUtils.isBlank((CharSequence)rangeKeyValue.toString())) {
                tableKeysAndAttributes.addHashOnlyPrimaryKey(hashKeyName, hashKeyValue);
                continue;
            }
            tableKeysAndAttributes.addHashAndRangePrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue);
        }
        return tableKeysAndAttributes;
    }
}

