/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.ml.polly;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.polly.AmazonPollyClient;
import com.amazonaws.services.polly.AmazonPollyClientBuilder;
import com.amazonaws.services.polly.model.StartSpeechSynthesisTaskRequest;
import com.amazonaws.services.polly.model.StartSpeechSynthesisTaskResult;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.aws.ml.AwsMachineLearningJobStarter;
import org.apache.nifi.processors.aws.ml.polly.GetAwsPollyJobStatus;

@Tags(value={"Amazon", "AWS", "ML", "Machine Learning", "Polly"})
@CapabilityDescription(value="Trigger a AWS Polly job. It should be followed by GetAwsPollyJobStatus processor in order to monitor job status.")
@SeeAlso(value={GetAwsPollyJobStatus.class})
public class StartAwsPollyJob
extends AwsMachineLearningJobStarter<AmazonPollyClient, StartSpeechSynthesisTaskRequest, StartSpeechSynthesisTaskResult> {
    protected AmazonPollyClient createClient(ProcessContext context, AWSCredentialsProvider credentialsProvider, ClientConfiguration config) {
        return (AmazonPollyClient)((AmazonPollyClientBuilder)((AmazonPollyClientBuilder)AmazonPollyClientBuilder.standard().withRegion(context.getProperty(REGION).getValue())).withCredentials(credentialsProvider)).build();
    }

    @Override
    protected StartSpeechSynthesisTaskResult sendRequest(StartSpeechSynthesisTaskRequest request, ProcessContext context, FlowFile flowFile) {
        return ((AmazonPollyClient)this.getClient(context)).startSpeechSynthesisTask(request);
    }

    @Override
    protected Class<? extends StartSpeechSynthesisTaskRequest> getAwsRequestClass(ProcessContext context, FlowFile flowFile) {
        return StartSpeechSynthesisTaskRequest.class;
    }

    @Override
    protected String getAwsTaskId(ProcessContext context, StartSpeechSynthesisTaskResult startSpeechSynthesisTaskResult, FlowFile flowFile) {
        return startSpeechSynthesisTaskResult.getSynthesisTask().getTaskId();
    }
}

