/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.credentials.provider.factory;

import com.amazonaws.auth.AWSCredentialsProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processors.aws.credentials.provider.factory.CredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.AccessKeyPairCredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.AnonymousCredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.AssumeRoleCredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.ExplicitDefaultCredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.FileCredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.ImplicitDefaultCredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.NamedProfileCredentialsStrategy;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class CredentialsProviderFactory {
    private final List<CredentialsStrategy> strategies = new ArrayList<CredentialsStrategy>();

    public CredentialsProviderFactory() {
        this.strategies.add(new ExplicitDefaultCredentialsStrategy());
        this.strategies.add(new AccessKeyPairCredentialsStrategy());
        this.strategies.add(new FileCredentialsStrategy());
        this.strategies.add(new NamedProfileCredentialsStrategy());
        this.strategies.add(new AnonymousCredentialsStrategy());
        this.strategies.add(new ImplicitDefaultCredentialsStrategy());
        this.strategies.add(new AssumeRoleCredentialsStrategy());
    }

    public CredentialsStrategy selectPrimaryStrategy(PropertyContext propertyContext) {
        for (CredentialsStrategy strategy : this.strategies) {
            if (!strategy.canCreatePrimaryCredential(propertyContext)) continue;
            return strategy;
        }
        return null;
    }

    public Collection<ValidationResult> validate(ValidationContext validationContext) {
        CredentialsStrategy selectedStrategy = this.selectPrimaryStrategy((PropertyContext)validationContext);
        ArrayList<ValidationResult> validationFailureResults = new ArrayList<ValidationResult>();
        for (CredentialsStrategy strategy : this.strategies) {
            Collection<ValidationResult> strategyValidationFailures = strategy.validate(validationContext, selectedStrategy);
            if (strategyValidationFailures == null) continue;
            validationFailureResults.addAll(strategyValidationFailures);
        }
        return validationFailureResults;
    }

    public AWSCredentialsProvider getCredentialsProvider(PropertyContext propertyContext) {
        CredentialsStrategy primaryStrategy = this.selectPrimaryStrategy(propertyContext);
        AWSCredentialsProvider primaryCredentialsProvider = primaryStrategy.getCredentialsProvider(propertyContext);
        AWSCredentialsProvider derivedCredentialsProvider = null;
        for (CredentialsStrategy strategy : this.strategies) {
            if (!strategy.canCreateDerivedCredential(propertyContext)) continue;
            derivedCredentialsProvider = strategy.getDerivedCredentialsProvider(propertyContext, primaryCredentialsProvider);
            break;
        }
        if (derivedCredentialsProvider != null) {
            return derivedCredentialsProvider;
        }
        return primaryCredentialsProvider;
    }

    public AwsCredentialsProvider getAwsCredentialsProvider(PropertyContext propertyContext) {
        CredentialsStrategy primaryStrategy = this.selectPrimaryStrategy(propertyContext);
        AwsCredentialsProvider primaryCredentialsProvider = primaryStrategy.getAwsCredentialsProvider(propertyContext);
        AwsCredentialsProvider derivedCredentialsProvider = null;
        for (CredentialsStrategy strategy : this.strategies) {
            if (!strategy.canCreateDerivedCredential(propertyContext)) continue;
            derivedCredentialsProvider = strategy.getDerivedAwsCredentialsProvider(propertyContext, primaryCredentialsProvider);
            break;
        }
        return derivedCredentialsProvider == null ? primaryCredentialsProvider : derivedCredentialsProvider;
    }
}

