/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.ml.translate;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.translate.AmazonTranslateClient;
import com.amazonaws.services.translate.AmazonTranslateClientBuilder;
import com.amazonaws.services.translate.model.StartTextTranslationJobRequest;
import com.amazonaws.services.translate.model.StartTextTranslationJobResult;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.aws.ml.AwsMachineLearningJobStarter;
import org.apache.nifi.processors.aws.ml.translate.GetAwsTranslateJobStatus;

@Tags(value={"Amazon", "AWS", "ML", "Machine Learning", "Translate"})
@CapabilityDescription(value="Trigger a AWS Translate job. It should be followed by GetAwsTranslateJobStatus processor in order to monitor job status.")
@SeeAlso(value={GetAwsTranslateJobStatus.class})
public class StartAwsTranslateJob
extends AwsMachineLearningJobStarter<AmazonTranslateClient, StartTextTranslationJobRequest, StartTextTranslationJobResult> {
    protected AmazonTranslateClient createClient(ProcessContext context, AWSCredentialsProvider credentialsProvider, ClientConfiguration config) {
        return (AmazonTranslateClient)((AmazonTranslateClientBuilder)((AmazonTranslateClientBuilder)AmazonTranslateClient.builder().withRegion(context.getProperty(REGION).getValue())).withCredentials(credentialsProvider)).build();
    }

    @Override
    protected StartTextTranslationJobResult sendRequest(StartTextTranslationJobRequest request, ProcessContext context, FlowFile flowFile) {
        return ((AmazonTranslateClient)this.getClient(context)).startTextTranslationJob(request);
    }

    @Override
    protected Class<StartTextTranslationJobRequest> getAwsRequestClass(ProcessContext context, FlowFile flowFile) {
        return StartTextTranslationJobRequest.class;
    }

    @Override
    protected String getAwsTaskId(ProcessContext context, StartTextTranslationJobResult startTextTranslationJobResult, FlowFile flowFile) {
        return startTextTranslationJobResult.getJobId();
    }
}

