/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.credentials.provider.factory.strategies;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processors.aws.credentials.provider.factory.CredentialPropertyDescriptors;
import org.apache.nifi.processors.aws.credentials.provider.factory.CredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.AbstractCredentialsStrategy;
import org.apache.nifi.processors.aws.signer.AwsCustomSignerUtil;
import org.apache.nifi.processors.aws.signer.AwsSignerType;
import org.apache.nifi.ssl.SSLContextService;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class AssumeRoleCredentialsStrategy
extends AbstractCredentialsStrategy {
    private static final String VPCE_ENDPOINT_SUFFIX = ".vpce.amazonaws.com";

    public AssumeRoleCredentialsStrategy() {
        super("Assume Role", new PropertyDescriptor[]{CredentialPropertyDescriptors.ASSUME_ROLE_ARN, CredentialPropertyDescriptors.ASSUME_ROLE_NAME, CredentialPropertyDescriptors.MAX_SESSION_TIME});
    }

    @Override
    public boolean canCreatePrimaryCredential(PropertyContext propertyContext) {
        return false;
    }

    @Override
    public boolean canCreateDerivedCredential(PropertyContext propertyContext) {
        String assumeRoleArn = propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_ARN).getValue();
        String assumeRoleName = propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_NAME).getValue();
        return assumeRoleArn != null && !assumeRoleArn.isEmpty() && assumeRoleName != null && !assumeRoleName.isEmpty();
    }

    protected boolean proxyVariablesValidForAssumeRole(PropertyContext propertyContext) {
        String assumeRoleProxyHost = propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_PROXY_HOST).getValue();
        String assumeRoleProxyPort = propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_PROXY_PORT).getValue();
        return assumeRoleProxyHost != null && !assumeRoleProxyHost.isEmpty() && assumeRoleProxyPort != null && !assumeRoleProxyPort.isEmpty();
    }

    @Override
    public Collection<ValidationResult> validate(ValidationContext validationContext, CredentialsStrategy primaryStrategy) {
        ArrayList<ValidationResult> validationFailureResults = new ArrayList<ValidationResult>();
        boolean assumeRoleArnIsSet = validationContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_ARN).isSet();
        if (assumeRoleArnIsSet) {
            boolean assumeRoleProxyPortIsSet;
            boolean assumeRoleProxyHostIsSet;
            Integer maxSessionTime = validationContext.getProperty(CredentialPropertyDescriptors.MAX_SESSION_TIME).asInteger();
            if (maxSessionTime < 900 || maxSessionTime > 3600) {
                validationFailureResults.add(new ValidationResult.Builder().valid(false).input("" + maxSessionTime).explanation(CredentialPropertyDescriptors.MAX_SESSION_TIME.getDisplayName() + " must be between 900 and 3600 seconds").build());
            }
            if ((assumeRoleProxyHostIsSet = validationContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_PROXY_HOST).isSet()) ^ (assumeRoleProxyPortIsSet = validationContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_PROXY_PORT).isSet())) {
                validationFailureResults.add(new ValidationResult.Builder().input("Assume Role Proxy Host and Port").valid(false).explanation("Assume role with proxy requires both host and port for the proxy to be set").build());
            }
        }
        return validationFailureResults;
    }

    @Override
    public AWSCredentialsProvider getCredentialsProvider(PropertyContext propertyContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AWSCredentialsProvider getDerivedCredentialsProvider(PropertyContext propertyContext, AWSCredentialsProvider primaryCredentialsProvider) {
        AwsSignerType assumeRoleSTSSignerType;
        String assumeRoleArn = propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_ARN).getValue();
        String assumeRoleName = propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_NAME).getValue();
        int maxSessionTime = propertyContext.getProperty(CredentialPropertyDescriptors.MAX_SESSION_TIME).asInteger();
        String assumeRoleExternalId = propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_EXTERNAL_ID).getValue();
        String assumeRoleSTSRegion = propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_STS_REGION).getValue();
        String assumeRoleSTSEndpoint = propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_STS_ENDPOINT).getValue();
        String assumeRoleSTSSigner = propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_STS_SIGNER_OVERRIDE).getValue();
        SSLContextService sslContextService = (SSLContextService)propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        ClientConfiguration config = new ClientConfiguration();
        if (sslContextService != null) {
            SSLContext sslContext = sslContextService.createContext();
            config.getApacheHttpClientConfig().setSslSocketFactory((ConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext));
        }
        if (this.proxyVariablesValidForAssumeRole(propertyContext)) {
            String assumeRoleProxyHost = propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_PROXY_HOST).getValue();
            int assumeRoleProxyPort = propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_PROXY_PORT).asInteger();
            config.withProxyHost(assumeRoleProxyHost);
            config.withProxyPort(assumeRoleProxyPort);
        }
        if ((assumeRoleSTSSignerType = AwsSignerType.forValue((String)assumeRoleSTSSigner)) == AwsSignerType.CUSTOM_SIGNER) {
            String signerClassName = propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_STS_CUSTOM_SIGNER_CLASS_NAME).evaluateAttributeExpressions().getValue();
            config.withSignerOverride(AwsCustomSignerUtil.registerCustomSigner((String)signerClassName));
        } else if (assumeRoleSTSSignerType != AwsSignerType.DEFAULT_SIGNER) {
            config.withSignerOverride(assumeRoleSTSSigner);
        }
        AWSSecurityTokenServiceClient securityTokenService = new AWSSecurityTokenServiceClient(primaryCredentialsProvider, config);
        if (assumeRoleSTSEndpoint != null && !assumeRoleSTSEndpoint.isEmpty()) {
            if (assumeRoleSTSSignerType == AwsSignerType.CUSTOM_SIGNER) {
                securityTokenService.setEndpoint(assumeRoleSTSEndpoint, securityTokenService.getServiceName(), assumeRoleSTSRegion);
            } else if (assumeRoleSTSEndpoint.endsWith(VPCE_ENDPOINT_SUFFIX)) {
                securityTokenService.setEndpoint(assumeRoleSTSEndpoint, securityTokenService.getServiceName(), assumeRoleSTSRegion);
            } else {
                securityTokenService.setEndpoint(assumeRoleSTSEndpoint);
            }
        }
        STSAssumeRoleSessionCredentialsProvider.Builder builder = new STSAssumeRoleSessionCredentialsProvider.Builder(assumeRoleArn, assumeRoleName).withStsClient((AWSSecurityTokenService)securityTokenService).withRoleSessionDurationSeconds(maxSessionTime);
        if (assumeRoleExternalId != null && !assumeRoleExternalId.isEmpty()) {
            builder = builder.withExternalId(assumeRoleExternalId);
        }
        STSAssumeRoleSessionCredentialsProvider credsProvider = builder.build();
        return credsProvider;
    }

    @Override
    public AwsCredentialsProvider getAwsCredentialsProvider(PropertyContext propertyContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AwsCredentialsProvider getDerivedAwsCredentialsProvider(PropertyContext propertyContext, AwsCredentialsProvider primaryCredentialsProvider) {
        String assumeRoleArn = propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_ARN).getValue();
        String assumeRoleName = propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_NAME).getValue();
        int maxSessionTime = propertyContext.getProperty(CredentialPropertyDescriptors.MAX_SESSION_TIME).asInteger();
        String assumeRoleExternalId = propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_EXTERNAL_ID).getValue();
        String assumeRoleSTSEndpoint = propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_STS_ENDPOINT).getValue();
        String stsRegion = propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_STS_REGION).getValue();
        SSLContextService sslContextService = (SSLContextService)propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        StsAssumeRoleCredentialsProvider.Builder builder = StsAssumeRoleCredentialsProvider.builder();
        ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder();
        if (sslContextService != null) {
            SSLContext sslContext = sslContextService.createContext();
            httpClientBuilder.socketFactory((ConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext));
        }
        if (this.proxyVariablesValidForAssumeRole(propertyContext)) {
            String assumeRoleProxyHost = propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_PROXY_HOST).getValue();
            int assumeRoleProxyPort = propertyContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_PROXY_PORT).asInteger();
            ProxyConfiguration proxyConfig = (ProxyConfiguration)ProxyConfiguration.builder().endpoint(URI.create(String.format("http://%s:%s", assumeRoleProxyHost, assumeRoleProxyPort))).build();
            httpClientBuilder.proxyConfiguration(proxyConfig);
        }
        if (stsRegion == null) {
            throw new IllegalStateException("Assume Role Region is required to interact with STS");
        }
        StsClientBuilder stsClientBuilder = (StsClientBuilder)((StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider(primaryCredentialsProvider)).region(Region.of((String)stsRegion))).httpClient(httpClientBuilder.build());
        if (assumeRoleSTSEndpoint != null && !assumeRoleSTSEndpoint.isEmpty()) {
            stsClientBuilder.endpointOverride(URI.create(assumeRoleSTSEndpoint));
        }
        StsClient stsClient = (StsClient)stsClientBuilder.build();
        AssumeRoleRequest.Builder roleRequestBuilder = AssumeRoleRequest.builder().roleArn(assumeRoleArn).roleSessionName(assumeRoleName);
        if (assumeRoleExternalId != null && !assumeRoleExternalId.isEmpty()) {
            roleRequestBuilder.externalId(assumeRoleExternalId);
        }
        ((StsAssumeRoleCredentialsProvider.Builder)builder.refreshRequest((AssumeRoleRequest)roleRequestBuilder.build()).stsClient(stsClient)).staleTime(Duration.ofSeconds(maxSessionTime));
        return builder.build();
    }
}

