/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.credentials.provider.factory;

import com.amazonaws.auth.AWSCredentialsProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.processors.aws.credentials.provider.factory.CredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.AccessKeyPairCredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.AnonymousCredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.AssumeRoleCredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.ExplicitDefaultCredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.FileCredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.ImplicitDefaultCredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.NamedProfileCredentialsStrategy;

public class CredentialsProviderFactory {
    private final List<CredentialsStrategy> strategies = new ArrayList<CredentialsStrategy>();

    public CredentialsProviderFactory() {
        this.strategies.add(new ExplicitDefaultCredentialsStrategy());
        this.strategies.add(new AccessKeyPairCredentialsStrategy());
        this.strategies.add(new FileCredentialsStrategy());
        this.strategies.add(new NamedProfileCredentialsStrategy());
        this.strategies.add(new AnonymousCredentialsStrategy());
        this.strategies.add(new ImplicitDefaultCredentialsStrategy());
        this.strategies.add(new AssumeRoleCredentialsStrategy());
    }

    public CredentialsStrategy selectPrimaryStrategy(Map<PropertyDescriptor, String> properties) {
        for (CredentialsStrategy strategy : this.strategies) {
            if (!strategy.canCreatePrimaryCredential(properties)) continue;
            return strategy;
        }
        return null;
    }

    public CredentialsStrategy selectPrimaryStrategy(ValidationContext validationContext) {
        Map properties = validationContext.getProperties();
        return this.selectPrimaryStrategy(properties);
    }

    public Collection<ValidationResult> validate(ValidationContext validationContext) {
        CredentialsStrategy selectedStrategy = this.selectPrimaryStrategy(validationContext);
        ArrayList<ValidationResult> validationFailureResults = new ArrayList<ValidationResult>();
        for (CredentialsStrategy strategy : this.strategies) {
            Collection<ValidationResult> strategyValidationFailures = strategy.validate(validationContext, selectedStrategy);
            if (strategyValidationFailures == null) continue;
            validationFailureResults.addAll(strategyValidationFailures);
        }
        return validationFailureResults;
    }

    public AWSCredentialsProvider getCredentialsProvider(Map<PropertyDescriptor, String> properties) {
        CredentialsStrategy primaryStrategy = this.selectPrimaryStrategy(properties);
        AWSCredentialsProvider primaryCredentialsProvider = primaryStrategy.getCredentialsProvider(properties);
        AWSCredentialsProvider derivedCredentialsProvider = null;
        for (CredentialsStrategy strategy : this.strategies) {
            if (!strategy.canCreateDerivedCredential(properties)) continue;
            derivedCredentialsProvider = strategy.getDerivedCredentialsProvider(properties, primaryCredentialsProvider);
            break;
        }
        if (derivedCredentialsProvider != null) {
            return derivedCredentialsProvider;
        }
        return primaryCredentialsProvider;
    }
}

