/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3.encryption;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.KMSEncryptionMaterialsProvider;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processors.aws.s3.encryption.S3EncryptionStrategy;

public class ClientSideKMSEncryptionStrategy
implements S3EncryptionStrategy {
    @Override
    public AmazonS3Client createEncryptionClient(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration, String kmsRegion, String keyIdOrMaterial) {
        KMSEncryptionMaterialsProvider materialProvider = new KMSEncryptionMaterialsProvider(keyIdOrMaterial);
        boolean haveKmsRegion = StringUtils.isNotBlank((CharSequence)kmsRegion);
        CryptoConfiguration cryptoConfig = new CryptoConfiguration();
        if (haveKmsRegion) {
            Region awsRegion = Region.getRegion((Regions)Regions.fromName((String)kmsRegion));
            cryptoConfig.setAwsKmsRegion(awsRegion);
        }
        AmazonS3EncryptionClient client = new AmazonS3EncryptionClient(credentialsProvider, (EncryptionMaterialsProvider)materialProvider, cryptoConfig);
        return client;
    }
}

