/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.GetObjectTaggingRequest;
import com.amazonaws.services.s3.model.GetObjectTaggingResult;
import com.amazonaws.services.s3.model.ObjectTagging;
import com.amazonaws.services.s3.model.SetObjectTaggingRequest;
import com.amazonaws.services.s3.model.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.s3.AbstractS3Processor;
import org.apache.nifi.processors.aws.s3.FetchS3Object;
import org.apache.nifi.processors.aws.s3.ListS3;
import org.apache.nifi.processors.aws.s3.PutS3Object;
import org.apache.nifi.util.StringUtils;

@SupportsBatching
@WritesAttributes(value={@WritesAttribute(attribute="s3.tag.___", description="The tags associated with the S3 object will be written as part of the FlowFile attributes"), @WritesAttribute(attribute="s3.exception", description="The class name of the exception thrown during processor execution"), @WritesAttribute(attribute="s3.additionalDetails", description="The S3 supplied detail from the failed operation"), @WritesAttribute(attribute="s3.statusCode", description="The HTTP error code (if available) from the failed operation"), @WritesAttribute(attribute="s3.errorCode", description="The S3 moniker of the failed operation"), @WritesAttribute(attribute="s3.errorMessage", description="The S3 exception message from the failed operation")})
@SeeAlso(value={PutS3Object.class, FetchS3Object.class, ListS3.class})
@Tags(value={"Amazon", "S3", "AWS", "Archive", "Tag"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Sets tags on a FlowFile within an Amazon S3 Bucket. If attempting to tag a file that does not exist, FlowFile is routed to success.")
public class TagS3Object
extends AbstractS3Processor {
    public static final PropertyDescriptor TAG_KEY = new PropertyDescriptor.Builder().name("tag-key").displayName("Tag Key").description("The key of the tag that will be set on the S3 Object").addValidator((Validator)new StandardValidators.StringLengthValidator(1, 127)).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).build();
    public static final PropertyDescriptor TAG_VALUE = new PropertyDescriptor.Builder().name("tag-value").displayName("Tag Value").description("The value of the tag that will be set on the S3 Object").addValidator((Validator)new StandardValidators.StringLengthValidator(1, 255)).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).build();
    public static final PropertyDescriptor APPEND_TAG = new PropertyDescriptor.Builder().name("append-tag").displayName("Append Tag").description("If set to true, the tag will be appended to the existing set of tags on the S3 object. Any existing tags with the same key as the new tag will be updated with the specified value. If set to false, the existing tags will be removed and the new tag will be set on the S3 object.").addValidator(StandardValidators.BOOLEAN_VALIDATOR).allowableValues(new String[]{"true", "false"}).expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).defaultValue("true").build();
    public static final PropertyDescriptor VERSION_ID = new PropertyDescriptor.Builder().name("version").displayName("Version ID").description("The Version of the Object to tag").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).build();
    public static final List<PropertyDescriptor> properties = Collections.unmodifiableList(Arrays.asList(KEY, BUCKET, VERSION_ID, TAG_KEY, TAG_VALUE, APPEND_TAG, ACCESS_KEY, SECRET_KEY, CREDENTIALS_FILE, AWS_CREDENTIALS_PROVIDER_SERVICE, REGION, TIMEOUT, SSL_CONTEXT_SERVICE, ENDPOINT_OVERRIDE, SIGNER_OVERRIDE, PROXY_CONFIGURATION_SERVICE, PROXY_HOST, PROXY_HOST_PORT, PROXY_USERNAME, PROXY_PASSWORD));

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        long startNanos = System.nanoTime();
        String bucket = context.getProperty(BUCKET).evaluateAttributeExpressions(flowFile).getValue();
        String key = context.getProperty(KEY).evaluateAttributeExpressions(flowFile).getValue();
        String newTagKey = context.getProperty(TAG_KEY).evaluateAttributeExpressions(flowFile).getValue();
        String newTagVal = context.getProperty(TAG_VALUE).evaluateAttributeExpressions(flowFile).getValue();
        if (StringUtils.isBlank((String)bucket)) {
            this.failFlowWithBlankEvaluatedProperty(session, flowFile, BUCKET);
            return;
        }
        if (StringUtils.isBlank((String)key)) {
            this.failFlowWithBlankEvaluatedProperty(session, flowFile, KEY);
            return;
        }
        if (StringUtils.isBlank((String)newTagKey)) {
            this.failFlowWithBlankEvaluatedProperty(session, flowFile, TAG_KEY);
            return;
        }
        if (StringUtils.isBlank((String)newTagVal)) {
            this.failFlowWithBlankEvaluatedProperty(session, flowFile, TAG_VALUE);
            return;
        }
        String version = context.getProperty(VERSION_ID).evaluateAttributeExpressions(flowFile).getValue();
        AmazonS3Client s3 = (AmazonS3Client)this.getClient();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        try {
            if (context.getProperty(APPEND_TAG).asBoolean().booleanValue()) {
                GetObjectTaggingRequest gr = new GetObjectTaggingRequest(bucket, key);
                GetObjectTaggingResult res = s3.getObjectTagging(gr);
                tags = res.getTagSet().stream().filter(t -> !t.getKey().equals(newTagKey)).collect(Collectors.toList());
            }
            tags.add(new Tag(newTagKey, newTagVal));
            SetObjectTaggingRequest r = StringUtils.isBlank((String)version) ? new SetObjectTaggingRequest(bucket, key, new ObjectTagging(tags)) : new SetObjectTaggingRequest(bucket, key, version, new ObjectTagging(tags));
            s3.setObjectTagging(r);
        }
        catch (AmazonServiceException ase) {
            flowFile = this.extractExceptionDetails((Exception)((Object)ase), session, flowFile);
            this.getLogger().error("Failed to tag S3 Object for {}; routing to failure", new Object[]{flowFile, ase});
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        flowFile = this.setTagAttributes(session, flowFile, tags);
        session.transfer(flowFile, REL_SUCCESS);
        String url = s3.getResourceUrl(bucket, key);
        long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
        this.getLogger().info("Successfully tagged S3 Object for {} in {} millis; routing to success", new Object[]{flowFile, transferMillis});
        session.getProvenanceReporter().invokeRemoteProcess(flowFile, url, "Object tagged");
    }

    private void failFlowWithBlankEvaluatedProperty(ProcessSession session, FlowFile flowFile, PropertyDescriptor pd) {
        this.getLogger().error("{} value is blank after attribute expression language evaluation", new Object[]{pd.getName()});
        flowFile = session.penalize(flowFile);
        session.transfer(flowFile, REL_FAILURE);
    }

    private FlowFile setTagAttributes(ProcessSession session, FlowFile flowFile, List<Tag> tags) {
        flowFile = session.removeAllAttributes(flowFile, Pattern.compile("^s3\\.tag\\..*"));
        HashMap tagAttrs = new HashMap();
        tags.stream().forEach(t -> tagAttrs.put("s3.tag." + t.getKey(), t.getValue()));
        flowFile = session.putAllAttributes(flowFile, tagAttrs);
        return flowFile;
    }
}

