/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.credentials.provider.factory.strategies;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.processors.aws.credentials.provider.factory.CredentialPropertyDescriptors;
import org.apache.nifi.processors.aws.credentials.provider.factory.CredentialsStrategy;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.AbstractCredentialsStrategy;

public class AssumeRoleCredentialsStrategy
extends AbstractCredentialsStrategy {
    public AssumeRoleCredentialsStrategy() {
        super("Assume Role", new PropertyDescriptor[]{CredentialPropertyDescriptors.ASSUME_ROLE_ARN, CredentialPropertyDescriptors.ASSUME_ROLE_NAME, CredentialPropertyDescriptors.MAX_SESSION_TIME});
    }

    @Override
    public boolean canCreatePrimaryCredential(Map<PropertyDescriptor, String> properties) {
        return false;
    }

    @Override
    public boolean canCreateDerivedCredential(Map<PropertyDescriptor, String> properties) {
        String assumeRoleArn = properties.get(CredentialPropertyDescriptors.ASSUME_ROLE_ARN);
        String assumeRoleName = properties.get(CredentialPropertyDescriptors.ASSUME_ROLE_NAME);
        return assumeRoleArn != null && !assumeRoleArn.isEmpty() && assumeRoleName != null && !assumeRoleName.isEmpty();
    }

    public boolean proxyVariablesValidForAssumeRole(Map<PropertyDescriptor, String> properties) {
        String assumeRoleProxyHost = properties.get(CredentialPropertyDescriptors.ASSUME_ROLE_PROXY_HOST);
        String assumeRoleProxyPort = properties.get(CredentialPropertyDescriptors.ASSUME_ROLE_PROXY_PORT);
        return assumeRoleProxyHost != null && !assumeRoleProxyHost.isEmpty() && assumeRoleProxyPort != null && !assumeRoleProxyPort.isEmpty();
    }

    @Override
    public Collection<ValidationResult> validate(ValidationContext validationContext, CredentialsStrategy primaryStrategy) {
        boolean assumeRoleArnIsSet = validationContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_ARN).isSet();
        boolean assumeRoleNameIsSet = validationContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_NAME).isSet();
        Integer maxSessionTime = validationContext.getProperty(CredentialPropertyDescriptors.MAX_SESSION_TIME).asInteger();
        boolean assumeRoleExternalIdIsSet = validationContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_EXTERNAL_ID).isSet();
        boolean assumeRoleProxyHostIsSet = validationContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_PROXY_HOST).isSet();
        boolean assumeRoleProxyPortIsSet = validationContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_PROXY_PORT).isSet();
        boolean assumeRoleSTSEndpointIsSet = validationContext.getProperty(CredentialPropertyDescriptors.ASSUME_ROLE_STS_ENDPOINT).isSet();
        ArrayList<ValidationResult> validationFailureResults = new ArrayList<ValidationResult>();
        if (assumeRoleArnIsSet ^ assumeRoleNameIsSet) {
            validationFailureResults.add(new ValidationResult.Builder().input("Assume Role Arn and Name").valid(false).explanation("Assume role requires both arn and name to be set").build());
        }
        if (maxSessionTime < 900 || maxSessionTime > 3600) {
            validationFailureResults.add(new ValidationResult.Builder().valid(false).input("" + maxSessionTime).explanation(CredentialPropertyDescriptors.MAX_SESSION_TIME.getDisplayName() + " must be between 900 and 3600 seconds").build());
        }
        if (!(!assumeRoleExternalIdIsSet || assumeRoleArnIsSet && assumeRoleNameIsSet)) {
            validationFailureResults.add(new ValidationResult.Builder().input("Assume Role External ID").valid(false).explanation("Assume role requires both arn and name to be set with External ID").build());
        }
        if (!(!assumeRoleSTSEndpointIsSet || assumeRoleArnIsSet && assumeRoleNameIsSet)) {
            validationFailureResults.add(new ValidationResult.Builder().input("Assume Role STS Endpoint").valid(false).explanation("Assume role requires both arn and name to be set with STS Endpoint").build());
        }
        if (assumeRoleProxyHostIsSet ^ assumeRoleProxyPortIsSet) {
            validationFailureResults.add(new ValidationResult.Builder().input("Assume Role Proxy Host and Port").valid(false).explanation("Assume role with proxy requires both host and port for the proxy to be set").build());
        }
        return validationFailureResults;
    }

    @Override
    public AWSCredentialsProvider getCredentialsProvider(Map<PropertyDescriptor, String> properties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AWSCredentialsProvider getDerivedCredentialsProvider(Map<PropertyDescriptor, String> properties, AWSCredentialsProvider primaryCredentialsProvider) {
        String assumeRoleArn = properties.get(CredentialPropertyDescriptors.ASSUME_ROLE_ARN);
        String assumeRoleName = properties.get(CredentialPropertyDescriptors.ASSUME_ROLE_NAME);
        String rawMaxSessionTime = properties.get(CredentialPropertyDescriptors.MAX_SESSION_TIME);
        rawMaxSessionTime = rawMaxSessionTime != null ? rawMaxSessionTime : CredentialPropertyDescriptors.MAX_SESSION_TIME.getDefaultValue();
        Integer maxSessionTime = Integer.parseInt(rawMaxSessionTime.trim());
        String assumeRoleExternalId = properties.get(CredentialPropertyDescriptors.ASSUME_ROLE_EXTERNAL_ID);
        String assumeRoleSTSEndpoint = properties.get(CredentialPropertyDescriptors.ASSUME_ROLE_STS_ENDPOINT);
        ClientConfiguration config = new ClientConfiguration();
        if (this.proxyVariablesValidForAssumeRole(properties)) {
            String assumeRoleProxyHost = properties.get(CredentialPropertyDescriptors.ASSUME_ROLE_PROXY_HOST);
            Integer assumeRoleProxyPort = Integer.parseInt(properties.get(CredentialPropertyDescriptors.ASSUME_ROLE_PROXY_PORT));
            config.withProxyHost(assumeRoleProxyHost);
            config.withProxyPort(assumeRoleProxyPort.intValue());
        }
        AWSSecurityTokenServiceClient securityTokenService = new AWSSecurityTokenServiceClient(primaryCredentialsProvider, config);
        if (assumeRoleSTSEndpoint != null && !assumeRoleSTSEndpoint.isEmpty()) {
            securityTokenService.setEndpoint(assumeRoleSTSEndpoint);
        }
        STSAssumeRoleSessionCredentialsProvider.Builder builder = new STSAssumeRoleSessionCredentialsProvider.Builder(assumeRoleArn, assumeRoleName).withStsClient((AWSSecurityTokenService)securityTokenService).withRoleSessionDurationSeconds(maxSessionTime.intValue());
        if (assumeRoleExternalId != null && !assumeRoleExternalId.isEmpty()) {
            builder = builder.withExternalId(assumeRoleExternalId);
        }
        STSAssumeRoleSessionCredentialsProvider credsProvider = builder.build();
        return credsProvider;
    }
}

