/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.http.conn.ssl.SdkTLSSocketFactory;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.AwsClientCache;
import org.apache.nifi.processors.aws.AwsClientDetails;
import org.apache.nifi.processors.aws.AwsClientProvider;
import org.apache.nifi.processors.aws.credentials.provider.factory.CredentialPropertyDescriptors;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxyConfigurationService;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.ssl.SSLContextService;

@Deprecated
public abstract class AbstractAWSProcessor<ClientType extends AmazonWebServiceClient>
extends AbstractSessionFactoryProcessor
implements AwsClientProvider<ClientType> {
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles are routed to success relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles are routed to failure relationship").build();
    public static final Set<Relationship> relationships = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));
    public static final PropertyDescriptor CREDENTIALS_FILE = CredentialPropertyDescriptors.CREDENTIALS_FILE;
    public static final PropertyDescriptor ACCESS_KEY = CredentialPropertyDescriptors.ACCESS_KEY;
    public static final PropertyDescriptor SECRET_KEY = CredentialPropertyDescriptors.SECRET_KEY;
    public static final PropertyDescriptor PROXY_HOST = new PropertyDescriptor.Builder().name("Proxy Host").description("Proxy host name or IP").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PROXY_HOST_PORT = new PropertyDescriptor.Builder().name("Proxy Host Port").description("Proxy host port").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).addValidator(StandardValidators.PORT_VALIDATOR).build();
    public static final PropertyDescriptor PROXY_USERNAME = new PropertyDescriptor.Builder().name("proxy-user-name").displayName("Proxy Username").description("Proxy username").expressionLanguageSupported(true).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PROXY_PASSWORD = new PropertyDescriptor.Builder().name("proxy-user-password").displayName("Proxy Password").description("Proxy password").expressionLanguageSupported(true).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor REGION = new PropertyDescriptor.Builder().name("Region").description("The AWS Region to connect to.").required(true).allowableValues(AbstractAWSProcessor.getAvailableRegions()).defaultValue(AbstractAWSProcessor.createAllowableValue(Regions.DEFAULT_REGION).getValue()).build();
    public static final PropertyDescriptor TIMEOUT = new PropertyDescriptor.Builder().name("Communications Timeout").description("The amount of time to wait in order to establish a connection to AWS or receive data from AWS before timing out.").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("30 secs").build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("Specifies an optional SSL Context Service that, if provided, will be used to create connections").required(false).identifiesControllerService(SSLContextService.class).build();
    public static final PropertyDescriptor ENDPOINT_OVERRIDE = new PropertyDescriptor.Builder().name("Endpoint Override URL").description("Endpoint URL to use instead of the AWS default including scheme, host, port, and path. The AWS libraries select an endpoint URL based on the AWS region, but this property overrides the selected endpoint URL, allowing use with other S3-compatible endpoints.").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).addValidator(StandardValidators.URL_VALIDATOR).build();
    protected static final String VPCE_ENDPOINT_SUFFIX = ".vpce.amazonaws.com";
    protected static final Pattern VPCE_ENDPOINT_PATTERN = Pattern.compile("^(?:.+[vpce-][a-z0-9-]+\\.)?([a-z0-9-]+)$");
    protected static final Protocol DEFAULT_PROTOCOL = Protocol.HTTPS;
    protected static final String DEFAULT_USER_AGENT = "NiFi";
    private static final ProxySpec[] PROXY_SPECS = new ProxySpec[]{ProxySpec.HTTP_AUTH};
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = ProxyConfiguration.createProxyConfigPropertyDescriptor((boolean)true, (ProxySpec[])PROXY_SPECS);
    private final AwsClientCache<ClientType> awsClientCache = new AwsClientCache();

    public static AllowableValue createAllowableValue(Regions region) {
        return new AllowableValue(region.getName(), region.getDescription(), "AWS Region Code : " + region.getName());
    }

    public static AllowableValue[] getAvailableRegions() {
        ArrayList<AllowableValue> values = new ArrayList<AllowableValue>();
        for (Regions region : Regions.values()) {
            values.add(AbstractAWSProcessor.createAllowableValue(region));
        }
        return values.toArray(new AllowableValue[0]);
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        boolean accessKeySet = validationContext.getProperty(ACCESS_KEY).isSet();
        boolean secretKeySet = validationContext.getProperty(SECRET_KEY).isSet();
        if (accessKeySet && !secretKeySet || secretKeySet && !accessKeySet) {
            validationResults.add(new ValidationResult.Builder().input("Access Key").valid(false).explanation("If setting Secret Key or Access Key, must set both").build());
        }
        boolean credentialsFileSet = validationContext.getProperty(CREDENTIALS_FILE).isSet();
        if ((secretKeySet || accessKeySet) && credentialsFileSet) {
            validationResults.add(new ValidationResult.Builder().input("Access Key").valid(false).explanation("Cannot set both Credentials File and Secret Key/Access Key").build());
        }
        boolean proxyHostSet = validationContext.getProperty(PROXY_HOST).isSet();
        boolean proxyPortSet = validationContext.getProperty(PROXY_HOST_PORT).isSet();
        boolean proxyConfigServiceSet = validationContext.getProperty(ProxyConfigurationService.PROXY_CONFIGURATION_SERVICE).isSet();
        if (proxyHostSet && !proxyPortSet || !proxyHostSet && proxyPortSet) {
            validationResults.add(new ValidationResult.Builder().subject("Proxy Host and Port").valid(false).explanation("If Proxy Host or Proxy Port is set, both must be set").build());
        }
        boolean proxyUserSet = validationContext.getProperty(PROXY_USERNAME).isSet();
        boolean proxyPwdSet = validationContext.getProperty(PROXY_PASSWORD).isSet();
        if (proxyUserSet && !proxyPwdSet || !proxyUserSet && proxyPwdSet) {
            validationResults.add(new ValidationResult.Builder().subject("Proxy User and Password").valid(false).explanation("If Proxy Username or Proxy Password is set, both must be set").build());
        }
        if (proxyUserSet && !proxyHostSet) {
            validationResults.add(new ValidationResult.Builder().subject("Proxy").valid(false).explanation("If Proxy Username or Proxy Password").build());
        }
        ProxyConfiguration.validateProxySpec((ValidationContext)validationContext, validationResults, (ProxySpec[])PROXY_SPECS);
        if (proxyHostSet && proxyConfigServiceSet) {
            validationResults.add(new ValidationResult.Builder().subject("Proxy Configuration Service").valid(false).explanation("Either Proxy Username and Proxy Password must be set or Proxy Configuration Service but not both").build());
        }
        return validationResults;
    }

    protected ClientConfiguration createConfiguration(ProcessContext context) {
        return this.createConfiguration((PropertyContext)context, context.getMaxConcurrentTasks());
    }

    protected ClientConfiguration createConfiguration(PropertyContext context, int maxConcurrentTasks) {
        ProxyConfiguration proxyConfig;
        SSLContextService sslContextService;
        ClientConfiguration config = new ClientConfiguration();
        config.setMaxConnections(maxConcurrentTasks);
        config.setMaxErrorRetry(0);
        config.setUserAgent(DEFAULT_USER_AGENT);
        config.setProtocol(DEFAULT_PROTOCOL);
        int commsTimeout = context.getProperty(TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        config.setConnectionTimeout(commsTimeout);
        config.setSocketTimeout(commsTimeout);
        if (this.getSupportedPropertyDescriptors().contains(SSL_CONTEXT_SERVICE) && (sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class)) != null) {
            SSLContext sslContext = sslContextService.createContext();
            SdkTLSSocketFactory sdkTLSSocketFactory = new SdkTLSSocketFactory(sslContext, (HostnameVerifier)new DefaultHostnameVerifier());
            config.getApacheHttpClientConfig().setSslSocketFactory((ConnectionSocketFactory)sdkTLSSocketFactory);
        }
        if (Proxy.Type.HTTP.equals((Object)(proxyConfig = ProxyConfiguration.getConfiguration((PropertyContext)context, () -> {
            if (context.getProperty(PROXY_HOST).isSet()) {
                ProxyConfiguration componentProxyConfig = new ProxyConfiguration();
                String proxyHost = context.getProperty(PROXY_HOST).evaluateAttributeExpressions().getValue();
                Integer proxyPort = context.getProperty(PROXY_HOST_PORT).evaluateAttributeExpressions().asInteger();
                String proxyUsername = context.getProperty(PROXY_USERNAME).evaluateAttributeExpressions().getValue();
                String proxyPassword = context.getProperty(PROXY_PASSWORD).evaluateAttributeExpressions().getValue();
                componentProxyConfig.setProxyType(Proxy.Type.HTTP);
                componentProxyConfig.setProxyServerHost(proxyHost);
                componentProxyConfig.setProxyServerPort(proxyPort);
                componentProxyConfig.setProxyUserName(proxyUsername);
                componentProxyConfig.setProxyUserPassword(proxyPassword);
                return componentProxyConfig;
            }
            if (context.getProperty(ProxyConfigurationService.PROXY_CONFIGURATION_SERVICE).isSet()) {
                ProxyConfigurationService configurationService = (ProxyConfigurationService)context.getProperty(ProxyConfigurationService.PROXY_CONFIGURATION_SERVICE).asControllerService(ProxyConfigurationService.class);
                return configurationService.getConfiguration();
            }
            return ProxyConfiguration.DIRECT_CONFIGURATION;
        })).getProxyType())) {
            config.setProxyHost(proxyConfig.getProxyServerHost());
            config.setProxyPort(proxyConfig.getProxyServerPort().intValue());
            if (proxyConfig.hasCredential()) {
                config.setProxyUsername(proxyConfig.getProxyUserName());
                config.setProxyPassword(proxyConfig.getProxyUserPassword());
            }
        }
        return config;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.getClient(context);
    }

    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        ProcessSession session = sessionFactory.createSession();
        try {
            this.onTrigger(context, session);
            session.commitAsync();
        }
        catch (Throwable t) {
            session.rollback(true);
            throw t;
        }
    }

    public abstract void onTrigger(ProcessContext var1, ProcessSession var2) throws ProcessException;

    @Override
    public ClientType createClient(ProcessContext context, AwsClientDetails awsClientDetails) {
        AWSCredentials credentials = this.getCredentials((PropertyContext)context);
        ClientConfiguration configuration = this.createConfiguration(context);
        ClientType createdClient = this.createClient(context, credentials, configuration);
        this.setRegionAndInitializeEndpoint(awsClientDetails.getRegion(), context, (AmazonWebServiceClient)createdClient);
        return createdClient;
    }

    protected ClientType createClient(ProcessContext context) {
        return this.createClient(context, new AwsClientDetails(this.getRegion(context)));
    }

    protected void setRegionAndInitializeEndpoint(Region region, ProcessContext context, AmazonWebServiceClient client) {
        String urlstr;
        if (region != null && client != null) {
            client.setRegion(region);
        }
        if (client != null && this.getSupportedPropertyDescriptors().contains(ENDPOINT_OVERRIDE) && !(urlstr = StringUtils.trimToEmpty((String)context.getProperty(ENDPOINT_OVERRIDE).evaluateAttributeExpressions().getValue())).isEmpty()) {
            this.getLogger().info("Overriding endpoint with {}", new Object[]{urlstr});
            if (urlstr.endsWith(VPCE_ENDPOINT_SUFFIX)) {
                String regionValue = this.parseRegionForVPCE(urlstr, region.getName());
                client.setEndpoint(urlstr, client.getServiceName(), regionValue);
            } else if (this.isCustomSignerConfigured(context)) {
                client.setEndpoint(urlstr, client.getServiceName(), region.getName());
            } else {
                client.setEndpoint(urlstr);
            }
        }
    }

    protected Region getRegion(ProcessContext context) {
        String regionValue;
        if (this.getSupportedPropertyDescriptors().contains(REGION) && (regionValue = context.getProperty(REGION).getValue()) != null) {
            return Region.getRegion((Regions)Regions.fromName((String)regionValue));
        }
        return null;
    }

    protected boolean isCustomSignerConfigured(ProcessContext context) {
        return false;
    }

    private String parseRegionForVPCE(String url, String configuredRegion) {
        int index = url.length() - VPCE_ENDPOINT_SUFFIX.length();
        Matcher matcher = VPCE_ENDPOINT_PATTERN.matcher(url.substring(0, index));
        if (matcher.matches()) {
            return matcher.group(1);
        }
        this.getLogger().info("Unable to get a match with the VPCE endpoint pattern; using the configured region: " + configuredRegion);
        return configuredRegion;
    }

    protected AWSCredentials getCredentials(PropertyContext context) {
        String accessKey = context.getProperty(ACCESS_KEY).evaluateAttributeExpressions().getValue();
        String secretKey = context.getProperty(SECRET_KEY).evaluateAttributeExpressions().getValue();
        String credentialsFile = context.getProperty(CREDENTIALS_FILE).getValue();
        if (credentialsFile != null) {
            try {
                return new PropertiesCredentials(new File(credentialsFile));
            }
            catch (IOException ioe) {
                throw new ProcessException("Could not read Credentials File", (Throwable)ioe);
            }
        }
        if (accessKey != null && secretKey != null) {
            return new BasicAWSCredentials(accessKey, secretKey);
        }
        return new AnonymousAWSCredentials();
    }

    @OnStopped
    public void onStopped() {
        this.awsClientCache.clearCache();
    }

    protected ClientType getClient(ProcessContext context, AwsClientDetails awsClientDetails) {
        return this.awsClientCache.getOrCreateClient(context, awsClientDetails, this);
    }

    protected ClientType getClient(ProcessContext context) {
        AwsClientDetails awsClientDetails = new AwsClientDetails(this.getRegion(context));
        return this.getClient(context, awsClientDetails);
    }

    @Deprecated
    protected abstract ClientType createClient(ProcessContext var1, AWSCredentials var2, ClientConfiguration var3);
}

