/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.kinesis.firehose;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehoseClient;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.kinesis.AbstractBaseKinesisProcessor;

public abstract class AbstractKinesisFirehoseProcessor
extends AbstractBaseKinesisProcessor<AmazonKinesisFirehoseClient> {
    public static final PropertyDescriptor KINESIS_FIREHOSE_DELIVERY_STREAM_NAME = new PropertyDescriptor.Builder().name("Amazon Kinesis Firehose Delivery Stream Name").description("The name of kinesis firehose delivery stream").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("Batch Size").description("Batch size for messages (1-500).").defaultValue("250").required(false).addValidator(StandardValidators.createLongValidator((long)1L, (long)500L, (boolean)true)).sensitive(false).build();
    public static final PropertyDescriptor MAX_MESSAGE_BUFFER_SIZE_MB = new PropertyDescriptor.Builder().name("Max message buffer size").description("Max message buffer").defaultValue("1 MB").required(false).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).sensitive(false).build();

    @Override
    protected AmazonKinesisFirehoseClient createClient(ProcessContext context, AWSCredentialsProvider credentialsProvider, ClientConfiguration config) {
        this.getLogger().info("Creating client using aws credentials provider");
        return new AmazonKinesisFirehoseClient(credentialsProvider, config);
    }

    @Override
    @Deprecated
    protected AmazonKinesisFirehoseClient createClient(ProcessContext context, AWSCredentials credentials, ClientConfiguration config) {
        this.getLogger().info("Creating client using aws credentials");
        return new AmazonKinesisFirehoseClient(credentials, config);
    }
}

