/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.credentials.provider.factory;

import java.util.ArrayList;
import java.util.EnumSet;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.AwsPropertyDescriptors;
import org.apache.nifi.processors.aws.signer.AwsSignerType;
import org.apache.nifi.ssl.SSLContextService;
import software.amazon.awssdk.regions.Region;

public class CredentialPropertyDescriptors {
    public static final PropertyDescriptor USE_DEFAULT_CREDENTIALS = new PropertyDescriptor.Builder().name("default-credentials").displayName("Use Default Credentials").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).addValidator(StandardValidators.BOOLEAN_VALIDATOR).sensitive(false).allowableValues(new String[]{"true", "false"}).defaultValue("false").description("If true, uses the Default Credential chain, including EC2 instance profiles or roles, environment variables, default user credentials, etc.").build();
    public static final PropertyDescriptor CREDENTIALS_FILE = new PropertyDescriptor.Builder().name("Credentials File").displayName("Credentials File").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).description("Path to a file containing AWS access key and secret key in properties file format.").build();
    public static final PropertyDescriptor ACCESS_KEY = new PropertyDescriptor.Builder().name("Access Key").displayName("Access Key ID").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor SECRET_KEY = new PropertyDescriptor.Builder().name("Secret Key").displayName("Secret Access Key").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor PROFILE_NAME = new PropertyDescriptor.Builder().name("profile-name").displayName("Profile Name").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).description("The AWS profile name for credentials from the profile configuration file.").build();
    public static final PropertyDescriptor USE_ANONYMOUS_CREDENTIALS = new PropertyDescriptor.Builder().name("anonymous-credentials").displayName("Use Anonymous Credentials").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).addValidator(StandardValidators.BOOLEAN_VALIDATOR).sensitive(false).allowableValues(new String[]{"true", "false"}).defaultValue("false").description("If true, uses Anonymous credentials").build();
    public static final PropertyDescriptor ASSUME_ROLE_ARN = new PropertyDescriptor.Builder().name("Assume Role ARN").displayName("Assume Role ARN").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).description("The AWS Role ARN for cross account access. This is used in conjunction with Assume Role Session Name and other Assume Role properties.").build();
    public static final PropertyDescriptor ASSUME_ROLE_NAME = new PropertyDescriptor.Builder().name("Assume Role Session Name").displayName("Assume Role Session Name").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).description("The AWS Role Session Name for cross account access. This is used in conjunction with Assume Role ARN.").dependsOn(ASSUME_ROLE_ARN, new AllowableValue[0]).build();
    public static final PropertyDescriptor MAX_SESSION_TIME = new PropertyDescriptor.Builder().name("Session Time").displayName("Assume Role Session Time").description("Session time for role based session (between 900 and 3600 seconds). This is used in conjunction with Assume Role ARN.").defaultValue("3600").required(false).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).sensitive(false).dependsOn(ASSUME_ROLE_ARN, new AllowableValue[0]).build();
    public static final PropertyDescriptor ASSUME_ROLE_EXTERNAL_ID = new PropertyDescriptor.Builder().name("assume-role-external-id").displayName("Assume Role External ID").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).description("External ID for cross-account access. This is used in conjunction with Assume Role ARN.").dependsOn(ASSUME_ROLE_ARN, new AllowableValue[0]).build();
    public static final PropertyDescriptor ASSUME_ROLE_SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("assume-role-ssl-context-service").displayName("Assume Role SSL Context Service").description("SSL Context Service used when connecting to the STS Endpoint.").identifiesControllerService(SSLContextService.class).required(false).dependsOn(ASSUME_ROLE_ARN, new AllowableValue[0]).build();
    public static final PropertyDescriptor ASSUME_ROLE_PROXY_HOST = new PropertyDescriptor.Builder().name("assume-role-proxy-host").displayName("Assume Role Proxy Host").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).description("Proxy host for cross-account access, if needed within your environment. This will configure a proxy to request for temporary access keys into another AWS account.").dependsOn(ASSUME_ROLE_ARN, new AllowableValue[0]).build();
    public static final PropertyDescriptor ASSUME_ROLE_PROXY_PORT = new PropertyDescriptor.Builder().name("assume-role-proxy-port").displayName("Assume Role Proxy Port").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).sensitive(false).description("Proxy port for cross-account access, if needed within your environment. This will configure a proxy to request for temporary access keys into another AWS account.").dependsOn(ASSUME_ROLE_ARN, new AllowableValue[0]).build();
    public static final PropertyDescriptor ASSUME_ROLE_STS_ENDPOINT = new PropertyDescriptor.Builder().name("assume-role-sts-endpoint").displayName("Assume Role STS Endpoint Override").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).description("The default AWS Security Token Service (STS) endpoint (\"sts.amazonaws.com\") works for all accounts that are not for China (Beijing) region or GovCloud. You only need to set this property to \"sts.cn-north-1.amazonaws.com.cn\" when you are requesting session credentials for services in China(Beijing) region or to \"sts.us-gov-west-1.amazonaws.com\" for GovCloud.").dependsOn(ASSUME_ROLE_ARN, new AllowableValue[0]).build();
    public static final PropertyDescriptor ASSUME_ROLE_STS_REGION = new PropertyDescriptor.Builder().name("assume-role-sts-region").displayName("Assume Role STS Region").description("The AWS Security Token Service (STS) region").dependsOn(ASSUME_ROLE_ARN, new AllowableValue[0]).allowableValues(CredentialPropertyDescriptors.getAvailableRegions()).defaultValue(CredentialPropertyDescriptors.createAllowableValue(Region.US_WEST_2).getValue()).build();
    public static final PropertyDescriptor ASSUME_ROLE_STS_SIGNER_OVERRIDE = new PropertyDescriptor.Builder().name("assume-role-sts-signer-override").displayName("Assume Role STS Signer Override").description("The AWS STS library uses Signature Version 4 by default. This property allows you to plug in your own custom signer implementation.").required(false).allowableValues(EnumSet.of(AwsSignerType.DEFAULT_SIGNER, AwsSignerType.AWS_V4_SIGNER, AwsSignerType.CUSTOM_SIGNER)).defaultValue(AwsSignerType.DEFAULT_SIGNER.getValue()).dependsOn(ASSUME_ROLE_ARN, new AllowableValue[0]).build();
    public static final PropertyDescriptor ASSUME_ROLE_STS_CUSTOM_SIGNER_CLASS_NAME = new PropertyDescriptor.Builder().fromPropertyDescriptor(AwsPropertyDescriptors.CUSTOM_SIGNER_CLASS_NAME).dependsOn(ASSUME_ROLE_STS_SIGNER_OVERRIDE, (DescribedValue)AwsSignerType.CUSTOM_SIGNER, new DescribedValue[0]).build();
    public static final PropertyDescriptor ASSUME_ROLE_STS_CUSTOM_SIGNER_MODULE_LOCATION = new PropertyDescriptor.Builder().fromPropertyDescriptor(AwsPropertyDescriptors.CUSTOM_SIGNER_MODULE_LOCATION).dependsOn(ASSUME_ROLE_STS_SIGNER_OVERRIDE, (DescribedValue)AwsSignerType.CUSTOM_SIGNER, new DescribedValue[0]).build();

    public static AllowableValue createAllowableValue(Region region) {
        return new AllowableValue(region.id(), region.metadata().description(), "AWS Region Code : " + region.id());
    }

    public static AllowableValue[] getAvailableRegions() {
        ArrayList<AllowableValue> values = new ArrayList<AllowableValue>();
        for (Region region : Region.regions()) {
            if (region.isGlobalRegion()) continue;
            values.add(CredentialPropertyDescriptors.createAllowableValue(region));
        }
        return values.toArray(new AllowableValue[0]);
    }
}

