/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.signer;

import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.components.DescribedValue;

public enum AwsSignerType implements DescribedValue
{
    DEFAULT_SIGNER("Default Signature", "Default Signature"),
    AWS_V4_SIGNER("AWS4SignerType", "Signature Version 4"),
    AWS_S3_V4_SIGNER("AWSS3V4SignerType", "Signature Version 4"),
    AWS_S3_V2_SIGNER("S3SignerType", "Signature Version 2"),
    CUSTOM_SIGNER("CustomSignerType", "Custom Signature");

    private static final Map<String, AwsSignerType> LOOKUP_MAP;
    private final String value;
    private final String displayName;
    private final String description;

    private AwsSignerType(String value, String displayName) {
        this(value, displayName, null);
    }

    private AwsSignerType(String value, String displayName, String description) {
        this.value = value;
        this.displayName = displayName;
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public static AwsSignerType forValue(String value) {
        return LOOKUP_MAP.get(value);
    }

    static {
        LOOKUP_MAP = new HashMap<String, AwsSignerType>();
        for (AwsSignerType signerType : AwsSignerType.values()) {
            LOOKUP_MAP.put(signerType.getValue(), signerType);
        }
    }
}

