/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws;

import com.amazonaws.AmazonWebServiceClient;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.aws.AwsClientDetails;
import org.apache.nifi.processors.aws.AwsClientProvider;

public class AwsClientCache<ClientType extends AmazonWebServiceClient> {
    private static final int MAXIMUM_CACHE_SIZE = 10;
    private final Cache<AwsClientDetails, ClientType> clientCache = Caffeine.newBuilder().maximumSize(10L).build();

    public ClientType getOrCreateClient(ProcessContext context, AwsClientDetails clientDetails, AwsClientProvider<ClientType> provider) {
        return (ClientType)((AmazonWebServiceClient)this.clientCache.get((Object)clientDetails, ignored -> provider.createClient(context, clientDetails)));
    }

    public void clearCache() {
        this.clientCache.invalidateAll();
        this.clientCache.cleanUp();
    }
}

