/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.credentials.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.nifi.processor.exception.ProcessException;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class PropertiesCredentialsProvider
implements AwsCredentialsProvider {
    private final String accessKey;
    private final String secretAccessKey;

    public PropertiesCredentialsProvider(File credentialsProperties) {
        try {
            if (!credentialsProperties.exists()) {
                throw new FileNotFoundException("File doesn't exist: " + credentialsProperties.getAbsolutePath());
            }
            try (FileInputStream stream = new FileInputStream(credentialsProperties);){
                Properties accountProperties = new Properties();
                accountProperties.load(stream);
                if (accountProperties.getProperty("accessKey") == null || accountProperties.getProperty("secretKey") == null) {
                    throw new IllegalArgumentException(String.format("The specified file (%s) doesn't contain the expected properties 'accessKey' and 'secretKey'.", credentialsProperties.getAbsolutePath()));
                }
                this.accessKey = accountProperties.getProperty("accessKey");
                this.secretAccessKey = accountProperties.getProperty("secretKey");
            }
        }
        catch (IOException e) {
            throw new ProcessException("Failed to load AWS credentials properties " + credentialsProperties, (Throwable)e);
        }
    }

    public AwsCredentials resolveCredentials() {
        return AwsBasicCredentials.create((String)this.accessKey, (String)this.secretAccessKey);
    }
}

