/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.dynamodb;

import com.amazonaws.services.dynamodbv2.document.BatchWriteItemOutcome;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.util.List;
import java.util.Map;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processors.aws.dynamodb.AbstractDynamoDBProcessor;
import org.apache.nifi.processors.aws.dynamodb.ItemKeys;

public abstract class AbstractWriteDynamoDBProcessor
extends AbstractDynamoDBProcessor {
    protected void handleUnprocessedItems(ProcessSession session, Map<ItemKeys, FlowFile> keysToFlowFileMap, String table, String hashKeyName, String hashKeyValueType, String rangeKeyName, String rangeKeyValueType, BatchWriteItemOutcome outcome) {
        BatchWriteItemResult result = outcome.getBatchWriteItemResult();
        List unprocessedItems = (List)result.getUnprocessedItems().get(table);
        if (unprocessedItems != null && unprocessedItems.size() > 0) {
            for (WriteRequest request : unprocessedItems) {
                Map<String, AttributeValue> item = this.getRequestItem(request);
                Object hashKeyValue = this.getValue(item, hashKeyName, hashKeyValueType);
                Object rangeKeyValue = this.getValue(item, rangeKeyName, rangeKeyValueType);
                this.sendUnprocessedToUnprocessedRelationship(session, keysToFlowFileMap, hashKeyValue, rangeKeyValue);
            }
        }
    }

    protected abstract Map<String, AttributeValue> getRequestItem(WriteRequest var1);
}

