/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.credentials.provider.factory;

import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;

public class CredentialPropertyDescriptors {
    public static final PropertyDescriptor USE_DEFAULT_CREDENTIALS = new PropertyDescriptor.Builder().name("default-credentials").displayName("Use Default Credentials").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).addValidator(StandardValidators.BOOLEAN_VALIDATOR).sensitive(false).allowableValues(new String[]{"true", "false"}).defaultValue("false").description("If true, uses the Default Credential chain, including EC2 instance profiles or roles, environment variables, default user credentials, etc.").build();
    public static final PropertyDescriptor CREDENTIALS_FILE = new PropertyDescriptor.Builder().name("Credentials File").displayName("Credentials File").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).description("Path to a file containing AWS access key and secret key in properties file format.").build();
    public static final PropertyDescriptor ACCESS_KEY = new PropertyDescriptor.Builder().name("Access Key").displayName("Access Key ID").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor SECRET_KEY = new PropertyDescriptor.Builder().name("Secret Key").displayName("Secret Access Key").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor PROFILE_NAME = new PropertyDescriptor.Builder().name("profile-name").displayName("Profile Name").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).description("The AWS profile name for credentials from the profile configuration file.").build();
    public static final PropertyDescriptor USE_ANONYMOUS_CREDENTIALS = new PropertyDescriptor.Builder().name("anonymous-credentials").displayName("Use Anonymous Credentials").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).addValidator(StandardValidators.BOOLEAN_VALIDATOR).sensitive(false).allowableValues(new String[]{"true", "false"}).defaultValue("false").description("If true, uses Anonymous credentials").build();
    public static final PropertyDescriptor ASSUME_ROLE_ARN = new PropertyDescriptor.Builder().name("Assume Role ARN").displayName("Assume Role ARN").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).description("The AWS Role ARN for cross account access. This is used in conjunction with role name and session timeout").build();
    public static final PropertyDescriptor ASSUME_ROLE_NAME = new PropertyDescriptor.Builder().name("Assume Role Session Name").displayName("Assume Role Session Name").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).description("The AWS Role Name for cross account access. This is used in conjunction with role ARN and session time out").build();
    public static final PropertyDescriptor MAX_SESSION_TIME = new PropertyDescriptor.Builder().name("Session Time").description("Session time for role based session (between 900 and 3600 seconds). This is used in conjunction with role ARN and name").defaultValue("3600").required(false).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor ASSUME_ROLE_EXTERNAL_ID = new PropertyDescriptor.Builder().name("assume-role-external-id").displayName("Assume Role External ID").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).description("External ID for cross-account access. This is used in conjunction with role arn, role name, and optional session time out").build();
    public static final PropertyDescriptor ASSUME_ROLE_PROXY_HOST = new PropertyDescriptor.Builder().name("assume-role-proxy-host").displayName("Assume Role Proxy Host").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).description("Proxy host for cross-account access, if needed within your environment. This will configure a proxy to request for temporary access keys into another AWS account").build();
    public static final PropertyDescriptor ASSUME_ROLE_PROXY_PORT = new PropertyDescriptor.Builder().name("assume-role-proxy-port").displayName("Assume Role Proxy Port").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).sensitive(false).description("Proxy port for cross-account access, if needed within your environment. This will configure a proxy to request for temporary access keys into another AWS account").build();
    public static final PropertyDescriptor ASSUME_ROLE_STS_ENDPOINT = new PropertyDescriptor.Builder().name("assume-role-sts-endpoint").displayName("Assume Role STS Endpoint").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).description("The default AWS Security Token Service (STS) endpoint (\"sts.amazonaws.com\") works for all accounts that are not for China (Beijing) region or GovCloud. You only need to set this property to \"sts.cn-north-1.amazonaws.com.cn\" when you are requesting session credentials for services in China(Beijing) region or to \"sts.us-gov-west-1.amazonaws.com\" for GovCloud.").build();
}

