/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.lambda;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.lambda.AWSLambdaClient;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.AbstractAWSCredentialsProviderProcessor;

public abstract class AbstractAWSLambdaProcessor
extends AbstractAWSCredentialsProviderProcessor<AWSLambdaClient> {
    public static final PropertyDescriptor AWS_LAMBDA_FUNCTION_NAME = new PropertyDescriptor.Builder().name("Amazon Lambda Name").description("The Lambda Function Name").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor AWS_LAMBDA_FUNCTION_QUALIFIER = new PropertyDescriptor.Builder().name("Amazon Lambda Qualifier (version)").description("The Lambda Function Version").defaultValue("$LATEST").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();

    @Override
    protected AWSLambdaClient createClient(ProcessContext context, AWSCredentialsProvider credentialsProvider, ClientConfiguration config) {
        this.getLogger().info("Creating client using aws credentials provider");
        return new AWSLambdaClient(credentialsProvider, config);
    }

    @Override
    protected AWSLambdaClient createClient(ProcessContext context, AWSCredentials credentials, ClientConfiguration config) {
        this.getLogger().info("Creating client using aws credentials");
        return new AWSLambdaClient(credentials, config);
    }
}

