/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.kinesis;

import com.amazonaws.AmazonWebServiceClient;
import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processors.aws.AbstractAWSCredentialsProviderProcessor;

public abstract class AbstractBaseKinesisProcessor<ClientType extends AmazonWebServiceClient>
extends AbstractAWSCredentialsProviderProcessor<ClientType> {
    public static final int MAX_MESSAGE_SIZE = 1024000;

    private void handleFlowFileTooBig(ProcessSession session, FlowFile flowFileCandidate, String message) {
        FlowFile tooBig = session.putAttribute(flowFileCandidate, message, "record too big " + flowFileCandidate.getSize() + " max allowed 1024000");
        session.transfer(tooBig, REL_FAILURE);
        this.getLogger().error("Failed to publish to kinesis records {} because the size was greater than {} bytes", new Object[]{tooBig, 1024000});
    }

    protected List<FlowFile> filterMessagesByMaxSize(ProcessSession session, int batchSize, long maxBufferSizeBytes, String message) {
        ArrayList<FlowFile> flowFiles = new ArrayList<FlowFile>(batchSize);
        long currentBufferSizeBytes = 0L;
        for (int i = 0; i < batchSize && currentBufferSizeBytes <= maxBufferSizeBytes; ++i) {
            FlowFile flowFileCandidate = session.get();
            if (flowFileCandidate == null) continue;
            if (flowFileCandidate.getSize() > 1024000L) {
                this.handleFlowFileTooBig(session, flowFileCandidate, message);
                continue;
            }
            currentBufferSizeBytes += flowFileCandidate.getSize();
            flowFiles.add(flowFileCandidate);
        }
        return flowFiles;
    }
}

