/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.asana.utils;

import com.asana.Json;
import com.asana.models.Project;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.apache.nifi.controller.asana.AsanaClient;
import org.apache.nifi.controller.asana.AsanaEventsCollection;
import org.apache.nifi.processors.asana.utils.AbstractAsanaObjectFetcher;
import org.apache.nifi.processors.asana.utils.AsanaObject;
import org.apache.nifi.processors.asana.utils.AsanaObjectFetcherException;
import org.apache.nifi.processors.asana.utils.AsanaObjectState;

public class AsanaProjectEventFetcher
extends AbstractAsanaObjectFetcher {
    private static final String PROJECT_GID = ".project.gid";
    private static final String NEXT_SYNC_TOKEN = ".nextSyncToken";
    private final AsanaClient client;
    private final Project project;
    private String nextSyncToken;

    public AsanaProjectEventFetcher(AsanaClient client, String projectName) {
        this.client = client;
        this.project = client.getProjectByName(projectName);
        this.nextSyncToken = "";
    }

    @Override
    public Map<String, String> saveState() {
        HashMap<String, String> state = new HashMap<String, String>();
        state.put(this.getClass().getName() + PROJECT_GID, this.project.gid);
        state.put(this.getClass().getName() + NEXT_SYNC_TOKEN, this.nextSyncToken);
        return state;
    }

    @Override
    public void loadState(Map<String, String> state) {
        if (!this.project.gid.equals(state.get(this.getClass().getName() + PROJECT_GID))) {
            throw new AsanaObjectFetcherException("Project gid does not match.");
        }
        this.nextSyncToken = state.getOrDefault(this.getClass().getName() + NEXT_SYNC_TOKEN, "");
    }

    @Override
    public void clearState() {
        this.nextSyncToken = "";
    }

    @Override
    protected Iterator<AsanaObject> fetch() {
        AsanaEventsCollection events = this.client.getEvents(this.project, this.nextSyncToken);
        Iterator<AsanaObject> result = StreamSupport.stream(events.spliterator(), false).map(e -> new AsanaObject(AsanaObjectState.NEW, String.format("%s.%s.%s.%d", e.type, e.resource.resourceType, e.resource.gid, e.createdAt.getValue()), Json.getInstance().toJson(e))).iterator();
        this.nextSyncToken = events.getNextSyncToken();
        return result;
    }
}

