/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.admin.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.nifi.admin.RepositoryUtils;
import org.apache.nifi.admin.dao.DataAccessException;
import org.apache.nifi.admin.dao.IdpUserGroupDAO;
import org.apache.nifi.idp.IdpType;
import org.apache.nifi.idp.IdpUserGroup;

public class StandardIdpUserGroupDAO
implements IdpUserGroupDAO {
    private static final String INSERT_USER_GROUP = "INSERT INTO IDENTITY_PROVIDER_USER_GROUP (IDENTITY, IDP_TYPE, GROUP_NAME, CREATED) VALUES (?, ?, ?, ?)";
    private static final String SELECT_USER_GROUP_BY_ID = "SELECT ID, IDENTITY, IDP_TYPE, GROUP_NAME, CREATED FROM IDENTITY_PROVIDER_USER_GROUP WHERE ID =?";
    private static final String SELECT_USER_GROUP_BY_IDENTITY = "SELECT ID, IDENTITY, IDP_TYPE, GROUP_NAME, CREATED FROM IDENTITY_PROVIDER_USER_GROUP WHERE IDENTITY =?";
    private static final String DELETE_USER_GROUPS_BY_ID = "DELETE FROM IDENTITY_PROVIDER_USER_GROUP WHERE ID = ?";
    private static final String DELETE_USER_GROUPS_BY_IDENTITY = "DELETE FROM IDENTITY_PROVIDER_USER_GROUP WHERE IDENTITY = ?";
    private final Connection connection;

    public StandardIdpUserGroupDAO(Connection connection) {
        this.connection = connection;
    }

    @Override
    public IdpUserGroup createUserGroup(IdpUserGroup userGroup) throws DataAccessException {
        ResultSet rs;
        PreparedStatement statement;
        block6: {
            if (userGroup == null) {
                throw new IllegalArgumentException("UserGroup cannot be null");
            }
            statement = null;
            rs = null;
            statement = this.connection.prepareStatement(INSERT_USER_GROUP, 1);
            this.populateStatement(statement, userGroup);
            int updateCount = statement.executeUpdate();
            rs = statement.getGeneratedKeys();
            if (updateCount != 1 || !rs.next()) break block6;
            userGroup.setId(rs.getInt(1));
            IdpUserGroup idpUserGroup = userGroup;
            RepositoryUtils.closeQuietly(rs);
            RepositoryUtils.closeQuietly(statement);
            return idpUserGroup;
        }
        try {
            try {
                throw new DataAccessException("Unable to save IDP User Group.");
            }
            catch (SQLException sqle) {
                throw new DataAccessException(sqle);
            }
        }
        catch (Throwable throwable) {
            RepositoryUtils.closeQuietly(rs);
            RepositoryUtils.closeQuietly(statement);
            throw throwable;
        }
    }

    @Override
    public List<IdpUserGroup> createUserGroups(List<IdpUserGroup> userGroups) throws DataAccessException {
        if (userGroups == null) {
            throw new IllegalArgumentException("UserGroups cannot be null");
        }
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.connection.prepareStatement(INSERT_USER_GROUP, 1);
            for (IdpUserGroup userGroup : userGroups) {
                this.populateStatement(statement, userGroup);
                statement.addBatch();
            }
            int[] updateCounts = statement.executeBatch();
            if (updateCounts.length != userGroups.size()) {
                throw new DataAccessException("Unable to save IDP User Groups");
            }
            for (int i = 0; i < updateCounts.length; ++i) {
                if (updateCounts[i] != 0) continue;
                throw new DataAccessException("Unable to save IDP User Groups");
            }
            rs = statement.getGeneratedKeys();
            int count = 0;
            while (rs.next()) {
                int id = rs.getInt(1);
                IdpUserGroup userGroup = userGroups.get(count);
                userGroup.setId(id);
                ++count;
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(rs);
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(rs);
        RepositoryUtils.closeQuietly(statement);
        return userGroups;
    }

    private void populateStatement(PreparedStatement statement, IdpUserGroup userGroup) throws SQLException {
        statement.setString(1, userGroup.getIdentity());
        statement.setString(2, userGroup.getType().name());
        statement.setString(3, userGroup.getGroupName());
        statement.setTimestamp(4, new Timestamp(userGroup.getCreated().getTime()));
    }

    @Override
    public IdpUserGroup findUserGroupById(int id) throws DataAccessException {
        IdpUserGroup userGroup = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.connection.prepareStatement(SELECT_USER_GROUP_BY_ID);
            statement.setInt(1, id);
            rs = statement.executeQuery();
            if (rs.next()) {
                userGroup = new IdpUserGroup();
                this.populateUserGroup(rs, userGroup);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(rs);
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(rs);
        RepositoryUtils.closeQuietly(statement);
        return userGroup;
    }

    @Override
    public List<IdpUserGroup> findUserGroupsByIdentity(String identity) throws DataAccessException {
        ArrayList<IdpUserGroup> userGroups = new ArrayList<IdpUserGroup>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.connection.prepareStatement(SELECT_USER_GROUP_BY_IDENTITY);
            statement.setString(1, identity);
            rs = statement.executeQuery();
            while (rs.next()) {
                IdpUserGroup userGroup = new IdpUserGroup();
                this.populateUserGroup(rs, userGroup);
                userGroups.add(userGroup);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(rs);
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(rs);
        RepositoryUtils.closeQuietly(statement);
        return userGroups;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int deleteUserGroupById(int id) throws DataAccessException {
        int n;
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(DELETE_USER_GROUPS_BY_ID);
            statement.setInt(1, id);
            n = statement.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
                catch (DataAccessException dae) {
                    throw dae;
                }
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(statement);
        return n;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int deleteUserGroupsByIdentity(String identity) throws DataAccessException {
        int n;
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(DELETE_USER_GROUPS_BY_IDENTITY);
            statement.setString(1, identity);
            n = statement.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                throw new DataAccessException(sqle);
                catch (DataAccessException dae) {
                    throw dae;
                }
            }
            catch (Throwable throwable) {
                RepositoryUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        RepositoryUtils.closeQuietly(statement);
        return n;
    }

    private void populateUserGroup(ResultSet rs, IdpUserGroup userGroup) throws SQLException {
        userGroup.setId(rs.getInt("ID"));
        userGroup.setIdentity(rs.getString("IDENTITY"));
        userGroup.setType(IdpType.valueOf(rs.getString("IDP_TYPE")));
        userGroup.setGroupName(rs.getString("GROUP_NAME"));
        userGroup.setCreated(new Date(rs.getTimestamp("CREATED").getTime()));
    }
}

