/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;

abstract class Schedulable {
    private double fairShare = 0.0;
    protected MetricsRecord metrics;

    Schedulable() {
    }

    public abstract String getName();

    public abstract TaskType getTaskType();

    public abstract int getDemand();

    public abstract int getRunningTasks();

    public abstract int getMinShare();

    public abstract double getWeight();

    public abstract JobPriority getPriority();

    public abstract long getStartTime();

    public abstract void updateDemand();

    public abstract void redistributeShare();

    public abstract Task assignTask(TaskTrackerStatus var1, long var2, Collection<JobInProgress> var4, int var5) throws IOException;

    public void setFairShare(double fairShare) {
        this.fairShare = fairShare;
    }

    public double getFairShare() {
        return this.fairShare;
    }

    protected abstract String getMetricsContextName();

    protected void initMetrics() {
        MetricsContext metricsContext = MetricsUtil.getContext((String)"fairscheduler");
        this.metrics = MetricsUtil.createRecord((MetricsContext)metricsContext, (String)this.getMetricsContextName());
        this.metrics.setTag("name", this.getName());
        this.metrics.setTag("taskType", this.getTaskType().toString());
    }

    void cleanupMetrics() {
        if (this.metrics != null) {
            this.metrics.remove();
            this.metrics = null;
        }
    }

    protected void setMetricValues(MetricsRecord metrics) {
        metrics.setMetric("fairShare", (float)this.getFairShare());
        metrics.setMetric("minShare", this.getMinShare());
        metrics.setMetric("demand", this.getDemand());
        metrics.setMetric("weight", (float)this.getWeight());
        metrics.setMetric("runningTasks", this.getRunningTasks());
    }

    abstract void updateMetrics();

    public String toString() {
        return String.format("[%s, demand=%d, running=%d, share=%.1f, w=%.1f]", this.getName(), this.getDemand(), this.getRunningTasks(), this.fairShare, this.getWeight());
    }
}

