/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskTrackerStatus;

public enum LocalityLevel {
    NODE,
    RACK,
    ANY;


    public static LocalityLevel fromTask(JobInProgress job, Task mapTask, TaskTrackerStatus tracker) {
        TaskID tipID = mapTask.getTaskID().getTaskID();
        TaskInProgress tip = job.getTaskInProgress(tipID);
        switch (job.getLocalityLevel(tip, tracker)) {
            case 0: {
                return NODE;
            }
            case 1: {
                return RACK;
            }
        }
        return ANY;
    }

    public int toCacheLevelCap() {
        switch (this) {
            case NODE: {
                return 1;
            }
            case RACK: {
                return 2;
            }
        }
        return Integer.MAX_VALUE;
    }
}

