/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.java.dev.eval.Expression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapreduce.TaskType;

public class SubClusterManager {
    public static final Log LOG = LogFactory.getLog(SubClusterManager.class);
    private static final String ALL_KEY = "*";
    private Map<String, SubCluster> mapSubClusterMap = new ConcurrentHashMap<String, SubCluster>();
    private Map<String, SubCluster> reduceSubClusterMap = new ConcurrentHashMap<String, SubCluster>();
    private volatile int numLabeledJobs = 0;

    private String getKey(JobInProgress job) {
        Expression expr = job.getLabel();
        return expr == null ? ALL_KEY : expr.toString();
    }

    public SubCluster get(JobInProgress job, TaskType taskType) {
        String key = this.getKey(job);
        return taskType.equals((Object)TaskType.MAP) ? this.mapSubClusterMap.get(key) : this.reduceSubClusterMap.get(key);
    }

    private void addJobEntry(Map<String, SubCluster> subClusterMap, String key, JobInProgress job, TaskType taskType) {
        SubCluster subCluster = subClusterMap.get(key);
        if (subCluster == null) {
            subCluster = new SubCluster();
            subCluster.totalSlots = job.getMaxSlotsAvailable(taskType);
            subClusterMap.put(key, subCluster);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Added SubCluster entry key: " + key + " type: " + taskType + " slots: " + subCluster.totalSlots + " cacheSize: " + subClusterMap.size()));
            }
        }
        subCluster.addTasks(job.getTasks(taskType).length);
    }

    private void removeJobEntry(Map<String, SubCluster> subClusterMap, String key, JobInProgress job, TaskType taskType) {
        SubCluster subCluster = subClusterMap.get(key);
        if (subCluster == null) {
            LOG.error((Object)("SubCluster not found for key: " + key + " type: " + taskType));
            return;
        }
        subCluster.removeTasks(job.getTasks(taskType).length);
    }

    public void addJob(JobInProgress job) {
        String key = this.getKey(job);
        this.addJobEntry(this.mapSubClusterMap, key, job, TaskType.MAP);
        this.addJobEntry(this.reduceSubClusterMap, key, job, TaskType.REDUCE);
        if (!key.equals(ALL_KEY)) {
            ++this.numLabeledJobs;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Num labeled jobs = " + this.numLabeledJobs));
        }
    }

    public void removeJob(JobInProgress job) {
        String key = this.getKey(job);
        this.removeJobEntry(this.mapSubClusterMap, key, job, TaskType.MAP);
        this.removeJobEntry(this.reduceSubClusterMap, key, job, TaskType.REDUCE);
        if (!key.equals(ALL_KEY)) {
            --this.numLabeledJobs;
            if (this.numLabeledJobs < 0) {
                LOG.warn((Object)("Num labeled jobs is negative: " + this.numLabeledJobs));
                this.numLabeledJobs = 0;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Num labeled jobs = " + this.numLabeledJobs));
        }
    }

    public boolean hasLabeledJobs() {
        return this.numLabeledJobs > 0;
    }

    public void refreshSlots(JobTracker jobTracker) {
        for (Map.Entry<String, SubCluster> mapEntry : this.mapSubClusterMap.entrySet()) {
            String key = mapEntry.getKey();
            Expression jobLabelExpr = key.equals(ALL_KEY) ? null : new Expression(key, true, new BigDecimal(0));
            int mapSlots = JobInProgress.getMaxSlotsAvailable((JobTracker)jobTracker, (Expression)jobLabelExpr, (TaskType)TaskType.MAP);
            mapEntry.getValue().totalSlots = mapSlots;
            int reduceSlots = JobInProgress.getMaxSlotsAvailable((JobTracker)jobTracker, (Expression)jobLabelExpr, (TaskType)TaskType.REDUCE);
            this.reduceSubClusterMap.get(key).totalSlots = reduceSlots;
            LOG.info((Object)("Refreshed map slots key: " + key + " = " + mapSlots));
            LOG.info((Object)("Refreshed reduce slots key: " + key + " = " + reduceSlots));
        }
    }

    public static class SubCluster {
        private int totalSlots;
        private int totalTasks;

        public void addTasks(int count) {
            this.totalTasks += count;
        }

        public void removeTasks(int count) {
            this.totalTasks -= count;
        }

        public int getTotalSlots() {
            return this.totalSlots;
        }

        public int getTotalTasks() {
            return this.totalTasks;
        }
    }
}

