/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.LoadManager;
import org.apache.hadoop.mapred.TaskTrackerStatus;

public class CapBasedLoadManager
extends LoadManager {
    float maxDiff = 0.0f;

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.maxDiff = conf.getFloat("mapred.fairscheduler.load.max.diff", 0.0f);
    }

    int getCap(int totalRunnableTasks, int localMaxTasks, int totalSlots) {
        double load = (double)this.maxDiff + (double)totalRunnableTasks / (double)totalSlots;
        return (int)Math.ceil((double)localMaxTasks * Math.min(1.0, load));
    }

    @Override
    public boolean canAssignMap(TaskTrackerStatus tracker, int totalRunnableMaps, int totalMapSlots) {
        return tracker.countMapTasks() < this.getCap(totalRunnableMaps, tracker.getMaxMapSlots(), totalMapSlots);
    }

    @Override
    public boolean canAssignReduce(TaskTrackerStatus tracker, int totalRunnableReduces, int totalReduceSlots) {
        return tracker.countReduceTasks() < this.getCap(totalRunnableReduces, tracker.getMaxReduceSlots(), totalReduceSlots);
    }

    @Override
    public boolean canAssignMap(TaskTrackerStatus tracker, int totalRunnableMaps, int totalMapSlots, int currentMapsAssigned) {
        return tracker.countMapTasks() + currentMapsAssigned < this.getCap(totalRunnableMaps, tracker.getMaxMapSlots(), totalMapSlots);
    }

    @Override
    public boolean canAssignReduce(TaskTrackerStatus tracker, int totalRunnableReduces, int totalReduceSlots, int currentReducesAssigned) {
        return tracker.countReduceTasks() + currentReducesAssigned < this.getCap(totalRunnableReduces, tracker.getMaxReduceSlots(), totalReduceSlots);
    }
}

