/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120000L, unit=TimeUnit.MILLISECONDS)
public class JsonUtilTest {
    @Test
    public void testOpenBraceComesFirst() {
        Assertions.assertTrue((boolean)JsonUtil.openBraceComesFirst((String)"{}"));
        Assertions.assertTrue((boolean)JsonUtil.openBraceComesFirst((String)" \t{\"foo\":\"bar\"}"));
        Assertions.assertTrue((boolean)JsonUtil.openBraceComesFirst((String)" { \"foo\": \"bar\" }"));
        Assertions.assertFalse((boolean)JsonUtil.openBraceComesFirst((String)"/my/file/path"));
        Assertions.assertFalse((boolean)JsonUtil.openBraceComesFirst((String)"mypath"));
        Assertions.assertFalse((boolean)JsonUtil.openBraceComesFirst((String)" blah{}"));
    }

    @Test
    public void testObjectFromCommandLineArgument() throws Exception {
        Assertions.assertEquals((int)123, (int)((Foo)JsonUtil.objectFromCommandLineArgument((String)"{\"bar\":123}", Foo.class)).bar);
        Assertions.assertEquals((int)1, (int)((Foo)JsonUtil.objectFromCommandLineArgument((String)"   {\"bar\": 1}   ", Foo.class)).bar);
        File tempFile = TestUtils.tempFile();
        try {
            Files.write(tempFile.toPath(), "{\"bar\": 456}".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)456, (int)((Foo)JsonUtil.objectFromCommandLineArgument((String)tempFile.getAbsolutePath(), Foo.class)).bar);
        }
        finally {
            Files.delete(tempFile.toPath());
        }
    }

    static final class Foo {
        @JsonProperty
        final int bar;

        @JsonCreator
        Foo(@JsonProperty(value="bar") int bar) {
            this.bar = bar;
        }
    }
}

