/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.basic;

import java.io.File;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.trogdor.common.Platform;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120000L, unit=TimeUnit.MILLISECONDS)
public class BasicPlatformTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateBasicPlatform() throws Exception {
        File configFile = TestUtils.tempFile();
        try {
            try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(configFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
                writer.write("{\n");
                writer.write("  \"platform\": \"org.apache.kafka.trogdor.basic.BasicPlatform\",\n");
                writer.write("  \"nodes\": {\n");
                writer.write("    \"bob01\": {\n");
                writer.write("      \"hostname\": \"localhost\",\n");
                writer.write("      \"trogdor.agent.port\": 8888\n");
                writer.write("    },\n");
                writer.write("    \"bob02\": {\n");
                writer.write("      \"hostname\": \"localhost\",\n");
                writer.write("      \"trogdor.agent.port\": 8889\n");
                writer.write("    }\n");
                writer.write("  }\n");
                writer.write("}\n");
            }
            Platform platform = Platform.Config.parse((String)"bob01", (String)configFile.getPath());
            Assertions.assertEquals((Object)"BasicPlatform", (Object)platform.name());
            Assertions.assertEquals((int)2, (int)platform.topology().nodes().size());
            Assertions.assertEquals((Object)"bob01, bob02", (Object)Utils.join(platform.topology().nodes().keySet(), (String)", "));
        }
        finally {
            Files.delete(configFile.toPath());
        }
    }
}

