/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.mapr.tools;

import com.mapr.kafka.eventstreams.Admin;
import com.mapr.kafka.eventstreams.StreamDescriptor;
import java.io.IOException;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.mapr.tools.KafkaMaprStreams;
import org.apache.kafka.mapr.tools.KafkaMaprTools;
import org.apache.kafka.mapr.tools.SuppressionUtil;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class KafkaMaprStreamsTest
extends EasyMockSupport {
    private static final String STREAM = "/stream";
    private Admin maprStreamsAdmin;
    private KafkaMaprStreams kafkaMaprStreams;

    @BeforeClass
    public static void avoidShimLoading() throws Exception {
        SuppressionUtil.suppressShimLoader();
    }

    @Before
    public void setUp() {
        this.maprStreamsAdmin = (Admin)this.mock(Admin.class);
        this.kafkaMaprStreams = new KafkaMaprStreams(this.maprStreamsAdmin);
    }

    @Test
    public void checkIfStreamsExists() throws IOException {
        EasyMock.expect((Object)this.maprStreamsAdmin.streamExists(STREAM)).andReturn((Object)true);
        this.replayAll();
        Assert.assertTrue((boolean)this.kafkaMaprStreams.streamExists(STREAM));
        this.verifyAll();
    }

    @Test
    public void rethrowsKafkaExpectionOnStreamExists() throws IOException {
        EasyMock.expect((Object)this.maprStreamsAdmin.streamExists(STREAM)).andThrow((Throwable)new IOException());
        this.replayAll();
        try {
            Assert.assertTrue((boolean)this.kafkaMaprStreams.streamExists(STREAM));
            Assert.fail((String)"Expected KafkaException");
        }
        catch (KafkaException kafkaException) {
            // empty catch block
        }
        this.verifyAll();
    }

    @Test
    public void preservesEnabledStreamLogCompaction() throws IOException {
        StreamDescriptor descriptor = (StreamDescriptor)this.mock(StreamDescriptor.class);
        EasyMock.expect((Object)descriptor.getCompact()).andReturn((Object)true);
        EasyMock.expect((Object)this.maprStreamsAdmin.getStreamDescriptor(STREAM)).andReturn((Object)descriptor);
        this.replayAll();
        this.kafkaMaprStreams.ensureStreamLogCompactionIsEnabled(STREAM);
        this.verifyAll();
    }

    @Test
    public void enablesStreamLogCompactionAndZeroTTL() throws IOException {
        StreamDescriptor descriptor = (StreamDescriptor)this.mock(StreamDescriptor.class);
        EasyMock.expect((Object)descriptor.getCompact()).andReturn((Object)false);
        EasyMock.expect((Object)this.maprStreamsAdmin.getStreamDescriptor(STREAM)).andReturn((Object)descriptor);
        descriptor.setCompact(true);
        descriptor.setTimeToLiveSec(0L);
        this.maprStreamsAdmin.editStream(STREAM, descriptor);
        this.replayAll();
        this.kafkaMaprStreams.ensureStreamLogCompactionIsEnabled(STREAM);
        this.verifyAll();
    }

    @Test
    public void rethrowsIOExceptionAsKafkaForEnsureStreamLogCompactionIsEnabled() throws IOException {
        EasyMock.expect((Object)this.maprStreamsAdmin.getStreamDescriptor(STREAM)).andThrow((Throwable)new IOException());
        this.replayAll();
        try {
            this.kafkaMaprStreams.ensureStreamLogCompactionIsEnabled(STREAM);
            Assert.fail((String)"Expected KafkaException");
        }
        catch (KafkaException kafkaException) {
            // empty catch block
        }
        this.verifyAll();
    }

    @Test
    public void closesAdmin() {
        this.maprStreamsAdmin.close();
        this.replayAll();
        this.kafkaMaprStreams.close();
        this.verifyAll();
    }

    @Test
    public void getsShortTopicNameFromFullTopicName() {
        String fromFullName = KafkaMaprStreams.getShortTopicNameFromFullTopicName((String)"/ss:topic");
        String fromShortName = KafkaMaprStreams.getShortTopicNameFromFullTopicName((String)"topic");
        Assert.assertEquals((Object)"topic", (Object)fromFullName);
        Assert.assertEquals((Object)"topic", (Object)fromShortName);
    }

    @Test
    public void createsStreamForClusterAdmin() throws IOException {
        Capture captured = EasyMock.newCapture();
        this.maprStreamsAdmin.createStream((String)EasyMock.eq((Object)STREAM), (StreamDescriptor)EasyMock.capture((Capture)captured));
        this.replayAll();
        this.kafkaMaprStreams.createStreamForClusterAdmin(STREAM);
        this.verifyAll();
        StreamDescriptor value = (StreamDescriptor)captured.getValue();
        Assert.assertNull((Object)value.getProducePerms());
        Assert.assertNull((Object)value.getConsumePerms());
    }

    @Test
    public void createsStreamForAllUsers() throws IOException {
        Capture captured = EasyMock.newCapture();
        this.maprStreamsAdmin.createStream((String)EasyMock.eq((Object)STREAM), (StreamDescriptor)EasyMock.capture((Capture)captured));
        this.replayAll();
        this.kafkaMaprStreams.createStreamForAllUsers(STREAM);
        this.verifyAll();
        StreamDescriptor value = (StreamDescriptor)captured.getValue();
        Assert.assertEquals((Object)"p", (Object)value.getProducePerms());
        Assert.assertEquals((Object)"p", (Object)value.getConsumePerms());
    }

    @Test
    public void createsStreamForCurrentUserWhichIsNotClusterAdmin() throws IOException {
        KafkaMaprTools.tools = (KafkaMaprTools)this.mock(KafkaMaprTools.class);
        EasyMock.expect((Object)KafkaMaprTools.tools().getCurrentUserName()).andReturn((Object)"mapruser1");
        EasyMock.expect((Object)KafkaMaprTools.tools().getClusterAdminUserName()).andReturn((Object)"mapr");
        Capture captured = EasyMock.newCapture();
        this.maprStreamsAdmin.createStream((String)EasyMock.eq((Object)STREAM), (StreamDescriptor)EasyMock.capture((Capture)captured));
        this.replayAll();
        this.kafkaMaprStreams.createStreamForCurrentUser(STREAM);
        this.verifyAll();
        StreamDescriptor value = (StreamDescriptor)captured.getValue();
        Assert.assertEquals((Object)"u:mapr | u:mapruser1", (Object)value.getProducePerms());
        Assert.assertEquals((Object)"u:mapr | u:mapruser1", (Object)value.getConsumePerms());
    }

    @Test
    public void createsStreamForCurrentUserWhichIsClusterAdmin() throws IOException {
        KafkaMaprTools.tools = (KafkaMaprTools)this.mock(KafkaMaprTools.class);
        EasyMock.expect((Object)KafkaMaprTools.tools().getCurrentUserName()).andReturn((Object)"mapr");
        EasyMock.expect((Object)KafkaMaprTools.tools().getClusterAdminUserName()).andReturn((Object)"mapr");
        Capture captured = EasyMock.newCapture();
        this.maprStreamsAdmin.createStream((String)EasyMock.eq((Object)STREAM), (StreamDescriptor)EasyMock.capture((Capture)captured));
        this.replayAll();
        this.kafkaMaprStreams.createStreamForCurrentUser(STREAM);
        this.verifyAll();
        StreamDescriptor value = (StreamDescriptor)captured.getValue();
        Assert.assertNull((Object)value.getProducePerms());
        Assert.assertNull((Object)value.getConsumePerms());
    }

    @Test
    public void suppressExceptionOnConcurrentlyCreatedStream() throws IOException {
        this.maprStreamsAdmin.createStream((String)EasyMock.eq((Object)STREAM), (StreamDescriptor)EasyMock.anyObject());
        EasyMock.expectLastCall().andThrow((Throwable)new IOException());
        EasyMock.expect((Object)this.maprStreamsAdmin.streamExists(STREAM)).andReturn((Object)true);
        this.replayAll();
        this.kafkaMaprStreams.createStreamForClusterAdmin(STREAM);
        this.verifyAll();
    }

    @Test
    public void rethrowExceptionOnFailedStreamCreation() throws IOException {
        this.maprStreamsAdmin.createStream((String)EasyMock.eq((Object)STREAM), (StreamDescriptor)EasyMock.anyObject());
        EasyMock.expectLastCall().andThrow((Throwable)new IOException());
        EasyMock.expect((Object)this.maprStreamsAdmin.streamExists(STREAM)).andReturn((Object)false);
        this.replayAll();
        try {
            this.kafkaMaprStreams.createStreamForClusterAdmin(STREAM);
            Assert.fail((String)"Expected KafkaException");
        }
        catch (KafkaException kafkaException) {
            // empty catch block
        }
        this.verifyAll();
    }
}

