/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.mapr.tools;

import com.mapr.fs.MapRFileAce;
import com.mapr.fs.MapRFileSystem;
import com.mapr.security.UnixUserGroupHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.mapr.tools.KafkaMaprTools;
import org.apache.kafka.mapr.tools.KafkaMaprfs;
import org.apache.kafka.mapr.tools.MaprfsPermissions;
import org.apache.kafka.mapr.tools.SuppressionUtil;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.core.classloader.annotations.SuppressStaticInitializationFor;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@SuppressStaticInitializationFor(value={"com.mapr.fs.MapRFileSystem", "com.mapr.baseutils.JVMProperties"})
public class KafkaMaprfsTest
extends EasyMockSupport {
    private static final String FILE = "/user/mapr/file";
    private static final Path FOLDER_PATH = new Path("/user/mapr/file");
    private static final String MAPR_USER_1 = "mapruser1";
    private static final String MAPR_ADMIN = "mapr";
    private static final String UNKNOWN_USER = "unknown-user";
    private MapRFileSystem delegatedFs;
    private KafkaMaprfs maprfs;

    @Before
    public void setUp() throws IllegalAccessException {
        SuppressionUtil.clearDefaultResources();
        KafkaMaprTools.tools = (KafkaMaprTools)this.mock(KafkaMaprTools.class);
        this.delegatedFs = (MapRFileSystem)this.mock(MapRFileSystem.class);
        this.maprfs = new KafkaMaprfs(this.delegatedFs);
        UnixUserGroupHelper unixUserGroupHelper = (UnixUserGroupHelper)EasyMock.mock(UnixUserGroupHelper.class);
        EasyMock.expect((Object)unixUserGroupHelper.getUserId(MAPR_USER_1)).andStubReturn((Object)1001);
        EasyMock.expect((Object)unixUserGroupHelper.getUserId(MAPR_ADMIN)).andStubReturn((Object)1002);
        EasyMock.expect((Object)unixUserGroupHelper.getUserId(UNKNOWN_USER)).andStubReturn((Object)-100);
        EasyMock.replay((Object[])new Object[]{unixUserGroupHelper});
        SuppressionUtil.setAceUnixUserGroupHelper(unixUserGroupHelper);
    }

    @Test
    public void deletesMaprfsDirectory() throws IOException {
        EasyMock.expect((Object)this.delegatedFs.delete(FOLDER_PATH)).andReturn((Object)true);
        this.replayAll();
        this.maprfs.delete(FILE);
        this.verifyAll();
    }

    @Test
    public void deletesRecursivelyMaprfsDirectory() throws IOException {
        EasyMock.expect((Object)this.delegatedFs.delete(FOLDER_PATH, true)).andReturn((Object)true);
        this.replayAll();
        this.maprfs.deleteRecursive(FILE);
        this.verifyAll();
    }

    @Test
    public void createsMaprfsDirectory() throws IOException {
        EasyMock.expect((Object)this.delegatedFs.mkdirs(FOLDER_PATH)).andReturn((Object)true);
        this.replayAll();
        this.maprfs.mkdirs(FILE);
        this.verifyAll();
    }

    @Test
    public void suppressExceptionIfDirectoryWasCreated() throws IOException {
        EasyMock.expect((Object)this.delegatedFs.mkdirs(FOLDER_PATH)).andThrow((Throwable)new IOException());
        EasyMock.expect((Object)this.delegatedFs.exists(FOLDER_PATH)).andReturn((Object)true);
        this.replayAll();
        this.maprfs.mkdirs(FILE);
        this.verifyAll();
    }

    @Test
    public void rethrowExceptionIfDirectoryWasNotCreated() throws IOException {
        EasyMock.expect((Object)this.delegatedFs.mkdirs(FOLDER_PATH)).andThrow((Throwable)new IOException());
        EasyMock.expect((Object)this.delegatedFs.exists(FOLDER_PATH)).andReturn((Object)false);
        this.replayAll();
        try {
            this.maprfs.mkdirs(FILE);
            Assert.fail((String)"Exception was not rethrown");
        }
        catch (KafkaException kafkaException) {
            // empty catch block
        }
        this.verifyAll();
    }

    @Test
    public void throwExceptionIfRequiredDirectoryDoesntExist() throws IOException {
        EasyMock.expect((Object)this.delegatedFs.exists(FOLDER_PATH)).andReturn((Object)false);
        this.replayAll();
        try {
            this.maprfs.requireExisting(FILE);
            Assert.fail((String)"Exception was not thrown");
        }
        catch (KafkaException kafkaException) {
            // empty catch block
        }
        this.verifyAll();
    }

    @Test
    public void rethrowsExceptionAsUnchecked() throws IOException {
        EasyMock.expect((Object)this.delegatedFs.exists(FOLDER_PATH)).andThrow((Throwable)new IOException());
        this.replayAll();
        try {
            this.maprfs.exists(FILE);
            Assert.fail((String)"Exception was not thrown");
        }
        catch (KafkaException kafkaException) {
            // empty catch block
        }
        this.verifyAll();
    }

    @Test
    public void returnsTrueOnAccessibleFolder() throws IOException {
        EasyMock.expect((Object)KafkaMaprTools.tools().getCurrentUserName()).andReturn((Object)MAPR_USER_1);
        MaprfsPermissions permissions = MaprfsPermissions.permissions().put(MapRFileAce.AccessType.READDIR, "u:mapruser1").put(MapRFileAce.AccessType.LOOKUPDIR, "u:mapruser1").put(MapRFileAce.AccessType.ADDCHILD, "u:mapruser1").put(MapRFileAce.AccessType.DELETECHILD, "u:mapruser1");
        EasyMock.expect((Object)this.delegatedFs.getAces(FOLDER_PATH)).andReturn((Object)permissions.buildAceList());
        this.replayAll();
        Assert.assertTrue((boolean)this.maprfs.isAccessibleAsDirectory(FILE));
        this.verifyAll();
    }

    @Test
    public void returnsTrueOnPublicFolder() throws IOException {
        EasyMock.expect((Object)KafkaMaprTools.tools().getCurrentUserName()).andReturn((Object)MAPR_USER_1);
        MaprfsPermissions permissions = MaprfsPermissions.permissions().put(MapRFileAce.AccessType.READDIR, "p").put(MapRFileAce.AccessType.LOOKUPDIR, "p").put(MapRFileAce.AccessType.ADDCHILD, "p").put(MapRFileAce.AccessType.DELETECHILD, "p");
        EasyMock.expect((Object)this.delegatedFs.getAces(FOLDER_PATH)).andReturn((Object)permissions.buildAceList());
        this.replayAll();
        Assert.assertTrue((boolean)this.maprfs.isAccessibleAsDirectory(FILE));
        this.verifyAll();
    }

    @Test
    public void returnsFalseOnMissingAces() throws IOException {
        EasyMock.expect((Object)KafkaMaprTools.tools().getCurrentUserName()).andReturn((Object)MAPR_USER_1);
        EasyMock.expect((Object)this.delegatedFs.getAces(FOLDER_PATH)).andReturn(Collections.emptyList());
        this.replayAll();
        Assert.assertFalse((boolean)this.maprfs.isAccessibleAsDirectory(FILE));
        this.verifyAll();
    }

    @Test
    public void returnsFalseOnUnsatisfyingAces() throws IOException {
        EasyMock.expect((Object)KafkaMaprTools.tools().getCurrentUserName()).andReturn((Object)MAPR_USER_1);
        MaprfsPermissions permissions = MaprfsPermissions.permissions().put(MapRFileAce.AccessType.READDIR, "u:mapruser1").put(MapRFileAce.AccessType.LOOKUPDIR, "u:mapr").put(MapRFileAce.AccessType.ADDCHILD, "u:mapruser1").put(MapRFileAce.AccessType.DELETECHILD, "u:mapruser1");
        EasyMock.expect((Object)this.delegatedFs.getAces(FOLDER_PATH)).andReturn((Object)permissions.buildAceList());
        this.replayAll();
        Assert.assertFalse((boolean)this.maprfs.isAccessibleAsDirectory(FILE));
        this.verifyAll();
    }

    @Test
    public void setsAcesWithList() throws IOException {
        List permissions = MaprfsPermissions.permissions().put(MapRFileAce.AccessType.READDIR, "u:mapruser1").put(MapRFileAce.AccessType.LOOKUPDIR, "u:mapr").put(MapRFileAce.AccessType.ADDCHILD, "u:mapruser1").put(MapRFileAce.AccessType.DELETECHILD, "u:mapruser1").buildAceList();
        this.delegatedFs.setAces(FOLDER_PATH, permissions);
        this.expectNoinherit();
        this.replayAll();
        this.maprfs.setAces(FILE, permissions);
        this.verifyAll();
    }

    private void expectNoinherit() throws IOException {
        EasyMock.expect((Object)this.delegatedFs.setAces(FOLDER_PATH, new ArrayList(), false, 1, 0, false, null)).andReturn((Object)0);
    }

    @Test
    public void suppressIOExceptionOnSetAces() throws IOException {
        EasyMock.expect((Object)KafkaMaprTools.tools().getCurrentUserName()).andReturn((Object)MAPR_USER_1);
        List permissions = MaprfsPermissions.permissions().put(MapRFileAce.AccessType.READDIR, "u:mapruser1").put(MapRFileAce.AccessType.LOOKUPDIR, "u:mapr").put(MapRFileAce.AccessType.ADDCHILD, "u:mapruser1").put(MapRFileAce.AccessType.DELETECHILD, "u:mapruser1").buildAceList();
        this.delegatedFs.setAces(FOLDER_PATH, permissions);
        EasyMock.expectLastCall().andThrow((Throwable)new IOException());
        this.replayAll();
        this.maprfs.setAces(FILE, permissions);
        this.verifyAll();
    }
}

