/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.mapr.tools;

import com.mapr.baseutils.utils.AceHelper;
import com.mapr.fs.MapRFileAce;
import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.mapr.tools.KafkaMaprTools;
import org.apache.kafka.mapr.tools.MaprfsPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaMaprfs {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaMaprfs.class);
    private static final int NOINHERIT = 1;
    private final MapRFileSystem fs;
    private final Map<String, Path> paths = new HashMap<String, Path>();

    public KafkaMaprfs(MapRFileSystem fs) {
        this.fs = fs;
    }

    private Path at(String path) {
        return this.paths.computeIfAbsent(path, Path::new);
    }

    public boolean isAccessibleAsDirectory(String path) {
        return this.isAccessibleWith(path, MapRFileAce.AccessType.READDIR, MapRFileAce.AccessType.ADDCHILD, MapRFileAce.AccessType.LOOKUPDIR, MapRFileAce.AccessType.DELETECHILD);
    }

    public boolean isAccessibleWith(String path, MapRFileAce.AccessType ... permissions) {
        String postfix = KafkaMaprfs.toPostfix("u:" + KafkaMaprTools.tools().getCurrentUserName());
        List<MapRFileAce> aces = this.getAces(path);
        return Arrays.stream(permissions).allMatch(accessType -> aces.stream().filter(mapRFileAce -> mapRFileAce.getAccessType() == accessType).map(MapRFileAce::getBooleanExpression).anyMatch(expression -> KafkaMaprfs.hasGrantedAccessAs(expression, postfix)));
    }

    public List<MapRFileAce> getAces(String path) {
        try {
            return this.fs.getAces(this.at(path));
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    private static String toPostfix(String expression) {
        try {
            return AceHelper.toPostfix((String)expression);
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    private static boolean hasGrantedAccessAs(String expression, String userPostfix) {
        return Arrays.stream(expression.split(",")).map(KafkaMaprfs::toPostfix).anyMatch(postfix -> postfix.equals(userPostfix) || postfix.equals("p"));
    }

    public void setAces(String path, List<MapRFileAce> aces) {
        try {
            this.fs.setAces(this.at(path), aces);
            this.fs.setAces(this.at(path), new ArrayList(), false, 1, 0, false, null);
        }
        catch (IOException e) {
            String user = KafkaMaprTools.tools().getCurrentUserName();
            LOG.warn("Failed to change permissions on file '{}' as '{}'", new Object[]{path, user, e});
        }
    }

    public void setPermissions(String path, MaprfsPermissions permissions) {
        this.setAces(path, permissions.buildAceList());
    }

    public void mkdirs(String path) {
        block2: {
            try {
                this.fs.mkdirs(this.at(path));
            }
            catch (IOException e) {
                if (this.exists(path)) break block2;
                throw new KafkaException((Throwable)e);
            }
        }
    }

    public boolean exists(String path) {
        try {
            return this.fs.exists(this.at(path));
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    public void requireExisting(String path) {
        if (!this.exists(path)) {
            throw new KafkaException(String.format("File '%s' doesn't exist", path));
        }
    }

    public void delete(String path) {
        try {
            this.fs.delete(this.at(path));
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    public void deleteRecursive(String path) {
        try {
            this.fs.delete(this.at(path), true);
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    public MapRFileSystem getFileSystem() {
        return this.fs;
    }
}

