/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.Serializable;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkAclStore;
import kafka.zk.ZkAclStore$;
import kafka.zk.ZkVersion$;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.zookeeper.client.ZKClientConfig;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class AclAuthorizer$ {
    public static final AclAuthorizer$ MODULE$ = new AclAuthorizer$();
    private static final String configPrefix = "authorizer.";
    private static final String ZkUrlProp = new StringBuilder(13).append(MODULE$.configPrefix()).append("zookeeper.url").toString();
    private static final String ZkConnectionTimeOutProp = new StringBuilder(31).append(MODULE$.configPrefix()).append("zookeeper.connection.timeout.ms").toString();
    private static final String ZkSessionTimeOutProp = new StringBuilder(28).append(MODULE$.configPrefix()).append("zookeeper.session.timeout.ms").toString();
    private static final String ZkMaxInFlightRequests = new StringBuilder(32).append(MODULE$.configPrefix()).append("zookeeper.max.in.flight.requests").toString();
    private static final String SuperUsersProp = "super.users";
    private static final String AllowEveryoneIfNoAclIsFoundProp = "allow.everyone.if.no.acl.found";
    private static final AclAuthorizer.VersionedAcls NoAcls = new AclAuthorizer.VersionedAcls((Set<AclEntry>)Predef$.MODULE$.Set().empty(), ZkVersion$.MODULE$.UnknownVersion());
    private static final String WildcardHost = "*";

    public String configPrefix() {
        return configPrefix;
    }

    public String ZkUrlProp() {
        return ZkUrlProp;
    }

    public String ZkConnectionTimeOutProp() {
        return ZkConnectionTimeOutProp;
    }

    public String ZkSessionTimeOutProp() {
        return ZkSessionTimeOutProp;
    }

    public String ZkMaxInFlightRequests() {
        return ZkMaxInFlightRequests;
    }

    public String SuperUsersProp() {
        return SuperUsersProp;
    }

    public String AllowEveryoneIfNoAclIsFoundProp() {
        return AllowEveryoneIfNoAclIsFoundProp;
    }

    public AclAuthorizer.VersionedAcls NoAcls() {
        return NoAcls;
    }

    public String WildcardHost() {
        return WildcardHost;
    }

    public ZKClientConfig zkClientConfigFromKafkaConfigAndMap(KafkaConfig kafkaConfig, Map<String, ?> configMap) {
        if (!StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)configMap.get((Object)new StringBuilder(0).append(this.configPrefix()).append(KafkaConfig$.MODULE$.ZkSslClientEnableProp()).toString()).map((Function1 & Serializable)x$3 -> x$3.toString().trim()).getOrElse((Function0 & Serializable)() -> Boolean.toString(kafkaConfig.zkSslClientEnable()))))) {
            return new ZKClientConfig();
        }
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(kafkaConfig, true);
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(kafkaProp, sysProp) -> {
            AclAuthorizer$.$anonfun$zkClientConfigFromKafkaConfigAndMap$3(configMap, zkClientConfig, kafkaProp, sysProp);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        return zkClientConfig;
    }

    public void kafka$security$authorizer$AclAuthorizer$$validateAclBinding(AclBinding aclBinding) {
        if (aclBinding.isUnknown()) {
            throw new IllegalArgumentException("ACL binding contains unknown elements");
        }
        if (aclBinding.pattern().name().contains("/")) {
            throw new IllegalArgumentException(new StringBuilder(44).append("ACL binding contains invalid resource name: ").append(aclBinding.pattern().name()).toString());
        }
    }

    public void loadAllAcls(KafkaZkClient zkClient, Logging logger, Function2<ResourcePattern, AclAuthorizer.VersionedAcls, BoxedUnit> aclConsumer) {
        ZkAclStore$.MODULE$.stores().foreach((Function1 & Serializable)store -> {
            AclAuthorizer$.$anonfun$loadAllAcls$1(zkClient, aclConsumer, logger, store);
            return BoxedUnit.UNIT;
        });
    }

    public AclAuthorizer.VersionedAcls getAclsFromZk(KafkaZkClient zkClient, ResourcePattern resource) {
        return zkClient.getVersionedAclsForResource(resource);
    }

    public static final /* synthetic */ void $anonfun$zkClientConfigFromKafkaConfigAndMap$4(ZKClientConfig zkClientConfig$1, String sysProp$1, String kafkaProp$1, Object prefixedValue) {
        String string;
        String string2 = kafkaProp$1;
        String string3 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            String string4 = prefixedValue.toString().trim().toUpperCase();
            String string5 = "HTTPS";
            string = Boolean.toString(string4 != null && string4.equals(string5));
        } else {
            string = prefixedValue.toString().trim();
        }
        zkClientConfig$1.setProperty(sysProp$1, string);
    }

    public static final /* synthetic */ void $anonfun$zkClientConfigFromKafkaConfigAndMap$3(Map configMap$1, ZKClientConfig zkClientConfig$1, String kafkaProp, String sysProp) {
        configMap$1.get((Object)new StringBuilder(0).append(MODULE$.configPrefix()).append(kafkaProp).toString()).foreach((Function1 & Serializable)prefixedValue -> {
            AclAuthorizer$.$anonfun$zkClientConfigFromKafkaConfigAndMap$4(zkClientConfig$1, sysProp, kafkaProp, prefixedValue);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$loadAllAcls$4(ResourceType resourceTypeObj$1, ZkAclStore store$1, KafkaZkClient zkClient$1, Function2 aclConsumer$1, String resourceName) {
        ResourcePattern resource = new ResourcePattern(resourceTypeObj$1, resourceName, store$1.patternType());
        AclAuthorizer.VersionedAcls versionedAcls = zkClient$1.getVersionedAclsForResource(resource);
        aclConsumer$1.apply((Object)resource, (Object)versionedAcls);
    }

    public static final /* synthetic */ void $anonfun$loadAllAcls$2(KafkaZkClient zkClient$1, ZkAclStore store$1, Function2 aclConsumer$1, Logging logger$1, String rType) {
        Try resourceType = Try$.MODULE$.apply((Function0 & Serializable)() -> SecurityUtils.resourceType((String)rType));
        if (resourceType instanceof Success) {
            ResourceType resourceTypeObj = (ResourceType)((Success)resourceType).value();
            zkClient$1.getResourceNames(store$1.patternType(), resourceTypeObj).foreach((Function1 & Serializable)resourceName -> {
                AclAuthorizer$.$anonfun$loadAllAcls$4(resourceTypeObj, store$1, zkClient$1, aclConsumer$1, resourceName);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (resourceType instanceof Failure) {
            logger$1.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Ignoring unknown ResourceType: ").append(rType).toString());
            return;
        }
        throw new MatchError((Object)resourceType);
    }

    public static final /* synthetic */ void $anonfun$loadAllAcls$1(KafkaZkClient zkClient$1, Function2 aclConsumer$1, Logging logger$1, ZkAclStore store) {
        zkClient$1.getResourceTypes(store.patternType()).foreach((Function1 & Serializable)rType -> {
            AclAuthorizer$.$anonfun$loadAllAcls$2(zkClient$1, store, aclConsumer$1, logger$1, rType);
            return BoxedUnit.UNIT;
        });
    }

    private AclAuthorizer$() {
    }
}

