/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.BrokerIdsZNode$;
import kafka.zk.BrokerInfo;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Factory;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BrokerIdZNode$ {
    public static final BrokerIdZNode$ MODULE$ = new BrokerIdZNode$();
    private static final String HostKey = "host";
    private static final String PortKey = "port";
    private static final String VersionKey = "version";
    private static final String EndpointsKey = "endpoints";
    private static final String RackKey = "rack";
    private static final String JmxPortKey = "jmx_port";
    private static final String ListenerSecurityProtocolMapKey = "listener_security_protocol_map";
    private static final String TimestampKey = "timestamp";

    private String HostKey() {
        return HostKey;
    }

    private String PortKey() {
        return PortKey;
    }

    private String VersionKey() {
        return VersionKey;
    }

    private String EndpointsKey() {
        return EndpointsKey;
    }

    private String RackKey() {
        return RackKey;
    }

    private String JmxPortKey() {
        return JmxPortKey;
    }

    private String ListenerSecurityProtocolMapKey() {
        return ListenerSecurityProtocolMapKey;
    }

    private String TimestampKey() {
        return TimestampKey;
    }

    public String path(int id) {
        return new StringBuilder(1).append(BrokerIdsZNode$.MODULE$.path()).append("/").append(id).toString();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] encode(int version, String host, int port, Seq<EndPoint> advertisedEndpoints, int jmxPort, Option<String> rack) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        Object[] objectArray = new Tuple2[6];
        Integer n = version;
        String $minus$greater$extension_$this = this.VersionKey();
        Object var8_8 = null;
        n = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y5);
        String ArrowAssoc_self = this.HostKey();
        Object var23_9 = null;
        String $minus$greater$extension_$this2 = ArrowAssoc_self;
        Object var10_10 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)host);
        Integer n2 = port;
        String $minus$greater$extension_$this3 = this.PortKey();
        Object var11_12 = null;
        n2 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y4);
        IterableOnceOps iterableOnceOps = (IterableOnceOps)advertisedEndpoints.map((Function1 & Serializable)x$1 -> x$1.connectionString());
        if (iterableOnceOps == null) {
            throw null;
        }
        IterableOnceOps toBuffer_this = iterableOnceOps;
        Object var13_13 = null;
        java.util.List list = AsJavaExtensions.BufferHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Buffer)((Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this))).asJava();
        String $minus$greater$extension_$this4 = this.EndpointsKey();
        Object var14_15 = null;
        list = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y3);
        Integer n3 = jmxPort;
        String $minus$greater$extension_$this5 = this.JmxPortKey();
        Object var16_17 = null;
        n3 = null;
        objectArray[4] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y2);
        String string = Long.toString(Time.SYSTEM.milliseconds());
        String $minus$greater$extension_$this6 = this.TimestampKey();
        Object var18_19 = null;
        string = null;
        objectArray[5] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y);
        scala.collection.mutable.Map jsonMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        if (rack == null) {
            throw null;
        }
        if (!rack.isEmpty()) {
            String string2 = (String)rack.get();
            BrokerIdZNode$.$anonfun$encode$2(version, jsonMap, string2);
        }
        if (version >= 4) {
            void $plus$eq_elem;
            void $minus$greater$extension_y6;
            java.util.Map map = AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((IterableOnceOps)advertisedEndpoints.map((Function1 & Serializable)endPoint -> {
                String $minus$greater$extension_y = endPoint.securityProtocol().name;
                String $minus$greater$extension_$this = endPoint.listenerName().value();
                return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
            String $minus$greater$extension_$this7 = this.ListenerSecurityProtocolMapKey();
            Object var20_23 = null;
            map = null;
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y6);
            if (jsonMap == null) {
                throw null;
            }
            jsonMap.addOne((Object)$plus$eq_elem);
            tuple2 = null;
        }
        return Json$.MODULE$.encodeAsBytes(AsJavaExtensions.MutableMapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (scala.collection.mutable.Map)jsonMap).asJava());
    }

    public byte[] encode(BrokerInfo brokerInfo) {
        Broker broker = brokerInfo.broker();
        Option option = broker.endPoints().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BrokerIdZNode$.$anonfun$encode$4(x$2)));
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? BrokerIdZNode$.$anonfun$encode$5() : getOrElse_this.get();
        Object var4_3 = null;
        EndPoint plaintextEndpoint = (EndPoint)object;
        return this.encode(brokerInfo.version(), plaintextEndpoint.host(), plaintextEndpoint.port(), broker.endPoints(), brokerInfo.jmxPort(), broker.rack());
    }

    /*
     * WARNING - void declaration
     */
    public BrokerInfo decode(int id, byte[] jsonBytes) {
        Either<JsonProcessingException, JsonValue> either = Json$.MODULE$.tryParseBytes(jsonBytes);
        if (either instanceof Right) {
            .colon.colon colon2;
            JsonObject brokerInfo = ((JsonValue)((Right)either).value()).asJsonObject();
            int version = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$));
            int jmxPort = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.JmxPortKey()).to(DecodeJson$DecodeInt$.MODULE$));
            if (version < 1) {
                throw new KafkaException(new StringBuilder(44).append("Unsupported version of broker registration: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            if (version == 1) {
                String host = brokerInfo.apply(this.HostKey()).to(DecodeJson$DecodeString$.MODULE$);
                int port = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.PortKey()).to(DecodeJson$DecodeInt$.MODULE$));
                SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                EndPoint endPoint = new EndPoint(host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
                colon2 = new .colon.colon((Object)endPoint, (List)Nil$.MODULE$);
            } else {
                void decodeSeq_factory;
                Option<JsonValue> option = brokerInfo.get(this.ListenerSecurityProtocolMapKey());
                if (option == null) {
                    throw null;
                }
                Option<JsonValue> map_this = option;
                Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BrokerIdZNode$.$anonfun$decode$2((JsonValue)map_this.get()));
                Object var15_11 = null;
                None$ securityProtocolMap = object;
                Seq$ iterableFactory_this = Seq$.MODULE$;
                Object var17_13 = null;
                Factory factory = IterableFactory.iterableFactory$((IterableFactory)iterableFactory_this);
                DecodeJson$DecodeString$ decodeSeq_decodeJson = DecodeJson$DecodeString$.MODULE$;
                Object var18_15 = null;
                factory = null;
                colon2 = (Seq)((Seq)brokerInfo.apply(this.EndpointsKey()).to(new DecodeJson<S>(decodeSeq_decodeJson, (Factory)decodeSeq_factory){
                    private final DecodeJson decodeJson$2;
                    private final Factory factory$1;

                    public Object decode(JsonNode node) {
                        return DecodeJson.decode$(this, node);
                    }

                    public final Either<String, S> decodeEither(JsonNode node) {
                        return DecodeJson$.kafka$utils$json$DecodeJson$$$anonfun$decodeSeq$1(node, this.decodeJson$2, this.factory$1);
                    }
                    {
                        this.decodeJson$2 = decodeJson$2;
                        this.factory$1 = factory$1;
                    }
                })).map(arg_0 -> BrokerIdZNode$.$anonfun$decode$4((Option)securityProtocolMap, arg_0));
            }
            .colon.colon endpoints = colon2;
            Option<JsonValue> option = brokerInfo.get(this.RackKey());
            if (option == null) {
                throw null;
            }
            Option<JsonValue> flatMap_this = option;
            Object object = flatMap_this.isEmpty() ? None$.MODULE$ : BrokerIdZNode$.$anonfun$decode$5((JsonValue)flatMap_this.get());
            Object var16_17 = null;
            None$ rack = object;
            return new BrokerInfo(new Broker(id, (Seq<EndPoint>)endpoints, (Option<String>)rack), version, jmxPort);
        }
        if (either instanceof Left) {
            JsonProcessingException e = (JsonProcessingException)((Object)((Left)either).value());
            throw new KafkaException(new StringBuilder(52).append("Failed to parse ZooKeeper registration for broker ").append(id).append(": ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString(), (Throwable)e);
        }
        throw new MatchError(either);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object $anonfun$encode$2(int version$1, scala.collection.mutable.Map jsonMap$1, String rack) {
        if (version$1 >= 3) {
            void $plus$eq_elem;
            String ArrowAssoc_self = MODULE$.RackKey();
            Object var5_3 = null;
            String $minus$greater$extension_$this = ArrowAssoc_self;
            Object var3_4 = null;
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)rack);
            if (jsonMap$1 == null) {
                throw null;
            }
            return jsonMap$1.addOne((Object)$plus$eq_elem);
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$encode$4(EndPoint x$2) {
        SecurityProtocol securityProtocol = x$2.securityProtocol();
        SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    public static final /* synthetic */ EndPoint $anonfun$encode$5() {
        return new EndPoint(null, -1, null, null);
    }

    public static final /* synthetic */ Map $anonfun$decode$2(JsonValue x$3) {
        scala.collection.Map$ mapFactory_this = scala.collection.Map$.MODULE$;
        Object var1_1 = null;
        Factory decodeMap_factory = MapFactory.mapFactory$((MapFactory)mapFactory_this);
        DecodeJson$DecodeString$ decodeMap_decodeJson = DecodeJson$DecodeString$.MODULE$;
        Object var2_3 = null;
        Object var3_2 = null;
        return (Map)((MapOps)x$3.to(new DecodeJson<M>(decodeMap_decodeJson, decodeMap_factory){
            private final DecodeJson decodeJson$3;
            private final Factory factory$2;

            public Object decode(JsonNode node) {
                return DecodeJson.decode$(this, node);
            }

            public final Either<String, M> decodeEither(JsonNode node) {
                return DecodeJson$.kafka$utils$json$DecodeJson$$$anonfun$decodeMap$1(node, this.decodeJson$3, this.factory$2);
            }
            {
                this.decodeJson$3 = decodeJson$3;
                this.factory$2 = factory$2;
            }
        })).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                void $minus$greater$extension_y;
                String listenerName = (String)x0$1._1();
                String securityProtocol = (String)x0$1._2();
                SecurityProtocol securityProtocol2 = SecurityProtocol.forName((String)securityProtocol);
                ListenerName $minus$greater$extension_$this = new ListenerName(listenerName);
                return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            }
            throw new MatchError(null);
        });
    }

    public static final /* synthetic */ EndPoint $anonfun$decode$4(Option securityProtocolMap$1, String x$4) {
        return EndPoint$.MODULE$.createEndPoint(x$4, (Option<Map<ListenerName, SecurityProtocol>>)securityProtocolMap$1);
    }

    public static final /* synthetic */ Option $anonfun$decode$5(JsonValue x$5) {
        DecodeJson$DecodeString$ decodeOption_decodeJson = DecodeJson$DecodeString$.MODULE$;
        Object var1_1 = null;
        return (Option)x$5.to(new DecodeJson<Option<E>>(decodeOption_decodeJson){
            private final DecodeJson decodeJson$1;

            public Object decode(JsonNode node) {
                return DecodeJson.decode$(this, node);
            }

            public final Either<String, Option<E>> decodeEither(JsonNode node) {
                return DecodeJson$.kafka$utils$json$DecodeJson$$$anonfun$decodeOption$1(node, this.decodeJson$1);
            }
            {
                this.decodeJson$1 = decodeJson$1;
            }
        });
    }

    private BrokerIdZNode$() {
    }
}

