/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.QuotaType$Request$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u00055c\u0001B\u000b\u0017\u0001mA\u0001\u0002\t\u0001\u0003\u0006\u0004%I!\t\u0005\tK\u0001\u0011\t\u0011)A\u0005E!Aa\u0005\u0001BC\u0002\u0013%q\u0005\u0003\u00055\u0001\t\u0005\t\u0015!\u0003)\u0011!)\u0004A!b\u0001\n\u00131\u0004\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0011y\u0002!\u0011!Q\u0001\n}B\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\u00061\u0002!\t!\u0017\u0005\bA\u0002\u0011\r\u0011\"\u0001b\u0011\u0019)\u0007\u0001)A\u0005E\")a\r\u0001C\u0001O\")1\u000e\u0001C\u0001Y\")Q\u000f\u0001C\u0001m\"9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001bBA\f\u0001\u0011E\u0013\u0011\u0004\u0005\b\u0003O\u0001A\u0011KA\u0015\u0011\u001d\ti\u0004\u0001C\u0005\u0003\u007fAq!!\u0011\u0001\t\u0013\t\u0019\u0005C\u0004\u0002F\u0001!I!a\u0012\u00033\rc\u0017.\u001a8u%\u0016\fX/Z:u#V|G/Y'b]\u0006<WM\u001d\u0006\u0003/a\taa]3sm\u0016\u0014(\"A\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\b\t\u0003;yi\u0011AF\u0005\u0003?Y\u0011!c\u00117jK:$\u0018+^8uC6\u000bg.Y4fe\u000611m\u001c8gS\u001e,\u0012A\t\t\u0003;\rJ!\u0001\n\f\u00031\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM]\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\u000f5,GO]5dgV\t\u0001\u0006\u0005\u0002*e5\t!F\u0003\u0002'W)\u0011A&L\u0001\u0007G>lWn\u001c8\u000b\u0005eq#BA\u00181\u0003\u0019\t\u0007/Y2iK*\t\u0011'A\u0002pe\u001eL!a\r\u0016\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0003uS6,W#A\u001c\u0011\u0005aZT\"A\u001d\u000b\u0005iZ\u0013!B;uS2\u001c\u0018B\u0001\u001f:\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002!QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\bC\u0001!J\u001d\t\tu\t\u0005\u0002C\u000b6\t1I\u0003\u0002E5\u00051AH]8pizR\u0011AR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0011\u0016\u000ba\u0001\u0015:fI\u00164\u0017B\u0001&L\u0005\u0019\u0019FO]5oO*\u0011\u0001*R\u0001\u000ecV|G/Y\"bY2\u0014\u0017mY6\u0011\u00079{\u0015+D\u0001F\u0013\t\u0001VI\u0001\u0004PaRLwN\u001c\t\u0003%Zk\u0011a\u0015\u0006\u0003)V\u000bQ!];pi\u0006T!aF\u0017\n\u0005]\u001b&aE\"mS\u0016tG/U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0017A\u0002\u001fj]&$h\b\u0006\u0004[7rkfl\u0018\t\u0003;\u0001AQ\u0001I\u0005A\u0002\tBQAJ\u0005A\u0002!BQ!N\u0005A\u0002]BQAP\u0005A\u0002}BQ\u0001T\u0005A\u00025\u000b\u0011#\\1y)\"\u0014x\u000e\u001e;mKRKW.Z't+\u0005\u0011\u0007C\u0001(d\u0013\t!WI\u0001\u0003M_:<\u0017AE7bqRC'o\u001c;uY\u0016$\u0016.\\3Ng\u0002\nA\"\u001a=f[B$8+\u001a8t_J,\u0012\u0001\u001b\t\u0003S%L!A\u001b\u0016\u0003\rM+gn]8s\u00031\u0011XmY8sI\u0016CX-\u001c9u)\ti\u0007\u000f\u0005\u0002O]&\u0011q.\u0012\u0002\u0005+:LG\u000fC\u0003r\u001b\u0001\u0007!/A\u0003wC2,X\r\u0005\u0002Og&\u0011A/\u0012\u0002\u0007\t>,(\r\\3\u0002?5\f\u0017PY3SK\u000e|'\u000fZ!oI\u001e+G\u000f\u00165s_R$H.\u001a+j[\u0016l5\u000f\u0006\u0003xu\u00065\u0001C\u0001(y\u0013\tIXIA\u0002J]RDQa\u001f\bA\u0002q\fqA]3rk\u0016\u001cH\u000fE\u0002~\u0003\u000fq1A`A\u0002\u001b\u0005y(bAA\u00011\u00059a.\u001a;x_J\\\u0017bAA\u0003\u007f\u0006q!+Z9vKN$8\t[1o]\u0016d\u0017\u0002BA\u0005\u0003\u0017\u0011qAU3rk\u0016\u001cHOC\u0002\u0002\u0006}Da!a\u0004\u000f\u0001\u0004\u0011\u0017A\u0002;j[\u0016l5/A\tnCf\u0014WMU3d_J$W\t_3naR$2!\\A\u000b\u0011\u0015Yx\u00021\u0001}\u00031!\bN]8ui2,G+[7f)\u001d\u0011\u00171DA\u0010\u0003GAa!!\b\u0011\u0001\u0004\u0011\u0018AC9v_R\fg+\u00197vK\"1\u0011\u0011\u0005\tA\u0002I\f!\"];pi\u0006\u0014u.\u001e8e\u0011\u0019\t)\u0003\u0005a\u0001E\u0006Qq/\u001b8e_^\u001c\u0016N_3\u0002)\rd\u0017.\u001a8u%\u0006$X-T3ue&\u001cg*Y7f)\u0011\tY#a\r\u0011\t\u00055\u0012qF\u0007\u0002W%\u0019\u0011\u0011G\u0016\u0003\u00155+GO]5d\u001d\u0006lW\rC\u0004\u00026E\u0001\r!a\u000e\u0002\u001fE,x\u000e^1NKR\u0014\u0018n\u0019+bON\u0004R\u0001QA\u001d\u007f}J1!a\u000fL\u0005\ri\u0015\r]\u0001\u0011Kb,W\u000e\u001d;NKR\u0014\u0018n\u0019(b[\u0016,\"!a\u000b\u0002!\u0015DX-\u001c9u'\u0016t7o\u001c:OC6,W#A \u0002#9\fgn\\:U_B+'oY3oi\u0006<W\rF\u0002s\u0003\u0013Ba!a\u0013\u0015\u0001\u0004\u0011\u0017!\u00028b]>\u001c\b")
public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final Time time;
    private final long maxThrottleTimeMs;

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private Time time() {
        return this.time;
    }

    public long maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    public Sensor exemptSensor() {
        return this.getOrCreateSensor(this.exemptSensorName(), this.exemptMetricName());
    }

    public void recordExempt(double value) {
        this.exemptSensor().record(value);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request, long timeMs) {
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable)timeNanos -> this.recordNoThrottle(this.getOrCreateQuotaSensors(request.session(), request.header().clientId()), (double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond())));
            return this.recordAndGetThrottleTimeMs(request.session(), request.header().clientId(), (double)request.requestThreadTimeNanos() * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond(), timeMs);
        }
        return 0;
    }

    public void maybeRecordExempt(RequestChannel.Request request) {
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable)timeNanos -> this.recordExempt((double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond())));
            this.recordExempt((double)request.requestThreadTimeNanos() * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond());
            return;
        }
    }

    @Override
    public long throttleTime(double quotaValue, double quotaBound, long windowSize) {
        return Math.min(super.throttleTime(quotaValue, quotaBound, windowSize), this.maxThrottleTimeMs());
    }

    @Override
    public MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("request-time", "Request", "Tracking request-time per user/client-id", AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, quotaMetricTags).asJava());
    }

    private MetricName exemptMetricName() {
        return this.metrics().metricName("exempt-request-time", "Request", "Tracking exempt-request-time utilization percentage");
    }

    private String exemptSensorName() {
        return new StringBuilder(7).append("exempt-").append(QuotaType$Request$.MODULE$).toString();
    }

    private double nanosToPercentage(long nanos) {
        return (double)nanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> quotaCallback) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        super(config, metrics, QuotaType$Request$.MODULE$, time, threadNamePrefix, quotaCallback);
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds());
    }
}

