/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.util.Properties;
import java.util.Set;
import kafka.api.ApiVersionValidator$;
import kafka.log.Defaults$;
import kafka.log.LogConfig;
import kafka.message.BrokerCompressionCodec$;
import kafka.server.KafkaConfig$;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.Implicits;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import scala.Console$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class LogConfig$
implements Serializable {
    public static final LogConfig$ MODULE$;
    private static final String SegmentBytesProp;
    private static final String SegmentMsProp;
    private static final String SegmentJitterMsProp;
    private static final String SegmentIndexBytesProp;
    private static final String FlushMessagesProp;
    private static final String FlushMsProp;
    private static final String RetentionBytesProp;
    private static final String RetentionMsProp;
    private static final String MaxMessageBytesProp;
    private static final String IndexIntervalBytesProp;
    private static final String DeleteRetentionMsProp;
    private static final String MinCompactionLagMsProp;
    private static final String MaxCompactionLagMsProp;
    private static final String FileDeleteDelayMsProp;
    private static final String MinCleanableDirtyRatioProp;
    private static final String CleanupPolicyProp;
    private static final String Delete;
    private static final String Compact;
    private static final String UncleanLeaderElectionEnableProp;
    private static final String MinInSyncReplicasProp;
    private static final String CompressionTypeProp;
    private static final String PreAllocateEnableProp;
    private static final String MessageFormatVersionProp;
    private static final String MessageTimestampTypeProp;
    private static final String MessageTimestampDifferenceMaxMsProp;
    private static final String MessageDownConversionEnableProp;
    private static final String LeaderReplicationThrottledReplicasProp;
    private static final String FollowerReplicationThrottledReplicasProp;
    private static final String SegmentSizeDoc;
    private static final String SegmentMsDoc;
    private static final String SegmentJitterMsDoc;
    private static final String MaxIndexSizeDoc;
    private static final String FlushIntervalDoc;
    private static final String FlushMsDoc;
    private static final String RetentionSizeDoc;
    private static final String RetentionMsDoc;
    private static final String MaxMessageSizeDoc;
    private static final String IndexIntervalDoc;
    private static final String FileDeleteDelayMsDoc;
    private static final String DeleteRetentionMsDoc;
    private static final String MinCompactionLagMsDoc;
    private static final String MaxCompactionLagMsDoc;
    private static final String MinCleanableRatioDoc;
    private static final String CompactDoc;
    private static final String UncleanLeaderElectionEnableDoc;
    private static final String MinInSyncReplicasDoc;
    private static final String CompressionTypeDoc;
    private static final String PreAllocateEnableDoc;
    private static final String MessageFormatVersionDoc;
    private static final String MessageTimestampTypeDoc;
    private static final String MessageTimestampDifferenceMaxMsDoc;
    private static final String MessageDownConversionEnableDoc;
    private static final String LeaderReplicationThrottledReplicasDoc;
    private static final String FollowerReplicationThrottledReplicasDoc;
    private static final String ServerDefaultHeaderName;
    private static final LogConfig.LogConfigDef kafka$log$LogConfig$$configDef;
    private static final Map<String, String> TopicConfigSynonyms;

    /*
     * WARNING - void declaration
     */
    static {
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_y9;
        void $minus$greater$extension_y10;
        void $minus$greater$extension_y11;
        void $minus$greater$extension_y12;
        void $minus$greater$extension_y13;
        void $minus$greater$extension_y14;
        void $minus$greater$extension_y15;
        void $minus$greater$extension_y16;
        void $minus$greater$extension_y17;
        void $minus$greater$extension_y18;
        void $minus$greater$extension_y19;
        void $minus$greater$extension_y20;
        void $minus$greater$extension_y21;
        void $minus$greater$extension_y22;
        MODULE$ = new LogConfig$();
        SegmentBytesProp = "segment.bytes";
        SegmentMsProp = "segment.ms";
        SegmentJitterMsProp = "segment.jitter.ms";
        SegmentIndexBytesProp = "segment.index.bytes";
        FlushMessagesProp = "flush.messages";
        FlushMsProp = "flush.ms";
        RetentionBytesProp = "retention.bytes";
        RetentionMsProp = "retention.ms";
        MaxMessageBytesProp = "max.message.bytes";
        IndexIntervalBytesProp = "index.interval.bytes";
        DeleteRetentionMsProp = "delete.retention.ms";
        MinCompactionLagMsProp = "min.compaction.lag.ms";
        MaxCompactionLagMsProp = "max.compaction.lag.ms";
        FileDeleteDelayMsProp = "file.delete.delay.ms";
        MinCleanableDirtyRatioProp = "min.cleanable.dirty.ratio";
        CleanupPolicyProp = "cleanup.policy";
        Delete = "delete";
        Compact = "compact";
        UncleanLeaderElectionEnableProp = "unclean.leader.election.enable";
        MinInSyncReplicasProp = "min.insync.replicas";
        CompressionTypeProp = "compression.type";
        PreAllocateEnableProp = "preallocate";
        MessageFormatVersionProp = "message.format.version";
        MessageTimestampTypeProp = "message.timestamp.type";
        MessageTimestampDifferenceMaxMsProp = "message.timestamp.difference.max.ms";
        MessageDownConversionEnableProp = "message.downconversion.enable";
        LeaderReplicationThrottledReplicasProp = "leader.replication.throttled.replicas";
        FollowerReplicationThrottledReplicasProp = "follower.replication.throttled.replicas";
        SegmentSizeDoc = "This configuration controls the segment file size for the log. Retention and cleaning is always done a file at a time so a larger segment size means fewer files but less granular control over retention.";
        SegmentMsDoc = "This configuration controls the period of time after which Kafka will force the log to roll even if the segment file isn't full to ensure that retention can delete or compact old data.";
        SegmentJitterMsDoc = "The maximum random jitter subtracted from the scheduled segment roll time to avoid thundering herds of segment rolling";
        MaxIndexSizeDoc = "This configuration controls the size of the index that maps offsets to file positions. We preallocate this index file and shrink it only after log rolls. You generally should not need to change this setting.";
        FlushIntervalDoc = "This setting allows specifying an interval at which we will force an fsync of data written to the log. For example if this was set to 1 we would fsync after every message; if it were 5 we would fsync after every five messages. In general we recommend you not set this and use replication for durability and allow the operating system's background flush capabilities as it is more efficient. This setting can be overridden on a per-topic basis (see <a href=\"#topicconfigs\">the per-topic configuration section</a>).";
        FlushMsDoc = "This setting allows specifying a time interval at which we will force an fsync of data written to the log. For example if this was set to 1000 we would fsync after 1000 ms had passed. In general we recommend you not set this and use replication for durability and allow the operating system's background flush capabilities as it is more efficient.";
        RetentionSizeDoc = "This configuration controls the maximum size a partition (which consists of log segments) can grow to before we will discard old log segments to free up space if we are using the \"delete\" retention policy. By default there is no size limit only a time limit. Since this limit is enforced at the partition level, multiply it by the number of partitions to compute the topic retention in bytes.";
        RetentionMsDoc = "This configuration controls the maximum time we will retain a log before we will discard old log segments to free up space if we are using the \"delete\" retention policy. This represents an SLA on how soon consumers must read their data. If set to -1, no time limit is applied.";
        MaxMessageSizeDoc = "The largest record batch size allowed by Kafka (after compression if compression is enabled). If this is increased and there are consumers older than 0.10.2, the consumers' fetch size must also be increased so that they can fetch record batches this large. In the latest message format version, records are always grouped into batches for efficiency. In previous message format versions, uncompressed records are not grouped into batches and this limit only applies to a single record in that case.";
        IndexIntervalDoc = "This setting controls how frequently Kafka adds an index entry to its offset index. The default setting ensures that we index a message roughly every 4096 bytes. More indexing allows reads to jump closer to the exact position in the log but makes the index larger. You probably don't need to change this.";
        FileDeleteDelayMsDoc = "The time to wait before deleting a file from the filesystem";
        DeleteRetentionMsDoc = "The amount of time to retain delete tombstone markers for <a href=\"#compaction\">log compacted</a> topics. This setting also gives a bound on the time in which a consumer must complete a read if they begin from offset 0 to ensure that they get a valid snapshot of the final stage (otherwise delete tombstones may be collected before they complete their scan).";
        MinCompactionLagMsDoc = "The minimum time a message will remain uncompacted in the log. Only applicable for logs that are being compacted.";
        MaxCompactionLagMsDoc = "The maximum time a message will remain ineligible for compaction in the log. Only applicable for logs that are being compacted.";
        MinCleanableRatioDoc = "This configuration controls how frequently the log compactor will attempt to clean the log (assuming <a href=\"#compaction\">log compaction</a> is enabled). By default we will avoid cleaning a log where more than 50% of the log has been compacted. This ratio bounds the maximum space wasted in the log by duplicates (at 50% at most 50% of the log could be duplicates). A higher ratio will mean fewer, more efficient cleanings but will mean more wasted space in the log. If the max.compaction.lag.ms or the min.compaction.lag.ms configurations are also specified, then the log compactor considers the log to be eligible for compaction as soon as either: (i) the dirty ratio threshold has been met and the log has had dirty (uncompacted) records for at least the min.compaction.lag.ms duration, or (ii) if the log has had dirty (uncompacted) records for at most the max.compaction.lag.ms period.";
        CompactDoc = "A string that is either \"delete\" or \"compact\" or both. This string designates the retention policy to use on old log segments. The default policy (\"delete\") will discard old segments when their retention time or size limit has been reached. The \"compact\" setting will enable <a href=\"#compaction\">log compaction</a> on the topic.";
        UncleanLeaderElectionEnableDoc = "Indicates whether to enable replicas not in the ISR set to be elected as leader as a last resort, even though doing so may result in data loss.";
        MinInSyncReplicasDoc = "When a producer sets acks to \"all\" (or \"-1\"), this configuration specifies the minimum number of replicas that must acknowledge a write for the write to be considered successful. If this minimum cannot be met, then the producer will raise an exception (either NotEnoughReplicas or NotEnoughReplicasAfterAppend).<br>When used together, <code>min.insync.replicas</code> and <code>acks</code> allow you to enforce greater durability guarantees. A typical scenario would be to create a topic with a replication factor of 3, set <code>min.insync.replicas</code> to 2, and produce with <code>acks</code> of \"all\". This will ensure that the producer raises an exception if a majority of replicas do not receive a write.";
        CompressionTypeDoc = "Specify the final compression type for a given topic. This configuration accepts the standard compression codecs ('gzip', 'snappy', 'lz4', 'zstd'). It additionally accepts 'uncompressed' which is equivalent to no compression; and 'producer' which means retain the original compression codec set by the producer.";
        PreAllocateEnableDoc = "True if we should preallocate the file on disk when creating a new log segment.";
        MessageFormatVersionDoc = "Specify the message format version the broker will use to append messages to the logs. The value should be a valid ApiVersion. Some examples are: 0.8.2, 0.9.0.0, 0.10.0, check ApiVersion for more details. By setting a particular message format version, the user is certifying that all the existing messages on disk are smaller or equal than the specified version. Setting this value incorrectly will cause consumers with older versions to break as they will receive messages with a format that they don't understand.";
        MessageTimestampTypeDoc = "Define whether the timestamp in the message is message create time or log append time. The value should be either `CreateTime` or `LogAppendTime`";
        MessageTimestampDifferenceMaxMsDoc = "The maximum difference allowed between the timestamp when a broker receives a message and the timestamp specified in the message. If message.timestamp.type=CreateTime, a message will be rejected if the difference in timestamp exceeds this threshold. This configuration is ignored if message.timestamp.type=LogAppendTime.";
        MessageDownConversionEnableDoc = "This configuration controls whether down-conversion of message formats is enabled to satisfy consume requests. When set to <code>false</code>, broker will not perform down-conversion for consumers expecting an older message format. The broker responds with <code>UNSUPPORTED_VERSION</code> error for consume requests from such older clients. This configurationdoes not apply to any message format conversion that might be required for replication to followers.";
        LeaderReplicationThrottledReplicasDoc = "A list of replicas for which log replication should be throttled on the leader side. The list should describe a set of replicas in the form [PartitionId]:[BrokerId],[PartitionId]:[BrokerId]:... or alternatively the wildcard '*' can be used to throttle all replicas for this topic.";
        FollowerReplicationThrottledReplicasDoc = "A list of replicas for which log replication should be throttled on the follower side. The list should describe a set of replicas in the form [PartitionId]:[BrokerId],[PartitionId]:[BrokerId]:... or alternatively the wildcard '*' can be used to throttle all replicas for this topic.";
        ServerDefaultHeaderName = "Server Default Property";
        kafka$log$LogConfig$$configDef = new LogConfig.LogConfigDef().define(MODULE$.SegmentBytesProp(), ConfigDef.Type.INT, Defaults$.MODULE$.SegmentSize(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)14), ConfigDef.Importance.MEDIUM, MODULE$.SegmentSizeDoc(), KafkaConfig$.MODULE$.LogSegmentBytesProp()).define(MODULE$.SegmentMsProp(), ConfigDef.Type.LONG, Defaults$.MODULE$.SegmentMs(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, MODULE$.SegmentMsDoc(), KafkaConfig$.MODULE$.LogRollTimeMillisProp()).define(MODULE$.SegmentJitterMsProp(), ConfigDef.Type.LONG, Defaults$.MODULE$.SegmentJitterMs(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MODULE$.SegmentJitterMsDoc(), KafkaConfig$.MODULE$.LogRollTimeJitterMillisProp()).define(MODULE$.SegmentIndexBytesProp(), ConfigDef.Type.INT, Defaults$.MODULE$.MaxIndexSize(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MODULE$.MaxIndexSizeDoc(), KafkaConfig$.MODULE$.LogIndexSizeMaxBytesProp()).define(MODULE$.FlushMessagesProp(), ConfigDef.Type.LONG, Defaults$.MODULE$.FlushInterval(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MODULE$.FlushIntervalDoc(), KafkaConfig$.MODULE$.LogFlushIntervalMessagesProp()).define(MODULE$.FlushMsProp(), ConfigDef.Type.LONG, Defaults$.MODULE$.FlushMs(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MODULE$.FlushMsDoc(), KafkaConfig$.MODULE$.LogFlushIntervalMsProp()).define(MODULE$.RetentionBytesProp(), ConfigDef.Type.LONG, Defaults$.MODULE$.RetentionSize(), ConfigDef.Importance.MEDIUM, MODULE$.RetentionSizeDoc(), KafkaConfig$.MODULE$.LogRetentionBytesProp()).define(MODULE$.RetentionMsProp(), ConfigDef.Type.LONG, Defaults$.MODULE$.RetentionMs(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)-1), ConfigDef.Importance.MEDIUM, MODULE$.RetentionMsDoc(), KafkaConfig$.MODULE$.LogRetentionTimeMillisProp()).define(MODULE$.MaxMessageBytesProp(), ConfigDef.Type.INT, Defaults$.MODULE$.MaxMessageSize(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MODULE$.MaxMessageSizeDoc(), KafkaConfig$.MODULE$.MessageMaxBytesProp()).define(MODULE$.IndexIntervalBytesProp(), ConfigDef.Type.INT, Defaults$.MODULE$.IndexInterval(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MODULE$.IndexIntervalDoc(), KafkaConfig$.MODULE$.LogIndexIntervalBytesProp()).define(MODULE$.DeleteRetentionMsProp(), ConfigDef.Type.LONG, Defaults$.MODULE$.DeleteRetentionMs(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MODULE$.DeleteRetentionMsDoc(), KafkaConfig$.MODULE$.LogCleanerDeleteRetentionMsProp()).define(MODULE$.MinCompactionLagMsProp(), ConfigDef.Type.LONG, Defaults$.MODULE$.MinCompactionLagMs(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MODULE$.MinCompactionLagMsDoc(), KafkaConfig$.MODULE$.LogCleanerMinCompactionLagMsProp()).define(MODULE$.MaxCompactionLagMsProp(), ConfigDef.Type.LONG, Defaults$.MODULE$.MaxCompactionLagMs(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, MODULE$.MaxCompactionLagMsDoc(), KafkaConfig$.MODULE$.LogCleanerMaxCompactionLagMsProp()).define(MODULE$.FileDeleteDelayMsProp(), ConfigDef.Type.LONG, Defaults$.MODULE$.FileDeleteDelayMs(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MODULE$.FileDeleteDelayMsDoc(), KafkaConfig$.MODULE$.LogDeleteDelayMsProp()).define(MODULE$.MinCleanableDirtyRatioProp(), ConfigDef.Type.DOUBLE, Defaults$.MODULE$.MinCleanableDirtyRatio(), (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)1), ConfigDef.Importance.MEDIUM, MODULE$.MinCleanableRatioDoc(), KafkaConfig$.MODULE$.LogCleanerMinCleanRatioProp()).define(MODULE$.CleanupPolicyProp(), ConfigDef.Type.LIST, Defaults$.MODULE$.CleanupPolicy(), (ConfigDef.Validator)ConfigDef.ValidList.in((String[])new String[]{MODULE$.Compact(), MODULE$.Delete()}), ConfigDef.Importance.MEDIUM, MODULE$.CompactDoc(), KafkaConfig$.MODULE$.LogCleanupPolicyProp()).define(MODULE$.UncleanLeaderElectionEnableProp(), ConfigDef.Type.BOOLEAN, Defaults$.MODULE$.UncleanLeaderElectionEnable(), ConfigDef.Importance.MEDIUM, MODULE$.UncleanLeaderElectionEnableDoc(), KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp()).define(MODULE$.MinInSyncReplicasProp(), ConfigDef.Type.INT, Defaults$.MODULE$.MinInSyncReplicas(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, MODULE$.MinInSyncReplicasDoc(), KafkaConfig$.MODULE$.MinInSyncReplicasProp()).define(MODULE$.CompressionTypeProp(), ConfigDef.Type.STRING, Defaults$.MODULE$.CompressionType(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])((String[])BrokerCompressionCodec$.MODULE$.brokerCompressionOptions().toArray(ClassTag$.MODULE$.apply(String.class)))), ConfigDef.Importance.MEDIUM, MODULE$.CompressionTypeDoc(), KafkaConfig$.MODULE$.CompressionTypeProp()).define(MODULE$.PreAllocateEnableProp(), ConfigDef.Type.BOOLEAN, Defaults$.MODULE$.PreAllocateEnable(), ConfigDef.Importance.MEDIUM, MODULE$.PreAllocateEnableDoc(), KafkaConfig$.MODULE$.LogPreAllocateProp()).define(MODULE$.MessageFormatVersionProp(), ConfigDef.Type.STRING, Defaults$.MODULE$.MessageFormatVersion(), ApiVersionValidator$.MODULE$, ConfigDef.Importance.MEDIUM, MODULE$.MessageFormatVersionDoc(), KafkaConfig$.MODULE$.LogMessageFormatVersionProp()).define(MODULE$.MessageTimestampTypeProp(), ConfigDef.Type.STRING, Defaults$.MODULE$.MessageTimestampType(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{"CreateTime", "LogAppendTime"}), ConfigDef.Importance.MEDIUM, MODULE$.MessageTimestampTypeDoc(), KafkaConfig$.MODULE$.LogMessageTimestampTypeProp()).define(MODULE$.MessageTimestampDifferenceMaxMsProp(), ConfigDef.Type.LONG, Defaults$.MODULE$.MessageTimestampDifferenceMaxMs(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MODULE$.MessageTimestampDifferenceMaxMsDoc(), KafkaConfig$.MODULE$.LogMessageTimestampDifferenceMaxMsProp()).define(MODULE$.LeaderReplicationThrottledReplicasProp(), ConfigDef.Type.LIST, Defaults$.MODULE$.LeaderReplicationThrottledReplicas(), ThrottledReplicaListValidator$.MODULE$, ConfigDef.Importance.MEDIUM, MODULE$.LeaderReplicationThrottledReplicasDoc(), MODULE$.LeaderReplicationThrottledReplicasProp()).define(MODULE$.FollowerReplicationThrottledReplicasProp(), ConfigDef.Type.LIST, Defaults$.MODULE$.FollowerReplicationThrottledReplicas(), ThrottledReplicaListValidator$.MODULE$, ConfigDef.Importance.MEDIUM, MODULE$.FollowerReplicationThrottledReplicasDoc(), MODULE$.FollowerReplicationThrottledReplicasProp()).define(MODULE$.MessageDownConversionEnableProp(), ConfigDef.Type.BOOLEAN, Defaults$.MODULE$.MessageDownConversionEnable(), ConfigDef.Importance.LOW, MODULE$.MessageDownConversionEnableDoc(), KafkaConfig$.MODULE$.LogMessageDownConversionEnableProp());
        Object[] objectArray = new Tuple2[24];
        String $minus$greater$extension_y23 = KafkaConfig$.MODULE$.LogSegmentBytesProp();
        Object $minus$greater$extension_$this = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.SegmentBytesProp());
        Object var0_1 = null;
        Object var1 = null;
        objectArray[0] = new Tuple2($minus$greater$extension_$this, (Object)$minus$greater$extension_y23);
        String $minus$greater$extension_y24 = KafkaConfig$.MODULE$.LogRollTimeMillisProp();
        Object $minus$greater$extension_$this2 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.SegmentMsProp());
        Object var2_3 = null;
        Object var3_2 = null;
        objectArray[1] = new Tuple2($minus$greater$extension_$this2, (Object)$minus$greater$extension_y24);
        String string = KafkaConfig$.MODULE$.LogRollTimeJitterMillisProp();
        Object $minus$greater$extension_$this3 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.SegmentJitterMsProp());
        Object var4_5 = null;
        string = null;
        objectArray[2] = new Tuple2($minus$greater$extension_$this3, (Object)$minus$greater$extension_y22);
        String string2 = KafkaConfig$.MODULE$.LogIndexSizeMaxBytesProp();
        Object $minus$greater$extension_$this4 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.SegmentIndexBytesProp());
        Object var6_7 = null;
        string2 = null;
        objectArray[3] = new Tuple2($minus$greater$extension_$this4, (Object)$minus$greater$extension_y21);
        String string3 = KafkaConfig$.MODULE$.LogFlushIntervalMessagesProp();
        Object $minus$greater$extension_$this5 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.FlushMessagesProp());
        Object var8_9 = null;
        string3 = null;
        objectArray[4] = new Tuple2($minus$greater$extension_$this5, (Object)$minus$greater$extension_y20);
        String string4 = KafkaConfig$.MODULE$.LogFlushIntervalMsProp();
        Object $minus$greater$extension_$this6 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.FlushMsProp());
        Object var10_11 = null;
        string4 = null;
        objectArray[5] = new Tuple2($minus$greater$extension_$this6, (Object)$minus$greater$extension_y19);
        String string5 = KafkaConfig$.MODULE$.LogRetentionBytesProp();
        Object $minus$greater$extension_$this7 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.RetentionBytesProp());
        Object var12_13 = null;
        string5 = null;
        objectArray[6] = new Tuple2($minus$greater$extension_$this7, (Object)$minus$greater$extension_y18);
        String string6 = KafkaConfig$.MODULE$.LogRetentionTimeMillisProp();
        Object $minus$greater$extension_$this8 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.RetentionMsProp());
        Object var14_15 = null;
        string6 = null;
        objectArray[7] = new Tuple2($minus$greater$extension_$this8, (Object)$minus$greater$extension_y17);
        String string7 = KafkaConfig$.MODULE$.MessageMaxBytesProp();
        Object $minus$greater$extension_$this9 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.MaxMessageBytesProp());
        Object var16_17 = null;
        string7 = null;
        objectArray[8] = new Tuple2($minus$greater$extension_$this9, (Object)$minus$greater$extension_y16);
        String string8 = KafkaConfig$.MODULE$.LogIndexIntervalBytesProp();
        Object $minus$greater$extension_$this10 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.IndexIntervalBytesProp());
        Object var18_19 = null;
        string8 = null;
        objectArray[9] = new Tuple2($minus$greater$extension_$this10, (Object)$minus$greater$extension_y15);
        String string9 = KafkaConfig$.MODULE$.LogCleanerDeleteRetentionMsProp();
        Object $minus$greater$extension_$this11 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.DeleteRetentionMsProp());
        Object var20_21 = null;
        string9 = null;
        objectArray[10] = new Tuple2($minus$greater$extension_$this11, (Object)$minus$greater$extension_y14);
        String string10 = KafkaConfig$.MODULE$.LogCleanerMinCompactionLagMsProp();
        Object $minus$greater$extension_$this12 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.MinCompactionLagMsProp());
        Object var22_23 = null;
        string10 = null;
        objectArray[11] = new Tuple2($minus$greater$extension_$this12, (Object)$minus$greater$extension_y13);
        String string11 = KafkaConfig$.MODULE$.LogCleanerMaxCompactionLagMsProp();
        Object $minus$greater$extension_$this13 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.MaxCompactionLagMsProp());
        Object var24_25 = null;
        string11 = null;
        objectArray[12] = new Tuple2($minus$greater$extension_$this13, (Object)$minus$greater$extension_y12);
        String string12 = KafkaConfig$.MODULE$.LogDeleteDelayMsProp();
        Object $minus$greater$extension_$this14 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.FileDeleteDelayMsProp());
        Object var26_27 = null;
        string12 = null;
        objectArray[13] = new Tuple2($minus$greater$extension_$this14, (Object)$minus$greater$extension_y11);
        String string13 = KafkaConfig$.MODULE$.LogCleanerMinCleanRatioProp();
        Object $minus$greater$extension_$this15 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.MinCleanableDirtyRatioProp());
        Object var28_29 = null;
        string13 = null;
        objectArray[14] = new Tuple2($minus$greater$extension_$this15, (Object)$minus$greater$extension_y10);
        String string14 = KafkaConfig$.MODULE$.LogCleanupPolicyProp();
        Object $minus$greater$extension_$this16 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.CleanupPolicyProp());
        Object var30_31 = null;
        string14 = null;
        objectArray[15] = new Tuple2($minus$greater$extension_$this16, (Object)$minus$greater$extension_y9);
        String string15 = KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp();
        Object $minus$greater$extension_$this17 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.UncleanLeaderElectionEnableProp());
        Object var32_33 = null;
        string15 = null;
        objectArray[16] = new Tuple2($minus$greater$extension_$this17, (Object)$minus$greater$extension_y8);
        String string16 = KafkaConfig$.MODULE$.MinInSyncReplicasProp();
        Object $minus$greater$extension_$this18 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.MinInSyncReplicasProp());
        Object var34_35 = null;
        string16 = null;
        objectArray[17] = new Tuple2($minus$greater$extension_$this18, (Object)$minus$greater$extension_y7);
        String string17 = KafkaConfig$.MODULE$.CompressionTypeProp();
        Object $minus$greater$extension_$this19 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.CompressionTypeProp());
        Object var36_37 = null;
        string17 = null;
        objectArray[18] = new Tuple2($minus$greater$extension_$this19, (Object)$minus$greater$extension_y6);
        String string18 = KafkaConfig$.MODULE$.LogPreAllocateProp();
        Object $minus$greater$extension_$this20 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.PreAllocateEnableProp());
        Object var38_39 = null;
        string18 = null;
        objectArray[19] = new Tuple2($minus$greater$extension_$this20, (Object)$minus$greater$extension_y5);
        String string19 = KafkaConfig$.MODULE$.LogMessageFormatVersionProp();
        Object $minus$greater$extension_$this21 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.MessageFormatVersionProp());
        Object var40_41 = null;
        string19 = null;
        objectArray[20] = new Tuple2($minus$greater$extension_$this21, (Object)$minus$greater$extension_y4);
        String string20 = KafkaConfig$.MODULE$.LogMessageTimestampTypeProp();
        Object $minus$greater$extension_$this22 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.MessageTimestampTypeProp());
        Object var42_43 = null;
        string20 = null;
        objectArray[21] = new Tuple2($minus$greater$extension_$this22, (Object)$minus$greater$extension_y3);
        String string21 = KafkaConfig$.MODULE$.LogMessageTimestampDifferenceMaxMsProp();
        Object $minus$greater$extension_$this23 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.MessageTimestampDifferenceMaxMsProp());
        Object var44_45 = null;
        string21 = null;
        objectArray[22] = new Tuple2($minus$greater$extension_$this23, (Object)$minus$greater$extension_y2);
        String string22 = KafkaConfig$.MODULE$.LogMessageDownConversionEnableProp();
        Object $minus$greater$extension_$this24 = Predef$.MODULE$.ArrowAssoc((Object)MODULE$.MessageDownConversionEnableProp());
        Object var46_47 = null;
        string22 = null;
        objectArray[23] = new Tuple2($minus$greater$extension_$this24, (Object)$minus$greater$extension_y);
        TopicConfigSynonyms = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public scala.collection.immutable.Set<String> $lessinit$greater$default$2() {
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        return Set.EmptySet$.MODULE$;
    }

    public void main(String[] args) {
        String println_x = this.kafka$log$LogConfig$$configDef().toHtml();
        Console$.MODULE$.println((Object)println_x);
    }

    public String SegmentBytesProp() {
        return SegmentBytesProp;
    }

    public String SegmentMsProp() {
        return SegmentMsProp;
    }

    public String SegmentJitterMsProp() {
        return SegmentJitterMsProp;
    }

    public String SegmentIndexBytesProp() {
        return SegmentIndexBytesProp;
    }

    public String FlushMessagesProp() {
        return FlushMessagesProp;
    }

    public String FlushMsProp() {
        return FlushMsProp;
    }

    public String RetentionBytesProp() {
        return RetentionBytesProp;
    }

    public String RetentionMsProp() {
        return RetentionMsProp;
    }

    public String MaxMessageBytesProp() {
        return MaxMessageBytesProp;
    }

    public String IndexIntervalBytesProp() {
        return IndexIntervalBytesProp;
    }

    public String DeleteRetentionMsProp() {
        return DeleteRetentionMsProp;
    }

    public String MinCompactionLagMsProp() {
        return MinCompactionLagMsProp;
    }

    public String MaxCompactionLagMsProp() {
        return MaxCompactionLagMsProp;
    }

    public String FileDeleteDelayMsProp() {
        return FileDeleteDelayMsProp;
    }

    public String MinCleanableDirtyRatioProp() {
        return MinCleanableDirtyRatioProp;
    }

    public String CleanupPolicyProp() {
        return CleanupPolicyProp;
    }

    public String Delete() {
        return Delete;
    }

    public String Compact() {
        return Compact;
    }

    public String UncleanLeaderElectionEnableProp() {
        return UncleanLeaderElectionEnableProp;
    }

    public String MinInSyncReplicasProp() {
        return MinInSyncReplicasProp;
    }

    public String CompressionTypeProp() {
        return CompressionTypeProp;
    }

    public String PreAllocateEnableProp() {
        return PreAllocateEnableProp;
    }

    public String MessageFormatVersionProp() {
        return MessageFormatVersionProp;
    }

    public String MessageTimestampTypeProp() {
        return MessageTimestampTypeProp;
    }

    public String MessageTimestampDifferenceMaxMsProp() {
        return MessageTimestampDifferenceMaxMsProp;
    }

    public String MessageDownConversionEnableProp() {
        return MessageDownConversionEnableProp;
    }

    public String LeaderReplicationThrottledReplicasProp() {
        return LeaderReplicationThrottledReplicasProp;
    }

    public String FollowerReplicationThrottledReplicasProp() {
        return FollowerReplicationThrottledReplicasProp;
    }

    public String SegmentSizeDoc() {
        return SegmentSizeDoc;
    }

    public String SegmentMsDoc() {
        return SegmentMsDoc;
    }

    public String SegmentJitterMsDoc() {
        return SegmentJitterMsDoc;
    }

    public String MaxIndexSizeDoc() {
        return MaxIndexSizeDoc;
    }

    public String FlushIntervalDoc() {
        return FlushIntervalDoc;
    }

    public String FlushMsDoc() {
        return FlushMsDoc;
    }

    public String RetentionSizeDoc() {
        return RetentionSizeDoc;
    }

    public String RetentionMsDoc() {
        return RetentionMsDoc;
    }

    public String MaxMessageSizeDoc() {
        return MaxMessageSizeDoc;
    }

    public String IndexIntervalDoc() {
        return IndexIntervalDoc;
    }

    public String FileDeleteDelayMsDoc() {
        return FileDeleteDelayMsDoc;
    }

    public String DeleteRetentionMsDoc() {
        return DeleteRetentionMsDoc;
    }

    public String MinCompactionLagMsDoc() {
        return MinCompactionLagMsDoc;
    }

    public String MaxCompactionLagMsDoc() {
        return MaxCompactionLagMsDoc;
    }

    public String MinCleanableRatioDoc() {
        return MinCleanableRatioDoc;
    }

    public String CompactDoc() {
        return CompactDoc;
    }

    public String UncleanLeaderElectionEnableDoc() {
        return UncleanLeaderElectionEnableDoc;
    }

    public String MinInSyncReplicasDoc() {
        return MinInSyncReplicasDoc;
    }

    public String CompressionTypeDoc() {
        return CompressionTypeDoc;
    }

    public String PreAllocateEnableDoc() {
        return PreAllocateEnableDoc;
    }

    public String MessageFormatVersionDoc() {
        return MessageFormatVersionDoc;
    }

    public String MessageTimestampTypeDoc() {
        return MessageTimestampTypeDoc;
    }

    public String MessageTimestampDifferenceMaxMsDoc() {
        return MessageTimestampDifferenceMaxMsDoc;
    }

    public String MessageDownConversionEnableDoc() {
        return MessageDownConversionEnableDoc;
    }

    public String LeaderReplicationThrottledReplicasDoc() {
        return LeaderReplicationThrottledReplicasDoc;
    }

    public String FollowerReplicationThrottledReplicasDoc() {
        return FollowerReplicationThrottledReplicasDoc;
    }

    public String ServerDefaultHeaderName() {
        return ServerDefaultHeaderName;
    }

    public LogConfig.LogConfigDef configDefCopy() {
        return new LogConfig.LogConfigDef(this.kafka$log$LogConfig$$configDef());
    }

    public LogConfig.LogConfigDef kafka$log$LogConfig$$configDef() {
        return kafka$log$LogConfig$$configDef;
    }

    public LogConfig apply() {
        return new LogConfig(new Properties(), this.apply$default$2());
    }

    public scala.collection.immutable.Set<String> apply$default$2() {
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        return Set.EmptySet$.MODULE$;
    }

    public Seq<String> configNames() {
        return (Seq)AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Set)this.kafka$log$LogConfig$$configDef().names()).asScala().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    public Option<String> serverConfigName(String configName) {
        return this.kafka$log$LogConfig$$configDef().serverConfigName(configName);
    }

    public Option<ConfigDef.Type> configType(String configName) {
        Option option = Option$.MODULE$.apply(this.kafka$log$LogConfig$$configDef().configKeys().get(configName));
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        if (map_this.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)((ConfigDef.ConfigKey)map_this.get()).type);
    }

    public LogConfig fromProps(java.util.Map<?, ?> defaults, Properties overrides) {
        Properties props = new Properties();
        defaults.forEach((k, v) -> props.put(k, v));
        new Implicits.PropertiesOps(props).$plus$plus$eq(overrides);
        scala.collection.immutable.Set overriddenKeys = ((IterableOnceOps)AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, overrides.keySet()).asScala().map((Function1 & Serializable)x$4 -> (String)x$4)).toSet();
        return new LogConfig(props, (scala.collection.immutable.Set<String>)overriddenKeys);
    }

    public void validateNames(Properties props) {
        Seq<String> names = this.configNames();
        AsScalaExtensions.PropertiesHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Properties)props).asScala().keys().foreach((Function1 & Serializable)name -> {
            LogConfig$.$anonfun$validateNames$1(names, name);
            return BoxedUnit.UNIT;
        });
    }

    public Map<String, ConfigDef.ConfigKey> configKeys() {
        return AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)this.kafka$log$LogConfig$$configDef().configKeys()).asScala();
    }

    public void validateValues(java.util.Map<?, ?> props) {
        long maxCompactionLag;
        long minCompactionLag = BoxesRunTime.unboxToLong(props.get(this.MinCompactionLagMsProp()));
        if (minCompactionLag > (maxCompactionLag = BoxesRunTime.unboxToLong(props.get(this.MaxCompactionLagMsProp())))) {
            throw new InvalidConfigurationException(new StringBuilder(39).append("conflict topic config setting ").append(this.MinCompactionLagMsProp()).append(" ").append("(").append(minCompactionLag).append(") > ").append(this.MaxCompactionLagMsProp()).append(" (").append(maxCompactionLag).append(")").toString());
        }
    }

    public void validate(Properties props) {
        this.validateNames(props);
        java.util.Map valueMaps = this.kafka$log$LogConfig$$configDef().parse(props);
        this.validateValues(valueMaps);
    }

    public Map<String, String> TopicConfigSynonyms() {
        return TopicConfigSynonyms;
    }

    public LogConfig apply(java.util.Map<?, ?> props, scala.collection.immutable.Set<String> overriddenConfigs) {
        return new LogConfig(props, overriddenConfigs);
    }

    public Option<Tuple2<java.util.Map<?, ?>, scala.collection.immutable.Set<String>>> unapply(LogConfig x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2(x$0.props(), x$0.overriddenConfigs()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LogConfig$.class);
    }

    public static final /* synthetic */ void $anonfun$validateNames$1(Seq names$1, String name) {
        if (!names$1.contains((Object)name)) {
            throw new InvalidConfigurationException(new StringBuilder(27).append("Unknown topic config name: ").append(name).toString());
        }
    }

    private LogConfig$() {
    }
}

