/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kafka.common.RequestAndCompletionHandler;
import kafka.common.UnsentRequests;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.convert.AsScalaExtensions;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0005\u0005-c!\u0002\f\u0018\u0003\u0003a\u0002\"C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u00132\u0011!\u0011\u0004A!A!\u0002\u0013\u0019\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \t\u0013\u0015\u0003!\u0011!Q\u0001\n\u0019S\u0005\"B&\u0001\t\u0003a\u0005\"B*\u0001\r\u0003!\u0006\"B1\u0001\r\u0003\u0011\u0007b\u00024\u0001\u0005\u0004%Ia\u001a\u0005\u0007W\u0002\u0001\u000b\u0011\u00025\t\u000b1\u0004A\u0011A7\t\u000b9\u0004A\u0011I8\t\u000bM\u0004A\u0011I8\t\u000bQ\u0004A\u0011B;\t\u000bm\u0004A\u0011\u0002?\t\u000by\u0004A\u0011B@\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006!1\u00111\u0005\u0001\u0005\u0002=<\u0011\"!\n\u0018\u0003\u0003E\t!a\n\u0007\u0011Y9\u0012\u0011!E\u0001\u0003SAaaS\n\u0005\u0002\u0005E\u0002\"CA\u001a'E\u0005I\u0011AA\u001b\u0005UIe\u000e^3s\u0005J|7.\u001a:TK:$G\u000b\u001b:fC\u0012T!\u0001G\r\u0002\r\r|W.\\8o\u0015\u0005Q\u0012!B6bM.\f7\u0001A\n\u0003\u0001u\u0001\"AH\u0011\u000e\u0003}Q!\u0001I\r\u0002\u000bU$\u0018\u000e\\:\n\u0005\tz\"AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012\fAA\\1nKB\u0011QE\f\b\u0003M1\u0002\"a\n\u0016\u000e\u0003!R!!K\u000e\u0002\rq\u0012xn\u001c;?\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0006\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055R\u0013BA\u0012\"\u00035qW\r^<pe.\u001cE.[3oiB\u0011A\u0007P\u0007\u0002k)\u0011agN\u0001\bG2LWM\u001c;t\u0015\tQ\u0002H\u0003\u0002:u\u00051\u0011\r]1dQ\u0016T\u0011aO\u0001\u0004_J<\u0017BA\u001f6\u00055qU\r^<pe.\u001cE.[3oi\u0006!A/[7f!\t\u00015)D\u0001B\u0015\t\u0001#I\u0003\u0002\u0019o%\u0011A)\u0011\u0002\u0005)&lW-A\bjg&sG/\u001a:skB$\u0018N\u00197f!\t9\u0005*D\u0001+\u0013\tI%FA\u0004C_>dW-\u00198\n\u0005\u0015\u000b\u0013A\u0002\u001fj]&$h\bF\u0003N\u001fB\u000b&\u000b\u0005\u0002O\u00015\tq\u0003C\u0003$\u000b\u0001\u0007A\u0005C\u00033\u000b\u0001\u00071\u0007C\u0003?\u000b\u0001\u0007q\bC\u0004F\u000bA\u0005\t\u0019\u0001$\u0002!\u001d,g.\u001a:bi\u0016\u0014V-];fgR\u001cH#A+\u0011\u0007Y[fL\u0004\u0002X3:\u0011q\u0005W\u0005\u0002W%\u0011!LK\u0001\ba\u0006\u001c7.Y4f\u0013\taVL\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\tQ&\u0006\u0005\u0002O?&\u0011\u0001m\u0006\u0002\u001c%\u0016\fX/Z:u\u0003:$7i\\7qY\u0016$\u0018n\u001c8IC:$G.\u001a:\u0002!I,\u0017/^3tiRKW.Z8vi6\u001bX#A2\u0011\u0005\u001d#\u0017BA3+\u0005\rIe\u000e^\u0001\u000fk:\u001cXM\u001c;SKF,Xm\u001d;t+\u0005A\u0007C\u0001(j\u0013\tQwC\u0001\bV]N,g\u000e\u001e*fcV,7\u000f^:\u0002\u001fUt7/\u001a8u%\u0016\fX/Z:ug\u0002\n\u0011\u0003[1t+:\u001cXM\u001c;SKF,Xm\u001d;t+\u00051\u0015\u0001C:ikR$wn\u001e8\u0015\u0003A\u0004\"aR9\n\u0005IT#\u0001B+oSR\fa\u0001Z8X_J\\\u0017\u0001D:f]\u0012\u0014V-];fgR\u001cHC\u0001<z!\t9u/\u0003\u0002yU\t!Aj\u001c8h\u0011\u0015QX\u00021\u0001w\u0003\rqwn^\u0001\u0011G\",7m\u001b#jg\u000e|gN\\3diN$\"\u0001]?\t\u000bit\u0001\u0019\u0001<\u0002'\u0019\f\u0017\u000e\\#ya&\u0014X\r\u001a*fcV,7\u000f^:\u0015\u0007A\f\t\u0001C\u0003{\u001f\u0001\u0007a/\u0001\fd_6\u0004H.\u001a;f/&$\b\u000eR5tG>tg.Z2u)\u001d\u0001\u0018qAA\t\u0003'Aq!!\u0003\u0011\u0001\u0004\tY!A\u0004sKF,Xm\u001d;\u0011\u0007Q\ni!C\u0002\u0002\u0010U\u0012Qb\u00117jK:$(+Z9vKN$\b\"\u0002>\u0011\u0001\u00041\bbBA\u000b!\u0001\u0007\u0011qC\u0001\u0018CV$\b.\u001a8uS\u000e\fG/[8o\u000bb\u001cW\r\u001d;j_:\u0004B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;\u0011\u0015AB3se>\u00148/\u0003\u0003\u0002\"\u0005m!aF!vi\",g\u000e^5dCRLwN\\#yG\u0016\u0004H/[8o\u0003\u00199\u0018m[3va\u0006)\u0012J\u001c;fe\n\u0013xn[3s'\u0016tG\r\u00165sK\u0006$\u0007C\u0001(\u0014'\r\u0019\u00121\u0006\t\u0004\u000f\u00065\u0012bAA\u0018U\t1\u0011I\\=SK\u001a$\"!a\n\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\t9DK\u0002G\u0003sY#!a\u000f\u0011\t\u0005u\u0012qI\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000bR\u0013AC1o]>$\u0018\r^5p]&!\u0011\u0011JA \u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public abstract class InterBrokerSendThread
extends ShutdownableThread {
    private final NetworkClient networkClient;
    private final Time time;
    private final UnsentRequests unsentRequests;

    public static boolean $lessinit$greater$default$4() {
        return true;
    }

    public abstract Iterable<RequestAndCompletionHandler> generateRequests();

    public abstract int requestTimeoutMs();

    private UnsentRequests unsentRequests() {
        return this.unsentRequests;
    }

    public boolean hasUnsentRequests() {
        return this.unsentRequests().iterator().hasNext();
    }

    @Override
    public void shutdown() {
        this.initiateShutdown();
        this.networkClient.wakeup();
        this.awaitShutdown();
    }

    @Override
    public void doWork() {
        long create_e = this.time.milliseconds();
        LongRef now = new LongRef(create_e);
        this.generateRequests().foreach((Function1 & Serializable)request -> {
            InterBrokerSendThread.$anonfun$doWork$1(this, now, request);
            return BoxedUnit.UNIT;
        });
        try {
            long timeout = this.sendRequests(now.elem);
            this.networkClient.poll(timeout, now.elem);
            now.elem = this.time.milliseconds();
            this.checkDisconnects(now.elem);
            this.failExpiredRequests(now.elem);
            this.unsentRequests().clean();
            return;
        }
        catch (FatalExitError fatalExitError) {
            throw fatalExitError;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "unhandled exception caught in InterBrokerSendThread", (Function0<Throwable>)(Function0 & Serializable)() -> t);
            throw new FatalExitError();
        }
    }

    private long sendRequests(long now) {
        long create_e = Long.MAX_VALUE;
        LongRef pollTimeout = new LongRef(create_e);
        AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, this.unsentRequests().nodes()).asScala().foreach((Function1 & Serializable)node -> {
            InterBrokerSendThread.$anonfun$sendRequests$1(this, now, pollTimeout, node);
            return BoxedUnit.UNIT;
        });
        return pollTimeout.elem;
    }

    /*
     * WARNING - void declaration
     */
    private void checkDisconnects(long now) {
        Iterator<Map.Entry<Node, ArrayDeque<ClientRequest>>> iterator = this.unsentRequests().iterator();
        while (iterator.hasNext()) {
            void var5_4;
            void var6_5;
            Map.Entry<Node, ArrayDeque<ClientRequest>> entry = iterator.next();
            ArrayDeque<ClientRequest> arrayDeque = entry.getValue();
            Node node = entry.getKey();
            ArrayDeque<ClientRequest> requests = arrayDeque;
            if (var6_5.isEmpty() || !this.networkClient.connectionFailed((Node)var5_4)) continue;
            iterator.remove();
            AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Collection)var6_5).asScala().foreach(arg_0 -> InterBrokerSendThread.$anonfun$checkDisconnects$1$adapted(this, (Node)var5_4, now, arg_0));
        }
    }

    private void failExpiredRequests(long now) {
        Collection<ClientRequest> timedOutRequests = this.unsentRequests().removeAllTimedOut(now);
        AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, timedOutRequests).asScala().foreach((Function1 & Serializable)request -> {
            InterBrokerSendThread.$anonfun$failExpiredRequests$1(this, now, request);
            return BoxedUnit.UNIT;
        });
    }

    public void completeWithDisconnect(ClientRequest request, long now, AuthenticationException authenticationException) {
        RequestCompletionHandler handler = request.callback();
        handler.onComplete(new ClientResponse(request.makeHeader(request.requestBuilder().latestAllowedVersion()), handler, request.destination(), now, now, true, null, authenticationException, null));
    }

    public void wakeup() {
        this.networkClient.wakeup();
    }

    public static final /* synthetic */ void $anonfun$doWork$1(InterBrokerSendThread $this, LongRef now$1, RequestAndCompletionHandler request) {
        RequestCompletionHandler completionHandler = request.handler();
        $this.unsentRequests().put(request.destination(), $this.networkClient.newClientRequest(request.destination().idString(), request.request(), now$1.elem, true, $this.requestTimeoutMs(), completionHandler));
    }

    public static final /* synthetic */ void $anonfun$sendRequests$1(InterBrokerSendThread $this, long now$2, LongRef pollTimeout$1, Node node) {
        Iterator<ClientRequest> requestIterator = $this.unsentRequests().requestIterator(node);
        while (requestIterator.hasNext()) {
            ClientRequest request = requestIterator.next();
            if ($this.networkClient.ready(node, now$2)) {
                $this.networkClient.send(request, now$2);
                requestIterator.remove();
                continue;
            }
            pollTimeout$1.elem = Math.min(pollTimeout$1.elem, $this.networkClient.connectionDelay(node, now$2));
        }
    }

    public static final /* synthetic */ void $anonfun$checkDisconnects$1(InterBrokerSendThread $this, Node node$1, long now$3, ClientRequest request) {
        AuthenticationException authenticationException = $this.networkClient.authenticationException(node$1);
        if (authenticationException != null) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("Failed to send the following request due to authentication error: ").append(request).toString());
        }
        $this.completeWithDisconnect(request, now$3, authenticationException);
    }

    public static final /* synthetic */ void $anonfun$failExpiredRequests$1(InterBrokerSendThread $this, long now$4, ClientRequest request) {
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Failed to send the following request after ").append(request.requestTimeoutMs()).append(" ms: ").append(request).toString());
        $this.completeWithDisconnect(request, now$4, null);
    }

    public InterBrokerSendThread(String name, NetworkClient networkClient, Time time, boolean isInterruptible) {
        this.networkClient = networkClient;
        this.time = time;
        super(name, isInterruptible);
        this.unsentRequests = new UnsentRequests();
    }

    public static final /* synthetic */ Object $anonfun$checkDisconnects$1$adapted(InterBrokerSendThread $this, Node node$1, long now$3, ClientRequest request) {
        InterBrokerSendThread.$anonfun$checkDisconnects$1($this, node$1, now$3, request);
        return BoxedUnit.UNIT;
    }
}

