/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import java.io.Serializable;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.checkpoints.LeaderEpochCheckpointFile;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.None$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.LinearSeqOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005ud\u0001\u0002\u00192\u0001aBQa\u0010\u0001\u0005\u0002\u0001Cqa\u0011\u0001C\u0002\u0013\u0005A\t\u0003\u0004Q\u0001\u0001\u0006I!\u0012\u0005\b#\u0002\u0001\r\u0011\"\u0003S\u0011\u001d1\u0006\u00011A\u0005\n]Ca!\u0018\u0001!B\u0013\u0019\u0006b\u00020\u0001\u0005\u0004%Ia\u0018\u0005\u0007M\u0002\u0001\u000b\u0011\u00021\t\u000f\u001d\u0004!\u0019!C\u0005Q\"1A\u000e\u0001Q\u0001\n%DQ!\u001c\u0001\u0005\u00029DQA\u001e\u0001\u0005\u00029DQ\u0001\u001f\u0001\u0005\u00029DQA\u001f\u0001\u0005\u00029DQ\u0001 \u0001\u0005\u00029DQA \u0001\u0005\u00029Da!!\u0001\u0001\t\u0003q\u0007BBA\u0003\u0001\u0011\u0005a\u000e\u0003\u0004\u0002\n\u0001!\tA\u001c\u0005\u0007\u0003\u001b\u0001A\u0011\u00018\t\r\u0005E\u0001\u0001\"\u0001o\u0011\u0019\t)\u0002\u0001C\u0001]\"1\u0011\u0011\u0004\u0001\u0005\u00029Da!!\b\u0001\t\u0003q\u0007BBA\u0011\u0001\u0011\u0005a\u000e\u0003\u0004\u0002&\u0001!\tA\u001c\u0005\u0007\u0003S\u0001A\u0011\u00018\t\r\u00055\u0002\u0001\"\u0001o\u0011\u0019\t\t\u0004\u0001C\u0001]\"1\u0011Q\u0007\u0001\u0005\u00029Da!!\u000f\u0001\t\u0003q\u0007BBA\u001f\u0001\u0011\u0005a\u000e\u0003\u0004\u0002B\u0001!\tA\u001c\u0005\u0007\u0003\u000b\u0002A\u0011\u00018\t\r\u0005%\u0003\u0001\"\u0001o\u0011\u0019\ti\u0005\u0001C\u0001]\"1\u0011\u0011\u000b\u0001\u0005\u00029Da!!\u0016\u0001\t\u0003q\u0007BBA-\u0001\u0011\u0005a\u000e\u0003\u0004\u0002^\u0001!\tA\u001c\u0005\u0007\u0003C\u0002A\u0011\u00018\t\r\u0005\u0015\u0004\u0001\"\u0001o\u0011\u0019\tI\u0007\u0001C\u0001]\"1\u0011Q\u000e\u0001\u0005\u00029Da!!\u001d\u0001\t\u0003q\u0007BBA;\u0001\u0011\u0005a\u000e\u0003\u0004\u0002z\u0001!\tA\u001c\u0002\u0019\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NR5mK\u000e\u000b7\r[3UKN$(B\u0001\u001a4\u0003\u0015)\u0007o\\2i\u0015\t!T'\u0001\u0004tKJ4XM\u001d\u0006\u0002m\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001:!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0011\t\u0003\u0005\u0002i\u0011!M\u0001\u0003iB,\u0012!\u0012\t\u0003\r:k\u0011a\u0012\u0006\u0003\u0011&\u000baaY8n[>t'B\u0001\u001cK\u0015\tYE*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0006\u0019qN]4\n\u0005=;%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0004iB\u0004\u0013\u0001\u00047pO\u0016sGm\u00144gg\u0016$X#A*\u0011\u0005i\"\u0016BA+<\u0005\u0011auN\\4\u0002!1|w-\u00128e\u001f\u001a47/\u001a;`I\u0015\fHC\u0001-\\!\tQ\u0014,\u0003\u0002[w\t!QK\\5u\u0011\u001daV!!AA\u0002M\u000b1\u0001\u001f\u00132\u00035awnZ#oI>3gm]3uA\u0005Q1\r[3dWB|\u0017N\u001c;\u0016\u0003\u0001\u0004\"!\u00193\u000e\u0003\tT!aY\u001a\u0002\u0017\rDWmY6q_&tGo]\u0005\u0003K\n\u0014Q\u0003T3bI\u0016\u0014X\t]8dQ\u000eCWmY6q_&tG/A\u0006dQ\u0016\u001c7\u000e]8j]R\u0004\u0013!B2bG\",W#A5\u0011\u0005\tS\u0017BA62\u0005QaU-\u00193fe\u0016\u0003xn\u00195GS2,7)Y2iK\u000611-Y2iK\u0002\nQe\u001d5pk2$\u0017\t\u001a3Fa>\u001c\u0007.\u00118e\u001b\u0016\u001c8/Y4f\u001f\u001a47/\u001a;U_\u000e\u000b7\r[3\u0015\u0003aC#a\u00039\u0011\u0005E$X\"\u0001:\u000b\u0005Md\u0015!\u00026v]&$\u0018BA;s\u0005\u0011!Vm\u001d;\u0002]MDw.\u001e7e%\u0016$XO\u001d8M_\u001e,e\u000eZ(gMN,G/\u00134MCR,7\u000f^#q_\u000eD'+Z9vKN$X\r\u001a\u0015\u0003\u0019A\fAg\u001d5pk2$'+\u001a;ve:,f\u000eZ3gS:,Gm\u00144gg\u0016$\u0018JZ+oI\u00164\u0017N\\3e\u000bB|7\r\u001b*fcV,7\u000f^3eQ\ti\u0001/\u0001\"tQ>,H\u000e\u001a(pi>3XM]<sSR,Gj\\4F]\u0012|eMZ:fi\u001a{'/\u0011'fC\u0012,'/\u00129pG\"|enY3Ji\"\u000b7OQ3f]\u0006\u001b8/[4oK\u0012D#A\u00049\u0002aMDw.\u001e7e\u000b:4wN]2f\u001b>tw\u000e^8oS\u000e\fG\u000e\\=J]\u000e\u0014X-Y:j]\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;tQ\ty\u0001/\u0001\u001ftQ>,H\u000e\u001a(pi>3XM]<sSR,wJ\u001a4tKR4uN]!MK\u0006$WM]#q_\u000eDwJ\\2f\u0013RD\u0015m\u001d\"fK:\f5o]5h]\u0016$\u0007F\u0001\tq\u0003!\u001a\bn\\;mIJ+G/\u001e:o+:\u001cX\u000f\u001d9peR,G-\u00134O_\u0016\u0003xn\u00195SK\u000e|'\u000fZ3eQ\t\t\u0002/\u0001\"tQ>,H\u000e\u001a*fiV\u0014h.\u00168tkB\u0004xN\u001d;fI&3gj\\#q_\u000eD'+Z2pe\u0012,G-\u00118e+:$WMZ5oK\u0012,\u0005o\\2i%\u0016\fX/Z:uK\u0012D#A\u00059\u0002qMDw.\u001e7e%\u0016$XO\u001d8GSJ\u001cH/\u00129pG\"LeMU3rk\u0016\u001cH/\u001a3Fa>\u001c\u0007\u000eT3tgRC\u0017M\u001c$jeN$X\t]8dQ\"\u00121\u0003]\u00016g\"|W\u000f\u001c3UeVt7-\u0019;f\u0013\u001al\u0015\r^2iS:<W\t]8dQ\n+H/R1sY&,'o\u0015;beRLgnZ(gMN,G\u000f\u000b\u0002\u0015a\u0006A5\u000f[8vY\u0012<U\r\u001e$jeN$xJ\u001a4tKR|emU;cg\u0016\fX/\u001a8u\u000bB|7\r[,iK:|eMZ:fiJ+\u0017/^3ti\u0016$gi\u001c:Qe\u00164\u0018n\\;t\u000bB|7\r\u001b\u0015\u0003+A\fQi\u001d5pk2$'+\u001a;ve:tU\r\u001f;Bm\u0006LG.\u00192mK\u0016\u0003xn\u00195JMRCWM]3Jg:{W\t_1di\u0016\u0003xn\u00195G_J$\u0006.Z(oKJ+\u0017/^3ti\u0016$\u0007F\u0001\fq\u0003I\u001a\bn\\;mI:{G/\u00169eCR,W\t]8dQ\u0006sGm\u0015;beR|eMZ:fi&3\u0017\n\u001e#jI:{Go\u00115b]\u001e,\u0007FA\fq\u0003\u0015\u001b\bn\\;mIJ+G/\u001e:o\u0013:4\u0018\r\\5e\u001f\u001a47/\u001a;JM\u0016\u0003xn\u00195JgJ+\u0017/^3ti\u0016$w\u000b[5dQ&\u001bhj\u001c;DkJ\u0014XM\u001c;msR\u0013\u0018mY6fI\"\u0012\u0001\u0004]\u0001*g\"|W\u000f\u001c3TkB\u0004xN\u001d;Fa>\u001c\u0007n\u001d+iCR$uNT8u'R\f'\u000f\u001e$s_6TVM]8)\u0005e\u0001\u0018aI:i_VdG\rU3sg&\u001cH/\u00129pG\"\u001c()\u001a;xK\u0016t\u0017J\\:uC:\u001cWm\u001d\u0015\u00035A\f!f\u001d5pk2$WI\u001c4pe\u000e,Wj\u001c8pi>t\u0017nY1mYfLen\u0019:fCNLgnZ#q_\u000eD7\u000f\u000b\u0002\u001ca\u0006I3\u000f[8vY\u0012,eNZ8sG\u0016|eMZ:fiNLen\u0019:fCN,Wj\u001c8pi>t\u0017nY1mYfD#\u0001\b9\u0002iMDw.\u001e7e\u0013:\u001c'/Z1tK\u0006sG\r\u0016:bG.,\u0005o\\2ig\u0006\u001bH*Z1eKJ\u001c8\t[1oO\u0016l\u0015M\\=US6,7\u000f\u000b\u0002\u001ea\u0006Q4\u000f[8vY\u0012Len\u0019:fCN,\u0017I\u001c3Ue\u0006\u001c7.\u00129pG\"\u001c\u0018i\u001d$pY2|w/\u001a:SK\u000e,\u0017N^3t\u001b\u0006t\u00170T3tg\u0006<Wm\u001d\u0015\u0003=A\f\u0011h\u001d5pk2$GI]8q\u000b:$(/[3t\u001f:,\u0005o\\2i\u0005>,h\u000eZ1ss^CWM\u001c*f[>4\u0018N\\4MCR,7\u000f^#oiJLWm\u001d\u0015\u0003?A\f1g\u001d5pk2$\u0007K]3tKJ4XMU3tKR|eMZ:fi>s7\t\\3be\u0016\u000b'\u000f\\5fgRLem\u00148f\u000bbL7\u000f^:)\u0005\u0001\u0002\u0018!O:i_VdG-\u00169eCR,7+\u0019<fI>3gm]3u/\",gn\u00144gg\u0016$Hk\\\"mK\u0006\u0014Hk\\%t\u0005\u0016$x/Z3o\u000bB|7\r[:)\u0005\u0005\u0002\u0018!J:i_VdGMT8u\u00072,\u0017M]!osRD\u0017N\\4JM>3gm]3u)>,\u0015M\u001d7zQ\t\u0011\u0003/A\u0016tQ>,H\u000e\u001a(pi\u000ecW-\u0019:B]f$\b.\u001b8h\u0013\u001a|eMZ:fiR{g)\u001b:ti>3gm]3uQ\t\u0019\u0003/A\u0015tQ>,H\u000e\u001a*fi\u0006Lg\u000eT1uKN$X\t]8dQ>s7\t\\3be\u0006cG.R1sY&,7\u000f\u001e\u0015\u0003IA\fqg\u001d5pk2$W\u000b\u001d3bi\u0016|eMZ:fi\n+Go^3f]\u0016\u0003xn\u00195C_VtG-\u0019:jKN|en\u00117fCJ,\u0015M\u001d7jKN$\bFA\u0013q\u0003a\u001a\bn\\;mIV\u0003H-\u0019;f\u001f\u001a47/\u001a;CKR<X-\u001a8Fa>\u001c\u0007NQ8v]\u0012\f'/[3t\u001f:\u001cE.Z1s\u000b\u0006\u0014H.[3tiJB#A\n9\u0002wMDw.\u001e7e%\u0016$\u0018-\u001b8MCR,7\u000f^#q_\u000eDwJ\\\"mK\u0006\u0014\u0018\t\u001c7FCJd\u0017.Z:u\u0003:$W\u000b\u001d3bi\u0016LEo](gMN,G\u000f\u000b\u0002(a\u000694\u000f[8vY\u0012$%o\u001c9F]R\u0014\u0018.Z:CKR<X-\u001a8Fa>\u001c\u0007NQ8v]\u0012\f'/_,iK:\u0014V-\\8wS:<g*Z<fgRD#\u0001\u000b9\u0002+MDw.\u001e7e\u00072,\u0017M]!mY\u0016sGO]5fg\"\u0012\u0011\u0006]\u00010g\"|W\u000f\u001c3O_R\u0014Vm]3u\u000bB|7\r\u001b%jgR|'/\u001f%fC\u0012Le-\u00168eK\u001aLg.\u001a3QCN\u001cX\r\u001a\u0015\u0003UA\fqf\u001d5pk2$gj\u001c;SKN,G/\u00129pG\"D\u0015n\u001d;pef$\u0016-\u001b7JMVsG-\u001a4j]\u0016$\u0007+Y:tK\u0012D#a\u000b9\u0002EMDw.\u001e7e\r\u0016$8\r\u001b'bi\u0016\u001cH/\u00129pG\"|e-R7qif\u001c\u0015m\u00195fQ\ta\u0003/\u0001\u0011tQ>,H\u000e\u001a$fi\u000eDWI\u001c3PM\u001a\u001cX\r^(g\u000b6\u0004H/_\"bG\",\u0007FA\u0017q\u0003}\u0019\bn\\;mI\u000ecW-\u0019:FCJd\u0017.Z:u\u001f:,U\u000e\u001d;z\u0007\u0006\u001c\u0007.\u001a\u0015\u0003]A\fQd\u001d5pk2$7\t\\3be2\u000bG/Z:u\u001f:,U\u000e\u001d;z\u0007\u0006\u001c\u0007.\u001a\u0015\u0003_A\u0004")
public class LeaderEpochFileCacheTest {
    private final TopicPartition tp = new TopicPartition("TestTopic", 5);
    private long logEndOffset = 0L;
    private final LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
        private Seq<EpochEntry> epochs;

        private Seq<EpochEntry> epochs() {
            return this.epochs;
        }

        private void epochs_$eq(Seq<EpochEntry> x$1) {
            this.epochs = x$1;
        }

        public void write(Seq<EpochEntry> epochs) {
            this.epochs_$eq(epochs);
        }

        public Seq<EpochEntry> read() {
            return this.epochs();
        }
        {
            this.epochs = Nil$.MODULE$;
        }
    };
    private final LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> this.logEndOffset(), this.checkpoint());

    public TopicPartition tp() {
        return this.tp;
    }

    private long logEndOffset() {
        return this.logEndOffset;
    }

    private void logEndOffset_$eq(long x$1) {
        this.logEndOffset = x$1;
    }

    private LeaderEpochCheckpoint checkpoint() {
        return this.checkpoint;
    }

    private LeaderEpochFileCache cache() {
        return this.cache;
    }

    @Test
    public void shouldAddEpochAndMessageOffsetToCache() {
        this.cache().assign(2, 10L);
        this.logEndOffset_$eq(11L);
        Assert.assertEquals((Object)new Some((Object)2), (Object)this.cache().latestEpoch());
        Assert.assertEquals((Object)new EpochEntry(2, 10L), (Object)this.cache().epochEntries().apply(0));
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(2, this.logEndOffset()), (Object)this.cache().endOffsetFor(2));
    }

    @Test
    public void shouldReturnLogEndOffsetIfLatestEpochRequested() {
        this.cache().assign(2, 11L);
        this.cache().assign(2, 12L);
        this.logEndOffset_$eq(14L);
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(2, this.logEndOffset()), (Object)this.cache().endOffsetFor(2));
    }

    @Test
    public void shouldReturnUndefinedOffsetIfUndefinedEpochRequested() {
        Tuple2.mcIJ.sp expectedEpochEndOffset = new Tuple2.mcIJ.sp(-1, -1L);
        this.cache().assign(2, 11L);
        this.cache().assign(3, 12L);
        Tuple2 epochAndOffsetFor = this.cache().endOffsetFor(-1);
        Assert.assertEquals((String)"Expected undefined epoch and offset if undefined epoch requested. Cache not empty.", (Object)expectedEpochEndOffset, (Object)epochAndOffsetFor);
    }

    @Test
    public void shouldNotOverwriteLogEndOffsetForALeaderEpochOnceItHasBeenAssigned() {
        this.logEndOffset_$eq(9L);
        this.cache().assign(2, this.logEndOffset());
        this.cache().assign(2, 10L);
        Assert.assertEquals((long)this.logEndOffset(), (long)((EpochEntry)this.cache().epochEntries().apply(0)).startOffset());
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 9L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingStartOffsets() {
        this.cache().assign(2, 9L);
        this.cache().assign(3, 9L);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotOverwriteOffsetForALeaderEpochOnceItHasBeenAssigned() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 10L);
        Assert.assertEquals((long)6L, (long)((EpochEntry)this.cache().epochEntries().apply(0)).startOffset());
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecorded() {
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(0));
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecordedAndUndefinedEpochRequested() {
        this.logEndOffset_$eq(73L);
        Tuple2 offsetFor = this.cache().endOffsetFor(-1);
        Assert.assertEquals((String)"Expected undefined epoch and offset if undefined epoch requested. Empty cache.", (Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)offsetFor);
    }

    @Test
    public void shouldReturnFirstEpochIfRequestedEpochLessThanFirstEpoch() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        Tuple2 epochAndOffset = this.cache().endOffsetFor(4);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(4, 11), (Object)epochAndOffset);
    }

    @Test
    public void shouldTruncateIfMatchingEpochButEarlierStartingOffset() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        this.cache().assign(7, 12L);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(5, 12), (Object)this.cache().endOffsetFor(5));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(5, 12), (Object)this.cache().endOffsetFor(6));
    }

    @Test
    public void shouldGetFirstOffsetOfSubsequentEpochWhenOffsetRequestedForPreviousEpoch() {
        this.cache().assign(1, 11L);
        this.cache().assign(1, 12L);
        this.cache().assign(2, 13L);
        this.cache().assign(2, 14L);
        this.cache().assign(3, 15L);
        this.cache().assign(3, 16L);
        this.logEndOffset_$eq(17L);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(2, 15), (Object)this.cache().endOffsetFor(2));
    }

    @Test
    public void shouldReturnNextAvailableEpochIfThereIsNoExactEpochForTheOneRequested() {
        this.cache().assign(0, 10L);
        this.cache().assign(2, 13L);
        this.cache().assign(4, 17L);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(0, 13), (Object)this.cache().endOffsetFor(1));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(2, 17), (Object)this.cache().endOffsetFor(2));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(2, 17), (Object)this.cache().endOffsetFor(3));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldNotUpdateEpochAndStartOffsetIfItDidNotChange() {
        void apply_n;
        this.cache().assign(2, 6L);
        this.cache().assign(2, 7L);
        Seq seq = this.cache().epochEntries();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)seq.length());
        List list = this.cache().epochEntries().toList();
        boolean bl = false;
        if (list == null) {
            throw null;
        }
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)LinearSeqOps.apply$((LinearSeqOps)list, (int)apply_n));
    }

    @Test
    public void shouldReturnInvalidOffsetIfEpochIsRequestedWhichIsNotCurrentlyTracked() {
        this.logEndOffset_$eq(100L);
        this.cache().assign(2, 100L);
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(3));
    }

    @Test
    public void shouldSupportEpochsThatDoNotStartFromZero() {
        this.cache().assign(2, 6L);
        this.logEndOffset_$eq(7L);
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(2, this.logEndOffset()), (Object)this.cache().endOffsetFor(2));
        Seq seq = this.cache().epochEntries();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)seq.length());
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)this.cache().epochEntries().apply(0));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldPersistEpochsBetweenInstances() {
        void apply_n;
        String checkpointPath = TestUtils.tempFile().getAbsolutePath();
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(new File(checkpointPath), null);
        new LeaderEpochFileCache(this.tp(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> this.logEndOffset(), (LeaderEpochCheckpoint)checkpoint).assign(2, 6L);
        LeaderEpochCheckpointFile checkpoint2 = new LeaderEpochCheckpointFile(new File(checkpointPath), null);
        LeaderEpochFileCache cache2 = new LeaderEpochFileCache(this.tp(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> this.logEndOffset(), (LeaderEpochCheckpoint)checkpoint2);
        Seq seq = cache2.epochEntries();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)seq.length());
        List list = cache2.epochEntries().toList();
        boolean bl = false;
        if (list == null) {
            throw null;
        }
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)LinearSeqOps.apply$((LinearSeqOps)list, (int)apply_n));
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingEpochs() {
        this.cache().assign(1, 5L);
        this.logEndOffset_$eq(6L);
        this.cache().assign(2, 6L);
        this.logEndOffset_$eq(7L);
        this.cache().assign(1, 7L);
        this.logEndOffset_$eq(8L);
        Assert.assertEquals((Object)new Some((Object)1), (Object)this.cache().latestEpoch());
        Assert.assertEquals((Object)new Tuple2.mcII.sp(1, 8), (Object)this.cache().endOffsetFor(1));
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(2));
        Assert.assertEquals((Object)new EpochEntry(1, 7L), (Object)this.cache().epochEntries().apply(0));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldEnforceOffsetsIncreaseMonotonically() {
        void apply_n;
        this.cache().assign(2, 6L);
        this.cache().assign(3, 5L);
        List list = this.cache().epochEntries().toList();
        boolean bl = false;
        if (list == null) {
            throw null;
        }
        Assert.assertEquals((Object)new EpochEntry(3, 5L), (Object)LinearSeqOps.apply$((LinearSeqOps)list, (int)apply_n));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsLeadersChangeManyTimes() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 0L);
        Assert.assertEquals((Object)new Some((Object)1), (Object)this.cache().latestEpoch());
        Assert.assertEquals((Object)new Tuple2.mcII.sp(1, 0), (Object)this.cache().endOffsetFor(1));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0));
        this.logEndOffset_$eq(5L);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(1, 5), (Object)this.cache().endOffsetFor(1));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0));
        this.cache().assign(2, 5L);
        this.logEndOffset_$eq(10L);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(2, 10), (Object)this.cache().endOffsetFor(2));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(1, 5), (Object)this.cache().endOffsetFor(1));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsFollowerReceivesManyMessages() {
        this.cache().assign(0, 0L);
        this.logEndOffset_$eq(1L);
        this.cache().assign(0, 1L);
        this.logEndOffset_$eq(2L);
        this.cache().assign(0, 2L);
        this.logEndOffset_$eq(3L);
        Assert.assertEquals((Object)new Some((Object)0), (Object)this.cache().latestEpoch());
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(0, this.logEndOffset()), (Object)this.cache().endOffsetFor(0));
        this.cache().assign(1, 3L);
        this.logEndOffset_$eq(4L);
        this.cache().assign(1, 4L);
        this.logEndOffset_$eq(5L);
        this.cache().assign(1, 5L);
        this.logEndOffset_$eq(6L);
        Assert.assertEquals((Object)new Some((Object)1), (Object)this.cache().latestEpoch());
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(1, this.logEndOffset()), (Object)this.cache().endOffsetFor(1));
        this.cache().assign(2, 6L);
        this.logEndOffset_$eq(7L);
        this.cache().assign(2, 7L);
        this.logEndOffset_$eq(8L);
        this.cache().assign(2, 8L);
        this.logEndOffset_$eq(9L);
        Assert.assertEquals((Object)new Some((Object)2), (Object)this.cache().latestEpoch());
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(2, this.logEndOffset()), (Object)this.cache().endOffsetFor(2));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(0, 3), (Object)this.cache().endOffsetFor(0));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(1, 6), (Object)this.cache().endOffsetFor(1));
    }

    @Test
    public void shouldDropEntriesOnEpochBoundaryWhenRemovingLatestEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(8L);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldPreserveResetOffsetOnClearEarliestIfOneExists() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(8L);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateSavedOffsetWhenOffsetToClearToIsBetweenEpochs() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToEarly() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(1L);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToFirstOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(6L);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(11L);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest2() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 7L);
        this.cache().assign(2, 10L);
        this.cache().truncateFromStart(5L);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 5L), new EpochEntry(1, 7L), new EpochEntry(2, 10L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliestAndUpdateItsOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(15L);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 15L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldDropEntriesBetweenEpochBoundaryWhenRemovingNewest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(9L);
        Assert.assertEquals((Object)new Some((Object)3), (Object)this.cache().latestEpoch());
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)ListBuffer$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldClearAllEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().clearAndFlush();
        Seq seq = this.cache().epochEntries();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)0L, (long)seq.length());
    }

    @Test
    public void shouldNotResetEpochHistoryHeadIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(-1L);
        Seq seq = this.cache().epochEntries();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)3L, (long)seq.length());
    }

    @Test
    public void shouldNotResetEpochHistoryTailIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(-1L);
        Seq seq = this.cache().epochEntries();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)3L, (long)seq.length());
    }

    @Test
    public void shouldFetchLatestEpochOfEmptyCache() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.cache().latestEpoch());
    }

    @Test
    public void shouldFetchEndOffsetOfEmptyCache() {
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(7));
    }

    @Test
    public void shouldClearEarliestOnEmptyCache() {
        this.cache().truncateFromStart(7L);
    }

    @Test
    public void shouldClearLatestOnEmptyCache() {
        this.cache().truncateFromEnd(7L);
    }
}

