/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.Constants$;
import kafka.server.DynamicConfig;
import kafka.server.DynamicConfigManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.TopicConfigHandler;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005%a\u0001\u0002\u000b\u0016\u0001iAQ!\t\u0001\u0005\u0002\tBQ!\n\u0001\u0005\u0002\u0019BQ\u0001\u000e\u0001\u0005\u0002UBQa\u0011\u0001\u0005\u0002UBQ!\u0012\u0001\u0005\n\u0019CQA\u0017\u0001\u0005\u0002UBQ\u0001\u0018\u0001\u0005\u0002UBQA\u0018\u0001\u0005\u0002UBQ\u0001\u0019\u0001\u0005\u0002UBQA\u0019\u0001\u0005\u0002UBQ\u0001\u001a\u0001\u0005\u0002UBQA\u001a\u0001\u0005\u0002UBQ\u0001\u001b\u0001\u0005\u0002UBQA\u001b\u0001\u0005\u0002UBQ\u0001\u001c\u0001\u0005\u0002UBQA\u001c\u0001\u0005\u0002UBQ\u0001\u001d\u0001\u0005\u0002UBQA\u001d\u0001\u0005\u0002UBQ\u0001\u001e\u0001\u0005\u0002U\u0014q\u0003R=oC6L7mQ8oM&<7\t[1oO\u0016$Vm\u001d;\u000b\u0005Y9\u0012AB:feZ,'OC\u0001\u0019\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0005y9\u0012aC5oi\u0016<'/\u0019;j_:L!\u0001I\u000f\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A\u0012\u0011\u0005\u0011\u0002Q\"A\u000b\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012a\n\t\u0004Q=\nT\"A\u0015\u000b\u0005)Z\u0013!C5n[V$\u0018M\u00197f\u0015\taS&\u0001\u0006d_2dWm\u0019;j_:T\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a%\u0012A\u0001T5tiB\u0011AEM\u0005\u0003gU\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006\u0001B/Z:u\u0007>tg-[4DQ\u0006tw-\u001a\u000b\u0002mA\u0011q\u0007O\u0007\u0002[%\u0011\u0011(\f\u0002\u0005+:LG\u000f\u000b\u0002\u0004wA\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0001\u0006\u0019qN]4\n\u0005\tk$\u0001\u0002+fgR\fA\u0004^3ti\u0012Kh.Y7jGR{\u0007/[2D_:4\u0017nZ\"iC:<W\r\u000b\u0002\u0005w\u0005)B/Z:u#V|G/Y\"p]\u001aLwm\u00115b]\u001e,G#\u0002\u001cH)ZC\u0006\"\u0002%\u0006\u0001\u0004I\u0015\u0001B;tKJ\u0004\"AS)\u000f\u0005-{\u0005C\u0001'.\u001b\u0005i%B\u0001(\u001a\u0003\u0019a$o\\8u}%\u0011\u0001+L\u0001\u0007!J,G-\u001a4\n\u0005I\u001b&AB*ue&twM\u0003\u0002Q[!)Q+\u0002a\u0001\u0013\u0006A1\r\\5f]RLE\rC\u0003X\u000b\u0001\u0007\u0011*\u0001\bs_>$XI\u001c;jif$\u0016\u0010]3\t\u000be+\u0001\u0019A%\u0002!\r|gNZ5h\u000b:$\u0018\u000e^=OC6,\u0017!\b;fgR\u001cE.[3oi&#\u0017+^8uC\u000e{gNZ5h\u0007\"\fgnZ3)\u0005\u0019Y\u0014!\u0007;fgR,6/\u001a:Rk>$\u0018mQ8oM&<7\t[1oO\u0016D#aB\u001e\u00027Q,7\u000f^+tKJ\u001cE.[3oi&#\u0017+^8uC\u000eC\u0017M\\4fQ\tA1(\u0001\u0013uKN$H)\u001a4bk2$8\t\\5f]RLE-U;pi\u0006\u001cuN\u001c4jO\u000eC\u0017M\\4fQ\tI1(\u0001\u0011uKN$H)\u001a4bk2$Xk]3s#V|G/Y\"p]\u001aLwm\u00115b]\u001e,\u0007F\u0001\u0006<\u0003!\"Xm\u001d;EK\u001a\fW\u000f\u001c;Vg\u0016\u00148\t\\5f]RLE-U;pi\u0006\u001cuN\u001c4jO\u000eC\u0017M\\4fQ\tY1(A\fuKN$\u0018+^8uC&s\u0017\u000e^5bY&T\u0018\r^5p]\"\u0012AbO\u0001#i\u0016\u001cHoQ8oM&<7\t[1oO\u0016|eNT8o\u000bbL7\u000f^5oOR{\u0007/[2)\u00055Y\u0014a\u0006;fgR\u0004&o\\2fgNtu\u000e^5gS\u000e\fG/[8oQ\tq1(A\u0013tQ>,H\u000e\u001a)beN,'+\u001a9mS\u000e\fG/[8o#V|G/\u0019)s_B,'\u000f^5fg\"\u0012qbO\u0001.g\"|W\u000f\u001c3QCJ\u001cXmV5mI\u000e\f'\u000f\u001a*fa2L7-\u0019;j_:\fVo\u001c;b!J|\u0007/\u001a:uS\u0016\u001c\bF\u0001\t<\u0003\u0001\u001a\bn\\;mIB\u000b'o]3SKBd\u0017nY1uS>t\u0017+^8uCJ+7/\u001a;)\u0005EY\u0014!L:i_VdG\rU1sg\u0016\u0014VmZ1sI2,7o](g/\"LG/Z:qC\u000e,\u0017I]8v]\u00124\u0016\r\\;fg\"\u0012!cO\u0001\u0006a\u0006\u00148/\u001a\u000b\u0005mv\f)\u0001E\u0002xqjl\u0011aK\u0005\u0003s.\u00121aU3r!\t940\u0003\u0002}[\t\u0019\u0011J\u001c;\t\u000by\u001c\u0002\u0019A@\u0002\u001b\r|gNZ5h\u0011\u0006tG\r\\3s!\r!\u0013\u0011A\u0005\u0004\u0003\u0007)\"A\u0005+pa&\u001c7i\u001c8gS\u001eD\u0015M\u001c3mKJDa!a\u0002\u0014\u0001\u0004I\u0015!\u0002<bYV,\u0007")
public class DynamicConfigChangeTest
extends KafkaServerTestHarness {
    public List<KafkaConfig> generateConfigs() {
        return new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1)), (List)Nil$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConfigChange() {
        Assert.assertTrue((String)"Should contain a ConfigHandler for topics", (boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)ConfigType$.MODULE$.Topic()));
        Long oldVal = 100000L;
        Long newVal = 200000L;
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), oldVal.toString());
        this.createTopic(tp.topic(), 1, 1, logProps);
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$1(this, tp, oldVal);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var17_9 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += Math.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var5_6 = null;
        Object var10_11 = null;
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), newVal.toString());
        this.adminZkClient().changeTopicConfig(tp.topic(), logProps);
        long l3 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$2(this, newVal, tp);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    Object var18_17 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += Math.min(l4, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicTopicConfigChange() {
        TopicPartition tp = new TopicPartition("test", 0);
        int oldSegmentSize = 1000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(oldSegmentSize));
        this.createTopic(tp.topic(), 1, 1, logProps);
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$1(this, tp, oldSegmentSize);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var24_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += Math.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var9_5 = null;
        Object var14_10 = null;
        LogManager qual$2 = ((KafkaServer)this.servers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        Log log = (Log)qual$2.getLog(tp, x$4).get();
        int newSegmentSize = 2000;
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(newSegmentSize));
        this.adminZkClient().changeTopicConfig(tp.topic(), logProps);
        long l3 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$2(newSegmentSize, log);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    Object var25_21 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += Math.min(l4, 1000L);
                continue;
            }
            break;
        }
        Object var15_16 = null;
        Object var20_20 = null;
        int n = 1;
        int to$extension_end = 50;
        Range.Inclusive foreach$mVc$sp_this = new Range.Inclusive(n, to$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                TestUtils$.MODULE$.produceMessage((Seq<KafkaServer>)this.servers(), tp.topic(), Integer.toString(foreach$mVc$sp_i), 30000, 20000);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var21_24 = null;
        Assert.assertTrue((String)"Log segment size change not applied", (boolean)log.logSegments().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$4(x$1))));
    }

    /*
     * WARNING - void declaration
     */
    private void testQuotaConfigChange(String user, String clientId, String rootEntityType, String configEntityName) {
        Assert.assertTrue((String)new StringBuilder(35).append("Should contain a ConfigHandler for ").append(rootEntityType).toString(), (boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)rootEntityType));
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "1000");
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "2000");
        QuotaFactory.QuotaManagers quotaManagers = ((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().quotas();
        String string = ConfigType$.MODULE$.Client();
        if (!(string != null ? !string.equals(rootEntityType) : rootEntityType != null)) {
            this.adminZkClient().changeClientIdConfig(configEntityName, props);
        } else {
            this.adminZkClient().changeUserOrUserClientIdConfig(configEntityName, props);
        }
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$1(quotaManagers, user, clientId);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var24_13 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += Math.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var12_8 = null;
        Object var17_12 = null;
        double defaultProducerQuota = Long.MAX_VALUE;
        double defaultConsumerQuota = Long.MAX_VALUE;
        Properties emptyProps = new Properties();
        String string2 = ConfigType$.MODULE$.Client();
        if (!(string2 != null ? !string2.equals(rootEntityType) : rootEntityType != null)) {
            this.adminZkClient().changeClientIdConfig(configEntityName, emptyProps);
        } else {
            this.adminZkClient().changeUserOrUserClientIdConfig(configEntityName, emptyProps);
        }
        long l3 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$2(quotaManagers, user, clientId, defaultProducerQuota, defaultConsumerQuota);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    Object var25_22 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += Math.min(l4, 1000L);
                continue;
            }
            break;
        }
    }

    @Test
    public void testClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.Client(), "testClient");
    }

    @Test
    public void testUserQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "ANONYMOUS");
    }

    @Test
    public void testUserClientIdQuotaChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "ANONYMOUS/clients/testClient");
    }

    @Test
    public void testDefaultClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.Client(), "<default>");
    }

    @Test
    public void testDefaultUserQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "<default>");
    }

    @Test
    public void testDefaultUserClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "<default>/clients/<default>");
    }

    @Test
    public void testQuotaInitialization() {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties clientIdProps = new Properties();
        server.shutdown();
        clientIdProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "1000");
        clientIdProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "2000");
        Properties userProps = new Properties();
        userProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "10000");
        userProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "20000");
        Properties userClientIdProps = new Properties();
        userClientIdProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "100000");
        userClientIdProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "200000");
        this.adminZkClient().changeClientIdConfig("overriddenClientId", clientIdProps);
        this.adminZkClient().changeUserOrUserClientIdConfig("overriddenUser", userProps);
        this.adminZkClient().changeUserOrUserClientIdConfig("ANONYMOUS/clients/overriddenUserClientId", userClientIdProps);
        this.zkClient().getChildren(ConfigEntityChangeNotificationZNode$.MODULE$.path()).foreach((Function1 & Serializable)p -> {
            DynamicConfigChangeTest.$anonfun$testQuotaInitialization$1(this, p);
            return BoxedUnit.UNIT;
        });
        server.startup();
        QuotaFactory.QuotaManagers quotaManagers = server.dataPlaneRequestProcessor().quotas();
        double upperBound_upperBound = 1000.0;
        Assert.assertEquals((Object)new Quota(upperBound_upperBound, true), (Object)quotaManagers.produce().quota("someuser", "overriddenClientId"));
        double upperBound_upperBound2 = 2000.0;
        Assert.assertEquals((Object)new Quota(upperBound_upperBound2, true), (Object)quotaManagers.fetch().quota("someuser", "overriddenClientId"));
        double upperBound_upperBound3 = 10000.0;
        Assert.assertEquals((Object)new Quota(upperBound_upperBound3, true), (Object)quotaManagers.produce().quota("overriddenUser", "someclientId"));
        double upperBound_upperBound4 = 20000.0;
        Assert.assertEquals((Object)new Quota(upperBound_upperBound4, true), (Object)quotaManagers.fetch().quota("overriddenUser", "someclientId"));
        double upperBound_upperBound5 = 100000.0;
        Assert.assertEquals((Object)new Quota(upperBound_upperBound5, true), (Object)quotaManagers.produce().quota("ANONYMOUS", "overriddenUserClientId"));
        double upperBound_upperBound6 = 200000.0;
        Assert.assertEquals((Object)new Quota(upperBound_upperBound6, true), (Object)quotaManagers.fetch().quota("ANONYMOUS", "overriddenUserClientId"));
    }

    @Test
    public void testConfigChangeOnNonExistingTopic() {
        String topic = TestUtils$.MODULE$.tempTopic();
        try {
            Properties logProps = new Properties();
            logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), (Object)10000);
            this.adminZkClient().changeTopicConfig(topic, logProps);
            Assert.fail((String)"Should fail with AdminOperationException for topic doesn't exist");
            return;
        }
        catch (AdminOperationException adminOperationException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testProcessNotification() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        new Properties().put("a.b", "10");
        Capture entityArgument = EasyMock.newCapture();
        Capture propertiesArgument = EasyMock.newCapture();
        ConfigHandler handler = (ConfigHandler)EasyMock.createNiceMock(ConfigHandler.class);
        handler.processConfigChanges((String)EasyMock.and((Object)EasyMock.capture((Capture)entityArgument), (Object)EasyMock.isA(String.class)), (Properties)EasyMock.and((Object)EasyMock.capture((Capture)propertiesArgument), (Object)EasyMock.isA(Properties.class)));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{handler});
        Object[] objectArray = new Tuple2[1];
        String ArrowAssoc_self = ConfigType$.MODULE$.Topic();
        Object var30_4 = null;
        String $minus$greater$extension_$this = ArrowAssoc_self;
        Object var9_5 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)handler);
        DynamicConfigManager configManager = new DynamicConfigManager(this.zkClient(), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), 900000L, Time.SYSTEM);
        configManager.ConfigChangedNotificationHandler().processNotification("not json".getBytes(StandardCharsets.UTF_8));
        try {
            void $minus$greater$extension_y4;
            void $minus$greater$extension_y5;
            Object[] objectArray2 = new Tuple2[2];
            Integer n = 1;
            String $minus$greater$extension_$this2 = "v";
            Object var10_8 = null;
            n = null;
            objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y5);
            Integer n2 = 2;
            String $minus$greater$extension_$this3 = "x";
            Object var12_10 = null;
            n2 = null;
            objectArray2[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y4);
            Map jsonMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
            configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)jsonMap).asJava()));
            Assert.fail((String)new StringBuilder(69).append("Should have thrown an Exception while parsing incorrect notification ").append(jsonMap).toString());
        }
        catch (Throwable throwable) {}
        try {
            void $minus$greater$extension_y6;
            void $minus$greater$extension_y7;
            void $minus$greater$extension_y8;
            Object[] objectArray3 = new Tuple2[3];
            Integer n = 1;
            String $minus$greater$extension_$this4 = "version";
            Object var14_13 = null;
            n = null;
            objectArray3[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y8);
            String string = "garbage";
            String $minus$greater$extension_$this5 = "entity_type";
            Object var16_15 = null;
            string = null;
            objectArray3[1] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y7);
            String string2 = "x";
            String $minus$greater$extension_$this6 = "entity_name";
            Object var18_17 = null;
            string2 = null;
            objectArray3[2] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
            Map jsonMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3));
            configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)jsonMap).asJava()));
            Assert.fail((String)new StringBuilder(69).append("Should have thrown an Exception while parsing incorrect notification ").append(jsonMap).toString());
        }
        catch (Throwable throwable) {}
        try {
            void $minus$greater$extension_y9;
            void $minus$greater$extension_y10;
            Object[] objectArray4 = new Tuple2[2];
            Integer n = 1;
            String $minus$greater$extension_$this7 = "version";
            Object var20_20 = null;
            n = null;
            objectArray4[0] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y10);
            String string = ConfigType$.MODULE$.Topic();
            String $minus$greater$extension_$this8 = "entity_type";
            Object var22_22 = null;
            string = null;
            objectArray4[1] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y9);
            Map jsonMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray4));
            configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)jsonMap).asJava()));
            Assert.fail((String)new StringBuilder(69).append("Should have thrown an Exception while parsing incorrect notification ").append(jsonMap).toString());
        }
        catch (Throwable throwable) {}
        Object[] objectArray5 = new Tuple2[3];
        Integer n = 1;
        String $minus$greater$extension_$this9 = "version";
        Object var24_25 = null;
        n = null;
        objectArray5[0] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y3);
        String string = ConfigType$.MODULE$.Topic();
        String $minus$greater$extension_$this10 = "entity_type";
        Object var26_27 = null;
        string = null;
        objectArray5[1] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y2);
        String string3 = "x";
        String $minus$greater$extension_$this11 = "entity_name";
        Object var28_29 = null;
        string3 = null;
        objectArray5[2] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)$minus$greater$extension_y);
        Map jsonMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray5));
        configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)jsonMap).asJava()));
        EasyMock.verify((Object[])new Object[]{handler});
    }

    @Test
    public void shouldParseReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:101,0:102,1:101,1:102");
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)configHandler.parseThrottledPartitions(props, 103, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
    }

    @Test
    public void shouldParseWildcardReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "*");
        Seq result = configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
        Assert.assertEquals((Object)Constants$.MODULE$.AllReplicas(), (Object)result);
    }

    @Test
    public void shouldParseReplicationQuotaReset() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "");
        Seq result = configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp());
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)result);
    }

    @Test
    public void shouldParseRegardlessOfWhitespaceAroundValues() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Assert.assertEquals((Object)Constants$.MODULE$.AllReplicas(), this.parse(configHandler, "* "));
        Assert.assertEquals((Object)Nil$.MODULE$, this.parse(configHandler, " "));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, "6:102"));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, "6:102 "));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, " 6:102"));
    }

    public Seq<Object> parse(TopicConfigHandler configHandler, String value) {
        return configHandler.parseThrottledPartitions(CoreUtils$.MODULE$.propsWith(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), value), 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$1, Long oldVal$1) {
        LogManager qual$1 = ((KafkaServer)$this.servers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$1, x$2);
        Assert.assertTrue((boolean)logOpt.isDefined());
        Assert.assertEquals((Object)oldVal$1, (Object)((Log)logOpt.get()).config().flushInterval());
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$2(DynamicConfigChangeTest $this, Long newVal$1, TopicPartition tp$1) {
        LogManager qual$2 = ((KafkaServer)$this.servers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        Assert.assertEquals((Object)newVal$1, (Object)((Log)qual$2.getLog(tp$1, x$4).get()).config().flushInterval());
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$2, int oldSegmentSize$1) {
        LogManager qual$1 = ((KafkaServer)$this.servers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$2, x$2);
        Assert.assertTrue((boolean)logOpt.isDefined());
        Assert.assertEquals((Object)oldSegmentSize$1, (Object)((Log)logOpt.get()).config().segmentSize());
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$2(int newSegmentSize$1, Log log$1) {
        Assert.assertEquals((Object)newSegmentSize$1, (Object)log$1.config().segmentSize());
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicTopicConfigChange$4(LogSegment x$1) {
        return x$1.size() > 1000;
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$1(QuotaFactory.QuotaManagers quotaManagers$1, String user$1, String clientId$1) {
        Quota overrideProducerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota overrideConsumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        double upperBound_upperBound = 1000.0;
        Assert.assertEquals((String)new StringBuilder(59).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have overridden producer quota of 1000").toString(), (Object)new Quota(upperBound_upperBound, true), (Object)overrideProducerQuota);
        double upperBound_upperBound2 = 2000.0;
        Assert.assertEquals((String)new StringBuilder(59).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have overridden consumer quota of 2000").toString(), (Object)new Quota(upperBound_upperBound2, true), (Object)overrideConsumerQuota);
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$2(QuotaFactory.QuotaManagers quotaManagers$1, String user$1, String clientId$1, double defaultProducerQuota$1, double defaultConsumerQuota$1) {
        Quota producerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota consumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        Assert.assertEquals((String)new StringBuilder(50).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have reset producer quota to ").append(defaultProducerQuota$1).toString(), (Object)new Quota(defaultProducerQuota$1, true), (Object)producerQuota);
        Assert.assertEquals((String)new StringBuilder(50).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have reset consumer quota to ").append(defaultConsumerQuota$1).toString(), (Object)new Quota(defaultConsumerQuota$1, true), (Object)consumerQuota);
    }

    public static final /* synthetic */ void $anonfun$testQuotaInitialization$1(DynamicConfigChangeTest $this, String p) {
        KafkaZkClient qual$1 = $this.zkClient();
        String x$1 = new StringBuilder(1).append(ConfigEntityChangeNotificationZNode$.MODULE$.path()).append("/").append(p).toString();
        int x$2 = qual$1.deletePath$default$2();
        boolean x$3 = qual$1.deletePath$default$3();
        qual$1.deletePath(x$1, x$2, x$3);
    }
}

