/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.Kafka$;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclAuthorizer$;
import kafka.security.authorizer.AclEntry$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.ZkAclStore;
import kafka.zk.ZkAclStore$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.GetDataRequest;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r5h\u0001\u00025j\u0001ADQa\u001e\u0001\u0005\u0002aDqa\u001f\u0001C\u0002\u0013%A\u0010C\u0004\u0002\u0016\u0001\u0001\u000b\u0011B?\t\u0011\u0005]\u0001A1A\u0005\nqDq!!\u0007\u0001A\u0003%Q\u0010\u0003\u0005\u0002\u001c\u0001\u0011\r\u0011\"\u0003}\u0011\u001d\ti\u0002\u0001Q\u0001\nuD\u0011\"a\b\u0001\u0005\u0004%I!!\t\t\u0011\u0005=\u0002\u0001)A\u0005\u0003GA\u0011\"!\r\u0001\u0005\u0004%I!!\t\t\u0011\u0005M\u0002\u0001)A\u0005\u0003GA\u0011\"!\u000e\u0001\u0005\u0004%I!!\t\t\u0011\u0005]\u0002\u0001)A\u0005\u0003GA\u0011\"!\u000f\u0001\u0005\u0004%I!a\u000f\t\u0011\u0005-\u0003\u0001)A\u0005\u0003{A\u0011\"!\u0014\u0001\u0005\u0004%I!a\u0014\t\u0011\u0005]\u0003\u0001)A\u0005\u0003#B\u0011\"!\u0017\u0001\u0005\u0004%I!a\u0014\t\u0011\u0005m\u0003\u0001)A\u0005\u0003#B1\"!\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\"!Y\u0011Q\f\u0001A\u0002\u0003\u0007I\u0011BA0\u0011-\t\t\b\u0001a\u0001\u0002\u0003\u0006K!a\t\t\u0013\u0005M\u0004A1A\u0005\n\u0005U\u0004\u0002CAD\u0001\u0001\u0006I!a\u001e\t\u0013\u0005%\u0005A1A\u0005\n\u0005U\u0004\u0002CAF\u0001\u0001\u0006I!a\u001e\t\u0013\u00055\u0005A1A\u0005\n\u0005m\u0002\u0002CAH\u0001\u0001\u0006I!!\u0010\t\u0013\u0005E\u0005A1A\u0005\n\u0005M\u0005\u0002CAQ\u0001\u0001\u0006I!!&\t\u0017\u0005\r\u0006\u00011AA\u0002\u0013%\u0011Q\u0015\u0005\f\u0003g\u0003\u0001\u0019!a\u0001\n\u0013\t)\fC\u0006\u0002:\u0002\u0001\r\u0011!Q!\n\u0005\u001d\u0006bCA^\u0001\u0001\u0007\t\u0019!C\u0005\u0003{C1\"a3\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002N\"Y\u0011\u0011\u001b\u0001A\u0002\u0003\u0005\u000b\u0015BA`\r\u0019\t\u0019\u000e\u0001\u0001\u0002V\"Q\u0011q[\u0013\u0003\u0002\u0003\u0006I!!7\t\u0015\u00055XE!A!\u0002\u0013\tI\u000e\u0003\u0004xK\u0011\u0005\u0011q\u001e\u0005\b\u0003s,C\u0011IA~\u0011\u001d\u0011i\u0001\u0001C!\u0005\u001fAqAa\b\u0001\t\u0003\u0012y\u0001C\u0004\u0003*\u0001!\tAa\u0004\t\u000f\t%\u0003\u0001\"\u0001\u0003\u0010!9!Q\n\u0001\u0005\u0002\t=\u0001b\u0002B)\u0001\u0011\u0005!q\u0002\u0005\b\u0005+\u0002A\u0011\u0001B\b\u0011\u001d\u0011I\u0006\u0001C\u0001\u0005\u001fAqA!\u0018\u0001\t\u0003\u0011y\u0001C\u0004\u0003b\u0001!\tAa\u0004\t\u000f\t\u0015\u0004\u0001\"\u0001\u0003\u0010!9!\u0011\u000e\u0001\u0005\u0002\t=\u0001b\u0002B7\u0001\u0011\u0005!q\u0002\u0005\b\u0005c\u0002A\u0011\u0001B\b\u0011\u001d\u0011)\b\u0001C\u0001\u0005\u001fAqA!\u001f\u0001\t\u0003\u0011y\u0001C\u0004\u0003~\u0001!\tAa\u0004\t\u000f\t\u0005\u0005\u0001\"\u0001\u0003\u0010!9!Q\u0011\u0001\u0005\u0002\t=\u0001b\u0002BE\u0001\u0011\u0005!q\u0002\u0005\b\u0005\u001b\u0003A\u0011\u0001B\b\u0011\u001d\u0011\t\n\u0001C\u0005\u0005'CqA!+\u0001\t\u0013\u0011Y\u000bC\u0004\u00034\u0002!\tAa\u0004\t\u000f\t]\u0006\u0001\"\u0001\u0003\u0010!9!1\u0018\u0001\u0005\u0002\t=\u0001b\u0002B`\u0001\u0011\u0005!q\u0002\u0005\b\u0005\u0007\u0004A\u0011\u0001B\b\u0011\u001d\u00119\r\u0001C\u0001\u0005\u001fAqAa3\u0001\t\u0003\u0011y\u0001C\u0004\u0003P\u0002!\tAa\u0004\t\u000f\tM\u0007\u0001\"\u0001\u0003\u0010!9!q\u001b\u0001\u0005\u0002\t=\u0001b\u0002Bn\u0001\u0011\u0005!q\u0002\u0005\b\u0005?\u0004A\u0011\u0001B\b\u0011\u001d\u0011\u0019\u000f\u0001C\u0001\u0005\u001fAqAa:\u0001\t\u0003\u0011y\u0001C\u0004\u0003l\u0002!\tAa\u0004\t\u000f\t=\b\u0001\"\u0001\u0003\u0010!9!1\u001f\u0001\u0005\u0002\t=\u0001b\u0002B|\u0001\u0011\u0005!q\u0002\u0005\b\u0005w\u0004A\u0011\u0001B\b\u0011\u001d\u0011y\u0010\u0001C\u0001\u0005\u001fAqaa\u0001\u0001\t\u0003\u0011y\u0001C\u0004\u0004\b\u0001!\tAa\u0004\t\u000f\r-\u0001\u0001\"\u0001\u0003\u0010!91q\u0002\u0001\u0005\u0002\t=\u0001bBB\n\u0001\u0011%1Q\u0003\u0005\b\u0007[\u0001A\u0011BB\u0018\u0011\u001d\u0019Y\u0004\u0001C\u0005\u0007{A\u0011ba\u0014\u0001#\u0003%Ia!\u0015\t\u000f\r\u001d\u0004\u0001\"\u0003\u0004j!I1Q\u0012\u0001\u0012\u0002\u0013%1q\u0012\u0005\b\u0007'\u0003A\u0011BBK\u0011\u001d\u0019\t\u000b\u0001C\u0005\u0007GCqaa,\u0001\t\u0013\u0019\t\fC\u0004\u0004:\u0002!Iaa/\t\u000f\re\u0006\u0001\"\u0003\u0004B\"91\u0011\u0018\u0001\u0005\n\r=\u0007bBBj\u0001\u0011%1Q\u001b\u0005\b\u00077\u0004A\u0011BBo\u0011\u001d\u0019y\u000e\u0001C\u0005\u0007C\u0014\u0011#Q2m\u0003V$\bn\u001c:ju\u0016\u0014H+Z:u\u0015\tQ7.\u0001\u0006bkRDwN]5{KJT!\u0001\\7\u0002\u0011M,7-\u001e:jifT\u0011A\\\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u000f\u0005\u0002sk6\t1O\u0003\u0002u[\u0006\u0011!p[\u0005\u0003mN\u0014ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001z!\tQ\b!D\u0001j\u00031\tG\u000e\\8x%\u0016\fG-Q2m+\u0005i\bc\u0001@\u0002\u00125\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011aA1dY*!\u0011QAA\u0004\u0003\u0019\u0019w.\\7p]*\u0019a.!\u0003\u000b\t\u0005-\u0011QB\u0001\u0007CB\f7\r[3\u000b\u0005\u0005=\u0011aA8sO&\u0019\u00111C@\u0003%\u0005\u001b7-Z:t\u0007>tGO]8m\u000b:$(/_\u0001\u000eC2dwn\u001e*fC\u0012\f5\r\u001c\u0011\u0002\u001b\u0005dGn\\<Xe&$X-Q2m\u00039\tG\u000e\\8x/JLG/Z!dY\u0002\n1\u0002Z3osJ+\u0017\rZ!dY\u0006aA-\u001a8z%\u0016\fG-Q2mA\u0005\u0001r/\u001b7e\u0007\u0006\u0014HMU3t_V\u00148-Z\u000b\u0003\u0003G\u0001B!!\n\u0002,5\u0011\u0011q\u0005\u0006\u0005\u0003S\t\u0019!\u0001\u0005sKN|WO]2f\u0013\u0011\ti#a\n\u0003\u001fI+7o\\;sG\u0016\u0004\u0016\r\u001e;fe:\f\u0011c^5mI\u000e\u000b'\u000f\u001a*fg>,(oY3!\u0003A\u0001(/\u001a4jq\u0016$'+Z:pkJ\u001cW-A\tqe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dK\u0002\nqb\u00197vgR,'OU3t_V\u00148-Z\u0001\u0011G2,8\u000f^3s%\u0016\u001cx.\u001e:dK\u0002\n\u0011c^5mI\u000e\f'\u000f\u001a)sS:\u001c\u0017\u000e]1m+\t\ti\u0004\u0005\u0003\u0002@\u0005\u001dSBAA!\u0015\u0011\t\u0019%!\u0012\u0002\t\u0005,H\u000f\u001b\u0006\u0004Y\u0006\r\u0011\u0002BA%\u0003\u0003\u0012abS1gW\u0006\u0004&/\u001b8dSB\fG.\u0001\nxS2$7-\u0019:e!JLgnY5qC2\u0004\u0013!D1dY\u0006+H\u000f[8sSj,'/\u0006\u0002\u0002RA\u0019!0a\u0015\n\u0007\u0005U\u0013NA\u0007BG2\fU\u000f\u001e5pe&TXM]\u0001\u000fC\u000ed\u0017)\u001e;i_JL'0\u001a:!\u00039\t7\r\\!vi\"|'/\u001b>feJ\nq\"Y2m\u0003V$\bn\u001c:ju\u0016\u0014(\u0007I\u0001\re\u0016\u001cx.\u001e:dK~#S-\u001d\u000b\u0005\u0003C\ni\u0007\u0005\u0003\u0002d\u0005%TBAA3\u0015\t\t9'A\u0003tG\u0006d\u0017-\u0003\u0003\u0002l\u0005\u0015$\u0001B+oSRD\u0011\"a\u001c\u0016\u0003\u0003\u0005\r!a\t\u0002\u0007a$\u0013'A\u0005sKN|WO]2fA\u0005Q1/\u001e9feV\u001bXM]:\u0016\u0005\u0005]\u0004\u0003BA=\u0003\u0007k!!a\u001f\u000b\t\u0005u\u0014qP\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0002\u0006!!.\u0019<b\u0013\u0011\t))a\u001f\u0003\rM#(/\u001b8h\u0003-\u0019X\u000f]3s+N,'o\u001d\u0011\u0002\u0011U\u001cXM\u001d8b[\u0016\f\u0011\"^:fe:\fW.\u001a\u0011\u0002\u0013A\u0014\u0018N\\2ja\u0006d\u0017A\u00039sS:\u001c\u0017\u000e]1mA\u0005q!/Z9vKN$8i\u001c8uKb$XCAAK!\u0011\t9*!(\u000e\u0005\u0005e%\u0002BAN\u0003\u0007\t\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003?\u000bIJ\u0001\bSKF,Xm\u001d;D_:$X\r\u001f;\u0002\u001fI,\u0017/^3ti\u000e{g\u000e^3yi\u0002\naaY8oM&<WCAAT!\u0011\tI+a,\u000e\u0005\u0005-&bAAW[\u000611/\u001a:wKJLA!!-\u0002,\nY1*\u00194lC\u000e{gNZ5h\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0005\u0003C\n9\fC\u0005\u0002p\u0001\n\t\u00111\u0001\u0002(\u000691m\u001c8gS\u001e\u0004\u0013a\u0004>p_.+W\r]3s\u00072LWM\u001c;\u0016\u0005\u0005}\u0006\u0003BAa\u0003\u000fl!!a1\u000b\u0007\u0005\u0015W.A\u0005{_>\\W-\u001a9fe&!\u0011\u0011ZAb\u0005=Qvn\\&fKB,'o\u00117jK:$\u0018a\u0005>p_.+W\r]3s\u00072LWM\u001c;`I\u0015\fH\u0003BA1\u0003\u001fD\u0011\"a\u001c$\u0003\u0003\u0005\r!a0\u0002!i|wnS3fa\u0016\u00148\t\\5f]R\u0004#aD\"vgR|W\u000e\u0015:j]\u000eL\u0007/\u00197\u0014\u0007\u0015\ni$A\u0007qe&t7-\u001b9bYRK\b/\u001a\t\u0005\u00037\fIO\u0004\u0003\u0002^\u0006\u0015\b\u0003BAp\u0003Kj!!!9\u000b\u0007\u0005\rx.\u0001\u0004=e>|GOP\u0005\u0005\u0003O\f)'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000b\u000bYO\u0003\u0003\u0002h\u0006\u0015\u0014\u0001\u00028b[\u0016$b!!=\u0002v\u0006]\bcAAzK5\t\u0001\u0001C\u0004\u0002X\"\u0002\r!!7\t\u000f\u00055\b\u00061\u0001\u0002Z\u00061Q-];bYN$B!!@\u0003\u0004A!\u00111MA\u0000\u0013\u0011\u0011\t!!\u001a\u0003\u000f\t{w\u000e\\3b]\"9!QA\u0015A\u0002\t\u001d\u0011!A8\u0011\t\u0005\r$\u0011B\u0005\u0005\u0005\u0017\t)GA\u0002B]f\fQa]3u+B$\"!!\u0019)\u0007)\u0012\u0019\u0002\u0005\u0003\u0003\u0016\tmQB\u0001B\f\u0015\u0011\u0011I\"!\u0004\u0002\u000b),h.\u001b;\n\t\tu!q\u0003\u0002\u0007\u0005\u00164wN]3\u0002\u0011Q,\u0017M\u001d#po:D3a\u000bB\u0012!\u0011\u0011)B!\n\n\t\t\u001d\"q\u0003\u0002\u0006\u0003\u001a$XM]\u0001(i\u0016\u001cH/Q;uQ>\u0014\u0018N_3UQJ|wo](o\u001d>tG*\u001b;fe\u0006d'+Z:pkJ\u001cW\rK\u0004-\u0005[\u0011\u0019D!\u000e\u0011\t\tU!qF\u0005\u0005\u0005c\u00119B\u0001\u0003UKN$\u0018\u0001C3ya\u0016\u001cG/\u001a3$\u0005\t]\u0002\u0003\u0002B\u001d\u0005\u0007rAAa\u000f\u0003@9!\u0011q\u001cB\u001f\u0013\t\t9'\u0003\u0003\u0003B\u0005\u0015\u0014a\u00029bG.\fw-Z\u0005\u0005\u0005\u000b\u00129E\u0001\rJY2,w-\u00197Be\u001e,X.\u001a8u\u000bb\u001cW\r\u001d;j_:TAA!\u0011\u0002f\u0005\u0011C/Z:u\u0003V$\bn\u001c:ju\u0016<\u0016\u000e\u001e5F[B$\u0018PU3t_V\u00148-\u001a(b[\u0016D3!\fB\u0017\u0003m!Xm\u001d;F[B$\u00180Q2m)\"\u0014xn^:Fq\u000e,\u0007\u000f^5p]\"\u001aaF!\f\u0002\u0019Q,7\u000f\u001e+pa&\u001c\u0017i\u00197)\u0007=\u0012i#\u0001\u0012uKN$\u0018\t\u001c7po\u0006\u001b7-Z:t/&$\bnQ;ti>l\u0007K]5oG&\u0004\u0018\r\u001c\u0015\u0004a\t5\u0012a\u0006;fgR$UM\\=UC.,7\u000f\u0015:fG\u0016$WM\\2fQ\r\t$QF\u0001\u0013i\u0016\u001cH/\u00117m_^\fE\u000e\\!dG\u0016\u001c8\u000fK\u00023\u0005[\ta\u0003^3tiN+\b/\u001a:Vg\u0016\u0014\b*Y:BG\u000e,7o\u001d\u0015\u0004g\t5\u0012!\u000b;fgR\u001cV\u000f]3s+N,'oV5uQ\u000e+8\u000f^8n!JLgnY5qC2D\u0015m]!dG\u0016\u001c8\u000fK\u00025\u0005[\t\u0001\u0003^3ti^KG\u000eZ\"be\u0012\f5\r\\:)\u0007U\u0012i#\u0001\buKN$hj\\!dY\u001a{WO\u001c3)\u0007Y\u0012i#\u0001\fuKN$hj\\!dY\u001a{WO\u001c3Pm\u0016\u0014(/\u001b3fQ\r9$QF\u0001\u0016i\u0016\u001cH/Q2m\u001b\u0006t\u0017mZ3nK:$\u0018\tU%tQ\rA$QF\u0001\u000ei\u0016\u001cH\u000fT8bI\u000e\u000b7\r[3)\u0007e\u0012i#\u0001\ruKN$8\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014H+[7j]\u001eD3A\u000fB\u0017\u00035\"Xm\u001d;M_\u000e\fGnQ8oGV\u0014(/\u001a8u\u001b>$\u0017NZ5dCRLwN\\(g%\u0016\u001cx.\u001e:dK\u0006\u001bGn\u001d\u0015\u0004w\t5\u0012a\r;fgR$\u0015n\u001d;sS\n,H/\u001a3D_:\u001cWO\u001d:f]Rlu\u000eZ5gS\u000e\fG/[8o\u001f\u001a\u0014Vm]8ve\u000e,\u0017i\u00197tQ\ra$QF\u0001.i\u0016\u001cH\u000fS5hQ\u000e{gnY;se\u0016t7-_'pI&4\u0017nY1uS>twJ\u001a*fg>,(oY3BG2\u001c\bfA\u001f\u0003.\u0005\u0011B/Z:u\u0003\u000ed\u0017J\u001c5fe&$\u0018M\\2fQ\rq$QF\u0001\u0018i\u0016\u001cH/S7qY&\u001c\u0017\r^5p]N|e-\u00117m_^$b!!\u0019\u0003\u0016\n}\u0005b\u0002BL\u007f\u0001\u0007!\u0011T\u0001\ta\u0006\u0014XM\u001c;PaB\u0019aPa'\n\u0007\tuuP\u0001\u0007BG2|\u0005/\u001a:bi&|g\u000eC\u0004\u0003\"~\u0002\rAa)\u0002\u0015\u0005dGn\\<fI>\u00038\u000f\u0005\u0004\u0002\\\n\u0015&\u0011T\u0005\u0005\u0005O\u000bYOA\u0002TKR\fa\u0003^3ti&k\u0007\u000f\\5dCRLwN\\:PM\u0012+g.\u001f\u000b\u0007\u0003C\u0012iKa,\t\u000f\t]\u0005\t1\u0001\u0003\u001a\"9!\u0011\u0017!A\u0002\t\r\u0016!\u00033f]&,Gm\u00149t\u0003%\"Xm\u001d;IS\u001eD7i\u001c8dkJ\u0014XM\\2z\t\u0016dW\r^5p]>3'+Z:pkJ\u001cW-Q2mg\"\u001a\u0011I!\f\u0002gQ,7\u000f^!dG\u0016\u001c8/\u00117m_^,G-\u00134BY2|w/Q2m\u000bbL7\u000f^:P]^KG\u000eZ2be\u0012\u0014Vm]8ve\u000e,\u0007f\u0001\"\u0003.\u0005yB/Z:u\t\u0016dW\r^3BG2|enV5mI\u000e\f'\u000f\u001a*fg>,(oY3)\u0007\r\u0013i#\u0001\u0012uKN$H)\u001a7fi\u0016\fE\u000e\\!dY>sw+\u001b7eG\u0006\u0014HMU3t_V\u00148-\u001a\u0015\u0004\t\n5\u0012a\r;fgR\f5mY3tg\u0006cGn\\<fI&3\u0017\t\u001c7po\u0006\u001bG.\u0012=jgR\u001cxJ\u001c)sK\u001aL\u00070\u001a3SKN|WO]2fQ\r)%QF\u0001 i\u0016\u001cH\u000fR3mKR,\u0017i\u00197P]B\u0013XMZ5yK\u0012\u0014Vm]8ve\u000e,\u0007f\u0001$\u0003.\u0005\u0011C/Z:u\t\u0016dW\r^3BY2\f5\r\\(o!J,g-\u001b=fIJ+7o\\;sG\u0016D3a\u0012B\u0017\u0003q!Xm\u001d;BI\u0012\f5\r\\:P]2KG/\u001a:bYJ+7o\\;sG\u0016D3\u0001\u0013B\u0017\u0003u!Xm\u001d;BI\u0012\f5\r\\:P]^KG\u000eZ2be\u0012\u0014Vm]8ve\u000e,\u0007fA%\u0003.\u0005iB/Z:u\u0003\u0012$\u0017i\u00197t\u001f:\u0004&/\u001a4jq\u0016$'+Z:pkJ\u001cW\rK\u0002K\u0005[\t\u0011\u0005^3ti\u0006+H\u000f[8sSj,w+\u001b;i!J,g-\u001b=fIJ+7o\\;sG\u0016D3a\u0013B\u0017\u0003}!Xm\u001d;TS:<G.Z\"iCJ\f7\r^3s%\u0016\u001cx.\u001e:dK\u0006\u001bGn\u001d\u0015\u0004\u0019\n5\u0012\u0001\u0006;fgR<U\r^!dYN\u0004&/\u001b8dSB\fG\u000eK\u0002N\u0005[\ta\u0002^3ti\u0006\u001bGn\u001d$jYR,'\u000fK\u0002O\u0005[\tA\b^3tiRC'o\\<t\u001f:\fE\r\u001a)sK\u001aL\u00070\u001a3BG2Le-\u00138uKJ\u0014%o\\6feB\u0013x\u000e^8d_24VM]:j_:$vn\u001c'po\"\u001aqJ!\f\u0002wQ,7\u000f^,sSR,7/\u0012=uK:$W\rZ!dY\u000eC\u0017M\\4f\u000bZ,g\u000e^%g\u0013:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\u001c(piN+G\u000fK\u0002Q\u0005[\tQ\t^3ti^\u0013\u0018\u000e^3t\u000bb$XM\u001c3fI\u0006\u001bGn\u00115b]\u001e,WI^3oi^CWM\\%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>d\u0017\t\u001e'fCN$8*\u00194lCZ\u0013\u0004fA)\u0003.\u0005AH/Z:u/JLG/Z:MSR,'/\u00197Xe&$Xm\u001d'ji\u0016\u0014\u0018\r\\!dY\u000eC\u0017M\\4f\u000bZ,g\u000e^,iK:Le\u000e^3s\u0005J|7.\u001a:Qe>$xnY8m\u0019\u0016\u001c8\u000f\u00165b].\u000bgm[1We\u0015\u0014\u0018\r\\!dY\u000eC\u0017M\\4fg\u001a{'o\u00147eKJ\u0004&o\u001c;pG>dg+\u001a:tS>t7\u000fK\u0002S\u0005[\tq\b^3ti^\u0013\u0018\u000e^3t\u0019&$XM]1m\u0003\u000ed7\t[1oO\u0016,e/\u001a8u/\",g.\u00138uKJ\u0014%o\\6feB\u0013x\u000e^8d_2L5oS1gW\u00064&\u0007K\u0002T\u0005[\t\u0001\u0004^3ti\u0006+H\u000f[8sSj,'OT8[W\u000e{gNZ5hQ\r!&QF\u00012i\u0016\u001cH/Q;uQ>\u0014\u0018N_3s5.\u001cuN\u001c4jO\u001a\u0013x.\\&bM.\f7i\u001c8gS\u001e<\u0016\u000e\u001e5EK\u001a\fW\u000f\u001c;tQ\r)&QF\u0001&i\u0016\u001cH/Q;uQ>\u0014\u0018N_3s5.\u001cuN\u001c4jO\u001a\u0013x.\\&bM.\f7i\u001c8gS\u001eD3A\u0016B\u0017\u0003%\"Xm\u001d;BkRDwN]5{KJT6nQ8oM&<gI]8n!J,g-\u001b=Pm\u0016\u0014(/\u001b3fg\"\u001aqK!\f\u0002-Q,7\u000f^\"sK\u0006$X\rR3mKR,G+[7j]\u001eD3\u0001\u0017B\u0017\u0003\t:\u0017N^3o\u0003V$\bn\u001c:ju\u0016\u0014x+\u001b;i!J|Go\\2pYZ+'o]5p]R!\u0011\u0011MB\f\u0011\u001d\u0019I\"\u0017a\u0001\u00077\tq\u0002\u001d:pi>\u001cw\u000e\u001c,feNLwN\u001c\t\u0007\u0003G\u001aib!\t\n\t\r}\u0011Q\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\r\r2\u0011F\u0007\u0003\u0007KQ1aa\nn\u0003\r\t\u0007/[\u0005\u0005\u0007W\u0019)C\u0001\u0006Ba&4VM]:j_:\f\u0011dZ3u\u0003\u000ed7\t[1oO\u0016,e/\u001a8u\u0003N\u001cFO]5oOR!\u0011qOB\u0019\u0011\u001d\u0019\u0019D\u0017a\u0001\u0007k\t1\u0002]1ui\u0016\u0014h\u000eV=qKB!\u0011QEB\u001c\u0013\u0011\u0019I$a\n\u0003\u0017A\u000bG\u000f^3s]RK\b/Z\u0001\u0013G\"\fgnZ3BG2\fe\u000e\u001a,fe&4\u0017\u0010\u0006\u0006\u0004@\r\u00053QIB%\u0007\u001b\u0002R!a7\u0003&vDqaa\u0011\\\u0001\u0004\u0019y$\u0001\u0007pe&<\u0017N\\1m\u0003\u000ed7\u000fC\u0004\u0004Hm\u0003\raa\u0010\u0002\u0013\u0005$G-\u001a3BG2\u001c\bbBB&7\u0002\u00071qH\u0001\fe\u0016lwN^3e\u0003\u000ed7\u000fC\u0005\u0002*m\u0003\n\u00111\u0001\u0002$\u0005a2\r[1oO\u0016\f5\r\\!oIZ+'/\u001b4zI\u0011,g-Y;mi\u0012\"TCAB*U\u0011\t\u0019c!\u0016,\u0005\r]\u0003\u0003BB-\u0007Gj!aa\u0017\u000b\t\ru3qL\u0001\nk:\u001c\u0007.Z2lK\u0012TAa!\u0019\u0002f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r\u001541\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00058foJ+\u0017/^3ti\u000e{g\u000e^3yiRA\u0011QSB6\u0007[\u001ai\bC\u0004\u0002\u000ev\u0003\r!!\u0010\t\u000f\r=T\f1\u0001\u0004r\u0005i1\r\\5f]R\fE\r\u001a:fgN\u0004Baa\u001d\u0004z5\u00111Q\u000f\u0006\u0005\u0007o\ny(A\u0002oKRLAaa\u001f\u0004v\tY\u0011J\\3u\u0003\u0012$'/Z:t\u0011%\u0019y(\u0018I\u0001\u0002\u0004\u0019\t)\u0001\u0004ba&\\U-\u001f\t\u0005\u0007\u0007\u001bI)\u0004\u0002\u0004\u0006*!1qQA\u0002\u0003!\u0001(o\u001c;pG>d\u0017\u0002BBF\u0007\u000b\u0013q!\u00119j\u0017\u0016L8/A\u000eoK^\u0014V-];fgR\u001cuN\u001c;fqR$C-\u001a4bk2$HeM\u000b\u0003\u0007#SCa!!\u0004V\u0005I\u0011-\u001e;i_JL'0\u001a\u000b\u000b\u0003{\u001c9j!'\u0004\u001c\u000e}\u0005B\u00026`\u0001\u0004\t\t\u0006C\u0004\u0002\u0012~\u0003\r!!&\t\u000f\ruu\f1\u0001\u0003\u001a\u0006Iq\u000e]3sCRLwN\u001c\u0005\b\u0003Sy\u0006\u0019AA\u0012\u0003\u001d\tG\rZ!dYN$\u0002\"!\u0019\u0004&\u000e\u001d61\u0016\u0005\u0007U\u0002\u0004\r!!\u0015\t\u000f\r%\u0006\r1\u0001\u0004@\u0005!\u0011mY3t\u0011\u001d\u0019i\u000b\u0019a\u0001\u0003G\tqB]3t_V\u00148-\u001a)biR,'O\\\u0001\u000be\u0016lwN^3BG2\u001cH\u0003CA\u007f\u0007g\u001b)la.\t\r)\f\u0007\u0019AA)\u0011\u001d\u0019I+\u0019a\u0001\u0007\u007fAqa!,b\u0001\u0004\t\u0019#A\u0004hKR\f5\r\\:\u0015\r\r}2QXB`\u0011\u0019Q'\r1\u0001\u0002R!91Q\u00162A\u0002\u0005\rBCBBb\u0007\u0017\u001ci\r\u0005\u0004\u0002\\\n\u00156Q\u0019\t\u0004}\u000e\u001d\u0017bABe\u007f\nQ\u0011i\u00197CS:$\u0017N\\4\t\r)\u001c\u0007\u0019AA)\u0011\u001d\tii\u0019a\u0001\u0003{!Baa1\u0004R\"1!\u000e\u001aa\u0001\u0003#\nqA^1mS\u0012|\u0005\u000f\u0006\u0003\u0002~\u000e]\u0007bBBmK\u0002\u0007!\u0011T\u0001\u0003_B\fA\u0003\u001d:fa\u0006\u0014X\rR3gCVdGoQ8oM&<WCAAm\u00035\u0001(/\u001a9be\u0016\u001cuN\u001c4jOR!\u0011\u0011\\Br\u0011\u001d\u0019)o\u001aa\u0001\u0007O\fQ\u0001\\5oKN\u0004b!a\u0019\u0004j\u0006e\u0017\u0002BBv\u0003K\u0012Q!\u0011:sCf\u0004")
public class AclAuthorizerTest
extends ZooKeeperTestHarness {
    private final AccessControlEntry allowReadAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
    private final AccessControlEntry allowWriteAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
    private final AccessControlEntry denyReadAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
    private final ResourcePattern wildCardResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
    private final ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.PREFIXED);
    private final ResourcePattern clusterResource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
    private final KafkaPrincipal wildcardPrincipal = SecurityUtils.parseKafkaPrincipal((String)AclEntry$.MODULE$.WildcardPrincipalString());
    private final AclAuthorizer aclAuthorizer = new AclAuthorizer();
    private final AclAuthorizer aclAuthorizer2 = new AclAuthorizer();
    private ResourcePattern resource;
    private final String superUsers;
    private final String username;
    private final KafkaPrincipal principal = new KafkaPrincipal("User", this.username());
    private final RequestContext requestContext = this.newRequestContext(this.principal(), InetAddress.getByName("192.168.0.1"), ApiKeys.PRODUCE);
    private KafkaConfig config;
    private ZooKeeperClient zooKeeperClient;

    private AccessControlEntry allowReadAcl() {
        return this.allowReadAcl;
    }

    private AccessControlEntry allowWriteAcl() {
        return this.allowWriteAcl;
    }

    private AccessControlEntry denyReadAcl() {
        return this.denyReadAcl;
    }

    private ResourcePattern wildCardResource() {
        return this.wildCardResource;
    }

    private ResourcePattern prefixedResource() {
        return this.prefixedResource;
    }

    private ResourcePattern clusterResource() {
        return this.clusterResource;
    }

    private KafkaPrincipal wildcardPrincipal() {
        return this.wildcardPrincipal;
    }

    private AclAuthorizer aclAuthorizer() {
        return this.aclAuthorizer;
    }

    private AclAuthorizer aclAuthorizer2() {
        return this.aclAuthorizer2;
    }

    private ResourcePattern resource() {
        return this.resource;
    }

    private void resource_$eq(ResourcePattern x$1) {
        this.resource = x$1;
    }

    private String superUsers() {
        return this.superUsers;
    }

    private String username() {
        return this.username;
    }

    private KafkaPrincipal principal() {
        return this.principal;
    }

    private RequestContext requestContext() {
        return this.requestContext;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    private ZooKeeperClient zooKeeperClient() {
        return this.zooKeeperClient;
    }

    private void zooKeeperClient_$eq(ZooKeeperClient x$1) {
        this.zooKeeperClient = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.aclAuthorizer().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        this.aclAuthorizer2().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(AclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.aclAuthorizer().configure(this.config().originals());
        this.aclAuthorizer2().configure(this.config().originals());
        this.resource_$eq(new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL));
        this.zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "kafka.test", "AclAuthorizerTest"));
    }

    @Override
    @After
    public void tearDown() {
        this.aclAuthorizer().close();
        this.aclAuthorizer2().close();
        this.zooKeeperClient().close();
        super.tearDown();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAuthorizeThrowsOnNonLiteralResource() {
        this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "something", PatternType.PREFIXED));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAuthorizeWithEmptyResourceName() {
        void apply_elems;
        Assert.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL));
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
    }

    @Test
    public void testEmptyAclThrowsException() {
        ApiException e = (ApiException)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL));
        }, ClassTag$.MODULE$.apply(ApiException.class), new Position("AclAuthorizerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        Assert.assertTrue((String)new StringBuilder(21).append("Unexpected exception ").append(e).toString(), (boolean)(e.getCause() instanceof IllegalArgumentException));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicAcl() {
        void apply_elems;
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "rob");
        KafkaPrincipal user3 = new KafkaPrincipal("User", "batman");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl4 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl5 = new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AccessControlEntry acl6 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl7 = new AccessControlEntry(user3.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4, acl5, acl6, acl7});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set acls = (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.changeAclAndVerify$default$4());
        RequestContext host1Context = this.newRequestContext(user1, host1, ApiKeys.PRODUCE);
        RequestContext host2Context = this.newRequestContext(user1, host2, ApiKeys.PRODUCE);
        Assert.assertTrue((String)"User1 should have READ access from host2", (boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.READ, this.resource()));
        Assert.assertFalse((String)"User1 should not have READ access from host1 due to denyAcl", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()));
        Assert.assertTrue((String)"User1 should have WRITE access from host1", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.WRITE, this.resource()));
        Assert.assertFalse((String)"User1 should not have WRITE access from host2 as no allow acl is defined", (boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.WRITE, this.resource()));
        Assert.assertTrue((String)"User1 should not have DESCRIBE access from host1", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.DESCRIBE, this.resource()));
        Assert.assertTrue((String)"User1 should have DESCRIBE access from host2", (boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.DESCRIBE, this.resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host1", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.ALTER, this.resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host2", (boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.ALTER, this.resource()));
        RequestContext user2Context = this.newRequestContext(user2, host1, ApiKeys.PRODUCE);
        RequestContext user3Context = this.newRequestContext(user3, host1, ApiKeys.PRODUCE);
        Assert.assertTrue((String)"User2 should have DESCRIBE access from host1", (boolean)this.authorize(this.aclAuthorizer(), user2Context, AclOperation.DESCRIBE, this.resource()));
        Assert.assertTrue((String)"User3 should have DESCRIBE access from host2", (boolean)this.authorize(this.aclAuthorizer(), user3Context, AclOperation.DESCRIBE, this.resource()));
        Assert.assertTrue((String)"User2 should have READ access from host1", (boolean)this.authorize(this.aclAuthorizer(), user2Context, AclOperation.READ, this.resource()));
        Assert.assertTrue((String)"User3 should have WRITE access from host2", (boolean)this.authorize(this.aclAuthorizer(), user3Context, AclOperation.WRITE, this.resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAllowAccessWithCustomPrincipal() {
        void apply_elems;
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        CustomPrincipal customUserPrincipal = new CustomPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl2 = new AccessControlEntry(user.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set acls = (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.changeAclAndVerify$default$4());
        RequestContext host1Context = this.newRequestContext(customUserPrincipal, host1, ApiKeys.PRODUCE);
        RequestContext host2Context = this.newRequestContext(customUserPrincipal, host2, ApiKeys.PRODUCE);
        Assert.assertTrue((String)"User1 should have READ access from host2", (boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.READ, this.resource()));
        Assert.assertFalse((String)"User1 should not have READ access from host1 due to denyAcl", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDenyTakesPrecedence() {
        void apply_elems;
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.2.1");
        RequestContext session = this.newRequestContext(user, host, ApiKeys.PRODUCE);
        AccessControlEntry allowAll = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        AccessControlEntry denyAcl = new AccessControlEntry(user.toString(), host.getHostAddress(), AclOperation.ALL, AclPermissionType.DENY);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAll, denyAcl});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set acls = (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.changeAclAndVerify$default$4());
        Assert.assertFalse((String)"deny should take precedence over allow.", (boolean)this.authorize(this.aclAuthorizer(), session, AclOperation.READ, this.resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAllowAllAccess() {
        void apply_elems;
        AccessControlEntry allowAllAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAllAcl});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.changeAclAndVerify$default$4());
        RequestContext context = this.newRequestContext(new KafkaPrincipal("User", "random"), InetAddress.getByName("192.0.4.4"), ApiKeys.PRODUCE);
        Assert.assertTrue((String)"allow all acl should allow access to all.", (boolean)this.authorize(this.aclAuthorizer(), context, AclOperation.READ, this.resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuperUserHasAccess() {
        void apply_elems;
        AccessControlEntry denyAllAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.DENY);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.changeAclAndVerify$default$4());
        RequestContext session1 = this.newRequestContext(new KafkaPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), ApiKeys.PRODUCE);
        RequestContext session2 = this.newRequestContext(new KafkaPrincipal("User", "superuser2"), InetAddress.getByName("192.0.4.4"), ApiKeys.PRODUCE);
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.authorize(this.aclAuthorizer(), session1, AclOperation.READ, this.resource()));
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.authorize(this.aclAuthorizer(), session2, AclOperation.READ, this.resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuperUserWithCustomPrincipalHasAccess() {
        void apply_elems;
        AccessControlEntry denyAllAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.DENY);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.changeAclAndVerify$default$4());
        RequestContext session = this.newRequestContext(new CustomPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), ApiKeys.PRODUCE);
        Assert.assertTrue((String)"superuser with custom principal always has access, no matter what acls.", (boolean)this.authorize(this.aclAuthorizer(), session, AclOperation.READ, this.resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWildCardAcls() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        Assert.assertFalse((String)"when acls = [], authorizer should fail close.", (boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        AccessControlEntry readAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{readAcl});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Set<AccessControlEntry> acls = this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems3)), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.wildCardResource());
        RequestContext host1Context = this.newRequestContext(user1, host1, ApiKeys.PRODUCE);
        Assert.assertTrue((String)"User1 should have READ access from host1", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()));
        AccessControlEntry writeAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{writeAcl});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems2)), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.changeAclAndVerify$default$4());
        AccessControlEntry denyWriteOnWildCardResourceAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyWriteOnWildCardResourceAcl});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems)), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.wildCardResource());
        Assert.assertFalse((String)"User1 should not have WRITE access from host1", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.WRITE, this.resource()));
    }

    @Test
    public void testNoAclFound() {
        Assert.assertFalse((String)"when acls = [], authorizer should deny op.", (boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testNoAclFoundOverride() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(AclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp(), "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (AclAuthorizer testAuthorizer = new AclAuthorizer();){
            testAuthorizer.configure(cfg.originals());
            Assert.assertTrue((String)"when acls = null or [],  authorizer should allow op with allow.everyone = true.", (boolean)this.authorize(testAuthorizer, this.requestContext(), AclOperation.READ, this.resource()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclManagementAPIs() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void $minus$greater$extension_y;
        void apply_elems4;
        void $minus$greater$extension_y2;
        void apply_elems5;
        void apply_elems6;
        void apply_elems7;
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        String host1 = "host1";
        String host2 = "host2";
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host1, AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user2.toString(), host2, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl4 = new AccessControlEntry(user2.toString(), host2, AclOperation.WRITE, AclPermissionType.ALLOW);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Set<AccessControlEntry> acls = this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems7)), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.changeAclAndVerify$default$4());
        AccessControlEntry acl5 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl5});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        acls = this.changeAclAndVerify(acls, (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems6)), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.changeAclAndVerify$default$4());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testAclManagementAPIs$1(this, acl1, acl2, user1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("changes not propagated in timeout period", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testAclManagementAPIs$4(this, acl3, acl4, acl5, user2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                throw Assertions$.MODULE$.fail("changes not propagated in timeout period", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs2, (long)waitUntilTrue_pause));
        }
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[4];
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW)});
        if (set$3 == null) {
            throw null;
        }
        Set$ apply_this = set$3;
        Object var22_20 = null;
        arraySeq3 = null;
        Object object = IterableFactory.apply$((IterableFactory)apply_this, (scala.collection.immutable.Seq)apply_elems5);
        ResourcePattern $minus$greater$extension_$this = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
        Object var13_22 = null;
        object = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW)});
        if (set$4 == null) {
            throw null;
        }
        Set$ apply_this2 = set$4;
        Object var24_24 = null;
        arraySeq4 = null;
        Object object2 = IterableFactory.apply$((IterableFactory)apply_this2, (scala.collection.immutable.Seq)apply_elems4);
        ResourcePattern $minus$greater$extension_$this2 = new ResourcePattern(ResourceType.CLUSTER, "*", PatternType.LITERAL);
        Object var15_26 = null;
        object2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        ResourcePattern ArrowAssoc_self = new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL);
        Object var47_27 = null;
        ResourcePattern $minus$greater$extension_$this3 = ArrowAssoc_self;
        Object var17_28 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, acls);
        ResourcePattern ArrowAssoc_self2 = new ResourcePattern(ResourceType.GROUP, "test-ConsumerGroup", PatternType.LITERAL);
        Object var48_29 = null;
        ResourcePattern $minus$greater$extension_$this4 = ArrowAssoc_self2;
        Object var18_30 = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, acls);
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq5 = null;
        scala.collection.immutable.Map resourceToAcls = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems3);
        resourceToAcls.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ResourcePattern key = (ResourcePattern)x0$1._1();
                Set value = (Set)x0$1._2();
                if (Predef$.MODULE$.Set() == null) {
                    throw null;
                }
                if (Predef$.MODULE$.Set() == null) {
                    throw null;
                }
                return this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)value, (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, key);
            }
            throw new MatchError(null);
        });
        ResourcePattern ArrowAssoc_self3 = this.resource();
        Object var49_33 = null;
        ResourcePattern $minus$greater$extension_$this5 = ArrowAssoc_self3;
        Object var19_34 = null;
        Set expectedAcls = ((IterableOnceOps)resourceToAcls.$plus(new Tuple2((Object)$minus$greater$extension_$this5, acls)).flatMap((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                ResourcePattern res = (ResourcePattern)x0$2._1();
                return (Set)((Set)x0$2._2()).map((Function1 & Serializable)acl -> new AclBinding(res, acl));
            }
            throw new MatchError(null);
        })).toSet();
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testAclManagementAPIs$10(this, expectedAcls)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                throw Assertions$.MODULE$.fail("changes not propagated in timeout period.", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs3, (long)waitUntilTrue_pause));
        }
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Set$ set$5 = Predef$.MODULE$.Set();
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl5});
        if (set$5 == null) {
            throw null;
        }
        arraySeq6 = null;
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$5, (scala.collection.immutable.Seq)apply_elems2)), this.changeAclAndVerify$default$4());
        acls = null;
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.resource());
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Authorizer)this.aclAuthorizer(), this.resource(), AccessControlEntryFilter.ANY);
        Assert.assertTrue((!this.zkClient().resourceExists(this.resource()) ? 1 : 0) != 0);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Set$ set$6 = Predef$.MODULE$.Set();
        ArraySeq arraySeq7 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1});
        if (set$6 == null) {
            throw null;
        }
        arraySeq7 = null;
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        acls = this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$6, (scala.collection.immutable.Seq)apply_elems)), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.changeAclAndVerify$default$4());
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, acls, this.changeAclAndVerify$default$4());
        Assert.assertTrue((!this.zkClient().resourceExists(this.resource()) ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLoadCache() {
        void apply_elems;
        void apply_elems2;
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), "host-1", AclOperation.READ, AclPermissionType.ALLOW);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set acls = (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.resource());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, "test-2", PatternType.LITERAL);
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), "host3", AclOperation.READ, AclPermissionType.DENY);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Set acls1 = (Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)acls1, resource1);
        this.zkClient().deleteAclChangeNotifications();
        try (AclAuthorizer authorizer = new AclAuthorizer();){
            authorizer.configure(this.config().originals());
            Assert.assertEquals((Object)acls, this.getAcls(authorizer, this.resource()));
            Assert.assertEquals((Object)acls1, this.getAcls(authorizer, resource1));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testChangeListenerTiming() {
        Semaphore configureSemaphore = new Semaphore(0);
        Semaphore listenerSemaphore = new Semaphore(0);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AclAuthorizer aclAuthorizer3 = new AclAuthorizer(null, configureSemaphore, listenerSemaphore){
            private final Semaphore configureSemaphore$1;
            private final Semaphore listenerSemaphore$1;

            public void startZkChangeListeners() {
                this.configureSemaphore$1.release();
                this.listenerSemaphore$1.acquireUninterruptibly();
                super.startZkChangeListeners();
            }
            {
                this.configureSemaphore$1 = configureSemaphore$1;
                this.listenerSemaphore$1 = listenerSemaphore$1;
            }
        };
        try {
            void apply_elems;
            Future<?> future = executor.submit(() -> aclAuthorizer3.configure(this.config().originals()));
            configureSemaphore.acquire();
            KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user1.toString(), "host-1", AclOperation.READ, AclPermissionType.DENY)});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            Set acls = (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
            this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.resource());
            listenerSemaphore.release();
            future.get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)acls, this.getAcls(aclAuthorizer3, this.resource()));
        }
        finally {
            aclAuthorizer3.close();
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLocalConcurrentModificationOfResourceAcls() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems3)), commonResource);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems2)), commonResource);
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems)), (Authorizer)this.aclAuthorizer(), commonResource, AccessControlEntryFilter.ANY);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDistributedConcurrentModificationOfResourceAcls() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        void apply_elems5;
        void apply_elems6;
        void apply_elems7;
        void apply_elems8;
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems8)), commonResource);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.addAcls(this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems7)), commonResource);
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems6)), (Authorizer)this.aclAuthorizer(), commonResource, AccessControlEntryFilter.ANY);
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2});
        if (set$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$4, (scala.collection.immutable.Seq)apply_elems5)), (Authorizer)this.aclAuthorizer2(), commonResource, AccessControlEntryFilter.ANY);
        KafkaPrincipal user3 = new KafkaPrincipal("User", "joe");
        AccessControlEntry acl3 = new AccessControlEntry(user3.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        Set$ set$5 = Predef$.MODULE$.Set();
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3});
        if (set$5 == null) {
            throw null;
        }
        arraySeq5 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$5, (scala.collection.immutable.Seq)apply_elems4)), commonResource);
        Set$ set$6 = Predef$.MODULE$.Set();
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3});
        if (set$6 == null) {
            throw null;
        }
        arraySeq6 = null;
        boolean deleted = this.removeAcls(this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$6, (scala.collection.immutable.Seq)apply_elems3)), commonResource);
        Assert.assertTrue((String)"The authorizer should see a value that needs to be deleted", (boolean)deleted);
        Set$ set$7 = Predef$.MODULE$.Set();
        ArraySeq arraySeq7 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2});
        if (set$7 == null) {
            throw null;
        }
        arraySeq7 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$7, (scala.collection.immutable.Seq)apply_elems2)), (Authorizer)this.aclAuthorizer(), commonResource, AccessControlEntryFilter.ANY);
        Set$ set$8 = Predef$.MODULE$.Set();
        ArraySeq arraySeq8 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2});
        if (set$8 == null) {
            throw null;
        }
        arraySeq8 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$8, (scala.collection.immutable.Seq)apply_elems)), (Authorizer)this.aclAuthorizer2(), commonResource, AccessControlEntryFilter.ANY);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighConcurrencyModificationOfResourceAcls() {
        Tuple2 tuple2;
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        int n = 0;
        int to$extension_end = 50;
        Range.Inclusive map_this = new Range.Inclusive(n, to$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            tuple2 = AclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$1(BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next()));
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            tuple2 = null;
        }
        Object var6_4 = null;
        Object var7_5 = null;
        Object var8_6 = null;
        tuple2 = null;
        IndexedSeq acls = (IndexedSeq)map_strictOptimizedMap_b.result();
        IndexedSeq concurrentFuctions = (IndexedSeq)acls.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                AccessControlEntry acl = (AccessControlEntry)x0$1._1();
                int aclId = x0$1._2$mcI$sp();
                return (Function0 & Serializable)() -> {
                    if (aclId % 2 == 0) {
                        void apply_elems;
                        Set$ set$ = Predef$.MODULE$.Set();
                        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl});
                        if (set$ == null) {
                            throw null;
                        }
                        arraySeq = null;
                        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), commonResource);
                    } else {
                        void apply_elems;
                        Set$ set$ = Predef$.MODULE$.Set();
                        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl});
                        if (set$ == null) {
                            throw null;
                        }
                        arraySeq = null;
                        this.addAcls(this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), commonResource);
                    }
                    if (aclId % 10 == 0) {
                        void apply_elems;
                        Set$ set$ = Predef$.MODULE$.Set();
                        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl});
                        if (set$ == null) {
                            throw null;
                        }
                        arraySeq = null;
                        return this.removeAcls(this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), commonResource);
                    }
                    return BoxedUnit.UNIT;
                };
            }
            throw new MatchError(null);
        });
        Set expectedAcls = ((IterableOnceOps)((IndexedSeqOps)acls.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$4(x0$2)))).map((Function1 & Serializable)x$4 -> (AccessControlEntry)x$4._1())).toSet();
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)expectedAcls, (Authorizer)this.aclAuthorizer(), commonResource, AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)expectedAcls, (Authorizer)this.aclAuthorizer2(), commonResource, AccessControlEntryFilter.ANY);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclInheritance() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        void apply_elems5;
        void apply_elems6;
        void apply_elems7;
        void apply_elems8;
        void apply_elems9;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.testImplicationsOfAllow(AclOperation.ALL, (Set<AclOperation>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems9)));
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.testImplicationsOfDeny(AclOperation.ALL, (Set<AclOperation>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems8)));
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        this.testImplicationsOfAllow(AclOperation.READ, (Set<AclOperation>)((Set)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems7)));
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE});
        if (set$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        this.testImplicationsOfAllow(AclOperation.WRITE, (Set<AclOperation>)((Set)IterableFactory.apply$((IterableFactory)set$4, (scala.collection.immutable.Seq)apply_elems6)));
        Set$ set$5 = Predef$.MODULE$.Set();
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE});
        if (set$5 == null) {
            throw null;
        }
        arraySeq5 = null;
        this.testImplicationsOfAllow(AclOperation.DELETE, (Set<AclOperation>)((Set)IterableFactory.apply$((IterableFactory)set$5, (scala.collection.immutable.Seq)apply_elems5)));
        Set$ set$6 = Predef$.MODULE$.Set();
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE});
        if (set$6 == null) {
            throw null;
        }
        arraySeq6 = null;
        this.testImplicationsOfAllow(AclOperation.ALTER, (Set<AclOperation>)((Set)IterableFactory.apply$((IterableFactory)set$6, (scala.collection.immutable.Seq)apply_elems4)));
        Set$ set$7 = Predef$.MODULE$.Set();
        Nil$ nil$ = Nil$.MODULE$;
        if (set$7 == null) {
            throw null;
        }
        nil$ = null;
        this.testImplicationsOfDeny(AclOperation.DESCRIBE, (Set<AclOperation>)((Set)IterableFactory.apply$((IterableFactory)set$7, (scala.collection.immutable.Seq)apply_elems3)));
        Set$ set$8 = Predef$.MODULE$.Set();
        ArraySeq arraySeq7 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE_CONFIGS});
        if (set$8 == null) {
            throw null;
        }
        arraySeq7 = null;
        this.testImplicationsOfAllow(AclOperation.ALTER_CONFIGS, (Set<AclOperation>)((Set)IterableFactory.apply$((IterableFactory)set$8, (scala.collection.immutable.Seq)apply_elems2)));
        Set$ set$9 = Predef$.MODULE$.Set();
        Nil$ nil$2 = Nil$.MODULE$;
        if (set$9 == null) {
            throw null;
        }
        nil$2 = null;
        this.testImplicationsOfDeny(AclOperation.DESCRIBE_CONFIGS, (Set<AclOperation>)((Set)IterableFactory.apply$((IterableFactory)set$9, (scala.collection.immutable.Seq)apply_elems)));
    }

    /*
     * WARNING - void declaration
     */
    private void testImplicationsOfAllow(AclOperation parentOp, Set<AclOperation> allowedOps) {
        void apply_elems;
        Object object;
        void apply_elems2;
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.3.1");
        RequestContext hostContext = this.newRequestContext(user, host, ApiKeys.PRODUCE);
        AccessControlEntry acl = new AccessControlEntry(user.toString(), AclEntry$.MODULE$.WildcardHost(), parentOp, AclPermissionType.ALLOW);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2)), this.clusterResource());
        AclOperation[] refArrayOps_xs = AclOperation.values();
        Object var7_8 = null;
        AclOperation[] filter$extension_$this = refArrayOps_xs;
        ClassTag filter$extension_make_evidence$1 = ClassTag$.MODULE$.apply(filter$extension_$this.getClass().getComponentType());
        Class clazz = filter$extension_make_evidence$1.runtimeClass();
        Class<Byte> clazz2 = Byte.TYPE;
        if (!(clazz2 != null ? !clazz2.equals(clazz) : clazz != null)) {
            object = new ArrayBuilder.ofByte();
        } else {
            Class<Short> clazz3 = Short.TYPE;
            if (!(clazz3 != null ? !clazz3.equals(clazz) : clazz != null)) {
                object = new ArrayBuilder.ofShort();
            } else {
                Class<Character> clazz4 = Character.TYPE;
                if (!(clazz4 != null ? !clazz4.equals(clazz) : clazz != null)) {
                    object = new ArrayBuilder.ofChar();
                } else {
                    Class<Integer> clazz5 = Integer.TYPE;
                    if (!(clazz5 != null ? !clazz5.equals(clazz) : clazz != null)) {
                        object = new ArrayBuilder.ofInt();
                    } else {
                        Class<Long> clazz6 = Long.TYPE;
                        if (!(clazz6 != null ? !clazz6.equals(clazz) : clazz != null)) {
                            object = new ArrayBuilder.ofLong();
                        } else {
                            Class<Float> clazz7 = Float.TYPE;
                            if (!(clazz7 != null ? !clazz7.equals(clazz) : clazz != null)) {
                                object = new ArrayBuilder.ofFloat();
                            } else {
                                Class<Double> clazz8 = Double.TYPE;
                                if (!(clazz8 != null ? !clazz8.equals(clazz) : clazz != null)) {
                                    object = new ArrayBuilder.ofDouble();
                                } else {
                                    Class<Boolean> clazz9 = Boolean.TYPE;
                                    if (!(clazz9 != null ? !clazz9.equals(clazz) : clazz != null)) {
                                        object = new ArrayBuilder.ofBoolean();
                                    } else {
                                        Class<Void> clazz10 = Void.TYPE;
                                        object = !(clazz10 != null ? !clazz10.equals(clazz) : clazz != null) ? new ArrayBuilder.ofUnit() : new ArrayBuilder.ofRef(filter$extension_make_evidence$1);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        Object var14_10 = null;
        clazz = null;
        ArrayBuilder.ofByte filter$extension_res = object;
        for (int filter$extension_i = 0; filter$extension_i < filter$extension_$this.length; ++filter$extension_i) {
            AclOperation filter$extension_x = filter$extension_$this[filter$extension_i];
            if (!this.validOp(filter$extension_x)) continue;
            filter$extension_res.addOne((Object)filter$extension_x);
        }
        Object var10_9 = null;
        Object var11_12 = null;
        Object var13_14 = null;
        Object[] foreach$extension_$this = (Object[])filter$extension_res.result();
        int foreach$extension_len = foreach$extension_$this.length;
        for (int foreach$extension_i = 0; foreach$extension_i < foreach$extension_len; ++foreach$extension_i) {
            AclOperation aclOperation = (AclOperation)foreach$extension_$this[foreach$extension_i];
            AclAuthorizerTest.$anonfun$testImplicationsOfAllow$2(this, hostContext, allowedOps, parentOp, aclOperation);
        }
        Object var16_15 = null;
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems)), this.clusterResource());
    }

    /*
     * WARNING - void declaration
     */
    private void testImplicationsOfDeny(AclOperation parentOp, Set<AclOperation> deniedOps) {
        Object object;
        void apply_elems;
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        RequestContext host1Context = this.newRequestContext(user1, host1, ApiKeys.PRODUCE);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), parentOp, AclPermissionType.DENY), new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set acls = (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.clusterResource());
        AclOperation[] refArrayOps_xs = AclOperation.values();
        Object var7_8 = null;
        AclOperation[] filter$extension_$this = refArrayOps_xs;
        ClassTag filter$extension_make_evidence$1 = ClassTag$.MODULE$.apply(filter$extension_$this.getClass().getComponentType());
        Class clazz = filter$extension_make_evidence$1.runtimeClass();
        Class<Byte> clazz2 = Byte.TYPE;
        if (!(clazz2 != null ? !clazz2.equals(clazz) : clazz != null)) {
            object = new ArrayBuilder.ofByte();
        } else {
            Class<Short> clazz3 = Short.TYPE;
            if (!(clazz3 != null ? !clazz3.equals(clazz) : clazz != null)) {
                object = new ArrayBuilder.ofShort();
            } else {
                Class<Character> clazz4 = Character.TYPE;
                if (!(clazz4 != null ? !clazz4.equals(clazz) : clazz != null)) {
                    object = new ArrayBuilder.ofChar();
                } else {
                    Class<Integer> clazz5 = Integer.TYPE;
                    if (!(clazz5 != null ? !clazz5.equals(clazz) : clazz != null)) {
                        object = new ArrayBuilder.ofInt();
                    } else {
                        Class<Long> clazz6 = Long.TYPE;
                        if (!(clazz6 != null ? !clazz6.equals(clazz) : clazz != null)) {
                            object = new ArrayBuilder.ofLong();
                        } else {
                            Class<Float> clazz7 = Float.TYPE;
                            if (!(clazz7 != null ? !clazz7.equals(clazz) : clazz != null)) {
                                object = new ArrayBuilder.ofFloat();
                            } else {
                                Class<Double> clazz8 = Double.TYPE;
                                if (!(clazz8 != null ? !clazz8.equals(clazz) : clazz != null)) {
                                    object = new ArrayBuilder.ofDouble();
                                } else {
                                    Class<Boolean> clazz9 = Boolean.TYPE;
                                    if (!(clazz9 != null ? !clazz9.equals(clazz) : clazz != null)) {
                                        object = new ArrayBuilder.ofBoolean();
                                    } else {
                                        Class<Void> clazz10 = Void.TYPE;
                                        object = !(clazz10 != null ? !clazz10.equals(clazz) : clazz != null) ? new ArrayBuilder.ofUnit() : new ArrayBuilder.ofRef(filter$extension_make_evidence$1);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        Object var13_10 = null;
        clazz = null;
        ArrayBuilder.ofByte filter$extension_res = object;
        for (int filter$extension_i = 0; filter$extension_i < filter$extension_$this.length; ++filter$extension_i) {
            AclOperation filter$extension_x = filter$extension_$this[filter$extension_i];
            if (!this.validOp(filter$extension_x)) continue;
            filter$extension_res.addOne((Object)filter$extension_x);
        }
        Object var9_9 = null;
        Object var10_12 = null;
        Object var12_14 = null;
        Object[] foreach$extension_$this = (Object[])filter$extension_res.result();
        int foreach$extension_len = foreach$extension_$this.length;
        for (int foreach$extension_i = 0; foreach$extension_i < foreach$extension_len; ++foreach$extension_i) {
            AclOperation aclOperation = (AclOperation)foreach$extension_$this[foreach$extension_i];
            AclAuthorizerTest.$anonfun$testImplicationsOfDeny$2(this, host1Context, deniedOps, parentOp, aclOperation);
        }
        Object var15_15 = null;
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.clusterResource());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighConcurrencyDeletionOfResourceAcls() {
        Function0 function0;
        AccessControlEntry acl = new AccessControlEntry(new KafkaPrincipal("User", this.username()).toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        int n = 0;
        int to$extension_end = 50;
        Range.Inclusive map_this = new Range.Inclusive(n, to$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            function0 = AclAuthorizerTest.$anonfun$testHighConcurrencyDeletionOfResourceAcls$1(this, acl, BoxesRunTime.unboxToInt((Object)object));
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            function0 = null;
        }
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        function0 = null;
        IndexedSeq concurrentFuctions = (IndexedSeq)map_strictOptimizedMap_b.result();
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Authorizer)this.aclAuthorizer(), this.resource(), AccessControlEntryFilter.ANY);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Authorizer)this.aclAuthorizer2(), this.resource(), AccessControlEntryFilter.ANY);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAccessAllowedIfAllowAclExistsOnWildcardResource() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), this.wildCardResource());
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteAclOnWildcardResource() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems3)), this.wildCardResource());
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems2)), this.wildCardResource());
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteAllAclOnWildcardResource() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), this.wildCardResource());
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.wildCardResource());
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, this.getAcls(this.aclAuthorizer()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAccessAllowedIfAllowAclExistsOnPrefixedResource() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), this.prefixedResource());
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteAclOnPrefixedResource() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems3)), this.prefixedResource());
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems2)), this.prefixedResource());
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteAllAclOnPrefixedResource() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), this.prefixedResource());
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.prefixedResource());
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, this.getAcls(this.aclAuthorizer()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddAclsOnLiteralResource() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems3)), this.resource());
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems2)), this.resource());
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems), this.getAcls(this.aclAuthorizer(), this.resource()));
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddAclsOnWildcardResource() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems3)), this.wildCardResource());
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems2)), this.wildCardResource());
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, this.getAcls(this.aclAuthorizer(), this.resource()));
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddAclsOnPrefixedResource() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems3)), this.prefixedResource());
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems2)), this.prefixedResource());
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, this.getAcls(this.aclAuthorizer(), this.resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAuthorizeWithPrefixedResource() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        void apply_elems5;
        void apply_elems6;
        void apply_elems7;
        void apply_elems8;
        void apply_elems9;
        void apply_elems10;
        void apply_elems11;
        void apply_elems12;
        void apply_elems13;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems13)), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.LITERAL));
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems12)), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.PREFIXED));
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems11)), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$4, (scala.collection.immutable.Seq)apply_elems10)), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        Set$ set$5 = Predef$.MODULE$.Set();
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$5 == null) {
            throw null;
        }
        arraySeq5 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$5, (scala.collection.immutable.Seq)apply_elems9)), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(8).append("foo-").append(UUID.randomUUID()).append("-zzz").toString(), PatternType.PREFIXED));
        Set$ set$6 = Predef$.MODULE$.Set();
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$6 == null) {
            throw null;
        }
        arraySeq6 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$6, (scala.collection.immutable.Seq)apply_elems8)), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(5).append("fooo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        Set$ set$7 = Predef$.MODULE$.Set();
        ArraySeq arraySeq7 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$7 == null) {
            throw null;
        }
        arraySeq7 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$7, (scala.collection.immutable.Seq)apply_elems7)), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("fo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        Set$ set$8 = Predef$.MODULE$.Set();
        ArraySeq arraySeq8 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$8 == null) {
            throw null;
        }
        arraySeq8 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$8, (scala.collection.immutable.Seq)apply_elems6)), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("fop-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        Set$ set$9 = Predef$.MODULE$.Set();
        ArraySeq arraySeq9 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$9 == null) {
            throw null;
        }
        arraySeq9 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$9, (scala.collection.immutable.Seq)apply_elems5)), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("fon-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        Set$ set$10 = Predef$.MODULE$.Set();
        ArraySeq arraySeq10 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$10 == null) {
            throw null;
        }
        arraySeq10 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$10, (scala.collection.immutable.Seq)apply_elems4)), new ResourcePattern(ResourceType.TOPIC, "fon-", PatternType.PREFIXED));
        Set$ set$11 = Predef$.MODULE$.Set();
        ArraySeq arraySeq11 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$11 == null) {
            throw null;
        }
        arraySeq11 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$11, (scala.collection.immutable.Seq)apply_elems3)), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED));
        Set$ set$12 = Predef$.MODULE$.Set();
        ArraySeq arraySeq12 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$12 == null) {
            throw null;
        }
        arraySeq12 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$12, (scala.collection.immutable.Seq)apply_elems2)), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL));
        Set$ set$13 = Predef$.MODULE$.Set();
        ArraySeq arraySeq13 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()});
        if (set$13 == null) {
            throw null;
        }
        arraySeq13 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$13, (scala.collection.immutable.Seq)apply_elems)), this.prefixedResource());
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSingleCharacterResourceAcls() {
        void apply_elems;
        void apply_elems2;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2)), new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL));
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL)));
        Assert.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL)));
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems)), new ResourcePattern(ResourceType.TOPIC, "_", PatternType.PREFIXED));
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_foo", PatternType.LITERAL)));
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_", PatternType.LITERAL)));
        Assert.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo_", PatternType.LITERAL)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetAclsPrincipal() {
        void apply_elems;
        void apply_elems2;
        AccessControlEntry aclOnSpecificPrincipal = new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnSpecificPrincipal});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2)), this.resource());
        Assert.assertEquals((String)"acl on specific should not be returned for wildcard request", (long)0L, (long)this.getAcls(this.aclAuthorizer(), this.wildcardPrincipal()).size());
        Assert.assertEquals((String)"acl on specific should be returned for specific request", (long)1L, (long)this.getAcls(this.aclAuthorizer(), this.principal()).size());
        Assert.assertEquals((String)"acl on specific should be returned for different principal instance", (long)1L, (long)this.getAcls(this.aclAuthorizer(), new KafkaPrincipal(this.principal().getPrincipalType(), this.principal().getName())).size());
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.resource());
        AccessControlEntry aclOnWildcardPrincipal = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnWildcardPrincipal});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems)), this.resource());
        Assert.assertEquals((String)"acl on wildcard should be returned for wildcard request", (long)1L, (long)this.getAcls(this.aclAuthorizer(), this.wildcardPrincipal()).size());
        Assert.assertEquals((String)"acl on wildcard should not be returned for specific request", (long)0L, (long)this.getAcls(this.aclAuthorizer(), this.principal()).size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclsFilter() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        void apply_elems5;
        void apply_elems6;
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        AclBinding acl1 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding acl2 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW));
        AclBinding acl3 = new AclBinding(resource2, new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding acl4 = new AclBinding(prefixedResource, new AccessControlEntry(this.wildcardPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        this.aclAuthorizer().createAcls((AuthorizableRequestContext)this.requestContext(), AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)acl1, (List)new .colon.colon((Object)acl2, (List)new .colon.colon((Object)acl3, (List)new .colon.colon((Object)acl4, (List)Nil$.MODULE$))))).asJava());
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2, acl3, acl4});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems6), (Object)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)this.aclAuthorizer().acls(AclBindingFilter.ANY)).asScala().toSet());
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems5), (Object)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)this.aclAuthorizer().acls(new AclBindingFilter(resource1.toFilter(), AccessControlEntryFilter.ANY))).asScala().toSet());
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl4});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems4), (Object)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)this.aclAuthorizer().acls(new AclBindingFilter(prefixedResource.toFilter(), AccessControlEntryFilter.ANY))).asScala().toSet());
        AclBindingFilter matchingFilter = new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, resource2.name(), PatternType.MATCH), AccessControlEntryFilter.ANY);
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4});
        if (set$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$4, (scala.collection.immutable.Seq)apply_elems3), (Object)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)this.aclAuthorizer().acls(matchingFilter)).asScala().toSet());
        .colon.colon filters = new .colon.colon((Object)matchingFilter, (List)new .colon.colon((Object)acl1.toFilter(), (List)new .colon.colon((Object)new AclBindingFilter(resource2.toFilter(), AccessControlEntryFilter.ANY), (List)new .colon.colon((Object)new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "baz", PatternType.ANY), AccessControlEntryFilter.ANY), (List)Nil$.MODULE$))));
        Buffer deleteResults = (Buffer)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)this.aclAuthorizer().deleteAcls((AuthorizableRequestContext)this.requestContext(), AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)filters).asJava())).asScala().map((Function1 & Serializable)x$6 -> (AclDeleteResult)x$6.toCompletableFuture().get());
        if (package$.MODULE$.List() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)deleteResults.filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testAclsFilter$2(x$7))));
        Range range = filters.indices();
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                AclAuthorizerTest.$anonfun$testAclsFilter$3(deleteResults, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var17_15 = null;
        Set$ set$5 = Predef$.MODULE$.Set();
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4});
        if (set$5 == null) {
            throw null;
        }
        arraySeq5 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$5, (scala.collection.immutable.Seq)apply_elems2), (Object)((IterableOnceOps)AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Collection)((AclDeleteResult)deleteResults.apply(0)).aclBindingDeleteResults()).asScala().map((Function1 & Serializable)x$9 -> x$9.aclBinding())).toSet());
        Set$ set$6 = Predef$.MODULE$.Set();
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1});
        if (set$6 == null) {
            throw null;
        }
        arraySeq6 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$6, (scala.collection.immutable.Seq)apply_elems), (Object)((IterableOnceOps)AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Collection)((AclDeleteResult)deleteResults.apply(1)).aclBindingDeleteResults()).asScala().map((Function1 & Serializable)x$10 -> x$10.aclBinding())).toSet());
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, (Object)((IterableOnceOps)AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Collection)((AclDeleteResult)deleteResults.apply(2)).aclBindingDeleteResults()).asScala().map((Function1 & Serializable)x$11 -> x$11.aclBinding())).toSet());
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, (Object)((IterableOnceOps)AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Collection)((AclDeleteResult)deleteResults.apply(3)).aclBindingDeleteResults()).asScala().map((Function1 & Serializable)x$12 -> x$12.aclBinding())).toSet());
    }

    @Test
    public void testThrowsOnAddPrefixedAclIfInterBrokerProtocolVersionTooLow() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        ApiException e = (ApiException)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED));
        }, ClassTag$.MODULE$.apply(ApiException.class), new Position("AclAuthorizerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 729));
        Assert.assertTrue((String)new StringBuilder(21).append("Unexpected exception ").append(e).toString(), (boolean)(e.getCause() instanceof UnsupportedVersionException));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWritesExtendedAclChangeEventIfInterBrokerProtocolNotSet() {
        void apply_elems;
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)None$.MODULE$);
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWritesExtendedAclChangeEventWhenInterBrokerProtocolAtLeastKafkaV2() {
        void apply_elems;
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWritesLiteralWritesLiteralAclChangeEventWhenInterBrokerProtocolLessThanKafkaV2eralAclChangesForOlderProtocolVersions() {
        void apply_elems;
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWritesLiteralAclChangeEventWhenInterBrokerProtocolIsKafkaV2() {
        void apply_elems;
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAuthorizerNoZkConfig() {
        Properties noTlsProps = Kafka$.MODULE$.getPropsFromArgs(new String[]{this.prepareDefaultConfig()});
        Assert.assertEquals((Object)None$.MODULE$, (Object)AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(noTlsProps), (scala.collection.mutable.Map)Map$.MODULE$.apply(AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Map)noTlsProps).asScala().toSeq())));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAuthorizerZkConfigFromKafkaConfigWithDefaults() {
        void apply_elems;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        Properties props = new Properties();
        String kafkaValue = "kafkaValue";
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[11];
        String string = "somewhere";
        String $minus$greater$extension_$this = "zookeeper.connect";
        Object var5_4 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        String string2 = "true";
        String $minus$greater$extension_$this2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        Object var7_6 = null;
        string2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        String ArrowAssoc_self = KafkaConfig$.MODULE$.ZkClientCnxnSocketProp();
        Object var19_7 = null;
        String $minus$greater$extension_$this3 = ArrowAssoc_self;
        Object var9_8 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)kafkaValue);
        String ArrowAssoc_self2 = KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp();
        Object var20_9 = null;
        String $minus$greater$extension_$this4 = ArrowAssoc_self2;
        Object var10_10 = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)kafkaValue);
        String ArrowAssoc_self3 = KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp();
        Object var21_11 = null;
        String $minus$greater$extension_$this5 = ArrowAssoc_self3;
        Object var11_12 = null;
        objectArray[4] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)kafkaValue);
        String ArrowAssoc_self4 = KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp();
        Object var22_13 = null;
        String $minus$greater$extension_$this6 = ArrowAssoc_self4;
        Object var12_14 = null;
        objectArray[5] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)kafkaValue);
        String ArrowAssoc_self5 = KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp();
        Object var23_15 = null;
        String $minus$greater$extension_$this7 = ArrowAssoc_self5;
        Object var13_16 = null;
        objectArray[6] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)kafkaValue);
        String ArrowAssoc_self6 = KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp();
        Object var24_17 = null;
        String $minus$greater$extension_$this8 = ArrowAssoc_self6;
        Object var14_18 = null;
        objectArray[7] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)kafkaValue);
        String ArrowAssoc_self7 = KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp();
        Object var25_19 = null;
        String $minus$greater$extension_$this9 = ArrowAssoc_self7;
        Object var15_20 = null;
        objectArray[8] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)kafkaValue);
        String ArrowAssoc_self8 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
        Object var26_21 = null;
        String $minus$greater$extension_$this10 = ArrowAssoc_self8;
        Object var16_22 = null;
        objectArray[9] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)kafkaValue);
        String ArrowAssoc_self9 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
        Object var27_23 = null;
        String $minus$greater$extension_$this11 = ArrowAssoc_self9;
        Object var17_24 = null;
        objectArray[10] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)kafkaValue);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        configs.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String key = (String)x0$1._1();
                String value = (String)x0$1._2();
                return props.put(key, value.toString());
            }
            throw new MatchError(null);
        });
        Option zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(props), (scala.collection.mutable.Map)Map$.MODULE$.apply(configs.toSeq()));
        Assert.assertTrue((boolean)zkClientConfig.isDefined());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)prop -> {
            AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$2(zkClientConfig, kafkaValue, prop);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAuthorizerZkConfigFromKafkaConfig() {
        void apply_elems;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        Properties props = new Properties();
        String kafkaValue = "kafkaValue";
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[15];
        String string = "somewhere";
        String $minus$greater$extension_$this = "zookeeper.connect";
        Object var5_4 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y5);
        String string2 = "true";
        String $minus$greater$extension_$this2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        Object var7_6 = null;
        string2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y4);
        String ArrowAssoc_self = KafkaConfig$.MODULE$.ZkClientCnxnSocketProp();
        Object var26_7 = null;
        String $minus$greater$extension_$this3 = ArrowAssoc_self;
        Object var9_8 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)kafkaValue);
        String ArrowAssoc_self2 = KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp();
        Object var27_9 = null;
        String $minus$greater$extension_$this4 = ArrowAssoc_self2;
        Object var10_10 = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)kafkaValue);
        String ArrowAssoc_self3 = KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp();
        Object var28_11 = null;
        String $minus$greater$extension_$this5 = ArrowAssoc_self3;
        Object var11_12 = null;
        objectArray[4] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)kafkaValue);
        String ArrowAssoc_self4 = KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp();
        Object var29_13 = null;
        String $minus$greater$extension_$this6 = ArrowAssoc_self4;
        Object var12_14 = null;
        objectArray[5] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)kafkaValue);
        String ArrowAssoc_self5 = KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp();
        Object var30_15 = null;
        String $minus$greater$extension_$this7 = ArrowAssoc_self5;
        Object var13_16 = null;
        objectArray[6] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)kafkaValue);
        String ArrowAssoc_self6 = KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp();
        Object var31_17 = null;
        String $minus$greater$extension_$this8 = ArrowAssoc_self6;
        Object var14_18 = null;
        objectArray[7] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)kafkaValue);
        String ArrowAssoc_self7 = KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp();
        Object var32_19 = null;
        String $minus$greater$extension_$this9 = ArrowAssoc_self7;
        Object var15_20 = null;
        objectArray[8] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)kafkaValue);
        String ArrowAssoc_self8 = KafkaConfig$.MODULE$.ZkSslProtocolProp();
        Object var33_21 = null;
        String $minus$greater$extension_$this10 = ArrowAssoc_self8;
        Object var16_22 = null;
        objectArray[9] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)kafkaValue);
        String ArrowAssoc_self9 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
        Object var34_23 = null;
        String $minus$greater$extension_$this11 = ArrowAssoc_self9;
        Object var17_24 = null;
        objectArray[10] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)kafkaValue);
        String ArrowAssoc_self10 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
        Object var35_25 = null;
        String $minus$greater$extension_$this12 = ArrowAssoc_self10;
        Object var18_26 = null;
        objectArray[11] = new Tuple2((Object)$minus$greater$extension_$this12, (Object)kafkaValue);
        String string3 = "HTTPS";
        String $minus$greater$extension_$this13 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        Object var19_28 = null;
        string3 = null;
        objectArray[12] = new Tuple2((Object)$minus$greater$extension_$this13, (Object)$minus$greater$extension_y3);
        String string4 = "false";
        String $minus$greater$extension_$this14 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        Object var21_30 = null;
        string4 = null;
        objectArray[13] = new Tuple2((Object)$minus$greater$extension_$this14, (Object)$minus$greater$extension_y2);
        String string5 = "false";
        String $minus$greater$extension_$this15 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
        Object var23_32 = null;
        string5 = null;
        objectArray[14] = new Tuple2((Object)$minus$greater$extension_$this15, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        configs.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String key = (String)x0$1._1();
                String value = (String)x0$1._2();
                return props.put(key, value.toString());
            }
            throw new MatchError(null);
        });
        Option zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(props), (scala.collection.mutable.Map)Map$.MODULE$.apply(configs.toSeq()));
        Assert.assertTrue((boolean)zkClientConfig.isDefined());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)prop -> {
            AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromKafkaConfig$2(zkClientConfig, kafkaValue, prop);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAuthorizerZkConfigFromPrefixOverrides() {
        void apply_elems;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_y9;
        Properties props = new Properties();
        String kafkaValue = "kafkaValue";
        String prefixedValue = "prefixedValue";
        String prefix = "authorizer.";
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[29];
        String string = "somewhere";
        String $minus$greater$extension_$this = "zookeeper.connect";
        Object var7_6 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y9);
        String string2 = "false";
        String $minus$greater$extension_$this2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        Object var9_8 = null;
        string2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y8);
        String ArrowAssoc_self = KafkaConfig$.MODULE$.ZkClientCnxnSocketProp();
        Object var46_9 = null;
        String $minus$greater$extension_$this3 = ArrowAssoc_self;
        Object var11_10 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)kafkaValue);
        String ArrowAssoc_self2 = KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp();
        Object var47_11 = null;
        String $minus$greater$extension_$this4 = ArrowAssoc_self2;
        Object var12_12 = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)kafkaValue);
        String ArrowAssoc_self3 = KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp();
        Object var48_13 = null;
        String $minus$greater$extension_$this5 = ArrowAssoc_self3;
        Object var13_14 = null;
        objectArray[4] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)kafkaValue);
        String ArrowAssoc_self4 = KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp();
        Object var49_15 = null;
        String $minus$greater$extension_$this6 = ArrowAssoc_self4;
        Object var14_16 = null;
        objectArray[5] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)kafkaValue);
        String ArrowAssoc_self5 = KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp();
        Object var50_17 = null;
        String $minus$greater$extension_$this7 = ArrowAssoc_self5;
        Object var15_18 = null;
        objectArray[6] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)kafkaValue);
        String ArrowAssoc_self6 = KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp();
        Object var51_19 = null;
        String $minus$greater$extension_$this8 = ArrowAssoc_self6;
        Object var16_20 = null;
        objectArray[7] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)kafkaValue);
        String ArrowAssoc_self7 = KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp();
        Object var52_21 = null;
        String $minus$greater$extension_$this9 = ArrowAssoc_self7;
        Object var17_22 = null;
        objectArray[8] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)kafkaValue);
        String ArrowAssoc_self8 = KafkaConfig$.MODULE$.ZkSslProtocolProp();
        Object var53_23 = null;
        String $minus$greater$extension_$this10 = ArrowAssoc_self8;
        Object var18_24 = null;
        objectArray[9] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)kafkaValue);
        String ArrowAssoc_self9 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
        Object var54_25 = null;
        String $minus$greater$extension_$this11 = ArrowAssoc_self9;
        Object var19_26 = null;
        objectArray[10] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)kafkaValue);
        String ArrowAssoc_self10 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
        Object var55_27 = null;
        String $minus$greater$extension_$this12 = ArrowAssoc_self10;
        Object var20_28 = null;
        objectArray[11] = new Tuple2((Object)$minus$greater$extension_$this12, (Object)kafkaValue);
        String string3 = "HTTPS";
        String $minus$greater$extension_$this13 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        Object var21_30 = null;
        string3 = null;
        objectArray[12] = new Tuple2((Object)$minus$greater$extension_$this13, (Object)$minus$greater$extension_y7);
        String string4 = "false";
        String $minus$greater$extension_$this14 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        Object var23_32 = null;
        string4 = null;
        objectArray[13] = new Tuple2((Object)$minus$greater$extension_$this14, (Object)$minus$greater$extension_y6);
        String string5 = "false";
        String $minus$greater$extension_$this15 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
        Object var25_34 = null;
        string5 = null;
        objectArray[14] = new Tuple2((Object)$minus$greater$extension_$this15, (Object)$minus$greater$extension_y5);
        String string6 = "true";
        String $minus$greater$extension_$this16 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslClientEnableProp()).toString();
        Object var27_36 = null;
        string6 = null;
        objectArray[15] = new Tuple2((Object)$minus$greater$extension_$this16, (Object)$minus$greater$extension_y4);
        String ArrowAssoc_self11 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()).toString();
        Object var56_37 = null;
        String $minus$greater$extension_$this17 = ArrowAssoc_self11;
        Object var29_38 = null;
        objectArray[16] = new Tuple2((Object)$minus$greater$extension_$this17, (Object)prefixedValue);
        String ArrowAssoc_self12 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()).toString();
        Object var57_39 = null;
        String $minus$greater$extension_$this18 = ArrowAssoc_self12;
        Object var30_40 = null;
        objectArray[17] = new Tuple2((Object)$minus$greater$extension_$this18, (Object)prefixedValue);
        String ArrowAssoc_self13 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp()).toString();
        Object var58_41 = null;
        String $minus$greater$extension_$this19 = ArrowAssoc_self13;
        Object var31_42 = null;
        objectArray[18] = new Tuple2((Object)$minus$greater$extension_$this19, (Object)prefixedValue);
        String ArrowAssoc_self14 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp()).toString();
        Object var59_43 = null;
        String $minus$greater$extension_$this20 = ArrowAssoc_self14;
        Object var32_44 = null;
        objectArray[19] = new Tuple2((Object)$minus$greater$extension_$this20, (Object)prefixedValue);
        String ArrowAssoc_self15 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp()).toString();
        Object var60_45 = null;
        String $minus$greater$extension_$this21 = ArrowAssoc_self15;
        Object var33_46 = null;
        objectArray[20] = new Tuple2((Object)$minus$greater$extension_$this21, (Object)prefixedValue);
        String ArrowAssoc_self16 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp()).toString();
        Object var61_47 = null;
        String $minus$greater$extension_$this22 = ArrowAssoc_self16;
        Object var34_48 = null;
        objectArray[21] = new Tuple2((Object)$minus$greater$extension_$this22, (Object)prefixedValue);
        String ArrowAssoc_self17 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp()).toString();
        Object var62_49 = null;
        String $minus$greater$extension_$this23 = ArrowAssoc_self17;
        Object var35_50 = null;
        objectArray[22] = new Tuple2((Object)$minus$greater$extension_$this23, (Object)prefixedValue);
        String ArrowAssoc_self18 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslProtocolProp()).toString();
        Object var63_51 = null;
        String $minus$greater$extension_$this24 = ArrowAssoc_self18;
        Object var36_52 = null;
        objectArray[23] = new Tuple2((Object)$minus$greater$extension_$this24, (Object)prefixedValue);
        String ArrowAssoc_self19 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp()).toString();
        Object var64_53 = null;
        String $minus$greater$extension_$this25 = ArrowAssoc_self19;
        Object var37_54 = null;
        objectArray[24] = new Tuple2((Object)$minus$greater$extension_$this25, (Object)prefixedValue);
        String ArrowAssoc_self20 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslCipherSuitesProp()).toString();
        Object var65_55 = null;
        String $minus$greater$extension_$this26 = ArrowAssoc_self20;
        Object var38_56 = null;
        objectArray[25] = new Tuple2((Object)$minus$greater$extension_$this26, (Object)prefixedValue);
        String string7 = "";
        String $minus$greater$extension_$this27 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp()).toString();
        Object var39_58 = null;
        string7 = null;
        objectArray[26] = new Tuple2((Object)$minus$greater$extension_$this27, (Object)$minus$greater$extension_y3);
        String string8 = "true";
        String $minus$greater$extension_$this28 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslCrlEnableProp()).toString();
        Object var41_60 = null;
        string8 = null;
        objectArray[27] = new Tuple2((Object)$minus$greater$extension_$this28, (Object)$minus$greater$extension_y2);
        String string9 = "true";
        String $minus$greater$extension_$this29 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslOcspEnableProp()).toString();
        Object var43_62 = null;
        string9 = null;
        objectArray[28] = new Tuple2((Object)$minus$greater$extension_$this29, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        configs.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String key = (String)x0$1._1();
                String value = (String)x0$1._2();
                return props.put(key, value.toString());
            }
            throw new MatchError(null);
        });
        Option zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(props), (scala.collection.mutable.Map)Map$.MODULE$.apply(configs.toSeq()));
        Assert.assertTrue((boolean)zkClientConfig.isDefined());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)prop -> {
            AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromPrefixOverrides$2(zkClientConfig, prefixedValue, prop);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreateDeleteTiming() {
        ResourcePattern literalResource = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        ResourcePattern wildcardResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
        AccessControlEntry ace = new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        Semaphore updateSemaphore = new Semaphore(1);
        try (AclAuthorizer deleteAuthorizer = new AclAuthorizer(null, updateSemaphore){
            private final Semaphore updateSemaphore$1;

            public void processAclChangeNotification(ResourcePattern resource) {
                this.updateSemaphore$1.acquire();
                try {
                    super.processAclChangeNotification(resource);
                }
                finally {
                    this.updateSemaphore$1.release();
                }
            }
            {
                this.updateSemaphore$1 = updateSemaphore$1;
            }
        };){
            deleteAuthorizer.configure(this.config().originals());
            .colon.colon foreach_these = new .colon.colon((Object)literalResource, (List)new .colon.colon((Object)prefixedResource, (List)new .colon.colon((Object)wildcardResource, (List)Nil$.MODULE$)));
            while (!foreach_these.isEmpty()) {
                ResourcePattern resourcePattern = (ResourcePattern)foreach_these.head();
                AclAuthorizerTest.$anonfun$testCreateDeleteTiming$9(this, deleteAuthorizer, updateSemaphore, ace, resourcePattern);
                foreach_these = (List)foreach_these.tail();
            }
            Object var8_7 = null;
        }
    }

    private void givenAuthorizerWithProtocolVersion(Option<ApiVersion> protocolVersion) {
        this.aclAuthorizer().close();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(AclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        if (protocolVersion == null) {
            throw null;
        }
        if (!protocolVersion.isEmpty()) {
            ApiVersion apiVersion = (ApiVersion)protocolVersion.get();
            props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), apiVersion.toString());
        }
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.aclAuthorizer().configure(this.config().originals());
    }

    private String getAclChangeEventAsString(PatternType patternType) {
        ZkAclStore store = ZkAclStore$.MODULE$.apply(patternType);
        GetChildrenResponse children = (GetChildrenResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(store.changeStore().aclChangePath(), true, (Option)None$.MODULE$));
        children.maybeThrow();
        Seq seq = children.children();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((String)"Expecting 1 change event", (long)1L, (long)seq.length());
        GetDataResponse data = (GetDataResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(new StringBuilder(1).append(store.changeStore().aclChangePath()).append("/").append(children.children().head()).toString(), (Option)None$.MODULE$));
        data.maybeThrow();
        return new String(data.data(), StandardCharsets.UTF_8);
    }

    private Set<AccessControlEntry> changeAclAndVerify(Set<AccessControlEntry> originalAcls, Set<AccessControlEntry> addedAcls, Set<AccessControlEntry> removedAcls, ResourcePattern resource) {
        Set acls = originalAcls;
        if (addedAcls.nonEmpty()) {
            this.addAcls(this.aclAuthorizer(), addedAcls, resource);
            if (originalAcls == null) {
                throw null;
            }
            acls = (Set)originalAcls.concat(addedAcls);
        }
        if (removedAcls.nonEmpty()) {
            this.removeAcls(this.aclAuthorizer(), removedAcls, resource);
            if (acls == null) {
                throw null;
            }
            acls = (Set)acls.removedAll(removedAcls);
        }
        TestUtils$.MODULE$.waitAndVerifyAcls(acls, (Authorizer)this.aclAuthorizer(), resource, AccessControlEntryFilter.ANY);
        return acls;
    }

    private ResourcePattern changeAclAndVerify$default$4() {
        return this.resource();
    }

    private RequestContext newRequestContext(KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        RequestHeader header = new RequestHeader(apiKey, 2, "", 1);
        return new RequestContext(header, "", clientAddress, principal, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol, ClientInformation.EMPTY);
    }

    private ApiKeys newRequestContext$default$3() {
        return ApiKeys.PRODUCE;
    }

    private boolean authorize(AclAuthorizer authorizer, RequestContext requestContext, AclOperation operation, ResourcePattern resource) {
        Action action = new Action(operation, resource, 1, true, true);
        Object object = AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)authorizer.authorize((AuthorizableRequestContext)requestContext, AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)action, (List)Nil$.MODULE$)).asJava())).asScala().head();
        AuthorizationResult authorizationResult = AuthorizationResult.ALLOWED;
        return !(object != null ? !object.equals(authorizationResult) : authorizationResult != null);
    }

    private void addAcls(AclAuthorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        Set bindings = (Set)aces.map((Function1 & Serializable)ace -> new AclBinding(resourcePattern, ace));
        ((IterableOnceOps)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)authorizer.createAcls((AuthorizableRequestContext)this.requestContext(), AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)bindings.toList()).asJava())).asScala().map((Function1 & Serializable)x$17 -> (AclCreateResult)x$17.toCompletableFuture().get())).foreach((Function1 & Serializable)result -> {
            AclAuthorizerTest.$anonfun$addAcls$3(result);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private boolean removeAcls(AclAuthorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        Set set;
        if (aces.isEmpty()) {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY)});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            set = (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
        } else {
            set = (Set)aces.map((Function1 & Serializable)ace -> new AclBinding(resourcePattern, ace).toFilter());
        }
        Set bindings = set;
        return ((IterableOnceOps)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)authorizer.deleteAcls((AuthorizableRequestContext)this.requestContext(), AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)bindings.toList()).asJava())).asScala().map((Function1 & Serializable)x$18 -> (AclDeleteResult)x$18.toCompletableFuture().get())).forall((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$removeAcls$3(result)));
    }

    private Set<AccessControlEntry> getAcls(AclAuthorizer authorizer, ResourcePattern resourcePattern) {
        return (Set)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)authorizer.acls(new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY))).asScala().toSet().map((Function1 & Serializable)x$19 -> x$19.entry());
    }

    private Set<AclBinding> getAcls(AclAuthorizer authorizer, KafkaPrincipal principal) {
        AclBindingFilter filter = new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(principal.toString(), null, AclOperation.ANY, AclPermissionType.ANY));
        return AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)authorizer.acls(filter)).asScala().toSet();
    }

    private Set<AclBinding> getAcls(AclAuthorizer authorizer) {
        return AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)authorizer.acls(AclBindingFilter.ANY)).asScala().toSet();
    }

    private boolean validOp(AclOperation op) {
        AclOperation aclOperation = op;
        AclOperation aclOperation2 = AclOperation.ANY;
        if (aclOperation == null ? aclOperation2 != null : !aclOperation.equals(aclOperation2)) {
            AclOperation aclOperation3 = op;
            AclOperation aclOperation4 = AclOperation.UNKNOWN;
            if (aclOperation3 == null ? aclOperation4 != null : !aclOperation3.equals(aclOperation4)) {
                return true;
            }
        }
        return false;
    }

    private String prepareDefaultConfig() {
        return this.prepareConfig(new String[]{"broker.id=1", "zookeeper.connect=somewhere"});
    }

    private String prepareConfig(String[] lines) {
        String string;
        File file = File.createTempFile("kafkatest", ".properties");
        file.deleteOnExit();
        try (OutputStream writer = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            for (String string2 : lines) {
                AclAuthorizerTest.$anonfun$prepareConfig$1(writer, string2);
            }
            string = file.getAbsolutePath();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$1(AclAuthorizerTest $this, AccessControlEntry acl1$1, AccessControlEntry acl2$1, KafkaPrincipal user1$1) {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1$1, acl2$1});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Object object = ((IterableOps)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).map((Function1 & Serializable)acl -> new AclBinding($this.resource(), acl));
        Set<AclBinding> set = $this.getAcls($this.aclAuthorizer(), user1$1);
        return !(object != null ? !object.equals(set) : set != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$3() {
        return "changes not propagated in timeout period";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$4(AclAuthorizerTest $this, AccessControlEntry acl3$1, AccessControlEntry acl4$1, AccessControlEntry acl5$1, KafkaPrincipal user2$1) {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3$1, acl4$1, acl5$1});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Object object = ((IterableOps)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).map((Function1 & Serializable)acl -> new AclBinding($this.resource(), acl));
        Set<AclBinding> set = $this.getAcls($this.aclAuthorizer(), user2$1);
        return !(object != null ? !object.equals(set) : set != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$6() {
        return "changes not propagated in timeout period";
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$10(AclAuthorizerTest $this, Set expectedAcls$1) {
        Set set = expectedAcls$1;
        Set<AclBinding> set2 = $this.getAcls($this.aclAuthorizer());
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$11() {
        return "changes not propagated in timeout period.";
    }

    public static final /* synthetic */ Tuple2 $anonfun$testHighConcurrencyModificationOfResourceAcls$1(int i) {
        KafkaPrincipal useri = new KafkaPrincipal("User", Integer.toString(i));
        return new Tuple2((Object)new AccessControlEntry(useri.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW), (Object)i);
    }

    public static final /* synthetic */ boolean $anonfun$testHighConcurrencyModificationOfResourceAcls$4(Tuple2 x0$2) {
        if (x0$2 != null) {
            return x0$2._2$mcI$sp() % 10 != 0;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testImplicationsOfAllow$2(AclAuthorizerTest $this, RequestContext hostContext$1, Set allowedOps$1, AclOperation parentOp$1, AclOperation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.authorize($this.aclAuthorizer(), hostContext$1, op, $this.clusterResource());
                if (allowedOps$1.contains((Object)op)) break block2;
                AclOperation aclOperation = op;
                if (aclOperation != null ? !aclOperation.equals(parentOp$1) : parentOp$1 != null) break block3;
            }
            Assert.assertTrue((String)new StringBuilder(26).append("ALLOW ").append(parentOp$1).append(" should imply ALLOW ").append(op).toString(), (boolean)authorized);
            return;
        }
        Assert.assertFalse((String)new StringBuilder(30).append("ALLOW ").append(parentOp$1).append(" should not imply ALLOW ").append(op).toString(), (boolean)authorized);
    }

    public static final /* synthetic */ void $anonfun$testImplicationsOfDeny$2(AclAuthorizerTest $this, RequestContext host1Context$1, Set deniedOps$1, AclOperation parentOp$2, AclOperation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.authorize($this.aclAuthorizer(), host1Context$1, op, $this.clusterResource());
                if (deniedOps$1.contains((Object)op)) break block2;
                AclOperation aclOperation = op;
                if (aclOperation != null ? !aclOperation.equals(parentOp$2) : parentOp$2 != null) break block3;
            }
            Assert.assertFalse((String)new StringBuilder(24).append("DENY ").append(parentOp$2).append(" should imply DENY ").append(op).toString(), (boolean)authorized);
            return;
        }
        Assert.assertTrue((String)new StringBuilder(28).append("DENY ").append(parentOp$2).append(" should not imply DENY ").append(op).toString(), (boolean)authorized);
    }

    public static final /* synthetic */ Function0 $anonfun$testHighConcurrencyDeletionOfResourceAcls$1(AclAuthorizerTest $this, AccessControlEntry acl$2, int x$5) {
        return (JFunction0.mcZ.sp & Serializable)() -> {
            void apply_elems;
            void apply_elems2;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl$2});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            $this.addAcls($this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2)), $this.resource());
            Set$ set$2 = Predef$.MODULE$.Set();
            ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl$2});
            if (set$2 == null) {
                throw null;
            }
            arraySeq2 = null;
            return $this.removeAcls($this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems)), $this.resource());
        };
    }

    public static final /* synthetic */ boolean $anonfun$testAclsFilter$2(AclDeleteResult x$7) {
        return x$7.exception().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testAclsFilter$4(AclDeleteResult.AclBindingDeleteResult x$8) {
        return x$8.exception().isPresent();
    }

    public static final /* synthetic */ void $anonfun$testAclsFilter$3(Buffer deleteResults$1, int i) {
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, (Object)AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Collection)((AclDeleteResult)deleteResults$1.apply(i)).aclBindingDeleteResults()).asScala().toSet().filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testAclsFilter$4(x$8))));
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$3() {
        return "<None>";
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$4() {
        return "<None>";
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$5() {
        return "<None>";
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$6() {
        return "<None>";
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$2(Option zkClientConfig$1, String kafkaValue$1, String prop) {
        boolean bl;
        boolean bl2;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(prop) : prop != null)) {
            bl2 = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            bl2 = !(string2 != null ? !string2.equals(prop) : prop != null);
        }
        if (bl2) {
            Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$1.get(), prop);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            Object object = getOrElse_this.isEmpty() ? "<None>" : getOrElse_this.get();
            Object var3_3 = null;
            Assert.assertEquals((Object)"true", (Object)object);
            return;
        }
        String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        if (!(string3 != null ? !string3.equals(prop) : prop != null)) {
            bl = true;
        } else {
            String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
            bl = !(string4 != null ? !string4.equals(prop) : prop != null);
        }
        if (bl) {
            Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$1.get(), prop);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            Object object = getOrElse_this.isEmpty() ? "<None>" : getOrElse_this.get();
            Object var4_4 = null;
            Assert.assertEquals((Object)"false", (Object)object);
            return;
        }
        String string5 = KafkaConfig$.MODULE$.ZkSslProtocolProp();
        if (!(string5 != null ? !string5.equals(prop) : prop != null)) {
            Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$1.get(), prop);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            Object object = getOrElse_this.isEmpty() ? "<None>" : getOrElse_this.get();
            Object var5_5 = null;
            Assert.assertEquals((Object)"TLSv1.2", (Object)object);
            return;
        }
        Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$1.get(), prop);
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? "<None>" : getOrElse_this.get();
        Object var6_6 = null;
        Assert.assertEquals((Object)kafkaValue$1, (Object)object);
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromKafkaConfig$3() {
        return "<None>";
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromKafkaConfig$4() {
        return "<None>";
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromKafkaConfig$5() {
        return "<None>";
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerZkConfigFromKafkaConfig$2(Option zkClientConfig$2, String kafkaValue$2, String prop) {
        boolean bl;
        boolean bl2;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(prop) : prop != null)) {
            bl2 = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            bl2 = !(string2 != null ? !string2.equals(prop) : prop != null);
        }
        if (bl2) {
            Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$2.get(), prop);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            Object object = getOrElse_this.isEmpty() ? "<None>" : getOrElse_this.get();
            Object var3_3 = null;
            Assert.assertEquals((Object)"true", (Object)object);
            return;
        }
        String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        if (!(string3 != null ? !string3.equals(prop) : prop != null)) {
            bl = true;
        } else {
            String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
            bl = !(string4 != null ? !string4.equals(prop) : prop != null);
        }
        if (bl) {
            Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$2.get(), prop);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            Object object = getOrElse_this.isEmpty() ? "<None>" : getOrElse_this.get();
            Object var4_4 = null;
            Assert.assertEquals((Object)"false", (Object)object);
            return;
        }
        Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$2.get(), prop);
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? "<None>" : getOrElse_this.get();
        Object var5_5 = null;
        Assert.assertEquals((Object)kafkaValue$2, (Object)object);
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromPrefixOverrides$3() {
        return "<None>";
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromPrefixOverrides$4() {
        return "<None>";
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromPrefixOverrides$5() {
        return "<None>";
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerZkConfigFromPrefixOverrides$2(Option zkClientConfig$3, String prefixedValue$1, String prop) {
        boolean bl;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(prop) : prop != null)) {
            bl = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string2 != null ? !string2.equals(prop) : prop != null)) {
                bl = true;
            } else {
                String string3 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string3 != null ? !string3.equals(prop) : prop != null);
            }
        }
        if (bl) {
            Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$3.get(), prop);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            Object object = getOrElse_this.isEmpty() ? "<None>" : getOrElse_this.get();
            Object var3_3 = null;
            Assert.assertEquals((Object)"true", (Object)object);
            return;
        }
        String string4 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        if (!(string4 != null ? !string4.equals(prop) : prop != null)) {
            Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$3.get(), prop);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            Object object = getOrElse_this.isEmpty() ? "<None>" : getOrElse_this.get();
            Object var4_4 = null;
            Assert.assertEquals((Object)"false", (Object)object);
            return;
        }
        Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$3.get(), prop);
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? "<None>" : getOrElse_this.get();
        Object var5_5 = null;
        Assert.assertEquals((Object)prefixedValue$1, (Object)object);
    }

    private final AclBinding createAcl$1(AclAuthorizer createAuthorizer, ResourcePattern resource, AccessControlEntry ace$1) {
        AclBinding acl = new AclBinding(resource, ace$1);
        AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)createAuthorizer.createAcls((AuthorizableRequestContext)this.requestContext(), Collections.singletonList(acl))).asScala().foreach((Function1 & Serializable)x$13 -> (AclCreateResult)x$13.toCompletableFuture().get(15L, TimeUnit.SECONDS));
        return acl;
    }

    private final List deleteAcl$1(AclAuthorizer deleteAuthorizer, ResourcePattern resource, PatternType deletePatternType) {
        AclBindingFilter filter = new AclBindingFilter(new ResourcePatternFilter(resource.resourceType(), resource.name(), deletePatternType), AccessControlEntryFilter.ANY);
        return ((IterableOnceOps)((IterableOps)((IterableOps)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)deleteAuthorizer.deleteAcls((AuthorizableRequestContext)this.requestContext(), Collections.singletonList(filter))).asScala().map((Function1 & Serializable)x$14 -> (AclDeleteResult)x$14.toCompletableFuture().get(15L, TimeUnit.SECONDS))).flatMap((Function1 & Serializable)x$15 -> AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Collection)x$15.aclBindingDeleteResults()).asScala())).map((Function1 & Serializable)x$16 -> x$16.aclBinding())).toList();
    }

    private static final List listAcls$1(AclAuthorizer authorizer) {
        return AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)authorizer.acls(AclBindingFilter.ANY)).asScala().toList();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateDeleteTiming$5(AclAuthorizer deleteAuthorizer$1) {
        return AclAuthorizerTest.listAcls$1(deleteAuthorizer$1).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testCreateDeleteTiming$6() {
        return "ACL not propagated";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateDeleteTiming$7(AclAuthorizer deleteAuthorizer$1) {
        return AclAuthorizerTest.listAcls$1(deleteAuthorizer$1).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testCreateDeleteTiming$8() {
        return "ACL delete not propagated";
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyCreateDeleteAcl$1(AclAuthorizer deleteAuthorizer, ResourcePattern resource, PatternType deletePatternType, Semaphore updateSemaphore$1, AccessControlEntry ace$1) {
        updateSemaphore$1.acquire();
        if (package$.MODULE$.List() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)AclAuthorizerTest.listAcls$1(deleteAuthorizer));
        AclBinding acl = this.createAcl$1(this.aclAuthorizer(), resource, ace$1);
        List deleted = this.deleteAcl$1(deleteAuthorizer, resource, deletePatternType);
        PatternType patternType = deletePatternType;
        PatternType patternType2 = PatternType.MATCH;
        if (patternType == null ? patternType2 != null : !patternType.equals(patternType2)) {
            Assert.assertEquals((Object)new .colon.colon((Object)acl, (List)Nil$.MODULE$), (Object)deleted);
        } else {
            if (package$.MODULE$.List() == null) {
                throw null;
            }
            Assert.assertEquals((Object)Nil$.MODULE$, (Object)deleted);
        }
        updateSemaphore$1.release();
        PatternType patternType3 = deletePatternType;
        PatternType patternType4 = PatternType.MATCH;
        if (!(patternType3 != null ? !patternType3.equals(patternType4) : patternType4 != null)) {
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!AclAuthorizerTest.$anonfun$testCreateDeleteTiming$5(deleteAuthorizer)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    throw Assertions$.MODULE$.fail("ACL not propagated", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
                }
                Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
            }
            Assert.assertEquals((Object)new .colon.colon((Object)acl, (List)Nil$.MODULE$), (Object)this.deleteAcl$1(deleteAuthorizer, resource, deletePatternType));
        }
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testCreateDeleteTiming$7(deleteAuthorizer)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("ACL delete not propagated", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$testCreateDeleteTiming$9(AclAuthorizerTest $this, AclAuthorizer deleteAuthorizer$2, Semaphore updateSemaphore$1, AccessControlEntry ace$1, ResourcePattern resource) {
        $this.verifyCreateDeleteAcl$1(deleteAuthorizer$2, resource, resource.patternType(), updateSemaphore$1, ace$1);
        $this.verifyCreateDeleteAcl$1(deleteAuthorizer$2, resource, PatternType.ANY, updateSemaphore$1, ace$1);
        $this.verifyCreateDeleteAcl$1(deleteAuthorizer$2, resource, PatternType.MATCH, updateSemaphore$1, ace$1);
    }

    public static final /* synthetic */ void $anonfun$addAcls$3(AclCreateResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
    }

    public static final /* synthetic */ boolean $anonfun$removeAcls$3(AclDeleteResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
        result.aclBindingDeleteResults().forEach(r -> r.exception().ifPresent(e -> {
            throw e;
        }));
        return !result.aclBindingDeleteResults().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$prepareConfig$1(OutputStream writer$1, String l) {
        writer$1.write(l.getBytes());
        writer$1.write("\n".getBytes());
    }

    public AclAuthorizerTest() {
        this.superUsers = "User:superuser1; User:superuser2";
        this.username = "alice";
    }

    public static final /* synthetic */ Tuple2 $anonfun$testHighConcurrencyModificationOfResourceAcls$1$adapted(Object i) {
        return AclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$1(BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Object $anonfun$testImplicationsOfAllow$1$adapted(AclAuthorizerTest $this, AclOperation op) {
        return BoxesRunTime.boxToBoolean((boolean)$this.validOp(op));
    }

    public static final /* synthetic */ Object $anonfun$testImplicationsOfAllow$2$adapted(AclAuthorizerTest $this, RequestContext hostContext$1, Set allowedOps$1, AclOperation parentOp$1, AclOperation op) {
        AclAuthorizerTest.$anonfun$testImplicationsOfAllow$2($this, hostContext$1, allowedOps$1, parentOp$1, op);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testImplicationsOfDeny$1$adapted(AclAuthorizerTest $this, AclOperation op) {
        return BoxesRunTime.boxToBoolean((boolean)$this.validOp(op));
    }

    public static final /* synthetic */ Object $anonfun$testImplicationsOfDeny$2$adapted(AclAuthorizerTest $this, RequestContext host1Context$1, Set deniedOps$1, AclOperation parentOp$2, AclOperation op) {
        AclAuthorizerTest.$anonfun$testImplicationsOfDeny$2($this, host1Context$1, deniedOps$1, parentOp$2, op);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Function0 $anonfun$testHighConcurrencyDeletionOfResourceAcls$1$adapted(AclAuthorizerTest $this, AccessControlEntry acl$2, Object x$5) {
        return AclAuthorizerTest.$anonfun$testHighConcurrencyDeletionOfResourceAcls$1($this, acl$2, BoxesRunTime.unboxToInt((Object)x$5));
    }

    public static final /* synthetic */ Object $anonfun$testCreateDeleteTiming$9$adapted(AclAuthorizerTest $this, AclAuthorizer deleteAuthorizer$2, Semaphore updateSemaphore$1, AccessControlEntry ace$1, ResourcePattern resource) {
        AclAuthorizerTest.$anonfun$testCreateDeleteTiming$9($this, deleteAuthorizer$2, updateSemaphore$1, ace$1, resource);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$prepareConfig$1$adapted(OutputStream writer$1, String l) {
        AclAuthorizerTest.$anonfun$prepareConfig$1(writer$1, l);
        return BoxedUnit.UNIT;
    }

    public class CustomPrincipal
    extends KafkaPrincipal {
        public boolean equals(Object o) {
            return false;
        }

        public /* synthetic */ AclAuthorizerTest kafka$security$authorizer$AclAuthorizerTest$CustomPrincipal$$$outer() {
            return AclAuthorizerTest.this;
        }

        public CustomPrincipal(String principalType, String name) {
            if (AclAuthorizerTest.this == null) {
                throw null;
            }
            super(principalType, name);
        }
    }
}

