/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015g\u0001\u0002\u000f\u001e\u0001\tBQ!\u000b\u0001\u0005\u0002)BQ!\f\u0001\u0005B9Bq!\u000e\u0001C\u0002\u0013\u0005a\u0007\u0003\u0004@\u0001\u0001\u0006Ia\u000e\u0005\b\u0001\u0002\u0011\r\u0011\"\u0001B\u0011\u0019q\u0005\u0001)A\u0005\u0005\"9q\n\u0001b\u0001\n\u0003\u0001\u0006BB,\u0001A\u0003%\u0011\u000bC\u0005Y\u0001\u0001\u0007\t\u0019!C\u00013\"I!\r\u0001a\u0001\u0002\u0004%\ta\u0019\u0005\nS\u0002\u0001\r\u0011!Q!\niCQA\u001b\u0001\u0005B-DQa\u001d\u0001\u0005B-DQ\u0001\u001f\u0001\u0005\u0002-DQ! \u0001\u0005\u0002-Daa \u0001\u0005\n\u0005\u0005\u0001bBA\u001c\u0001\u0011%\u0011\u0011\b\u0005\b\u0003\u007f\u0001A\u0011BA!\u0011\u001d\t\u0019\u0006\u0001C\u0005\u0003+B\u0011\"!\u001b\u0001#\u0003%I!a\u001b\t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002\u0004\"1\u0011\u0011\u0013\u0001\u0005\u00029Bq!a%\u0001\t\u0003\t)\nC\u0004\u0002 \u0002!I!!)\t\u0013\u0005\u0015\u0006!%A\u0005\n\u0005\u001d\u0006bBAV\u0001\u0011%\u0011Q\u0016\u0005\b\u0003g\u0003A\u0011BA[\u0005i!\u0015P\\1nS\u000e\u001cuN\u001c8fGRLwN\\)v_R\fG+Z:u\u0015\tqr$A\u0004oKR<xN]6\u000b\u0003\u0001\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001GA\u0011AeJ\u0007\u0002K)\u0011aeH\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005!*#a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005Y\u0003C\u0001\u0017\u0001\u001b\u0005i\u0012a\u00032s_.,'oQ8v]R,\u0012a\f\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0004\u0013:$\u0018!\u0002;pa&\u001cW#A\u001c\u0011\u0005ajT\"A\u001d\u000b\u0005iZ\u0014\u0001\u00027b]\u001eT\u0011\u0001P\u0001\u0005U\u00064\u0018-\u0003\u0002?s\t11\u000b\u001e:j]\u001e\fa\u0001^8qS\u000e\u0004\u0013\u0001\u00037jgR,g.\u001a:\u0016\u0003\t\u0003\"a\u0011'\u000e\u0003\u0011S!AH#\u000b\u0005\u0019;\u0015AB2p[6|gN\u0003\u0002!\u0011*\u0011\u0011JS\u0001\u0007CB\f7\r[3\u000b\u0003-\u000b1a\u001c:h\u0013\tiEI\u0001\u0007MSN$XM\\3s\u001d\u0006lW-A\u0005mSN$XM\\3sA\u0005aAn\\2bY\u0006#GM]3tgV\t\u0011\u000b\u0005\u0002S+6\t1K\u0003\u0002Uw\u0005\u0019a.\u001a;\n\u0005Y\u001b&aC%oKR\fE\r\u001a:fgN\fQ\u0002\\8dC2\fE\r\u001a:fgN\u0004\u0013\u0001C3yK\u000e,Ho\u001c:\u0016\u0003i\u0003\"a\u00171\u000e\u0003qS!!\u00180\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002`w\u0005!Q\u000f^5m\u0013\t\tGLA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u00031)\u00070Z2vi>\u0014x\fJ3r)\t!w\r\u0005\u00021K&\u0011a-\r\u0002\u0005+:LG\u000fC\u0004i\u0015\u0005\u0005\t\u0019\u0001.\u0002\u0007a$\u0013'A\u0005fq\u0016\u001cW\u000f^8sA\u0005)1/\u001a;VaR\tA\r\u000b\u0002\r[B\u0011a.]\u0007\u0002_*\u0011\u0001OS\u0001\u0006UVt\u0017\u000e^\u0005\u0003e>\u0014aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u00055)\bC\u00018w\u0013\t9xNA\u0003BMR,'/\u0001\u000euKN$H)\u001f8b[&\u001c7i\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018\r\u000b\u0002\u000fuB\u0011an_\u0005\u0003y>\u0014A\u0001V3ti\u0006\u0011C/Z:u\tft\u0017-\\5d\u0019&\u001cH/\u001a8fe\u000e{gN\\3di&|g.U;pi\u0006D#a\u0004>\u0002%I,7m\u001c8gS\u001e,(/Z*feZ,'o\u001d\u000b\bI\u0006\r\u0011qBA\r\u0011\u001d\t)\u0001\u0005a\u0001\u0003\u000f\t\u0001B\\3x!J|\u0007o\u001d\t\u0005\u0003\u0013\tY!D\u0001_\u0013\r\tiA\u0018\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBA\t!\u0001\u0007\u00111C\u0001\u0010a\u0016\u0014(I]8lKJ\u001cuN\u001c4jOB\u0019\u0001'!\u0006\n\u0007\u0005]\u0011GA\u0004C_>dW-\u00198\t\u000f\u0005m\u0001\u00031\u0001\u0002\u001e\u0005i\u0011\r\u0015:paR{g+\u001a:jMf\u0004r\u0001MA\u0010\u0003G\t\u0019#C\u0002\u0002\"E\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BA\u0013\u0003gqA!a\n\u00020A\u0019\u0011\u0011F\u0019\u000e\u0005\u0005-\"bAA\u0017C\u00051AH]8pizJ1!!\r2\u0003\u0019\u0001&/\u001a3fM&\u0019a(!\u000e\u000b\u0007\u0005E\u0012'A\bxC&$hi\u001c:MSN$XM\\3s)\r!\u00171\b\u0005\b\u0003{\t\u0002\u0019AA\u0012\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f\u0003E\u0019'/Z1uK\u0006#W.\u001b8DY&,g\u000e\u001e\u000b\u0003\u0003\u0007\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%A\u0003bI6LgNC\u0002\u0002N\u001d\u000bqa\u00197jK:$8/\u0003\u0003\u0002R\u0005\u001d#!B!e[&t\u0017!F<bSR4uN]\"p]\u001aLwm\u00148TKJ4XM\u001d\u000b\bI\u0006]\u00131LA0\u0011\u001d\tIf\u0005a\u0001\u0003G\t\u0001\u0002\u001d:pa:\u000bW.\u001a\u0005\b\u0003;\u001a\u0002\u0019AA\u0012\u0003%\u0001(o\u001c9WC2,X\rC\u0005\u0002bM\u0001\n\u00111\u0001\u0002d\u0005IQ.\u0019=XC&$Xj\u001d\t\u0004a\u0005\u0015\u0014bAA4c\t!Aj\u001c8h\u0003}9\u0018-\u001b;G_J\u001cuN\u001c4jO>s7+\u001a:wKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003[RC!a\u0019\u0002p-\u0012\u0011\u0011\u000f\t\u0005\u0003g\ni(\u0004\u0002\u0002v)!\u0011qOA=\u0003%)hn\u00195fG.,GMC\u0002\u0002|E\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty(!\u001e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bqe>$WoY3SKF,Xm\u001d;\u0016\u0005\u0005\u0015\u0005\u0003BAD\u0003\u001bk!!!#\u000b\u0007\u0005-U)\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\ty)!#\u0003\u001dA\u0013x\u000eZ;dKJ+\u0017/^3ti\u0006y1m\u001c8oK\u000e$\u0018n\u001c8D_VtG/A\u0004d_:tWm\u0019;\u0015\t\u0005]\u0015Q\u0014\t\u0004%\u0006e\u0015bAAN'\n11k\\2lKRDa\u0001Q\fA\u0002\u0005\r\u0012!G2sK\u0006$X-\u00118e-\u0016\u0014\u0018NZ=D_:tWm\u0019;j_:$2\u0001ZAR\u0011!\u0001\u0005\u0004%AA\u0002\u0005\r\u0012aI2sK\u0006$X-\u00118e-\u0016\u0014\u0018NZ=D_:tWm\u0019;j_:$C-\u001a4bk2$H%M\u000b\u0003\u0003SSC!a\t\u0002p\u0005\u0001b/\u001a:jMf\u001cuN\u001c8fGRLwN\u001c\u000b\u0004I\u0006=\u0006bBAY5\u0001\u0007\u0011qS\u0001\u0007g>\u001c7.\u001a;\u0002)Y,'/\u001b4z\u001b\u0006D8i\u001c8oK\u000e$\u0018n\u001c8t)\u0015!\u0017qWA^\u0011\u0019\tIl\u0007a\u0001_\u0005qQ.\u0019=D_:tWm\u0019;j_:\u001c\bbBA_7\u0001\u0007\u0011qX\u0001\u0013G>tg.Z2u/&$\bNR1jYV\u0014X\r\u0005\u00031\u0003\u0003$\u0017bAAbc\tIa)\u001e8di&|g\u000e\r")
public class DynamicConnectionQuotaTest
extends BaseRequestTest {
    private final String topic;
    private final ListenerName listener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    private final InetAddress localAddress = InetAddress.getByName("127.0.0.1");
    private ExecutorService executor;

    @Override
    public int brokerCount() {
        return 1;
    }

    public String topic() {
        return this.topic;
    }

    public ListenerName listener() {
        return this.listener;
    }

    public InetAddress localAddress() {
        return this.localAddress;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), this.brokerCount(), this.brokerCount(), (Seq<KafkaServer>)this.servers(), new Properties());
    }

    @Override
    @After
    public void tearDown() {
        try {
            if (this.executor() != null) {
                this.executor().shutdownNow();
                Assert.assertTrue((boolean)this.executor().awaitTermination(10L, TimeUnit.SECONDS));
            }
        }
        finally {
            super.tearDown();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicConnectionQuota() {
        void verifyMaxConnections_$colon$plus_elem;
        Socket socket;
        void verifyMaxConnections_$colon$plus_elem2;
        Socket socket2;
        int maxConnectionsPerIP = 5;
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), Integer.toString(maxConnectionsPerIP));
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), (Object)Integer.toString(maxConnectionsPerIP)));
        JFunction0.mcV.sp & Serializable verifyMaxConnections_connectWithFailure = (JFunction0.mcV.sp & Serializable)() -> this.connectAndVerify$1();
        int verifyMaxConnections_initialConnectionCount = this.connectionCount();
        int n = this.connectionCount();
        int verifyMaxConnections_until$extension_end = maxConnectionsPerIP - 1;
        Range.Exclusive verifyMaxConnections_map_this = new Range.Exclusive(n, verifyMaxConnections_until$extension_end, 1);
        verifyMaxConnections_map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder verifyMaxConnections_map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator verifyMaxConnections_map_strictOptimizedMap_it = verifyMaxConnections_map_this.iterator();
        while (verifyMaxConnections_map_strictOptimizedMap_it.hasNext()) {
            void verifyMaxConnections_map_strictOptimizedMap_$plus$eq_elem;
            Integer cfr_ignored_0 = (Integer)verifyMaxConnections_map_strictOptimizedMap_it.next();
            socket2 = this.connect("PLAINTEXT");
            if (verifyMaxConnections_map_strictOptimizedMap_b == null) {
                throw null;
            }
            verifyMaxConnections_map_strictOptimizedMap_b.addOne((Object)verifyMaxConnections_map_strictOptimizedMap_$plus$eq_elem);
            socket2 = null;
        }
        Object var9_7 = null;
        Object var10_8 = null;
        Object var11_9 = null;
        socket2 = null;
        IndexedSeq verifyMaxConnections_conns = (IndexedSeq)verifyMaxConnections_map_strictOptimizedMap_b.result();
        this.createAndVerifyConnection("PLAINTEXT");
        long l = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnectionsPerIP)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("produce request connection is not closed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(verifyMaxConnections_waitUntilTrue_waitTimeMs, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        Socket socket3 = this.connect("PLAINTEXT");
        if (verifyMaxConnections_conns == null) {
            throw null;
        }
        socket3 = null;
        verifyMaxConnections_conns = (IndexedSeq)verifyMaxConnections_conns.appended((Object)verifyMaxConnections_$colon$plus_elem2);
        Assertions$.MODULE$.intercept((Function0)verifyMaxConnections_connectWithFailure, ClassTag$.MODULE$.apply(IOException.class), new Position("DynamicConnectionQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
        ((Socket)verifyMaxConnections_conns.head()).close();
        long l2 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs2 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4(this, maxConnectionsPerIP)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime2 + verifyMaxConnections_waitUntilTrue_waitTimeMs2) {
                throw Assertions$.MODULE$.fail("connection is not closed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(verifyMaxConnections_waitUntilTrue_waitTimeMs2, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection("PLAINTEXT");
        verifyMaxConnections_conns.foreach((Function1 & Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        });
        long l3 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs3 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$7(this, verifyMaxConnections_initialConnectionCount)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime3 + verifyMaxConnections_waitUntilTrue_waitTimeMs3) {
                throw Assertions$.MODULE$.fail("Connections not closed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(verifyMaxConnections_waitUntilTrue_waitTimeMs3, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        Object var4_3 = null;
        Object var6_11 = null;
        int maxConnectionsPerIPOverride = 7;
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), new StringBuilder(10).append("localhost:").append(maxConnectionsPerIPOverride).toString());
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), (Object)new StringBuilder(10).append("localhost:").append(maxConnectionsPerIPOverride).toString()));
        JFunction0.mcV.sp & Serializable verifyMaxConnections_connectWithFailure2 = (JFunction0.mcV.sp & Serializable)() -> this.connectAndVerify$1();
        int verifyMaxConnections_initialConnectionCount2 = this.connectionCount();
        int n2 = this.connectionCount();
        int verifyMaxConnections_until$extension_end2 = maxConnectionsPerIPOverride - 1;
        Range.Exclusive verifyMaxConnections_map_this2 = new Range.Exclusive(n2, verifyMaxConnections_until$extension_end2, 1);
        verifyMaxConnections_map_this2.scala$collection$immutable$Range$$validateMaxLength();
        Builder verifyMaxConnections_map_strictOptimizedMap_b2 = IndexedSeq$.MODULE$.newBuilder();
        Iterator verifyMaxConnections_map_strictOptimizedMap_it2 = verifyMaxConnections_map_this2.iterator();
        while (verifyMaxConnections_map_strictOptimizedMap_it2.hasNext()) {
            void verifyMaxConnections_map_strictOptimizedMap_$plus$eq_elem;
            Integer cfr_ignored_1 = (Integer)verifyMaxConnections_map_strictOptimizedMap_it2.next();
            socket = this.connect("PLAINTEXT");
            if (verifyMaxConnections_map_strictOptimizedMap_b2 == null) {
                throw null;
            }
            verifyMaxConnections_map_strictOptimizedMap_b2.addOne((Object)verifyMaxConnections_map_strictOptimizedMap_$plus$eq_elem);
            socket = null;
        }
        Object var37_27 = null;
        Object var38_28 = null;
        Object var39_29 = null;
        socket = null;
        IndexedSeq verifyMaxConnections_conns2 = (IndexedSeq)verifyMaxConnections_map_strictOptimizedMap_b2.result();
        this.createAndVerifyConnection("PLAINTEXT");
        long l4 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs4 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnectionsPerIPOverride)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime4 + verifyMaxConnections_waitUntilTrue_waitTimeMs4) {
                throw Assertions$.MODULE$.fail("produce request connection is not closed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(verifyMaxConnections_waitUntilTrue_waitTimeMs4, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        Socket socket4 = this.connect("PLAINTEXT");
        if (verifyMaxConnections_conns2 == null) {
            throw null;
        }
        socket4 = null;
        verifyMaxConnections_conns2 = (IndexedSeq)verifyMaxConnections_conns2.appended((Object)verifyMaxConnections_$colon$plus_elem);
        Assertions$.MODULE$.intercept((Function0)verifyMaxConnections_connectWithFailure2, ClassTag$.MODULE$.apply(IOException.class), new Position("DynamicConnectionQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
        ((Socket)verifyMaxConnections_conns2.head()).close();
        long l5 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs5 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4(this, maxConnectionsPerIPOverride)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime5 + verifyMaxConnections_waitUntilTrue_waitTimeMs5) {
                throw Assertions$.MODULE$.fail("connection is not closed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(verifyMaxConnections_waitUntilTrue_waitTimeMs5, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection("PLAINTEXT");
        verifyMaxConnections_conns2.foreach((Function1 & Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        });
        long l6 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs6 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$7(this, verifyMaxConnections_initialConnectionCount2)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime6 + verifyMaxConnections_waitUntilTrue_waitTimeMs6) {
                throw Assertions$.MODULE$.fail("Connections not closed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(verifyMaxConnections_waitUntilTrue_waitTimeMs6, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicListenerConnectionQuota() {
        Socket socket2;
        Socket socket3;
        Socket socket4;
        Socket socket5;
        void verifyMaxConnections_$colon$plus_elem;
        Socket socket6;
        void $plus$plus_suffix;
        Socket socket7;
        Socket socket8;
        void verifyMaxConnections_connectWithFailure;
        void verifyMaxConnections_$colon$plus_elem2;
        Socket socket9;
        int initialConnectionCount = this.connectionCount();
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "5");
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsProp(), (Object)"5"));
        JFunction0.mcV.sp & Serializable intersect = (JFunction0.mcV.sp & Serializable)() -> this.connectAndVerify$2();
        int verifyMaxConnections_maxConnections = 5;
        int verifyMaxConnections_initialConnectionCount = this.connectionCount();
        int n = this.connectionCount();
        int verifyMaxConnections_until$extension_end = verifyMaxConnections_maxConnections - 1;
        Range.Exclusive verifyMaxConnections_map_this = new Range.Exclusive(n, verifyMaxConnections_until$extension_end, 1);
        verifyMaxConnections_map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder verifyMaxConnections_map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : verifyMaxConnections_map_this) {
            void verifyMaxConnections_map_strictOptimizedMap_$plus$eq_elem;
            socket9 = this.connect("PLAINTEXT");
            if (verifyMaxConnections_map_strictOptimizedMap_b == null) {
                throw null;
            }
            verifyMaxConnections_map_strictOptimizedMap_b.addOne((Object)verifyMaxConnections_map_strictOptimizedMap_$plus$eq_elem);
            socket9 = null;
        }
        Object var25_8 = null;
        Object var26_9 = null;
        Object var27_10 = null;
        socket9 = null;
        IndexedSeq verifyMaxConnections_conns = (IndexedSeq)verifyMaxConnections_map_strictOptimizedMap_b.result();
        this.createAndVerifyConnection("PLAINTEXT");
        long l = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, verifyMaxConnections_maxConnections)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("produce request connection is not closed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(verifyMaxConnections_waitUntilTrue_waitTimeMs, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        Socket socket10 = this.connect("PLAINTEXT");
        if (verifyMaxConnections_conns == null) {
            throw null;
        }
        socket10 = null;
        verifyMaxConnections_conns = (IndexedSeq)verifyMaxConnections_conns.appended((Object)verifyMaxConnections_$colon$plus_elem2);
        Assertions$.MODULE$.intercept((Function0)verifyMaxConnections_connectWithFailure, ClassTag$.MODULE$.apply(IOException.class), new Position("DynamicConnectionQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
        ((Socket)verifyMaxConnections_conns.head()).close();
        long l2 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs2 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4(this, verifyMaxConnections_maxConnections)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime2 + verifyMaxConnections_waitUntilTrue_waitTimeMs2) {
                throw Assertions$.MODULE$.fail("connection is not closed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(verifyMaxConnections_waitUntilTrue_waitTimeMs2, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection("PLAINTEXT");
        verifyMaxConnections_conns.foreach((Function1 & Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        });
        long l3 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs3 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$7(this, verifyMaxConnections_initialConnectionCount)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime3 + verifyMaxConnections_waitUntilTrue_waitTimeMs3) {
                throw Assertions$.MODULE$.fail("Connections not closed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(verifyMaxConnections_waitUntilTrue_waitTimeMs3, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        intersect = null;
        Object var22_13 = null;
        String newListeners = "PLAINTEXT://localhost:0,INTERNAL://localhost:0";
        props.put(KafkaConfig$.MODULE$.ListenersProp(), newListeners);
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "PLAINTEXT:PLAINTEXT,INTERNAL:PLAINTEXT");
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "10");
        props.put("listener.name.internal.max.connections", "5");
        props.put("listener.name.plaintext.max.connections", "5");
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.ListenersProp(), (Object)newListeners));
        this.waitForListener("INTERNAL");
        int n2 = this.connectionCount();
        int until$extension_end = 5;
        Range.Exclusive map_this = new Range.Exclusive(n2, until$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            socket8 = this.connect("PLAINTEXT");
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            socket8 = null;
        }
        Object var48_27 = null;
        Object var49_28 = null;
        Object var50_29 = null;
        socket8 = null;
        IndexedSeq conns = (IndexedSeq)map_strictOptimizedMap_b.result();
        int n3 = 5;
        int until$extension_end2 = 10;
        Range.Exclusive map_this2 = new Range.Exclusive(n3, until$extension_end2, 1);
        map_this2.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b2 = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this2) {
            void map_strictOptimizedMap_$plus$eq_elem;
            socket7 = this.connect("INTERNAL");
            if (map_strictOptimizedMap_b2 == null) {
                throw null;
            }
            map_strictOptimizedMap_b2.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            socket7 = null;
        }
        Object var52_35 = null;
        Object var53_36 = null;
        Object var54_37 = null;
        socket7 = null;
        IndexedSeq indexedSeq = (IndexedSeq)map_strictOptimizedMap_b2.result();
        if (conns == null) {
            throw null;
        }
        indexedSeq = null;
        conns = (IndexedSeq)conns.appendedAll((IterableOnce)$plus$plus_suffix);
        conns.foreach((Function1 & Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        conns.foreach((Function1 & Serializable)x$4 -> {
            x$4.close();
            return BoxedUnit.UNIT;
        });
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$6(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("Connections not closed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        int maxConnectionsPlaintext = 7;
        String listenerProp = new StringBuilder(0).append(this.listener().configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionsProp()).toString();
        props.put(listenerProp, Integer.toString(maxConnectionsPlaintext));
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)listenerProp, (Object)Integer.toString(maxConnectionsPlaintext)));
        JFunction0.mcV.sp & Serializable verifyMaxConnections_connectWithFailure2 = (JFunction0.mcV.sp & Serializable)() -> this.connectAndVerify$2();
        int verifyMaxConnections_initialConnectionCount2 = this.connectionCount();
        int n4 = this.connectionCount();
        int verifyMaxConnections_until$extension_end2 = maxConnectionsPlaintext - 1;
        Range.Exclusive verifyMaxConnections_map_this2 = new Range.Exclusive(n4, verifyMaxConnections_until$extension_end2, 1);
        verifyMaxConnections_map_this2.scala$collection$immutable$Range$$validateMaxLength();
        Builder verifyMaxConnections_map_strictOptimizedMap_b2 = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : verifyMaxConnections_map_this2) {
            void verifyMaxConnections_map_strictOptimizedMap_$plus$eq_elem;
            socket6 = this.connect("PLAINTEXT");
            if (verifyMaxConnections_map_strictOptimizedMap_b2 == null) {
                throw null;
            }
            verifyMaxConnections_map_strictOptimizedMap_b2.addOne((Object)verifyMaxConnections_map_strictOptimizedMap_$plus$eq_elem);
            socket6 = null;
        }
        Object var67_50 = null;
        Object var68_51 = null;
        Object var69_52 = null;
        socket6 = null;
        IndexedSeq verifyMaxConnections_conns2 = (IndexedSeq)verifyMaxConnections_map_strictOptimizedMap_b2.result();
        this.createAndVerifyConnection("PLAINTEXT");
        long l5 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs4 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnectionsPlaintext)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime4 + verifyMaxConnections_waitUntilTrue_waitTimeMs4) {
                throw Assertions$.MODULE$.fail("produce request connection is not closed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(verifyMaxConnections_waitUntilTrue_waitTimeMs4, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        Socket socket11 = this.connect("PLAINTEXT");
        if (verifyMaxConnections_conns2 == null) {
            throw null;
        }
        socket11 = null;
        verifyMaxConnections_conns2 = (IndexedSeq)verifyMaxConnections_conns2.appended((Object)verifyMaxConnections_$colon$plus_elem);
        Assertions$.MODULE$.intercept((Function0)verifyMaxConnections_connectWithFailure2, ClassTag$.MODULE$.apply(IOException.class), new Position("DynamicConnectionQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
        ((Socket)verifyMaxConnections_conns2.head()).close();
        long l6 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs5 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4(this, maxConnectionsPlaintext)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime5 + verifyMaxConnections_waitUntilTrue_waitTimeMs5) {
                throw Assertions$.MODULE$.fail("connection is not closed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(verifyMaxConnections_waitUntilTrue_waitTimeMs5, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection("PLAINTEXT");
        verifyMaxConnections_conns2.foreach((Function1 & Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        });
        long l7 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs6 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$7(this, verifyMaxConnections_initialConnectionCount2)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime6 + verifyMaxConnections_waitUntilTrue_waitTimeMs6) {
                throw Assertions$.MODULE$.fail("Connections not closed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(verifyMaxConnections_waitUntilTrue_waitTimeMs6, (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        Object var62_46 = null;
        Object var64_55 = null;
        int n5 = this.connectionCount();
        Range.Exclusive map_this3 = new Range.Exclusive(n5, maxConnectionsPlaintext, 1);
        map_this3.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b3 = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this3) {
            void map_strictOptimizedMap_$plus$eq_elem;
            socket5 = this.connect("PLAINTEXT");
            if (map_strictOptimizedMap_b3 == null) {
                throw null;
            }
            map_strictOptimizedMap_b3.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            socket5 = null;
        }
        Object var90_67 = null;
        Object var91_68 = null;
        Object var92_69 = null;
        socket5 = null;
        IndexedSeq plaintextConnections = (IndexedSeq)map_strictOptimizedMap_b3.result();
        this.executor_$eq(Executors.newSingleThreadExecutor());
        Future<?> future = this.executor().submit(() -> this.createAndVerifyConnection("PLAINTEXT"));
        Thread.sleep(100L);
        Assert.assertFalse((boolean)future.isDone());
        ((Socket)plaintextConnections.head()).close();
        future.get(30L, TimeUnit.SECONDS);
        plaintextConnections.foreach((Function1 & Serializable)x$6 -> {
            x$6.close();
            return BoxedUnit.UNIT;
        });
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$12(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                throw Assertions$.MODULE$.fail("Connections not closed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs2, (long)waitUntilTrue_pause));
        }
        int n6 = this.connectionCount();
        int until$extension_end3 = 5;
        Range.Exclusive map_this4 = new Range.Exclusive(n6, until$extension_end3, 1);
        map_this4.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b4 = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this4) {
            void map_strictOptimizedMap_$plus$eq_elem;
            socket4 = this.connect("PLAINTEXT");
            if (map_strictOptimizedMap_b4 == null) {
                throw null;
            }
            map_strictOptimizedMap_b4.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            socket4 = null;
        }
        Object var100_79 = null;
        Object var101_80 = null;
        Object var102_81 = null;
        socket4 = null;
        IndexedSeq plaintextConns = (IndexedSeq)map_strictOptimizedMap_b4.result();
        int n7 = 5;
        int until$extension_end4 = 10;
        Range.Exclusive map_this5 = new Range.Exclusive(n7, until$extension_end4, 1);
        map_this5.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b5 = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this5) {
            void map_strictOptimizedMap_$plus$eq_elem;
            socket3 = this.connect("INTERNAL");
            if (map_strictOptimizedMap_b5 == null) {
                throw null;
            }
            map_strictOptimizedMap_b5.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            socket3 = null;
        }
        Object var104_87 = null;
        Object var105_88 = null;
        Object var106_89 = null;
        socket3 = null;
        IndexedSeq internalConns = (IndexedSeq)map_strictOptimizedMap_b5.result();
        plaintextConns.foreach((Function1 & Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        internalConns.foreach((Function1 & Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        int n8 = 0;
        int until$extension_end5 = 2;
        Range.Exclusive map_this6 = new Range.Exclusive(n8, until$extension_end5, 1);
        map_this6.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b6 = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this6) {
            void map_strictOptimizedMap_$plus$eq_elem;
            socket2 = this.connect("PLAINTEXT");
            if (map_strictOptimizedMap_b6 == null) {
                throw null;
            }
            map_strictOptimizedMap_b6.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            socket2 = null;
        }
        Object var108_95 = null;
        Object var109_96 = null;
        Object var110_97 = null;
        socket2 = null;
        IndexedSeq $plus$plus_suffix2 = (IndexedSeq)map_strictOptimizedMap_b6.result();
        Object var18_100 = null;
        plaintextConns = (IndexedSeq)plaintextConns.appendedAll((IterableOnce)$plus$plus_suffix2);
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$19(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                throw Assertions$.MODULE$.fail("Internal connections not closed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs3, (long)waitUntilTrue_pause));
        }
        plaintextConns.foreach((Function1 & Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> internalConns.foreach((Function1 & Serializable)socket -> (ProduceResponse)this.sendAndReceive((AbstractRequest)this.produceRequest(), (Socket)socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))), ClassTag$.MODULE$.apply(IOException.class), new Position("DynamicConnectionQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        plaintextConns.foreach((Function1 & Serializable)x$10 -> {
            x$10.close();
            return BoxedUnit.UNIT;
        });
        internalConns.foreach((Function1 & Serializable)x$11 -> {
            x$11.close();
            return BoxedUnit.UNIT;
        });
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$26(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                throw Assertions$.MODULE$.fail("Connections not closed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs4, (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reconfigureServers(Properties newProps, boolean perBrokerConfig, Tuple2<String, String> aPropToVerify) {
        int initialConnectionCount = this.connectionCount();
        Admin adminClient = this.createAdminClient();
        TestUtils$.MODULE$.incrementalAlterConfigs((Seq<KafkaServer>)this.servers(), adminClient, newProps, perBrokerConfig, AlterConfigOp.OpType.SET).all().get();
        this.waitForConfigOnServer((String)aPropToVerify._1(), (String)aPropToVerify._2(), 10000L);
        adminClient.close();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$reconfigureServers$1(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("Admin client connection not closed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    private void waitForListener(String listenerName) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConnectionQuotaTest.$anonfun$waitForListener$1(this, listenerName);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += Math.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    private Admin createAdminClient() {
        String bootstrapServers = TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), new ListenerName(this.securityProtocol().name));
        Properties config = new Properties();
        config.put("bootstrap.servers", bootstrapServers);
        config.put("metadata.max.age.ms", "10");
        return Admin.create((Properties)config);
    }

    private void waitForConfigOnServer(String propName, String propValue, long maxWaitMs) {
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConnectionQuotaTest.$anonfun$waitForConfigOnServer$1(this, propValue, propName);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var9_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += Math.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    private long waitForConfigOnServer$default$3() {
        return 10000L;
    }

    /*
     * WARNING - void declaration
     */
    private ProduceRequest produceRequest() {
        void forCurrentMagic_partitionRecords;
        void forCurrentMagic_timeout;
        void apply_elems;
        void withRecords_records;
        void withRecords_timestampType;
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var5_3 = null;
        simpleRecordArray = null;
        MemoryRecords memoryRecords = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = new Tuple2((Object)topicPartition, (Object)memoryRecords);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        java.util.Map map = AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)partitionRecords).asJava();
        int n = 3000;
        short forCurrentMagic_acks = -1;
        map = null;
        return (ProduceRequest)ProduceRequest.Builder.forMagic((byte)2, (short)forCurrentMagic_acks, (int)forCurrentMagic_timeout, (java.util.Map)forCurrentMagic_partitionRecords, null).build();
    }

    public int connectionCount() {
        return ((KafkaServer)this.servers().head()).socketServer().connectionCount(this.localAddress());
    }

    public Socket connect(String listener) {
        ListenerName listenerName = ListenerName.normalised((String)listener);
        return new Socket("localhost", ((KafkaServer)this.servers().head()).socketServer().boundPort(listenerName));
    }

    private void createAndVerifyConnection(String listener) {
        try (Socket socket = this.connect(listener);){
            this.verifyConnection(socket);
        }
    }

    private String createAndVerifyConnection$default$1() {
        return "PLAINTEXT";
    }

    /*
     * WARNING - void declaration
     */
    private void verifyConnection(Socket socket) {
        void var4_4;
        ProduceResponse produceResponse = (ProduceResponse)this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
        Tuple2 tuple2 = (Tuple2)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)produceResponse.responses()).asScala().head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple2._2();
        Assert.assertEquals((Object)Errors.NONE, (Object)var4_4.error);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyMaxConnections(int maxConnections, Function0<BoxedUnit> connectWithFailure) {
        void $colon$plus_elem;
        Socket socket;
        int initialConnectionCount = this.connectionCount();
        int n = this.connectionCount();
        int until$extension_end = maxConnections - 1;
        Range.Exclusive map_this = new Range.Exclusive(n, until$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Integer cfr_ignored_0 = (Integer)map_strictOptimizedMap_it.next();
            socket = this.connect("PLAINTEXT");
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            socket = null;
        }
        Object var7_6 = null;
        Object var8_7 = null;
        Object var9_8 = null;
        socket = null;
        IndexedSeq conns = (IndexedSeq)map_strictOptimizedMap_b.result();
        this.createAndVerifyConnection("PLAINTEXT");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnections)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("produce request connection is not closed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Socket socket2 = this.connect("PLAINTEXT");
        if (conns == null) {
            throw null;
        }
        socket2 = null;
        conns = (IndexedSeq)conns.appended((Object)$colon$plus_elem);
        Assertions$.MODULE$.intercept(connectWithFailure, ClassTag$.MODULE$.apply(IOException.class), new Position("DynamicConnectionQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
        ((Socket)conns.head()).close();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4(this, maxConnections)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                throw Assertions$.MODULE$.fail("connection is not closed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs2, (long)waitUntilTrue_pause));
        }
        this.createAndVerifyConnection("PLAINTEXT");
        conns.foreach((Function1 & Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        });
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$7(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                throw Assertions$.MODULE$.fail("Connections not closed", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs3, (long)waitUntilTrue_pause));
        }
    }

    private final void connectAndVerify$1() {
        try (Socket socket = this.connect(this.connect$default$1(), this.connect$default$2());){
            this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        }
    }

    private final void connectAndVerify$2() {
        socket.setSoTimeout(1000);
        try (Socket socket = this.connect("PLAINTEXT");){
            this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$6(DynamicConnectionQuotaTest $this, int initialConnectionCount$1) {
        return initialConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$7() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$12(DynamicConnectionQuotaTest $this, int initialConnectionCount$1) {
        return initialConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$13() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$19(DynamicConnectionQuotaTest $this) {
        return $this.connectionCount() <= 10;
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$20() {
        return "Internal connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$26(DynamicConnectionQuotaTest $this, int initialConnectionCount$1) {
        return initialConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$27() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$reconfigureServers$1(DynamicConnectionQuotaTest $this, int initialConnectionCount$2) {
        return initialConnectionCount$2 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$reconfigureServers$2() {
        return "Admin client connection not closed";
    }

    public static final /* synthetic */ void $anonfun$waitForListener$1(DynamicConnectionQuotaTest $this, String listenerName$1) {
        try {
            Assert.assertTrue((((KafkaServer)$this.servers().head()).socketServer().boundPort(ListenerName.normalised((String)listenerName$1)) > 0 ? 1 : 0) != 0);
            return;
        }
        catch (KafkaException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static final /* synthetic */ void $anonfun$waitForConfigOnServer$1(DynamicConnectionQuotaTest $this, String propValue$1, String propName$1) {
        Assert.assertEquals((Object)propValue$1, ((KafkaServer)$this.servers().head()).config().originals().get(propName$1));
    }

    public static final /* synthetic */ boolean $anonfun$verifyMaxConnections$2(DynamicConnectionQuotaTest $this, int maxConnections$1) {
        return $this.connectionCount() == maxConnections$1 - 1;
    }

    public static final /* synthetic */ String $anonfun$verifyMaxConnections$3() {
        return "produce request connection is not closed";
    }

    public static final /* synthetic */ boolean $anonfun$verifyMaxConnections$4(DynamicConnectionQuotaTest $this, int maxConnections$1) {
        return $this.connectionCount() == maxConnections$1 - 1;
    }

    public static final /* synthetic */ String $anonfun$verifyMaxConnections$5() {
        return "connection is not closed";
    }

    public static final /* synthetic */ boolean $anonfun$verifyMaxConnections$7(DynamicConnectionQuotaTest $this, int initialConnectionCount$3) {
        return initialConnectionCount$3 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$verifyMaxConnections$8() {
        return "Connections not closed";
    }

    public DynamicConnectionQuotaTest() {
        this.topic = "test";
    }

    public static final /* synthetic */ Socket $anonfun$testDynamicListenerConnectionQuota$2$adapted(DynamicConnectionQuotaTest $this, Object x$2) {
        return $this.connect("PLAINTEXT");
    }

    public static final /* synthetic */ Socket $anonfun$testDynamicListenerConnectionQuota$3$adapted(DynamicConnectionQuotaTest $this, Object x$3) {
        return $this.connect("INTERNAL");
    }

    public static final /* synthetic */ Socket $anonfun$testDynamicListenerConnectionQuota$9$adapted(DynamicConnectionQuotaTest $this, Object x$5) {
        return $this.connect("PLAINTEXT");
    }

    public static final /* synthetic */ Socket $anonfun$testDynamicListenerConnectionQuota$14$adapted(DynamicConnectionQuotaTest $this, Object x$7) {
        return $this.connect("PLAINTEXT");
    }

    public static final /* synthetic */ Socket $anonfun$testDynamicListenerConnectionQuota$15$adapted(DynamicConnectionQuotaTest $this, Object x$8) {
        return $this.connect("INTERNAL");
    }

    public static final /* synthetic */ Socket $anonfun$testDynamicListenerConnectionQuota$18$adapted(DynamicConnectionQuotaTest $this, Object x$9) {
        return $this.connect("PLAINTEXT");
    }

    public static final /* synthetic */ Socket $anonfun$verifyMaxConnections$1$adapted(DynamicConnectionQuotaTest $this, Object x$12) {
        return $this.connect("PLAINTEXT");
    }
}

