/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SortedOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.IntegralProxy;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\u0005ed\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001A\u0002\u0013\u00051\u0006C\u00040\u0001\u0001\u0007I\u0011\u0001\u0019\t\rY\u0002\u0001\u0015)\u0003-\u0011\u001d9\u0004A1A\u0005\u0002aBa\u0001\u0010\u0001!\u0002\u0013I\u0004bB\u001f\u0001\u0005\u0004%\tA\u0010\u0005\u0007\u0005\u0002\u0001\u000b\u0011B \t\u000b\r\u0003A\u0011\u0001#\t\u000b9\u0003A\u0011\u0001#\t\u000bM\u0003A\u0011\u0001#\t\u000ba\u0003A\u0011\u0001#\t\u000bi\u0003A\u0011\u0001#\t\u000bq\u0003A\u0011\u0001#\t\u000b1\u0004A\u0011\u0001#\t\u000b9\u0004A\u0011\u0001#\t\u000bq\u0004A\u0011\u0001#\t\u000by\u0004A\u0011\u0001#\t\r\u0005\u0005\u0001\u0001\"\u0001E\u0011\u0019\t)\u0001\u0001C\u0001\t\"1\u0011\u0011\u0002\u0001\u0005\u0002\u0011Cq!!\u0004\u0001\t\u0003\ty\u0001C\u0004\u0002N\u0001!\t!a\u0014\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002h\tyqJ\u001a4tKRLe\u000eZ3y)\u0016\u001cHO\u0003\u0002\u001c9\u0005\u0019An\\4\u000b\u0003u\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001AA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0015\u0011\u0005%\u0002Q\"\u0001\u000e\u0002\u0007%$\u00070F\u0001-!\tIS&\u0003\u0002/5\tYqJ\u001a4tKRLe\u000eZ3y\u0003\u001dIG\r_0%KF$\"!\r\u001b\u0011\u0005\u0005\u0012\u0014BA\u001a#\u0005\u0011)f.\u001b;\t\u000fU\u001a\u0011\u0011!a\u0001Y\u0005\u0019\u0001\u0010J\u0019\u0002\t%$\u0007\u0010I\u0001\u000b[\u0006DXI\u001c;sS\u0016\u001cX#A\u001d\u0011\u0005\u0005R\u0014BA\u001e#\u0005\rIe\u000e^\u0001\f[\u0006DXI\u001c;sS\u0016\u001c\b%\u0001\u0006cCN,wJ\u001a4tKR,\u0012a\u0010\t\u0003C\u0001K!!\u0011\u0012\u0003\t1{gnZ\u0001\fE\u0006\u001cXm\u00144gg\u0016$\b%A\u0003tKR,\b\u000fF\u00012Q\tIa\t\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006)!.\u001e8ji*\t1*A\u0002pe\u001eL!!\u0014%\u0003\r\t+gm\u001c:f\u0003!!X-\u0019:e_^t\u0007F\u0001\u0006Q!\t9\u0015+\u0003\u0002S\u0011\n)\u0011I\u001a;fe\u0006\u0001\"/\u00198e_6dun\\6vaR+7\u000f\u001e\u0015\u0003\u0017U\u0003\"a\u0012,\n\u0005]C%\u0001\u0002+fgR\f!\u0003\\8pWV\u0004X\t\u001f;sK6,7)Y:fg\"\u0012A\"V\u0001\ni\u0016\u001cH/\u00128uefD#!D+\u0002#Q,7\u000f^#oiJLxJ^3sM2|w\u000f\u000b\u0003\u000f+z{\u0016\u0001C3ya\u0016\u001cG/\u001a3$\u0003\u0001\u0004\"!Y5\u000f\u0005\t<gBA2g\u001b\u0005!'BA3\u001f\u0003\u0019a$o\\8u}%\t1%\u0003\u0002iE\u00059\u0001/Y2lC\u001e,\u0017B\u00016l\u0005aIE\u000e\\3hC2\f%oZ;nK:$X\t_2faRLwN\u001c\u0006\u0003Q\n\nQ\"\u00199qK:$Gk\\8NC:L\bFA\bV\u0003A\t\u0007\u000f]3oI>+Ho\u00144Pe\u0012,'\u000f\u000b\u0003\u0011+z\u00038%A9\u0011\u0005ITX\"A:\u000b\u0005Q,\u0018AB3se>\u00148O\u0003\u0002wo\u000611m\\7n_:T!!\b=\u000b\u0005eT\u0015AB1qC\u000eDW-\u0003\u0002|g\n1\u0012J\u001c<bY&$wJ\u001a4tKR,\u0005pY3qi&|g.A\ruKN$h)\u001a;dQV\u0003\b/\u001a:C_VtGm\u00144gg\u0016$\bFA\tV\u0003)!Xm\u001d;SK>\u0004XM\u001c\u0015\u0003%U\u000b\u0001\u0002\u001e:v]\u000e\fG/\u001a\u0015\u0003'U\u000baBZ8sG\u0016,f.\\1q)\u0016\u001cH\u000f\u000b\u0002\u0015+\u0006)C/Z:u'\u0006t\u0017\u000e^=MCN$xJ\u001a4tKR,\u0015/^1m)>\u0014\u0015m]3PM\u001a\u001cX\r\u001e\u0015\u0003+U\u000b\u0001#Y:tKJ$xK]5uK\u001a\u000b\u0017\u000e\\:\u0016\t\u0005E\u00111\b\u000b\nc\u0005M\u0011qEA\u0015\u0003[Aq!!\u0006\u0017\u0001\u0004\t9\"A\u0004nKN\u001c\u0018mZ3\u0011\t\u0005e\u0011\u0011\u0005\b\u0005\u00037\ti\u0002\u0005\u0002dE%\u0019\u0011q\u0004\u0012\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019#!\n\u0003\rM#(/\u001b8h\u0015\r\tyB\t\u0005\u0006UY\u0001\r\u0001\f\u0005\u0007\u0003W1\u0002\u0019A\u001d\u0002\r=4gm]3u\u0011\u001d\tyC\u0006a\u0001\u0003c\tQa\u001b7bgN\u0004b!!\u0007\u00024\u0005]\u0012\u0002BA\u001b\u0003K\u0011Qa\u00117bgN\u0004B!!\u000f\u0002<1\u0001AaBA\u001f-\t\u0007\u0011q\b\u0002\u0002)F!\u0011\u0011IA$!\r\t\u00131I\u0005\u0004\u0003\u000b\u0012#a\u0002(pi\"Lgn\u001a\t\u0004C\u0005%\u0013bAA&E\t\u0019\u0011I\\=\u0002\u00195|gn\u001c;p]&\u001c7+Z9\u0015\r\u0005E\u0013QLA1!\u0015\t\u0019&!\u0017:\u001b\t\t)FC\u0002\u0002X\t\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY&!\u0016\u0003\u0007M+\u0017\u000f\u0003\u0004\u0002`]\u0001\r!O\u0001\u0005E\u0006\u001cX\r\u0003\u0004\u0002d]\u0001\r!O\u0001\u0004Y\u0016t\u0017a\u00058p]\u0016C\u0018n\u001d;f]R$V-\u001c9GS2,GCAA5!\u0011\tY'!\u001e\u000e\u0005\u00055$\u0002BA8\u0003c\n!![8\u000b\u0005\u0005M\u0014\u0001\u00026bm\u0006LA!a\u001e\u0002n\t!a)\u001b7f\u0001")
public class OffsetIndexTest {
    private OffsetIndex idx = null;
    private final int maxEntries;
    private final long baseOffset;

    public OffsetIndex idx() {
        return this.idx;
    }

    public void idx_$eq(OffsetIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    @Before
    public void setup() {
        this.idx_$eq(new OffsetIndex(this.nonExistentTempFile(), this.baseOffset(), 240, true));
    }

    @After
    public void teardown() {
        if (this.idx() != null) {
            this.idx().file().delete();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void randomLookupTest() {
        void $plus$plus_xs;
        Assert.assertEquals((String)"Not present value should return physical offset 0.", (Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(92L));
        int base = (int)this.idx().baseOffset() + 1;
        int size = this.idx().maxEntries();
        Seq vals = (Seq)((IterableOps)this.monotonicSeq(base, size).map((Function1)(JFunction1.mcJI.sp & Serializable)x$1 -> x$1)).zip(this.monotonicSeq(0, size));
        vals.foreach((Function1 & Serializable)x -> {
            OffsetIndexTest.$anonfun$randomLookupTest$2(this, x);
            return BoxedUnit.UNIT;
        });
        vals.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)OffsetIndexTest.$anonfun$randomLookupTest$3(check$ifrefutable$1))).foreach((Function1 & Serializable)x$2 -> {
            OffsetIndexTest.$anonfun$randomLookupTest$4(this, x$2);
            return BoxedUnit.UNIT;
        });
        IterableOnce iterableOnce = (IterableOnce)vals.map((Function1 & Serializable)p -> new Tuple2((Object)p._1$mcJ$sp(), p));
        TreeMap $plus$plus_this = new TreeMap((Ordering)Ordering.Long$.MODULE$);
        Object var6_5 = null;
        iterableOnce = null;
        TreeMap valMap = $plus$plus_this.concat((IterableOnce)$plus$plus_xs);
        long[] offsets = (long[])IntegralProxy.until$((IntegralProxy)new RichLong(this.idx().baseOffset()), (Object)((int)((Tuple2)vals.last())._1$mcJ$sp())).toArray((ClassTag)ClassTag$.MODULE$.Long());
        Collections.shuffle(Arrays.asList(new long[][]{offsets}));
        int take$extension_n = 30;
        for (long l : (long[])ArrayOps$.MODULE$.slice$extension((Object)offsets, 0, take$extension_n)) {
            OffsetIndexTest.$anonfun$randomLookupTest$6(this, valMap, l);
        }
    }

    @Test
    public void lookupExtremeCases() {
        Assert.assertEquals((String)"Lookup on empty file", (Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        int n = 0;
        int until$extension_end = this.idx().maxEntries();
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                OffsetIndexTest.$anonfun$lookupExtremeCases$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var2_3 = null;
        Assert.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        Assert.assertEquals((Object)new OffsetPosition(this.idx().baseOffset() + (long)this.idx().maxEntries(), this.idx().maxEntries() - 1), (Object)this.idx().lookup(this.idx().baseOffset() + (long)this.idx().maxEntries()));
    }

    @Test
    public void testEntry() {
        int n = 0;
        int until$extension_end = this.idx().maxEntries();
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                OffsetIndexTest.$anonfun$testEntry$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var3_3 = null;
        int n2 = 0;
        int until$extension_end2 = this.idx().maxEntries();
        Range.Exclusive foreach$mVc$sp_this2 = new Range.Exclusive(n2, until$extension_end2, 1);
        if (!foreach$mVc$sp_this2.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this2.start();
            while (true) {
                OffsetIndexTest.$anonfun$testEntry$2(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this2.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this2.step();
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEntryOverflow() {
        this.idx().entry(0);
    }

    @Test
    public void appendTooMany() {
        int n = 0;
        int until$extension_end = this.idx().maxEntries();
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                OffsetIndexTest.$anonfun$appendTooMany$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var2_3 = null;
        this.assertWriteFails("Append should fail on a full index", this.idx(), this.idx().maxEntries() + 1, IllegalArgumentException.class);
    }

    @Test(expected=InvalidOffsetException.class)
    public void appendOutOfOrder() {
        this.idx().append(51L, 0);
        this.idx().append(50L, 1);
    }

    @Test
    public void testFetchUpperBoundOffset() {
        OffsetPosition first = new OffsetPosition(this.baseOffset() + 0L, 0);
        OffsetPosition second = new OffsetPosition(this.baseOffset() + 1L, 10);
        OffsetPosition third = new OffsetPosition(this.baseOffset() + 2L, 23);
        OffsetPosition fourth = new OffsetPosition(this.baseOffset() + 3L, 37);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(first, 5));
        .colon.colon foreach_these = new .colon.colon((Object)first, (List)new .colon.colon((Object)second, (List)new .colon.colon((Object)third, (List)new .colon.colon((Object)fourth, (List)Nil$.MODULE$))));
        while (!foreach_these.isEmpty()) {
            OffsetPosition offsetPosition = (OffsetPosition)foreach_these.head();
            OffsetIndexTest.$anonfun$testFetchUpperBoundOffset$1(this, offsetPosition);
            foreach_these = (List)foreach_these.tail();
        }
        Object var5_5 = null;
        Assert.assertEquals((Object)new Some((Object)second), (Object)this.idx().fetchUpperBoundOffset(first, 5));
        Assert.assertEquals((Object)new Some((Object)second), (Object)this.idx().fetchUpperBoundOffset(first, 10));
        Assert.assertEquals((Object)new Some((Object)third), (Object)this.idx().fetchUpperBoundOffset(first, 23));
        Assert.assertEquals((Object)new Some((Object)third), (Object)this.idx().fetchUpperBoundOffset(first, 22));
        Assert.assertEquals((Object)new Some((Object)fourth), (Object)this.idx().fetchUpperBoundOffset(second, 24));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(fourth, 1));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(first, 200));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(second, 200));
    }

    @Test
    public void testReopen() {
        OffsetPosition first = new OffsetPosition(51L, 0);
        OffsetPosition sec = new OffsetPosition(52L, 1);
        this.idx().append(first.offset(), first.position());
        this.idx().append(sec.offset(), sec.position());
        this.idx().close();
        OffsetIndex idxRo = new OffsetIndex(this.idx().file(), this.idx().baseOffset(), -1, true);
        Assert.assertEquals((Object)first, (Object)idxRo.lookup(first.offset()));
        Assert.assertEquals((Object)sec, (Object)idxRo.lookup(sec.offset()));
        Assert.assertEquals((long)sec.offset(), (long)idxRo.lastOffset());
        Assert.assertEquals((long)2L, (long)idxRo.entries());
        this.assertWriteFails("Append should fail on read-only index", idxRo, 53, IllegalArgumentException.class);
    }

    @Test
    public void truncate() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80, true);
        idx.truncate();
        int n = 1;
        int until$extension_end = 10;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                idx.append((long)foreach$mVc$sp_i, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var3_4 = null;
        idx.truncateTo(12L);
        Assert.assertEquals((String)"Index should be unchanged by truncate past the end", (Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"9 should be the last entry in the index", (long)9L, (long)idx.lastOffset());
        idx.append(10L, 10);
        idx.truncateTo(10L);
        Assert.assertEquals((String)"Index should be unchanged by truncate at the end", (Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"9 should be the last entry in the index", (long)9L, (long)idx.lastOffset());
        idx.append(10L, 10);
        idx.truncateTo(9L);
        Assert.assertEquals((String)"Index should truncate off last entry", (Object)new OffsetPosition(8L, 8), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"8 should be the last entry in the index", (long)8L, (long)idx.lastOffset());
        idx.append(9L, 9);
        idx.truncateTo(5L);
        Assert.assertEquals((String)"4 should be the last entry in the index", (Object)new OffsetPosition(4L, 4), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"4 should be the last entry in the index", (long)4L, (long)idx.lastOffset());
        idx.append(5L, 5);
        idx.truncate();
        Assert.assertEquals((String)"Full truncation should leave no entries", (long)0L, (long)idx.entries());
        idx.append(0L, 0);
    }

    @Test
    public void forceUnmapTest() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80, true);
        idx.forceUnmap();
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> idx.lookup(1L), ClassTag$.MODULE$.apply(NullPointerException.class), new Position("OffsetIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
    }

    @Test
    public void testSanityLastOffsetEqualToBaseOffset() {
        long baseOffset = 20L;
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), baseOffset, 80, true);
        idx.append(baseOffset, 0);
        idx.sanityCheck();
    }

    public <T> void assertWriteFails(String message, OffsetIndex idx, int offset, Class<T> klass) {
        try {
            idx.append((long)offset, 1);
            Assert.fail((String)message);
            return;
        }
        catch (Exception e) {
            Assert.assertEquals((String)"Got an unexpected exception.", klass, e.getClass());
            return;
        }
    }

    public Seq<Object> monotonicSeq(int base, int len) {
        Random rand = new Random(1L);
        ArrayBuffer vals = new ArrayBuffer(len);
        int n = base;
        int n2 = 0;
        Range.Exclusive foreach_this = new Range.Exclusive(n2, len, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                Integer $anonfun$monotonicSeq$1_$plus$eq_elem = n += rand.nextInt(15) + 1;
                Object var8_9 = null;
                ArrayBuffer cfr_ignored_0 = (ArrayBuffer)vals.addOne((Object)$anonfun$monotonicSeq$1_$plus$eq_elem);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        return vals;
    }

    public File nonExistentTempFile() {
        File file = TestUtils.tempFile();
        Files.delete(file.toPath());
        return file;
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$2(OffsetIndexTest $this, Tuple2 x) {
        $this.idx().append(x._1$mcJ$sp(), x._2$mcI$sp());
    }

    public static final /* synthetic */ boolean $anonfun$randomLookupTest$3(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$4(OffsetIndexTest $this, Tuple2 x$2) {
        if (x$2 != null) {
            long logical = x$2._1$mcJ$sp();
            int physical = x$2._2$mcI$sp();
            Assert.assertEquals((String)"Should be able to find values that are present.", (Object)new OffsetPosition(logical, physical), (Object)$this.idx().lookup(logical));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$6(OffsetIndexTest $this, TreeMap valMap$1, long offset) {
        OffsetPosition offsetPosition;
        if (offset < BoxesRunTime.unboxToLong((Object)valMap$1.firstKey())) {
            offsetPosition = new OffsetPosition($this.idx().baseOffset(), 0);
        } else {
            Long to_to = offset;
            Object var5_3 = null;
            Long to_to2 = offset;
            Object var6_4 = null;
            OffsetPosition offsetPosition2 = new OffsetPosition(((TreeMap)SortedOps.to$((SortedOps)valMap$1, (Object)to_to)).last()._1$mcJ$sp(), ((Tuple2)((TreeMap)SortedOps.to$((SortedOps)valMap$1, (Object)to_to2)).last()._2())._2$mcI$sp());
            offsetPosition = offsetPosition2;
        }
        OffsetPosition rightAnswer = offsetPosition;
        Assert.assertEquals((String)"The index should give the same answer as the sorted map", (Object)rightAnswer, (Object)$this.idx().lookup(offset));
    }

    public static final /* synthetic */ void $anonfun$lookupExtremeCases$1(OffsetIndexTest $this, int i) {
        $this.idx().append($this.idx().baseOffset() + (long)i + 1L, i);
    }

    public static final /* synthetic */ void $anonfun$testEntry$1(OffsetIndexTest $this, int i) {
        $this.idx().append($this.idx().baseOffset() + (long)i + 1L, i);
    }

    public static final /* synthetic */ void $anonfun$testEntry$2(OffsetIndexTest $this, int i) {
        Assert.assertEquals((Object)new OffsetPosition($this.idx().baseOffset() + (long)i + 1L, i), (Object)$this.idx().entry(i));
    }

    public static final /* synthetic */ void $anonfun$appendTooMany$1(OffsetIndexTest $this, int i) {
        long offset = $this.idx().baseOffset() + (long)i + 1L;
        $this.idx().append(offset, i);
    }

    public static final /* synthetic */ void $anonfun$testFetchUpperBoundOffset$1(OffsetIndexTest $this, OffsetPosition offsetPosition) {
        $this.idx().append(offsetPosition.offset(), offsetPosition.position());
    }

    public static final /* synthetic */ void $anonfun$truncate$1(OffsetIndex idx$1, int i) {
        idx$1.append((long)i, i);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ArrayBuffer $anonfun$monotonicSeq$1(IntRef last$1, Random rand$1, ArrayBuffer vals$1, int x$3) {
        void $plus$eq_elem;
        last$1.elem += rand$1.nextInt(15) + 1;
        Integer n = last$1.elem;
        if (vals$1 == null) {
            throw null;
        }
        return (ArrayBuffer)vals$1.addOne((Object)$plus$eq_elem);
    }

    public OffsetIndexTest() {
        this.maxEntries = 30;
        this.baseOffset = 45L;
    }

    public static final /* synthetic */ Object $anonfun$testFetchUpperBoundOffset$1$adapted(OffsetIndexTest $this, OffsetPosition offsetPosition) {
        OffsetIndexTest.$anonfun$testFetchUpperBoundOffset$1($this, offsetPosition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$monotonicSeq$1$adapted(IntRef last$1, Random rand$1, ArrayBuffer vals$1, Object x$3) {
        return OffsetIndexTest.$anonfun$monotonicSeq$1(last$1, rand$1, vals$1, BoxesRunTime.unboxToInt((Object)x$3));
    }
}

