/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.AppendOrigin;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.server.Defaults$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.ReplicaManager;
import kafka.utils.MockScheduler;
import kafka.utils.Pool;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Set;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\rUb\u0001\u0002,X\u0001yCQ!\u001a\u0001\u0005\u0002\u0019Dq!\u001b\u0001C\u0002\u0013\u0005!\u000e\u0003\u0004o\u0001\u0001\u0006Ia\u001b\u0005\b_\u0002\u0011\r\u0011\"\u0001k\u0011\u0019\u0001\b\u0001)A\u0005W\"9\u0011\u000f\u0001b\u0001\n\u0003Q\u0007B\u0002:\u0001A\u0003%1\u000eC\u0004t\u0001\t\u0007I\u0011\u0001;\t\u000f\u0005\u0005\u0001\u0001)A\u0005k\"A\u00111\u0001\u0001C\u0002\u0013\u0005!\u000eC\u0004\u0002\u0006\u0001\u0001\u000b\u0011B6\t\u0013\u0005\u001d\u0001A1A\u0005\u0002\u0005%\u0001\u0002CA\u0014\u0001\u0001\u0006I!a\u0003\t\u0013\u0005%\u0002A1A\u0005\u0002\u0005-\u0002\u0002CA\u001d\u0001\u0001\u0006I!!\f\t\u0013\u0005m\u0002A1A\u0005\u0002\u0005u\u0002\u0002CA%\u0001\u0001\u0006I!a\u0010\t\u0013\u0005-\u0003A1A\u0005\u0002\u00055\u0003\u0002CA.\u0001\u0001\u0006I!a\u0014\t\u0013\u0005u\u0003A1A\u0005\u0002\u0005}\u0003\u0002CA7\u0001\u0001\u0006I!!\u0019\t\u0013\u0005=\u0004A1A\u0005\u0002\u0005E\u0004\u0002CA?\u0001\u0001\u0006I!a\u001d\t\u0013\u0005}\u0004A1A\u0005\u0002\u0005\u0005\u0005\u0002CAE\u0001\u0001\u0006I!a!\t\u0013\u0005-\u0005A1A\u0005\u0002\u00055\u0005\u0002CAK\u0001\u0001\u0006I!a$\t\u0013\u0005]\u0005A1A\u0005\u0002\u0005e\u0005\u0002CAY\u0001\u0001\u0006I!a'\t\u0013\u0005M\u0006A1A\u0005\u0002\u0005e\u0005\u0002CA[\u0001\u0001\u0006I!a'\t\u0013\u0005]\u0006A1A\u0005\u0002\u0005e\u0006\u0002CAd\u0001\u0001\u0006I!a/\t\u0013\u0005%\u0007A1A\u0005\u0002\u0005e\u0006\u0002CAf\u0001\u0001\u0006I!a/\t\u0013\u00055\u0007A1A\u0005\u0002\u0005=\u0007\u0002CAp\u0001\u0001\u0006I!!5\t\u0013\u0005\u0005\b\u00011A\u0005\u0002\u0005\r\b\"CAv\u0001\u0001\u0007I\u0011AAw\u0011!\tI\u0010\u0001Q!\n\u0005\u0015\b\"CA~\u0001\u0001\u0007I\u0011AAr\u0011%\ti\u0010\u0001a\u0001\n\u0003\ty\u0010\u0003\u0005\u0003\u0004\u0001\u0001\u000b\u0015BAs\u0011%\u0011)\u0001\u0001a\u0001\n\u0003\u00119\u0001C\u0005\u0003\u0016\u0001\u0001\r\u0011\"\u0001\u0003\u0018!A!1\u0004\u0001!B\u0013\u0011I\u0001C\u0004\u0003\u001e\u0001!\tAa\b\t\u000f\t=\u0002\u0001\"\u0001\u0003 !9!\u0011\b\u0001\u0005\u0002\t}\u0001b\u0002B\"\u0001\u0011\u0005!q\u0004\u0005\b\u0005\u000f\u0002A\u0011\u0001B\u0010\u0011\u001d\u0011Y\u0005\u0001C\u0001\u0005?AqAa\u0014\u0001\t\u0003\u0011y\u0002C\u0004\u0003T\u0001!\tAa\b\t\u000f\t]\u0003\u0001\"\u0001\u0003 !9!1\f\u0001\u0005\u0002\t}\u0001b\u0002B0\u0001\u0011\u0005!q\u0004\u0005\b\u0005G\u0002A\u0011\u0001B\u0010\u0011\u001d\u00119\u0007\u0001C\u0001\u0005?AqAa\u001b\u0001\t\u0003\u0011y\u0002C\u0004\u0003p\u0001!\tAa\b\t\u000f\t\u001d\u0005\u0001\"\u0001\u0003 !9!1\u0012\u0001\u0005\u0002\t}\u0001b\u0002BH\u0001\u0011\u0005!q\u0004\u0005\b\u0005'\u0003A\u0011\u0001B\u0010\u0011\u001d\u00119\n\u0001C\u0001\u0005?AqAa'\u0001\t\u0003\u0011y\u0002C\u0004\u0003 \u0002!\tAa\b\t\u000f\t\r\u0006\u0001\"\u0001\u0003 !9!q\u0015\u0001\u0005\u0002\t}\u0001b\u0002BV\u0001\u0011\u0005!q\u0004\u0005\b\u0005_\u0003A\u0011\u0001B\u0010\u0011\u001d\u0011\u0019\f\u0001C\u0001\u0005?AqAa.\u0001\t\u0003\u0011y\u0002C\u0004\u0003<\u0002!IA!0\t\u000f\t\r\u0007\u0001\"\u0003\u0003F\"9!\u0011\u001a\u0001\u0005\n\t-\u0007b\u0002Bn\u0001\u0011%!Q\u001c\u0005\b\u0005G\u0004A\u0011\u0002Bs\u0011\u001d\u0011I\u000f\u0001C\u0005\u0005WD\u0011B!?\u0001#\u0003%IAa?\t\u0013\rE\u0001!%A\u0005\n\rM\u0001bBB\f\u0001\u0011%1\u0011\u0004\u0005\b\u0007W\u0001A\u0011BB\u0017\u0011\u001d\u0019\t\u0004\u0001C\u0001\u0005?\u00111\u0004\u0016:b]N\f7\r^5p]N#\u0018\r^3NC:\fw-\u001a:UKN$(B\u0001-Z\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005i[\u0016aC2p_J$\u0017N\\1u_JT\u0011\u0001X\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\f\u0005\u0002aG6\t\u0011MC\u0001c\u0003\u0015\u00198-\u00197b\u0013\t!\u0017M\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u0004\"\u0001\u001b\u0001\u000e\u0003]\u000b1\u0002]1si&$\u0018n\u001c8JIV\t1\u000e\u0005\u0002aY&\u0011Q.\u0019\u0002\u0004\u0013:$\u0018\u0001\u00049beRLG/[8o\u0013\u0012\u0004\u0013!\u00048v[B\u000b'\u000f^5uS>t7/\u0001\bok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002)Q\u0014\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f^'t\u0003U!(/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;Ng\u0002\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001v!\t1h0D\u0001x\u0015\tA\u00180\u0001\u0004d_6lwN\u001c\u0006\u00039jT!a\u001f?\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0018aA8sO&\u0011qp\u001e\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0003E\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000eI\u0001\u000bibt'+Z2pe\u0012\u001cXCAA\u0006!\u0019\ti!a\u0006\u0002\u001c5\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"A\u0004nkR\f'\r\\3\u000b\u0007\u0005U\u0011-\u0001\u0006d_2dWm\u0019;j_:LA!!\u0007\u0002\u0010\tY\u0011I\u001d:bs\n+hMZ3s!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011o\u00061!/Z2pe\u0012LA!!\n\u0002 \ta1+[7qY\u0016\u0014VmY8sI\u0006YA\u000f\u001f8SK\u000e|'\u000fZ:!\u0003\u0011!\u0018.\\3\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005Mr/A\u0003vi&d7/\u0003\u0003\u00028\u0005E\"\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014XCAA !\u0011\t\t%!\u0012\u000e\u0005\u0005\r#bAA\u001a7&!\u0011qIA\"\u00055iunY6TG\",G-\u001e7fe\u0006Q1o\u00195fIVdWM\u001d\u0011\u0002\u0011i\\7\t\\5f]R,\"!a\u0014\u0011\t\u0005E\u0013qK\u0007\u0003\u0003'R1!!\u0016\\\u0003\tQ8.\u0003\u0003\u0002Z\u0005M#!D&bM.\f'l[\"mS\u0016tG/A\u0005{W\u000ec\u0017.\u001a8uA\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014XCAA1!\u0011\t\u0019'!\u001b\u000e\u0005\u0005\u0015$bAA47\u000611/\u001a:wKJLA!a\u001b\u0002f\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u000f5,GO]5dgV\u0011\u00111\u000f\t\u0005\u0003k\nI(\u0004\u0002\u0002x)\u0019\u0011qN<\n\t\u0005m\u0014q\u000f\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013!\u0003;y]\u000e{gNZ5h+\t\t\u0019\tE\u0002i\u0003\u000bK1!a\"X\u0005E!&/\u00198tC\u000e$\u0018n\u001c8D_:4\u0017nZ\u0001\u000bibt7i\u001c8gS\u001e\u0004\u0013A\u0005;sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hKJ,\"!a$\u0011\u0007!\f\t*C\u0002\u0002\u0014^\u0013q\u0003\u0016:b]N\f7\r^5p]N#\u0018\r^3NC:\fw-\u001a:\u0002'Q\u0014\u0018M\\:bGRLwN\\'b]\u0006<WM\u001d\u0011\u0002!Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\fTCAAN!\u0011\ti*a+\u000f\t\u0005}\u0015q\u0015\t\u0004\u0003C\u000bWBAAR\u0015\r\t)+X\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%\u0016-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\u000byK\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003S\u000b\u0017!\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u001332A\u0005\u0001BO]1og\u0006\u001cG/[8oC2LEMM\u0001\u0012iJ\fgn]1di&|g.\u00197JIJ\u0002\u0013a\u0005;y]6+7o]1hK.+\u0017PQ=uKN\fTCAA^!\u0015\u0001\u0017QXAa\u0013\r\ty,\u0019\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004A\u0006\r\u0017bAAcC\n!!)\u001f;f\u0003Q!\bP\\'fgN\fw-Z&fs\nKH/Z:2A\u0005\u0019B\u000f\u001f8NKN\u001c\u0018mZ3LKf\u0014\u0015\u0010^3te\u0005!B\u000f\u001f8NKN\u001c\u0018mZ3LKf\u0014\u0015\u0010^3te\u0001\n1\u0002\u001d:pIV\u001cWM]%egV\u0011\u0011\u0011\u001b\t\t\u0003'\f).a'\u0002Z6\u0011\u00111C\u0005\u0005\u0003/\f\u0019BA\u0002NCB\u00042\u0001YAn\u0013\r\ti.\u0019\u0002\u0005\u0019>tw-\u0001\u0007qe>$WoY3s\u0013\u0012\u001c\b%\u0001\u0007uq:lU\r^1eCR\f\u0017'\u0006\u0002\u0002fB\u0019\u0001.a:\n\u0007\u0005%xKA\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018-\u0001\tuq:lU\r^1eCR\f\u0017g\u0018\u0013fcR!\u0011q^A{!\r\u0001\u0017\u0011_\u0005\u0004\u0003g\f'\u0001B+oSRD\u0011\"a>(\u0003\u0003\u0005\r!!:\u0002\u0007a$\u0013'A\u0007uq:lU\r^1eCR\f\u0017\u0007I\u0001\ribtW*\u001a;bI\u0006$\u0018MM\u0001\u0011ibtW*\u001a;bI\u0006$\u0018MM0%KF$B!a<\u0003\u0002!I\u0011q\u001f\u0016\u0002\u0002\u0003\u0007\u0011Q]\u0001\u000eibtW*\u001a;bI\u0006$\u0018M\r\u0011\u0002\u001b\u0015D\b/Z2uK\u0012,%O]8s+\t\u0011I\u0001\u0005\u0003\u0003\f\tEQB\u0001B\u0007\u0015\r\u0011ya^\u0001\taJ|Go\\2pY&!!1\u0003B\u0007\u0005\u0019)%O]8sg\u0006\tR\r\u001f9fGR,G-\u0012:s_J|F%Z9\u0015\t\u0005=(\u0011\u0004\u0005\n\u0003ol\u0013\u0011!a\u0001\u0005\u0013\ta\"\u001a=qK\u000e$X\rZ#se>\u0014\b%A\u0003tKR,\u0006\u000f\u0006\u0002\u0002p\"\u001aqFa\t\u0011\t\t\u0015\"1F\u0007\u0003\u0005OQ1A!\u000b}\u0003\u0015QWO\\5u\u0013\u0011\u0011iCa\n\u0003\r\t+gm\u001c:f\u0003!!X-\u0019:E_^t\u0007f\u0001\u0019\u00034A!!Q\u0005B\u001b\u0013\u0011\u00119Da\n\u0003\u000b\u00053G/\u001a:\u0002=Q,7\u000f\u001e,bY&$\u0017\r^3Ue\u0006t7/Y2uS>tG+[7f_V$\bfA\u0019\u0003>A!!Q\u0005B \u0013\u0011\u0011\tEa\n\u0003\tQ+7\u000f^\u0001\u000fi\u0016\u001cH/\u00113e\u000f\u0016$\b+\u001b3tQ\r\u0011$QH\u0001\u0014i\u0016\u001cH\u000fR3mKR,\u0007+\u0019:uSRLwN\u001c\u0015\u0004g\tu\u0012A\u0007;fgR$U\r\\3uK2{\u0017\rZ5oOB\u000b'\u000f^5uS>t\u0007f\u0001\u001b\u0003>\u0005IC/Z:u\u0019>\fG-\u00118e%\u0016lwN^3Ue\u0006t7/Y2uS>t7OR8s!\u0006\u0014H/\u001b;j_:D3!\u000eB\u001f\u0003%\"Xm\u001d;D_6\u0004H.\u001a;f)J\fgn]5uS>tw\u000b[3o\u0003B\u0004XM\u001c3Tk\u000e\u001cW-\u001a3fI\"\u001aaG!\u0010\u0002YQ,7\u000f^!qa\u0016tGMR1jYR{7i\\8sI&t\u0017\r^8s\u001d>$\u0018I^1jY\u0006\u0014G.Z#se>\u0014\bfA\u001c\u0003>\u0005\u0019C/Z:u\u0003B\u0004XM\u001c3GC&dGk\u001c(pi\u000e{wN\u001d3j]\u0006$xN]#se>\u0014\bf\u0001\u001d\u0003>\u00059C/Z:u\u0003B\u0004XM\u001c3GC&dGk\\\"p_J$\u0017N\\1u_Jdu.\u00193j]\u001e,%O]8sQ\rI$QH\u0001\u001di\u0016\u001cH/\u00119qK:$g)Y5m)>,fn\u001b8po:,%O]8sQ\rQ$QH\u0001&i\u0016\u001cH\u000fU3oI&twm\u0015;bi\u0016tu\u000e\u001e*fg\u0016$xJ\u001c*fiJL\u0018\t\u001d9f]\u0012D3a\u000fB\u001f\u00035\"Xm\u001d;BaB,g\u000e\u001a+sC:\u001c\u0018m\u0019;j_:$v\u000eT8h/\"LG.\u001a)s_\u0012,8-\u001a:GK:\u001cW\r\u001a\u0015\u0004y\tu\u0012A\r;fgR\f\u0005\u000f]3oIR\u0013\u0018M\\:bGRLwN\u001c+p\u0019><w\u000b[5mKB+g\u000eZ5oON#\u0018\r^3DQ\u0006tw-\u001a3)\u000fu\u0012iDa\u001d\u0003v\u0005AQ\r\u001f9fGR,Gm\t\u0002\u0003xA!!\u0011\u0010BB\u001b\t\u0011YH\u0003\u0003\u0003~\t}\u0014\u0001\u00027b]\u001eT!A!!\u0002\t)\fg/Y\u0005\u0005\u0005\u000b\u0013YHA\u000bJY2,w-\u00197Ti\u0006$X-\u0012=dKB$\u0018n\u001c8\u0002\u007fMDw.\u001e7e%\u0016$XO\u001d8O_R\u001cun\u001c:jI:\fGo\u001c:FeJ|'/\u00134Ue\u0006t7/Y2uS>t\u0017\n\u001a)beRLG/[8o\u001d>$xj\u001e8fI\"\u001aaH!\u0010\u0002mMDw.\u001e7e\u001f:d\u0017pQ8og&$WM\u001d+sC:\u001c\u0018m\u0019;j_:\u001c\u0018J\u001c+iK>swm\\5oON#\u0018\r^3U_\u0006\u0013wN\u001d;)\u0007}\u0012i$\u0001\u001dtQ>,H\u000eZ,sSR,G\u000b\u001f8NCJ\\WM]:G_J$&/\u00198tC\u000e$\u0018n\u001c8J]B\u0013X\r]1sK\u0012\u001cu.\\7jiN#\u0018\r^3)\u0007\u0001\u0013i$A\u001ctQ>,H\u000eZ,sSR,G\u000b\u001f8NCJ\\WM]:G_J$&/\u00198tC\u000e$\u0018n\u001c8J]B\u0013X\r]1sK\u0012\f%m\u001c:u'R\fG/\u001a\u0015\u0004\u0003\nu\u0012AM:i_VdGMU3n_Z,7i\\7qY\u0016$XmQ8n[6LG/\u0012=qSJ,G\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:)\u0007\t\u0013i$\u0001\u0019tQ>,H\u000e\u001a*f[>4XmQ8na2,G/Z!c_J$X\t\u001f9je\u0016$GK]1og\u0006\u001cG/[8oC2LEm\u001d\u0015\u0004\u0007\nu\u0012\u0001K:i_VdGMU3n_Z,W)\u001c9us\u0016C\b/\u001b:fIR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\bf\u0001#\u0003>\u000514\u000f[8vY\u0012tu\u000e\u001e*f[>4X-\u0012=qSJ,G\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:JM2{w-\u00119qK:$g)Y5mg\"\u001aQI!\u0010\u0002MMDw.\u001e7e\u001d>$(+Z7pm\u0016|enZ8j]\u001e$&/\u00198tC\u000e$\u0018n\u001c8bY&#7\u000fK\u0002G\u0005{\t1f\u001d5pk2$gj\u001c;SK6|g/\u001a)sKB\f'/Z!c_J$HK]1og\u0006\u001cG/[8oC2LEm\u001d\u0015\u0004\u000f\nu\u0012\u0001L:i_VdGMT8u%\u0016lwN^3Qe\u0016\u0004\u0018M]3D_6l\u0017\u000e\u001e+sC:\u001c\u0018m\u0019;j_:\fG.\u00133tQ\rA%QH\u0001\u001ci\u0016\u001cHoU;dG\u0016\u001c8OZ;m%\u0016LW.\\5he\u0006$\u0018n\u001c8)\u0007%\u0013i$A\u0016uKN$Hj\\1e)J\fgn]1di&|g.T3uC\u0012\fG/Y,ji\"\u001cuN\u001d:vaR,G\rT8hQ\rQ%QH\u0001#m\u0016\u0014\u0018NZ=NKR\fG-\u0019;b\t>,7/\u0012=jgR\fe\u000eZ%t+N\f'\r\\3\u0015\t\u0005=(q\u0018\u0005\b\u0005\u0003\\\u0005\u0019AAN\u0003=!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0017!\u0007<fe&4\u00170T3uC\u0012\fG/\u0019#pKNtG/\u0012=jgR$B!a<\u0003H\"9!\u0011\u0019'A\u0002\u0005m\u0015\u0001J:fiV\u0004\u0018I\u001c3Sk:$&/\u00198tC\u000e$\u0018n\u001c8bY&#W\t\u001f9je\u0006$\u0018n\u001c8\u0015\r\u0005=(Q\u001aBi\u0011\u001d\u0011y-\u0014a\u0001\u0005\u0013\tQ!\u001a:s_JDqAa5N\u0001\u0004\u0011).\u0001\u0005uq:\u001cF/\u0019;f!\rA'q[\u0005\u0004\u00053<&\u0001\u0005+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u0003\u00112XM]5gs^\u0013\u0018\u000e^3t)btW*\u0019:lKJ\u001c\u0018J\u001c)sKB\f'/Z*uCR,G\u0003BAx\u0005?DqA!9O\u0001\u0004\u0011).A\u0003ti\u0006$X-\u0001\bbgN,'\u000f^\"bY2\u0014\u0017mY6\u0015\t\u0005=(q\u001d\u0005\b\u0005\u001f|\u0005\u0019\u0001B\u0005\u0003M!(/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b))\t)O!<\u0003p\nM(Q\u001f\u0005\b\u0005\u0003\u0004\u0006\u0019AAN\u0011\u001d\u0011\t\u0010\u0015a\u0001\u00033\f!\u0002\u001d:pIV\u001cWM]%e\u0011%\u0011\t\u000f\u0015I\u0001\u0002\u0004\u0011)\u000e\u0003\u0005\u0003xB\u0003\n\u00111\u0001l\u0003)!\bP\u001c+j[\u0016|W\u000f^\u0001\u001eiJ\fgn]1di&|g.T3uC\u0012\fG/\u0019\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q \u0016\u0005\u0005+\u0014yp\u000b\u0002\u0004\u0002A!11AB\u0007\u001b\t\u0019)A\u0003\u0003\u0004\b\r%\u0011!C;oG\",7m[3e\u0015\r\u0019Y!Y\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\b\u0007\u000b\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003u!(/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;bI\u0011,g-Y;mi\u0012\"TCAB\u000bU\rY'q`\u0001\u000eaJ,\u0007/\u0019:f)btGj\\4\u0015\u0011\u0005=81DB\u000f\u0007CAQa]*A\u0002UDqaa\bT\u0001\u0004\tI.A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\bbBB\u0012'\u0002\u00071QE\u0001\be\u0016\u001cwN\u001d3t!\u0011\tiba\n\n\t\r%\u0012q\u0004\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\u00025A\u0014X\r]1sK\u001a{'\u000f\u0016=o\u001b\u0016\u001c8/Y4f\u0003B\u0004XM\u001c3\u0015\t\u0005=8q\u0006\u0005\b\u0005\u001f$\u0006\u0019\u0001B\u0005\u0003]!Xm\u001d;QCJ$\u0018\u000e^5p]2{\u0017\rZ'fiJL7\rK\u0002V\u0005{\u0001")
public class TransactionStateManagerTest {
    private final int partitionId;
    private final int numPartitions;
    private final int transactionTimeoutMs;
    private final TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionId());
    private final int coordinatorEpoch;
    private final ArrayBuffer<SimpleRecord> txnRecords = (ArrayBuffer)IterableFactory.apply$((IterableFactory)ArrayBuffer$.MODULE$, (Seq)Nil$.MODULE$);
    private final MockTime time = new MockTime();
    private final MockScheduler scheduler = new MockScheduler((Time)this.time());
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
    private final ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
    private final Metrics metrics;
    private final TransactionConfig txnConfig;
    private final TransactionStateManager transactionManager;
    private final String transactionalId1;
    private final String transactionalId2;
    private final byte[] txnMessageKeyBytes1;
    private final byte[] txnMessageKeyBytes2;
    private final Map<String, Object> producerIds;
    private TransactionMetadata txnMetadata1;
    private TransactionMetadata txnMetadata2;
    private Errors expectedError;

    public int partitionId() {
        return this.partitionId;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public ArrayBuffer<SimpleRecord> txnRecords() {
        return this.txnRecords;
    }

    public MockTime time() {
        return this.time;
    }

    public MockScheduler scheduler() {
        return this.scheduler;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public TransactionConfig txnConfig() {
        return this.txnConfig;
    }

    public TransactionStateManager transactionManager() {
        return this.transactionManager;
    }

    public String transactionalId1() {
        return this.transactionalId1;
    }

    public String transactionalId2() {
        return this.transactionalId2;
    }

    public byte[] txnMessageKeyBytes1() {
        return this.txnMessageKeyBytes1;
    }

    public byte[] txnMessageKeyBytes2() {
        return this.txnMessageKeyBytes2;
    }

    public Map<String, Object> producerIds() {
        return this.producerIds;
    }

    public TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    public void txnMetadata1_$eq(TransactionMetadata x$1) {
        this.txnMetadata1 = x$1;
    }

    public TransactionMetadata txnMetadata2() {
        return this.txnMetadata2;
    }

    public void txnMetadata2_$eq(TransactionMetadata x$1) {
        this.txnMetadata2 = x$1;
    }

    public Errors expectedError() {
        return this.expectedError;
    }

    public void expectedError_$eq(Errors x$1) {
        this.expectedError = x$1;
    }

    @Before
    public void setUp() {
        Assert.assertEquals((long)this.partitionId(), (long)this.transactionManager().partitionFor(this.transactionalId1()));
        Assert.assertEquals((long)this.partitionId(), (long)this.transactionManager().partitionFor(this.transactionalId2()));
    }

    @After
    public void tearDown() {
        EasyMock.reset((Object[])new Object[]{this.zkClient(), this.replicaManager()});
        this.transactionManager().shutdown();
    }

    @Test
    public void testValidateTransactionTimeout() {
        Assert.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(1));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(-1));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(0));
        Assert.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs()));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs() + 1));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddGetPids() {
        void apply_value;
        void apply_value2;
        void apply_value3;
        void apply_value4;
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        None$ none$ = None$.MODULE$;
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        none$ = null;
        Assert.assertEquals((Object)new Right((Object)apply_value4), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        CoordinatorEpochAndTxnMetadata coordinatorEpochAndTxnMetadata = new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1());
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        coordinatorEpochAndTxnMetadata = null;
        Assert.assertEquals((Object)new Right((Object)apply_value3), (Object)this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1()));
        Some some = new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()));
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        some = null;
        Assert.assertEquals((Object)new Right((Object)apply_value2), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        CoordinatorEpochAndTxnMetadata coordinatorEpochAndTxnMetadata2 = new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata2());
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        coordinatorEpochAndTxnMetadata2 = null;
        Assert.assertEquals((Object)new Right((Object)apply_value), (Object)this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata2()));
    }

    @Test
    public void testDeletePartition() {
        TransactionMetadata metadata1 = this.transactionMetadata("b", 5L, (TransactionState)Empty$.MODULE$, this.transactionTimeoutMs());
        TransactionMetadata metadata2 = this.transactionMetadata("a", 10L, (TransactionState)Empty$.MODULE$, this.transactionTimeoutMs());
        Assert.assertEquals((long)0L, (long)this.transactionManager().partitionFor(metadata1.transactionalId()));
        Assert.assertEquals((long)1L, (long)this.transactionManager().partitionFor(metadata2.transactionalId()));
        this.transactionManager().addLoadedTransactionsToCache(0, this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(metadata1);
        this.transactionManager().addLoadedTransactionsToCache(1, this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(metadata2);
        Assert.assertEquals((Object)new Some((Object)metadata1.producerEpoch()), (Object)this.cachedProducerEpoch$1(metadata1.transactionalId()));
        Assert.assertEquals((Object)new Some((Object)metadata2.producerEpoch()), (Object)this.cachedProducerEpoch$1(metadata2.transactionalId()));
        this.transactionManager().removeTransactionsForTxnTopicPartition(0);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.cachedProducerEpoch$1(metadata1.transactionalId()));
        Assert.assertEquals((Object)new Some((Object)metadata2.producerEpoch()), (Object)this.cachedProducerEpoch$1(metadata2.transactionalId()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteLoadingPartition() {
        void apply_value;
        void withRecords_records;
        void apply_elems;
        long startOffset = 0L;
        long endOffset = 1L;
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        Log logMock = (Log)EasyMock.mock(Log.class);
        EasyMock.expect((Object)this.replicaManager().getLog(this.topicPartition())).andStubReturn((Object)new Some((Object)logMock));
        EasyMock.expect((Object)logMock.logStartOffset()).andStubReturn((Object)startOffset);
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((boolean)true))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), (Records)fileRecordsMock, false, (Option)None$.MODULE$));
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).andStubReturn((Object)new Some((Object)endOffset));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.txnMetadata1().addPartitions((Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit()))};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        Object var23_8 = null;
        Object var21_7 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        CountDownLatch latch = new CountDownLatch(1);
        EasyMock.expect((Object)fileRecordsMock.sizeInBytes()).andStubReturn((Object)records.sizeInBytes());
        Capture bufferCapture = EasyMock.newCapture();
        fileRecordsMock.readInto((ByteBuffer)EasyMock.capture((Capture)bufferCapture), EasyMock.anyInt());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, latch, bufferCapture, records){
            private final CountDownLatch latch$1;
            private final Capture bufferCapture$1;
            private final MemoryRecords records$1;

            public void answer() {
                this.latch$1.await();
                ByteBuffer buffer = (ByteBuffer)this.bufferCapture$1.getValue();
                buffer.put(this.records$1.buffer().duplicate());
                buffer.flip();
            }
            {
                this.latch$1 = latch$1;
                this.bufferCapture$1 = bufferCapture$1;
                this.records$1 = records$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logMock, fileRecordsMock, this.replicaManager()});
        int coordinatorEpoch = 0;
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(this.partitionId(), coordinatorEpoch);
        Thread loadingThread = new Thread(() -> this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), coordinatorEpoch, (Function4 & Serializable)(x$2, x$3, x$4, x$5) -> {
            TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$2(BoxesRunTime.unboxToInt((Object)x$2), x$3, x$4, x$5);
            return BoxedUnit.UNIT;
        }));
        loadingThread.start();
        long x$4 = 15000L;
        long waitUntilTrue_pause = 10L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$3(this, partitionAndLeaderEpoch)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                throw Assertions$.MODULE$.fail("Timed out waiting for loading partition", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(x$4, waitUntilTrue_pause));
        }
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId());
        Assert.assertFalse((boolean)this.transactionManager().loadingPartitions().contains((Object)partitionAndLeaderEpoch));
        latch.countDown();
        loadingThread.join();
        Errors errors = Errors.NOT_COORDINATOR;
        if (package$.MODULE$.Left() == null) {
            throw null;
        }
        errors = null;
        Assert.assertEquals((Object)new Left((Object)apply_value), (Object)this.transactionManager().getTransactionState(this.txnMetadata1().transactionalId()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLoadAndRemoveTransactionsForPartition() {
        void withRecords_records;
        void $plus$eq_elem;
        void $plus$eq_elem2;
        void $plus$eq_elem3;
        void $plus$eq_elem4;
        void apply_elems;
        void $plus$eq_elem5;
        void $plus$eq_elem6;
        void apply_elems2;
        void $plus$eq_elem7;
        void apply_elems3;
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.txnMetadata1().addPartitions((Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems3));
        ArrayBuffer<SimpleRecord> arrayBuffer = this.txnRecords();
        SimpleRecord simpleRecord = new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit()));
        if (arrayBuffer == null) {
            throw null;
        }
        arrayBuffer.addOne((Object)$plus$eq_elem7);
        simpleRecord = null;
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.txnMetadata1().addPartitions((Set)IterableFactory.apply$((IterableFactory)set$2, (Seq)apply_elems2));
        ArrayBuffer<SimpleRecord> arrayBuffer2 = this.txnRecords();
        SimpleRecord simpleRecord2 = new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit()));
        if (arrayBuffer2 == null) {
            throw null;
        }
        arrayBuffer2.addOne((Object)$plus$eq_elem6);
        simpleRecord2 = null;
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        ArrayBuffer<SimpleRecord> arrayBuffer3 = this.txnRecords();
        SimpleRecord simpleRecord3 = new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit()));
        if (arrayBuffer3 == null) {
            throw null;
        }
        arrayBuffer3.addOne((Object)$plus$eq_elem5);
        simpleRecord3 = null;
        this.txnMetadata2().state_$eq((TransactionState)Ongoing$.MODULE$);
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic3", 0), new TopicPartition("topic3", 1), new TopicPartition("topic3", 2)});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        this.txnMetadata2().addPartitions((Set)IterableFactory.apply$((IterableFactory)set$3, (Seq)apply_elems));
        ArrayBuffer<SimpleRecord> arrayBuffer4 = this.txnRecords();
        SimpleRecord simpleRecord4 = new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit()));
        if (arrayBuffer4 == null) {
            throw null;
        }
        arrayBuffer4.addOne((Object)$plus$eq_elem4);
        simpleRecord4 = null;
        this.txnMetadata2().state_$eq((TransactionState)PrepareAbort$.MODULE$);
        ArrayBuffer<SimpleRecord> arrayBuffer5 = this.txnRecords();
        SimpleRecord simpleRecord5 = new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit()));
        if (arrayBuffer5 == null) {
            throw null;
        }
        arrayBuffer5.addOne((Object)$plus$eq_elem3);
        simpleRecord5 = null;
        this.txnMetadata2().state_$eq((TransactionState)CompleteAbort$.MODULE$);
        ArrayBuffer<SimpleRecord> arrayBuffer6 = this.txnRecords();
        SimpleRecord simpleRecord6 = new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit()));
        if (arrayBuffer6 == null) {
            throw null;
        }
        arrayBuffer6.addOne((Object)$plus$eq_elem2);
        simpleRecord6 = null;
        this.txnMetadata2().state_$eq((TransactionState)Empty$.MODULE$);
        this.txnMetadata2().topicPartitions().clear();
        ArrayBuffer<SimpleRecord> arrayBuffer7 = this.txnRecords();
        SimpleRecord simpleRecord7 = new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit()));
        if (arrayBuffer7 == null) {
            throw null;
        }
        arrayBuffer7.addOne((Object)$plus$eq_elem);
        simpleRecord7 = null;
        long startOffset = 15L;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        Object var25_13 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])withRecords_records);
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        Either either = this.transactionManager().getTransactionState(this.transactionalId1());
        if (either == null) {
            throw null;
        }
        Either fold_this = either;
        if (fold_this instanceof Right) {
            Option option = (Option)((Right)fold_this).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
        }
        if (!(fold_this instanceof Left)) {
            throw new MatchError((Object)fold_this);
        }
        Errors errors = (Errors)((Left)fold_this).value();
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)errors);
        Object var16_15 = null;
        Either either2 = this.transactionManager().getTransactionState(this.transactionalId2());
        if (either2 == null) {
            throw null;
        }
        Either fold_this2 = either2;
        if (fold_this2 instanceof Right) {
            Option option = (Option)((Right)fold_this2).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(44).append(this.transactionalId2()).append("'s transaction state is already in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        }
        if (!(fold_this2 instanceof Left)) {
            throw new MatchError((Object)fold_this2);
        }
        Errors errors2 = (Errors)((Left)fold_this2).value();
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)errors2);
        Object var17_18 = null;
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable)(x$8, x$9, x$10, x$11) -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$5(BoxesRunTime.unboxToInt((Object)x$8), x$9, x$10, x$11);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Either either3 = this.transactionManager().getTransactionState(this.transactionalId1());
        if (either3 == null) {
            throw null;
        }
        Either fold_this3 = either3;
        if (!(fold_this3 instanceof Right)) {
            if (fold_this3 instanceof Left) {
                Errors errors3 = (Errors)((Left)fold_this3).value();
                throw Assertions$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(errors3).toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
            }
            throw new MatchError((Object)fold_this3);
        }
        Option option = (Option)((Right)fold_this3).value();
        TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$7(this, option);
        Object var18_21 = null;
        Either either4 = this.transactionManager().getTransactionState(this.transactionalId1());
        if (either4 == null) {
            throw null;
        }
        Either fold_this4 = either4;
        if (!(fold_this4 instanceof Right)) {
            if (fold_this4 instanceof Left) {
                Errors errors4 = (Errors)((Left)fold_this4).value();
                throw Assertions$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(errors4).toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
            }
            throw new MatchError((Object)fold_this4);
        }
        Object fold_b = ((Right)fold_this4).value();
        Option option2 = (Option)fold_b;
        Object var19_24 = null;
        Object var20_25 = null;
        CoordinatorEpochAndTxnMetadata cachedPidMetadata1 = TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$10(this, option2);
        Either either5 = this.transactionManager().getTransactionState(this.transactionalId2());
        if (either5 == null) {
            throw null;
        }
        Either fold_this5 = either5;
        if (!(fold_this5 instanceof Right)) {
            if (fold_this5 instanceof Left) {
                Errors errors5 = (Errors)((Left)fold_this5).value();
                throw Assertions$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state access returns error ").append(errors5).toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
            }
            throw new MatchError((Object)fold_this5);
        }
        Object fold_b2 = ((Right)fold_this5).value();
        Option option3 = (Option)fold_b2;
        Object var21_29 = null;
        Object var22_30 = null;
        CoordinatorEpochAndTxnMetadata cachedPidMetadata2 = TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$13(this, option3);
        Assert.assertEquals((Object)this.txnMetadata1(), (Object)cachedPidMetadata1.transactionMetadata());
        Assert.assertEquals((Object)this.txnMetadata2(), (Object)cachedPidMetadata2.transactionMetadata());
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.scheduler().tick();
        Either either6 = this.transactionManager().getTransactionState(this.transactionalId1());
        if (either6 == null) {
            throw null;
        }
        Either fold_this6 = either6;
        if (fold_this6 instanceof Right) {
            Option option4 = (Option)((Right)fold_this6).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state is still in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
        }
        if (!(fold_this6 instanceof Left)) {
            throw new MatchError((Object)fold_this6);
        }
        Errors errors6 = (Errors)((Left)fold_this6).value();
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)errors6);
        Object var23_34 = null;
        Either either7 = this.transactionManager().getTransactionState(this.transactionalId2());
        if (either7 == null) {
            throw null;
        }
        Either fold_this7 = either7;
        if (fold_this7 instanceof Right) {
            Option option5 = (Option)((Right)fold_this7).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state is still in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
        }
        if (fold_this7 instanceof Left) {
            Errors errors7 = (Errors)((Left)fold_this7).value();
            Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)errors7);
            return;
        }
        throw new MatchError((Object)fold_this7);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCompleteTransitionWhenAppendSucceeded() {
        void apply_value;
        void apply_elems;
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NONE);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems), this.time().milliseconds());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), this.coordinatorEpoch(), newMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Some some = new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()));
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        some = null;
        Assert.assertEquals((Object)new Right((Object)apply_value), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAppendFailToCoordinatorNotAvailableError() {
        void apply_value;
        void apply_elems;
        void apply_value2;
        void apply_elems2;
        void apply_value3;
        void apply_elems3;
        void apply_value4;
        void apply_elems4;
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems4), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Some some = new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()));
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        some = null;
        Assert.assertEquals((Object)new Right((Object)apply_value4), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$2, (Seq)apply_elems3), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Some some2 = new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()));
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        some2 = null;
        Assert.assertEquals((Object)new Right((Object)apply_value3), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$3, (Seq)apply_elems2), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Some some3 = new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()));
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        some3 = null;
        Assert.assertEquals((Object)new Right((Object)apply_value2), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)});
        if (set$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$4, (Seq)apply_elems), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.REQUEST_TIMED_OUT);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Some some4 = new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()));
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        some4 = null;
        Assert.assertEquals((Object)new Right((Object)apply_value), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAppendFailToNotCoordinatorError() {
        void apply_elems;
        void apply_value;
        void apply_elems2;
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems2), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_LEADER_OR_FOLLOWER);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Some some = new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()));
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        some = null;
        Assert.assertEquals((Object)new Right((Object)apply_value), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$2, (Seq)apply_elems), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch() + 1, new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAppendFailToCoordinatorLoadingError() {
        void apply_elems;
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_LOAD_IN_PROGRESS);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadingPartition(this.partitionId(), this.coordinatorEpoch() + 1);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAppendFailToUnknownError() {
        void apply_value;
        void apply_elems;
        void apply_value2;
        void apply_elems2;
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.UNKNOWN_SERVER_ERROR);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems2), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.MESSAGE_TOO_LARGE);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Some some = new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()));
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        some = null;
        Assert.assertEquals((Object)new Right((Object)apply_value2), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$2, (Seq)apply_elems), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.RECORD_LIST_TOO_LARGE);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Some some2 = new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()));
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        some2 = null;
        Assert.assertEquals((Object)new Right((Object)apply_value), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPendingStateNotResetOnRetryAppend() {
        void apply_value;
        void apply_elems;
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testPendingStateNotResetOnRetryAppend$2(x$14)));
        Some some = new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()));
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        some = null;
        Assert.assertEquals((Object)new Right((Object)apply_value), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)new Some((Object)Ongoing$.MODULE$), (Object)this.txnMetadata1().pendingState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAppendTransactionToLogWhileProducerFenced() {
        void apply_elems;
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), 0, new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems), this.time().milliseconds());
        this.txnMetadata1().producerEpoch_$eq((short)(this.txnMetadata1().producerEpoch() + 1));
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, newMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    /*
     * WARNING - void declaration
     */
    @Test(expected=IllegalStateException.class)
    public void testAppendTransactionToLogWhilePendingStateChanged() {
        void apply_elems;
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.INVALID_PRODUCER_EPOCH);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems), this.time().milliseconds());
        this.txnMetadata1().pendingState_$eq((Option)None$.MODULE$);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, newMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned() {
        Either either = this.transactionManager().getTransactionState(this.transactionalId1());
        if (either == null) {
            throw null;
        }
        Either fold_this = either;
        if (fold_this instanceof Right) {
            Option option = (Option)((Right)fold_this).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
        }
        if (fold_this instanceof Left) {
            Errors errors = (Errors)((Left)fold_this).value();
            Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)errors);
            return;
        }
        throw new MatchError((Object)fold_this);
    }

    @Test
    public void shouldOnlyConsiderTransactionsInTheOngoingStateToAbort() {
        int n = 0;
        int until$extension_end = this.numPartitions();
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                TransactionStateManagerTest.$anonfun$shouldOnlyConsiderTransactionsInTheOngoingStateToAbort$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var3_3 = null;
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("ongoing", 0L, (TransactionState)Ongoing$.MODULE$, this.transactionTimeoutMs()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("not-expiring", 1L, (TransactionState)Ongoing$.MODULE$, 10000));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("prepare-commit", 2L, (TransactionState)PrepareCommit$.MODULE$, this.transactionTimeoutMs()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("prepare-abort", 3L, (TransactionState)PrepareAbort$.MODULE$, this.transactionTimeoutMs()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("complete-commit", 4L, (TransactionState)CompleteCommit$.MODULE$, this.transactionTimeoutMs()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("complete-abort", 5L, (TransactionState)CompleteAbort$.MODULE$, this.transactionTimeoutMs()));
        this.time().sleep(2000L);
        Iterable expiring = this.transactionManager().timedOutTransactions();
        Assert.assertEquals((Object)new .colon.colon((Object)new TransactionalIdAndProducerIdEpoch("ongoing", 0L, 0), (List)Nil$.MODULE$), (Object)expiring);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedCommitState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedAbortState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test
    public void shouldRemoveCompleteCommmitExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteCommit$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveCompleteAbortExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveEmptyExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Empty$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveExpiredTransactionalIdsIfLogAppendFails() {
        this.setupAndRunTransactionalIdExpiration(Errors.NOT_ENOUGH_REPLICAS, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveOngoingTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Ongoing$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareAbortTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareCommitTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareCommit$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuccessfulReimmigration() {
        void withRecords_records;
        void $plus$eq_elem;
        void apply_elems;
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.txnMetadata1().addPartitions((Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems));
        ArrayBuffer<SimpleRecord> arrayBuffer = this.txnRecords();
        SimpleRecord simpleRecord = new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit()));
        if (arrayBuffer == null) {
            throw null;
        }
        arrayBuffer.addOne((Object)$plus$eq_elem);
        simpleRecord = null;
        long startOffset = 0L;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        Object var8_6 = null;
        Object var6_5 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable)(x$16, x$17, x$18, x$19) -> {
            TransactionStateManagerTest.$anonfun$testSuccessfulReimmigration$1(BoxesRunTime.unboxToInt((Object)x$16), x$17, x$18, x$19);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)0L, (long)this.transactionManager().loadingPartitions().size());
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 1, (Function4 & Serializable)(x$20, x$21, x$22, x$23) -> {
            TransactionStateManagerTest.$anonfun$testSuccessfulReimmigration$2(BoxesRunTime.unboxToInt((Object)x$20), x$21, x$22, x$23);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)0L, (long)this.transactionManager().loadingPartitions().size());
        Assert.assertTrue((boolean)this.transactionManager().transactionMetadataCache().get((Object)this.partitionId()).isDefined());
        Assert.assertEquals((long)1L, (long)((TxnMetadataCacheEntry)this.transactionManager().transactionMetadataCache().get((Object)this.partitionId()).get()).coordinatorEpoch());
    }

    @Test
    public void testLoadTransactionMetadataWithCorruptedLog() {
        long startOffset = 0L;
        long endOffset = 10L;
        Log logMock = (Log)EasyMock.mock(Log.class);
        EasyMock.expect((Object)this.replicaManager().getLog(this.topicPartition())).andStubReturn((Object)new Some((Object)logMock));
        EasyMock.expect((Object)logMock.logStartOffset()).andStubReturn((Object)startOffset);
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((boolean)true))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), (Records)MemoryRecords.EMPTY, false, (Option)None$.MODULE$));
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).andStubReturn((Object)new Some((Object)endOffset));
        EasyMock.replay((Object[])new Object[]{logMock});
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable)(x$24, x$25, x$26, x$27) -> {
            TransactionStateManagerTest.$anonfun$testLoadTransactionMetadataWithCorruptedLog$1(BoxesRunTime.unboxToInt((Object)x$24), x$25, x$26, x$27);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        EasyMock.verify((Object[])new Object[]{logMock});
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
        Assert.assertEquals((long)0L, (long)this.transactionManager().loadingPartitions().size());
    }

    private void verifyMetadataDoesExistAndIsUsable(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            throw Assertions$.MODULE$.fail("shouldn't have been any errors", new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 620));
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                throw Assertions$.MODULE$.fail("metadata should have been removed", new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 621));
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            CoordinatorEpochAndTxnMetadata metadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
            Assert.assertTrue((String)"metadata shouldn't be in a pending state", (boolean)metadata.transactionMetadata().pendingState().isEmpty());
            return;
        }
        throw new MatchError((Object)either);
    }

    private void verifyMetadataDoesntExist(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            throw Assertions$.MODULE$.fail("shouldn't have been any errors", new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 629));
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            if ((Option)right.value() instanceof Some) {
                throw Assertions$.MODULE$.fail("metadata should have been removed", new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 630));
            }
        }
        if (bl && None$.MODULE$.equals(option = (Option)right.value())) {
            return;
        }
        throw new MatchError((Object)either);
    }

    /*
     * WARNING - void declaration
     */
    private void setupAndRunTransactionalIdExpiration(Errors error, TransactionState txnState) {
        void withRecords_records;
        void withRecords_timestampType;
        int n = 0;
        int until$extension_end = this.numPartitions();
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                TransactionStateManagerTest.$anonfun$setupAndRunTransactionalIdExpiration$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var8_5 = null;
        Capture capturedArgument = EasyMock.newCapture();
        TopicPartition partition = new TopicPartition("__transaction_state", this.transactionManager().partitionFor(this.transactionalId1()));
        Object[] objectArray = new Tuple2[1];
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds() + (long)this.txnConfig().removeExpiredTransactionalIdsIntervalMs(), TransactionLog$.MODULE$.keyToBytes(this.transactionalId1()), null)};
        CompressionType withRecords_compressionType = TransactionLog$.MODULE$.EnforcedCompressionType();
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var11_10 = null;
        simpleRecordArray = null;
        MemoryRecords $minus$greater$extension_y = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Object var7_14 = null;
        objectArray[0] = new Tuple2((Object)partition, (Object)$minus$greater$extension_y);
        Map recordsByPartition = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        if (Empty$.MODULE$.equals(txnState) ? true : (CompleteCommit$.MODULE$.equals(txnState) ? true : CompleteAbort$.MODULE$.equals(txnState))) {
            this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.eq((short)((short)-1)), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)EasyMock.eq((Object)recordsByPartition), (Function1)EasyMock.capture((Capture)capturedArgument), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
            EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer(() -> {
                TransactionStateManagerTest.$anonfun$setupAndRunTransactionalIdExpiration$2(capturedArgument, partition, error);
                return BoxedUnit.UNIT;
            });
        }
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.txnMetadata1().txnLastUpdateTimestamp_$eq(this.time().milliseconds() - (long)this.txnConfig().transactionalIdExpirationMs());
        this.txnMetadata1().state_$eq(txnState);
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.txnMetadata2().txnLastUpdateTimestamp_$eq(this.time().milliseconds());
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata2());
        this.transactionManager().enableTransactionalIdExpiration();
        this.time().sleep((long)this.txnConfig().removeExpiredTransactionalIdsIntervalMs());
        this.scheduler().tick();
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    /*
     * WARNING - void declaration
     */
    private void verifyWritesTxnMarkersInPrepareState(TransactionState state) {
        void withRecords_records;
        void $plus$eq_elem;
        void apply_elems;
        this.txnMetadata1().state_$eq(state);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.txnMetadata1().addPartitions((Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems));
        ArrayBuffer<SimpleRecord> arrayBuffer = this.txnRecords();
        SimpleRecord simpleRecord = new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit()));
        if (arrayBuffer == null) {
            throw null;
        }
        arrayBuffer.addOne((Object)$plus$eq_elem);
        simpleRecord = null;
        long startOffset = 0L;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        Object var10_7 = null;
        Object var8_6 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        ObjectRef txnId = new ObjectRef(null);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable)(coordinatorEpoch, command, metadata, newMetadata) -> {
            TransactionStateManagerTest.rememberTxnMarkers$1(BoxesRunTime.unboxToInt((Object)coordinatorEpoch), command, metadata, newMetadata, txnId);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assert.assertEquals((Object)this.transactionalId1(), (Object)((String)txnId.elem));
    }

    private void assertCallback(Errors error) {
        Assert.assertEquals((Object)this.expectedError(), (Object)error);
    }

    private TransactionMetadata transactionMetadata(String transactionalId, long producerId, TransactionState state, int txnTimeout) {
        return TransactionMetadata$.MODULE$.apply(transactionalId, producerId, (short)0, txnTimeout, state, this.time().milliseconds());
    }

    private TransactionState transactionMetadata$default$3() {
        return Empty$.MODULE$;
    }

    private int transactionMetadata$default$4() {
        return this.transactionTimeoutMs();
    }

    private void prepareTxnLog(TopicPartition topicPartition, long startOffset, MemoryRecords records) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Log logMock = (Log)EasyMock.mock(Log.class);
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        long endOffset = startOffset + (long)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.lang.Iterable)records.records()).asScala().size();
        EasyMock.expect((Object)this.replicaManager().getLog(topicPartition)).andStubReturn((Object)new Some((Object)logMock));
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(topicPartition)).andStubReturn((Object)new Some((Object)endOffset));
        EasyMock.expect((Object)logMock.logStartOffset()).andStubReturn((Object)startOffset);
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((boolean)true))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), (Records)fileRecordsMock, false, (Option)None$.MODULE$));
        EasyMock.expect((Object)fileRecordsMock.sizeInBytes()).andStubReturn((Object)records.sizeInBytes());
        Capture bufferCapture = EasyMock.newCapture();
        fileRecordsMock.readInto((ByteBuffer)EasyMock.capture((Capture)bufferCapture), EasyMock.anyInt());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, bufferCapture, records){
            private final Capture bufferCapture$2;
            private final MemoryRecords records$2;

            public void answer() {
                ByteBuffer buffer = (ByteBuffer)this.bufferCapture$2.getValue();
                buffer.put(this.records$2.buffer().duplicate());
                buffer.flip();
            }
            {
                this.bufferCapture$2 = bufferCapture$2;
                this.records$2 = records$2;
            }
        });
        EasyMock.replay((Object[])new Object[]{logMock, fileRecordsMock, this.replicaManager()});
    }

    private void prepareForTxnMessageAppend(Errors error) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Capture capturedArgument = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)capturedArgument), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer(() -> {
            TransactionStateManagerTest.$anonfun$prepareForTxnMessageAppend$1(this, capturedArgument, error);
            return BoxedUnit.UNIT;
        });
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)1));
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionLoadMetric() {
        void withRecords_records;
        void $plus$eq_elem;
        void apply_elems;
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        String mBeanName = "kafka.server:type=transaction-coordinator-metrics";
        JmxReporter reporter = new JmxReporter();
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("kafka.server");
        reporter.contextChange((MetricsContext)metricsContext);
        this.metrics().addReporter((MetricsReporter)reporter);
        Assert.assertTrue((boolean)server.isRegistered(new ObjectName(mBeanName)));
        Assert.assertEquals((double)Double.NaN, (double)TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-max", server, mBeanName), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-avg", server, mBeanName), (double)0.0);
        Assert.assertTrue((boolean)reporter.containsMbean(mBeanName));
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 1), new TopicPartition("topic1", 1)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.txnMetadata1().addPartitions((Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems));
        ArrayBuffer<SimpleRecord> arrayBuffer = this.txnRecords();
        SimpleRecord simpleRecord = new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit()));
        if (arrayBuffer == null) {
            throw null;
        }
        arrayBuffer.addOne((Object)$plus$eq_elem);
        simpleRecord = null;
        long startOffset = 15L;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        Object var12_10 = null;
        Object var10_9 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable)(x$28, x$29, x$30, x$31) -> {
            TransactionStateManagerTest.$anonfun$testPartitionLoadMetric$1(BoxesRunTime.unboxToInt((Object)x$28), x$29, x$30, x$31);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assert.assertTrue((TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-max", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-avg", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ short $anonfun$testDeletePartition$1(CoordinatorEpochAndTxnMetadata x$1) {
        return x$1.transactionMetadata().producerEpoch();
    }

    private final Option cachedProducerEpoch$1(String transactionalId) {
        Option option = this.transactionManager().getTransactionState(transactionalId).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        if (map_this.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)TransactionStateManagerTest.$anonfun$testDeletePartition$1((CoordinatorEpochAndTxnMetadata)map_this.get()));
    }

    public static final /* synthetic */ void $anonfun$testDeleteLoadingPartition$2(int x$2, TransactionResult x$3, TransactionMetadata x$4, TxnTransitMetadata x$5) {
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteLoadingPartition$3(TransactionStateManagerTest $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.transactionManager().loadingPartitions().contains((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ String $anonfun$testDeleteLoadingPartition$4() {
        return "Timed out waiting for loading partition";
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$1(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$3(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$5(int x$8, TransactionResult x$9, TransactionMetadata x$10, TxnTransitMetadata x$11) {
    }

    public static final /* synthetic */ CoordinatorEpochAndTxnMetadata $anonfun$testLoadAndRemoveTransactionsForPartition$7(TransactionStateManagerTest $this, Option entry) {
        if (entry == null) {
            throw null;
        }
        if (entry.isEmpty()) {
            throw Assertions$.MODULE$.fail(new StringBuilder(50).append($this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        }
        return (CoordinatorEpochAndTxnMetadata)entry.get();
    }

    public static final /* synthetic */ CoordinatorEpochAndTxnMetadata $anonfun$testLoadAndRemoveTransactionsForPartition$10(TransactionStateManagerTest $this, Option entry) {
        if (entry == null) {
            throw null;
        }
        if (entry.isEmpty()) {
            throw Assertions$.MODULE$.fail(new StringBuilder(50).append($this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        }
        return (CoordinatorEpochAndTxnMetadata)entry.get();
    }

    public static final /* synthetic */ CoordinatorEpochAndTxnMetadata $anonfun$testLoadAndRemoveTransactionsForPartition$13(TransactionStateManagerTest $this, Option entry) {
        if (entry == null) {
            throw null;
        }
        if (entry.isEmpty()) {
            throw Assertions$.MODULE$.fail(new StringBuilder(50).append($this.transactionalId2()).append("'s transaction state was not loaded into the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
        }
        return (CoordinatorEpochAndTxnMetadata)entry.get();
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$15(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$17(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ boolean $anonfun$testPendingStateNotResetOnRetryAppend$2(Errors x$14) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned$1(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$shouldOnlyConsiderTransactionsInTheOngoingStateToAbort$1(TransactionStateManagerTest $this, int partitionId) {
        $this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)None$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulReimmigration$1(int x$16, TransactionResult x$17, TransactionMetadata x$18, TxnTransitMetadata x$19) {
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulReimmigration$2(int x$20, TransactionResult x$21, TransactionMetadata x$22, TxnTransitMetadata x$23) {
    }

    public static final /* synthetic */ void $anonfun$testLoadTransactionMetadataWithCorruptedLog$1(int x$24, TransactionResult x$25, TransactionMetadata x$26, TxnTransitMetadata x$27) {
    }

    public static final /* synthetic */ void $anonfun$setupAndRunTransactionalIdExpiration$1(TransactionStateManagerTest $this, int partitionId) {
        $this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)None$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$setupAndRunTransactionalIdExpiration$2(Capture capturedArgument$1, TopicPartition partition$1, Errors error$1) {
        Object[] objectArray = new Tuple2[1];
        ProduceResponse.PartitionResponse $minus$greater$extension_y = new ProduceResponse.PartitionResponse(error$1, 0L, -1L, 0L);
        Object var3_3 = null;
        objectArray[0] = new Tuple2((Object)partition$1, (Object)$minus$greater$extension_y);
        ((Function1)capturedArgument$1.getValue()).apply(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
    }

    private static final void rememberTxnMarkers$1(int coordinatorEpoch, TransactionResult command, TransactionMetadata metadata, TxnTransitMetadata newMetadata, ObjectRef txnId$1) {
        txnId$1.elem = metadata.transactionalId();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$prepareForTxnMessageAppend$1(TransactionStateManagerTest $this, Capture capturedArgument$2, Errors error$2) {
        void $minus$greater$extension_y;
        Object[] objectArray = new Tuple2[1];
        ProduceResponse.PartitionResponse partitionResponse = new ProduceResponse.PartitionResponse(error$2, 0L, -1L, 0L);
        TopicPartition $minus$greater$extension_$this = new TopicPartition("__transaction_state", $this.partitionId());
        Object var3_4 = null;
        partitionResponse = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ((Function1)capturedArgument$2.getValue()).apply(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
    }

    private static final double partitionLoadTime$1(String attribute, MBeanServer server$1, String mBeanName$1) {
        return BoxesRunTime.unboxToDouble((Object)server$1.getAttribute(new ObjectName(mBeanName$1), attribute));
    }

    public static final /* synthetic */ void $anonfun$testPartitionLoadMetric$1(int x$28, TransactionResult x$29, TransactionMetadata x$30, TxnTransitMetadata x$31) {
    }

    /*
     * WARNING - void declaration
     */
    public TransactionStateManagerTest() {
        void $minus$greater$extension_y;
        this.partitionId = 0;
        this.numPartitions = 2;
        this.transactionTimeoutMs = 1000;
        this.coordinatorEpoch = 10;
        EasyMock.expect((Object)this.zkClient().getTopicPartitionCount("__transaction_state")).andReturn((Object)new Some((Object)this.numPartitions())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.metrics = new Metrics();
        this.txnConfig = new TransactionConfig(TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs(), TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs(), TransactionLog$.MODULE$.DefaultNumPartitions(), TransactionLog$.MODULE$.DefaultReplicationFactor(), TransactionLog$.MODULE$.DefaultSegmentBytes(), TransactionLog$.MODULE$.DefaultLoadBufferSize(), TransactionLog$.MODULE$.DefaultMinInSyncReplicas(), TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs(), TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs(), Defaults$.MODULE$.RequestTimeoutMs());
        this.transactionManager = new TransactionStateManager(0, this.zkClient(), (Scheduler)this.scheduler(), this.replicaManager(), this.txnConfig(), (Time)this.time(), this.metrics());
        this.transactionalId1 = "one";
        this.transactionalId2 = "two";
        this.txnMessageKeyBytes1 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId1());
        this.txnMessageKeyBytes2 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId2());
        Object[] objectArray = new Tuple2[2];
        Long $minus$greater$extension_y2 = 1L;
        String $minus$greater$extension_$this = this.transactionalId1();
        Object var1_2 = null;
        Object var2_1 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        Long l = 2L;
        String $minus$greater$extension_$this2 = this.transactionalId2();
        Object var3_4 = null;
        l = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        this.producerIds = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.txnMetadata1 = this.transactionMetadata(this.transactionalId1(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId1())), (TransactionState)Empty$.MODULE$, this.transactionTimeoutMs());
        this.txnMetadata2 = this.transactionMetadata(this.transactionalId2(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId2())), (TransactionState)Empty$.MODULE$, this.transactionTimeoutMs());
        this.expectedError = Errors.NONE;
    }

    public static final /* synthetic */ Object $anonfun$testLoadAndRemoveTransactionsForPartition$1$adapted(Errors err) {
        TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$1(err);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadAndRemoveTransactionsForPartition$3$adapted(Errors err) {
        TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$3(err);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadAndRemoveTransactionsForPartition$15$adapted(Errors err) {
        TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$15(err);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadAndRemoveTransactionsForPartition$17$adapted(Errors err) {
        TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$17(err);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned$1$adapted(Errors err) {
        TransactionStateManagerTest.$anonfun$shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned$1(err);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDeletePartition$1$adapted(CoordinatorEpochAndTxnMetadata x$1) {
        return BoxesRunTime.boxToShort((short)TransactionStateManagerTest.$anonfun$testDeletePartition$1(x$1));
    }
}

