/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.util.Arrays;
import kafka.coordinator.group.MemberMetadata;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005I4A\u0001G\r\u0001A!)q\u0005\u0001C\u0001Q!91\u0006\u0001b\u0001\n\u0003a\u0003BB\u001b\u0001A\u0003%Q\u0006C\u00047\u0001\t\u0007I\u0011A\u001c\t\rm\u0002\u0001\u0015!\u00039\u0011\u001da\u0004A1A\u0005\u00021Ba!\u0010\u0001!\u0002\u0013i\u0003b\u0002 \u0001\u0005\u0004%\t\u0001\f\u0005\u0007\u007f\u0001\u0001\u000b\u0011B\u0017\t\u000f\u0001\u0003!\u0019!C\u0001Y!1\u0011\t\u0001Q\u0001\n5BqA\u0011\u0001C\u0002\u0013\u0005A\u0006\u0003\u0004D\u0001\u0001\u0006I!\f\u0005\b\t\u0002\u0011\r\u0011\"\u0001F\u0011\u0019I\u0005\u0001)A\u0005\r\"9!\n\u0001b\u0001\n\u0003)\u0005BB&\u0001A\u0003%a\tC\u0003M\u0001\u0011\u0005Q\nC\u0003[\u0001\u0011\u0005Q\nC\u0003]\u0001\u0011\u0005Q\nC\u0003_\u0001\u0011\u0005Q\nC\u0003o\u0001\u0011\u0005Q\nC\u0003q\u0001\u0011\u0005QJ\u0001\nNK6\u0014WM]'fi\u0006$\u0017\r^1UKN$(B\u0001\u000e\u001c\u0003\u00159'o\\;q\u0015\taR$A\u0006d_>\u0014H-\u001b8bi>\u0014(\"\u0001\u0010\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\t\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0003C\u0001\u0016\u0001\u001b\u0005I\u0012aB4s_V\u0004\u0018\nZ\u000b\u0002[A\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0005Y\u0006twMC\u00013\u0003\u0011Q\u0017M^1\n\u0005Qz#AB*ue&tw-\u0001\u0005he>,\b/\u00133!\u0003=9'o\\;q\u0013:\u001cH/\u00198dK&#W#\u0001\u001d\u0011\u0007\tJT&\u0003\u0002;G\t!1k\\7f\u0003A9'o\\;q\u0013:\u001cH/\u00198dK&#\u0007%\u0001\u0005dY&,g\u000e^%e\u0003%\u0019G.[3oi&#\u0007%\u0001\u0006dY&,g\u000e\u001e%pgR\f1b\u00197jK:$\bj\\:uA\u0005AQ.Z7cKJLE-A\u0005nK6\u0014WM]%eA\u0005a\u0001O]8u_\u000e|G\u000eV=qK\u0006i\u0001O]8u_\u000e|G\u000eV=qK\u0002\n!C]3cC2\fgnY3US6,w.\u001e;NgV\ta\t\u0005\u0002#\u000f&\u0011\u0001j\t\u0002\u0004\u0013:$\u0018a\u0005:fE\u0006d\u0017M\\2f)&lWm\\;u\u001bN\u0004\u0013\u0001E:fgNLwN\u001c+j[\u0016|W\u000f^'t\u0003E\u0019Xm]:j_:$\u0016.\\3pkRl5\u000fI\u0001\u001ei\u0016\u001cH/T1uG\",7oU;qa>\u0014H/\u001a3Qe>$xnY8mgR\ta\n\u0005\u0002#\u001f&\u0011\u0001k\t\u0002\u0005+:LG\u000f\u000b\u0002\u0013%B\u00111\u000bW\u0007\u0002)*\u0011QKV\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002/\u0006\u0019qN]4\n\u0005e#&\u0001\u0002+fgR\fA\u0004^3tiZ{G/\u001a$peB\u0013XMZ3se\u0016$\u0007K]8u_\u000e|G\u000e\u000b\u0002\u0014%\u0006aA/Z:u\u001b\u0016$\u0018\rZ1uC\"\u0012ACU\u0001(i\u0016\u001cH/T3uC\u0012\fG/\u0019*bSN,7o\u00148V]N,\b\u000f]8si\u0016$\u0007K]8u_\u000e|G\u000e\u000b\u0003\u0016%\u0002\f\u0017\u0001C3ya\u0016\u001cG/\u001a3$\u0003\t\u0004\"aY6\u000f\u0005\u0011LgBA3i\u001b\u00051'BA4 \u0003\u0019a$o\\8u}%\tA%\u0003\u0002kG\u00059\u0001/Y2lC\u001e,\u0017B\u00017n\u0005aIE\u000e\\3hC2\f%oZ;nK:$X\t_2faRLwN\u001c\u0006\u0003U\u000e\nA\u0005^3tiZ{G/\u001a*bSN,7o\u00148O_N+\b\u000f]8si\u0016$\u0007K]8u_\u000e|Gn\u001d\u0015\u0005-I\u0003\u0017-A\u000euKN$\b*Y:WC2LGm\u0012:pkBLen\u001d;b]\u000e,\u0017\n\u001a\u0015\u0003/I\u0003")
public class MemberMetadataTest {
    private final String groupId;
    private final Some<String> groupInstanceId = new Some((Object)"groupInstanceId");
    private final String clientId;
    private final String clientHost;
    private final String memberId;
    private final String protocolType;
    private final int rebalanceTimeoutMs;
    private final int sessionTimeoutMs;

    public String groupId() {
        return this.groupId;
    }

    public Some<String> groupInstanceId() {
        return this.groupInstanceId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientHost() {
        return this.clientHost;
    }

    public String memberId() {
        return this.memberId;
    }

    public String protocolType() {
        return this.protocolType;
    }

    public int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    public int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    @Test
    public void testMatchesSupportedProtocols() {
        .colon.colon protocols = new .colon.colon((Object)new Tuple2((Object)"range", (Object)new byte[0]), (List)Nil$.MODULE$);
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)protocols);
        Assert.assertTrue((boolean)member.matches((List)protocols));
        Assert.assertFalse((boolean)member.matches((List)new .colon.colon((Object)new Tuple2((Object)"range", (Object)new byte[]{0}), (List)Nil$.MODULE$)));
        Assert.assertFalse((boolean)member.matches((List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", (Object)new byte[0]), (List)Nil$.MODULE$)));
        Assert.assertFalse((boolean)member.matches((List)new .colon.colon((Object)new Tuple2((Object)"range", (Object)new byte[0]), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", (Object)new byte[0]), (List)Nil$.MODULE$))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testVoteForPreferredProtocol() {
        void apply_elems;
        void apply_elems2;
        .colon.colon protocols = new .colon.colon((Object)new Tuple2((Object)"range", (Object)new byte[0]), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", (Object)new byte[0]), (List)Nil$.MODULE$));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)protocols);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)"range", (Object)member.vote((Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems2)));
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"blah", "roundrobin"});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)"roundrobin", (Object)member.vote((Set)IterableFactory.apply$((IterableFactory)set$2, (Seq)apply_elems)));
    }

    @Test
    public void testMetadata() {
        .colon.colon protocols = new .colon.colon((Object)new Tuple2((Object)"range", (Object)new byte[]{0}), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", (Object)new byte[]{1}), (List)Nil$.MODULE$));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)protocols);
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{0}, member.metadata("range")));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1}, member.metadata("roundrobin")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMetadataRaisesOnUnsupportedProtocol() {
        .colon.colon protocols = new .colon.colon((Object)new Tuple2((Object)"range", (Object)new byte[0]), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", (Object)new byte[0]), (List)Nil$.MODULE$));
        new MemberMetadata(this.memberId(), this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)protocols).metadata("blah");
        Assert.fail();
    }

    /*
     * WARNING - void declaration
     */
    @Test(expected=IllegalArgumentException.class)
    public void testVoteRaisesOnNoSupportedProtocols() {
        void apply_elems;
        .colon.colon protocols = new .colon.colon((Object)new Tuple2((Object)"range", (Object)new byte[0]), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", (Object)new byte[0]), (List)Nil$.MODULE$));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"blah"});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        new MemberMetadata(this.memberId(), this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)protocols).vote((Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems));
        Assert.fail();
    }

    @Test
    public void testHasValidGroupInstanceId() {
        .colon.colon protocols = new .colon.colon((Object)new Tuple2((Object)"range", (Object)new byte[]{0}), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", (Object)new byte[]{1}), (List)Nil$.MODULE$));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)protocols);
        Assert.assertTrue((boolean)member.isStaticMember());
        Assert.assertEquals(this.groupInstanceId(), (Object)member.groupInstanceId());
    }

    public MemberMetadataTest() {
        this.groupId = "groupId";
        this.clientId = "clientId";
        this.clientHost = "clientHost";
        this.memberId = "memberId";
        this.protocolType = "consumer";
        this.rebalanceTimeoutMs = 60000;
        this.sessionTimeoutMs = 10000;
    }
}

