/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.File;
import java.util.Properties;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.controller.ZkReplicaStateMachine;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ResponseMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t\u0005e\u0001B'O\u0001MCQA\u0017\u0001\u0005\u0002mCqA\u0018\u0001A\u0002\u0013%q\fC\u0004d\u0001\u0001\u0007I\u0011\u00023\t\r)\u0004\u0001\u0015)\u0003a\u0011\u001dY\u0007\u00011A\u0005\n1Dqa\u001d\u0001A\u0002\u0013%A\u000f\u0003\u0004w\u0001\u0001\u0006K!\u001c\u0005\bo\u0002\u0001\r\u0011\"\u0003y\u0011\u001da\b\u00011A\u0005\nuDaa \u0001!B\u0013I\b\"CA\u0001\u0001\u0001\u0007I\u0011BA\u0002\u0011%\tY\u0001\u0001a\u0001\n\u0013\ti\u0001\u0003\u0005\u0002\u0012\u0001\u0001\u000b\u0015BA\u0003\u0011%\t\u0019\u0002\u0001b\u0001\n\u0013\t)\u0002\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\f\u0011%\ty\u0002\u0001b\u0001\n\u0013\t\t\u0003\u0003\u0005\u00020\u0001\u0001\u000b\u0011BA\u0012\u0011%\t\t\u0004\u0001b\u0001\n\u0013\t)\u0002\u0003\u0005\u00024\u0001\u0001\u000b\u0011BA\f\u0011%\t)\u0004\u0001b\u0001\n\u0013\t9\u0004\u0003\u0005\u0002P\u0001\u0001\u000b\u0011BA\u001d\u0011%\t\t\u0006\u0001b\u0001\n\u0013\t\u0019\u0006\u0003\u0005\u0002f\u0001\u0001\u000b\u0011BA+\u0011%\t9\u0007\u0001b\u0001\n\u0013\tI\u0007\u0003\u0005\u0002r\u0001\u0001\u000b\u0011BA6\u0011%\t\u0019\b\u0001b\u0001\n\u0013\t)\b\u0003\u0005\u0002z\u0001\u0001\u000b\u0011BA<\u0011\u001d\tY\b\u0001C\u0001\u0003{Bq!!$\u0001\t\u0013\ty\tC\u0004\u0002\u001a\u0002!\t!! \t\u000f\u0005\r\u0006\u0001\"\u0001\u0002~!9\u0011q\u0015\u0001\u0005\u0002\u0005u\u0004bBAV\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003_\u0003A\u0011AA?\u0011\u001d\t\u0019\f\u0001C\u0001\u0003{Bq!a.\u0001\t\u0003\ti\bC\u0004\u0002<\u0002!\t!! \t\u000f\u0005}\u0006\u0001\"\u0001\u0002~!9\u00111\u0019\u0001\u0005\u0002\u0005u\u0004bBAd\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003\u0017\u0004A\u0011AA?\u0011\u001d\ty\r\u0001C\u0001\u0003{Bq!a5\u0001\t\u0003\ti\bC\u0004\u0002X\u0002!\t!! \t\u000f\u0005m\u0007\u0001\"\u0001\u0002~!9\u0011q\u001c\u0001\u0005\u0002\u0005u\u0004bBAr\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003O\u0004A\u0011AA?\u0011\u001d\tY\u000f\u0001C\u0001\u0003{Bq!a<\u0001\t\u0003\ti\bC\u0004\u0002t\u0002!\t!! \t\u000f\u0005]\b\u0001\"\u0001\u0002~!9\u00111 \u0001\u0005\u0002\u0005u\u0004bBA\u0000\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0005\u0007\u0001A\u0011AA?\u0011\u001d\u00119\u0001\u0001C\u0001\u0003{BqAa\u0003\u0001\t\u0003\ti\bC\u0004\u0003\u0010\u0001!\t!! \t\u000f\tM\u0001\u0001\"\u0001\u0002~!9!q\u0003\u0001\u0005\u0002\u0005u\u0004b\u0002B\u000e\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0005?\u0001A\u0011AA?\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0003{BqAa\n\u0001\t\u0003\ti\bC\u0004\u0003,\u0001!\t!! \t\u000f\t=\u0002\u0001\"\u0001\u0002~!9!1\u0007\u0001\u0005\u0002\u0005u\u0004b\u0002B\u001c\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0005w\u0001A\u0011AA?\u0011\u001d\u0011y\u0004\u0001C\u0001\u0003{BqAa\u0011\u0001\t\u0003\ti\bC\u0004\u0003H\u0001!\t!! \t\u000f\t-\u0003\u0001\"\u0001\u0002~!9!q\n\u0001\u0005\u0002\u0005u\u0004b\u0002B*\u0001\u0011%!Q\u000b\u0005\b\u0005?\u0002A\u0011\u0002B1\u0005]\u0011V\r\u001d7jG\u0006\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f)\u0016\u001cHO\u0003\u0002P!\u0006Q1m\u001c8ue>dG.\u001a:\u000b\u0003E\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001)B\u0011Q\u000bW\u0007\u0002-*\tq+A\u0003tG\u0006d\u0017-\u0003\u0002Z-\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001/\u0011\u0005u\u0003Q\"\u0001(\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/F\u0001a!\ti\u0016-\u0003\u0002c\u001d\n\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0002+\r|g\u000e\u001e:pY2,'oQ8oi\u0016DHo\u0018\u0013fcR\u0011Q\r\u001b\t\u0003+\u001aL!a\u001a,\u0003\tUs\u0017\u000e\u001e\u0005\bS\u000e\t\t\u00111\u0001a\u0003\rAH%M\u0001\u0013G>tGO]8mY\u0016\u00148i\u001c8uKb$\b%\u0001\u0007n_\u000e\\'l[\"mS\u0016tG/F\u0001n!\tq\u0017/D\u0001p\u0015\t\u0001\b+\u0001\u0002{W&\u0011!o\u001c\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002!5|7m\u001b.l\u00072LWM\u001c;`I\u0015\fHCA3v\u0011\u001dIg!!AA\u00025\fQ\"\\8dWj[7\t\\5f]R\u0004\u0013\u0001I7pG.\u001cuN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\",\u0012!\u001f\t\u0003;jL!a\u001f(\u00039\r{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQ\u0006!Sn\\2l\u0007>tGO]8mY\u0016\u0014(I]8lKJ\u0014V-];fgR\u0014\u0015\r^2i?\u0012*\u0017\u000f\u0006\u0002f}\"9\u0011.CA\u0001\u0002\u0004I\u0018!I7pG.\u001cuN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\"\u0004\u0013a\u0005:fa2L7-Y*uCR,W*Y2iS:,WCAA\u0003!\ri\u0016qA\u0005\u0004\u0003\u0013q%a\u0005*fa2L7-Y*uCR,W*Y2iS:,\u0017a\u0006:fa2L7-Y*uCR,W*Y2iS:,w\fJ3r)\r)\u0017q\u0002\u0005\tS2\t\t\u00111\u0001\u0002\u0006\u0005!\"/\u001a9mS\u000e\f7\u000b^1uK6\u000b7\r[5oK\u0002\n\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0003\u0003/\u00012!VA\r\u0013\r\tYB\u0016\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003\u0019\u0019wN\u001c4jOV\u0011\u00111\u0005\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011\u0006)\u0002\rM,'O^3s\u0013\u0011\ti#a\n\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u0003=\u0019wN\u001c;s_2dWM]#q_\u000eD\u0017\u0001E2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195!\u0003%\u0001\u0018M\u001d;ji&|g.\u0006\u0002\u0002:A!\u00111HA&\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013AB2p[6|gNC\u0002R\u0003\u0007RA!!\u0012\u0002H\u00051\u0011\r]1dQ\u0016T!!!\u0013\u0002\u0007=\u0014x-\u0003\u0003\u0002N\u0005u\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013A\u00039beRLG/[8ogV\u0011\u0011Q\u000b\t\u0007\u0003/\n\t'!\u000f\u000e\u0005\u0005e#\u0002BA.\u0003;\n\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005}c+\u0001\u0006d_2dWm\u0019;j_:LA!a\u0019\u0002Z\t\u00191+Z9\u0002\u0017A\f'\u000f^5uS>t7\u000fI\u0001\be\u0016\u0004H.[2b+\t\tY\u0007E\u0002^\u0003[J1!a\u001cO\u0005M\u0001\u0016M\u001d;ji&|g.\u00118e%\u0016\u0004H.[2b\u0003!\u0011X\r\u001d7jG\u0006\u0004\u0013\u0001\u0003:fa2L7-Y:\u0016\u0005\u0005]\u0004CBA,\u0003C\nY'A\u0005sKBd\u0017nY1tA\u0005)1/\u001a;VaR\tQ\rK\u0002\u001d\u0003\u0003\u0003B!a!\u0002\n6\u0011\u0011Q\u0011\u0006\u0005\u0003\u000f\u000b9%A\u0003kk:LG/\u0003\u0003\u0002\f\u0006\u0015%A\u0002\"fM>\u0014X-\u0001\u0007sKBd\u0017nY1Ti\u0006$X\r\u0006\u0003\u0002\u0012\u0006]\u0005cA/\u0002\u0014&\u0019\u0011Q\u0013(\u0003\u0019I+\u0007\u000f\\5dCN#\u0018\r^3\t\u000f\u0005\u001dT\u00041\u0001\u0002l\u0005QB/Z:u'R\f'\u000f^;q\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]\"\u001aa$!(\u0011\t\u0005\r\u0015qT\u0005\u0005\u0003C\u000b)I\u0001\u0003UKN$\u0018a\u0007;fgR\u001cF/\u0019:ukB|eM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|g\u000eK\u0002 \u0003;\u000b1\u0005^3tiN#\u0018M\u001d;va^KG\u000f\u001b*fa2L7-Y,ji\"|W\u000f\u001e'fC\u0012,'\u000fK\u0002!\u0003;\u000bA\u0006^3ti:{g.\u001a=jgR,g\u000e\u001e*fa2L7-\u0019+p\u001d\u0016<(+\u001a9mS\u000e\fGK]1og&$\u0018n\u001c8)\u0007\u0005\ni*\u0001\u001cuKN$\u0018J\u001c<bY&$gj\u001c8fq&\u001cH/\u001a8u%\u0016\u0004H.[2b)>|e\u000e\\5oKJ+\u0007\u000f\\5dCR\u0013\u0018M\\:ji&|g\u000eK\u0002#\u0003;\u000bq\u0007^3ti&sg/\u00197jI:{g.\u001a=jgR,g\u000e\u001e*fa2L7-\u0019+p\u001f\u001a4G.\u001b8f%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007fA\u0012\u0002\u001e\u0006yD/Z:u\u0013:4\u0018\r\\5e\u001d>tW\r_5ti\u0016tGOU3qY&\u001c\u0017\rV8SKBd\u0017nY1EK2,G/[8o'R\f'\u000f^3e)J\fgn]5uS>t\u0007f\u0001\u0013\u0002\u001e\u0006\u0011E/Z:u\u0013:4\u0018\r\\5e\u001d>tW\r_5ti\u0016tGOU3qY&\u001c\u0017\rV8SKBd\u0017nY1EK2,G/[8o\u0013:,G.[4jE2,GK]1og&$\u0018n\u001c8)\u0007\u0015\ni*\u0001\"uKN$\u0018J\u001c<bY&$gj\u001c8fq&\u001cH/\u001a8u%\u0016\u0004H.[2b)>\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7+^2dKN\u001ch-\u001e7Ue\u0006t7/\u001b;j_:D3AJAO\u0003M\"Xm\u001d;J]Z\fG.\u001b3OK^\u0014V\r\u001d7jG\u0006$vNT8oKbL7\u000f^3oiJ+\u0007\u000f\\5dCR\u0013\u0018M\\:ji&|g\u000eK\u0002(\u0003;\u000bq\u0005^3ti:+wOU3qY&\u001c\u0017\rV8P]2Lg.\u001a*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\u001a\u0001&!(\u0002QQ,7\u000f\u001e(foJ+\u0007\u000f\\5dCR{wJ\u001a4mS:,'+\u001a9mS\u000e\fGK]1og&$\u0018n\u001c8)\u0007%\ni*A\u001cuKN$\u0018J\u001c<bY&$g*Z<SKBd\u0017nY1U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cF/\u0019:uK\u0012$&/\u00198tSRLwN\u001c\u0015\u0004U\u0005u\u0015A\u000f;fgRLeN^1mS\u0012tUm\u001e*fa2L7-\u0019+p%\u0016\u0004H.[2b\t\u0016dW\r^5p]&sW\r\\5hS\ndW\r\u0016:b]NLG/[8oQ\rY\u0013QT\u0001;i\u0016\u001cH/\u00138wC2LGMT3x%\u0016\u0004H.[2b)>\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7+^2dKN\u001ch-\u001e7Ue\u0006t7/\u001b;j_:D3\u0001LAO\u0003Y\"Xm\u001d;J]Z\fG.\u001b3P]2Lg.\u001a*fa2L7-\u0019+p\u001d>tW\r_5ti\u0016tGOU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\ri\u0013QT\u0001/i\u0016\u001cH/\u00138wC2LGm\u00148mS:,'+\u001a9mS\u000e\fGk\u001c(foJ+\u0007\u000f\\5dCR\u0013\u0018M\\:ji&|g\u000eK\u0002/\u0003;\u000b!\u0006^3ti>sG.\u001b8f%\u0016\u0004H.[2b)>|e\u000e\\5oKJ+\u0007\u000f\\5dCR\u0013\u0018M\\:ji&|g\u000eK\u00020\u0003;\u000b1\u0006^3ti>sG.\u001b8f%\u0016\u0004H.[2b)>|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0004a\u0005u\u0015A\u000f;fgRLeN^1mS\u0012|e\u000e\\5oKJ+\u0007\u000f\\5dCR{'+\u001a9mS\u000e\fG)\u001a7fi&|gn\u0015;beR,G\r\u0016:b]NLG/[8oQ\r\t\u0014QT\u0001>i\u0016\u001cH/\u00138wC2LGm\u00148mS:,'+\u001a9mS\u000e\fGk\u001c*fa2L7-\u0019#fY\u0016$\u0018n\u001c8J]\u0016d\u0017nZ5cY\u0016$&/\u00198tSRLwN\u001c\u0015\u0004e\u0005u\u0015!\u0010;fgRLeN^1mS\u0012|e\u000e\\5oKJ+\u0007\u000f\\5dCR{'+\u001a9mS\u000e\fG)\u001a7fi&|gnU;dG\u0016\u001c8OZ;m)J\fgn]5uS>t\u0007fA\u001a\u0002\u001e\u00069D/Z:u\u0013:4\u0018\r\\5e\u001f\u001a4G.\u001b8f%\u0016\u0004H.[2b)>tuN\\3ySN$XM\u001c;SKBd\u0017nY1Ue\u0006t7/\u001b;j_:D3\u0001NAO\u0003=\"Xm\u001d;J]Z\fG.\u001b3PM\u001ad\u0017N\\3SKBd\u0017nY1U_:+wOU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\r)\u0014QT\u0001,i\u0016\u001cHo\u00144gY&tWMU3qY&\u001c\u0017\rV8P]2Lg.\u001a*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\u001aa'!(\u0002iQ,7\u000f^(gM2Lg.\u001a*fa2L7-\u0019+p%\u0016\u0004H.[2b\t\u0016dW\r^5p]N#\u0018M\u001d;fIR\u0013\u0018M\\:ji&|g\u000eK\u00028\u0003;\u000bq\u0007^3ti>3g\r\\5oKJ+\u0007\u000f\\5dCR{'+\u001a9mS\u000e\fG)\u001a7fi&|g.\u00138fY&<\u0017N\u00197f)J\fgn]5uS>t\u0007f\u0001\u001d\u0002\u001e\u0006qD/Z:u\u0013:4\u0018\r\\5e\u001f\u001a4G.\u001b8f%\u0016\u0004H.[2b)>\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7+^2dKN\u001ch-\u001e7Ue\u0006t7/\u001b;j_:D3!OAO\u0003}\"Xm\u001d;J]Z\fG.\u001b3SKBd\u0017nY1EK2,G/[8o'R\f'\u000f^3e)>tuN\\3ySN$XM\u001c;SKBd\u0017nY1Ue\u0006t7/\u001b;j_:D3AOAO\u0003]\"Xm\u001d;J]Z\fG.\u001b3SKBd\u0017nY1EK2,G/[8o'R\f'\u000f^3e)>tUm\u001e*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\u001a1(!(\u0002uQ,7\u000f^%om\u0006d\u0017\u000e\u001a*fa2L7-\u0019#fY\u0016$\u0018n\u001c8Ti\u0006\u0014H/\u001a3U_>sG.\u001b8f%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007f\u0001\u001f\u0002\u001e\u0006YD/Z:u\u0013:4\u0018\r\\5e%\u0016\u0004H.[2b\t\u0016dW\r^5p]N#\u0018M\u001d;fIR{wJ\u001a4mS:,'+\u001a9mS\u000e\fGK]1og&$\u0018n\u001c8)\u0007u\ni*A uKN$(+\u001a9mS\u000e\fG)\u001a7fi&|gn\u0015;beR,G\rV8SKBd\u0017nY1EK2,G/[8o\u0013:,G.[4jE2,GK]1og&$\u0018n\u001c8)\u0007y\ni*A uKN$(+\u001a9mS\u000e\fG)\u001a7fi&|gn\u0015;beR,G\rV8SKBd\u0017nY1EK2,G/[8o'V\u001c7-Z:tMVdGK]1og&$\u0018n\u001c8)\u0007}\ni*A\u001euKN$(+\u001a9mS\u000e\fG)\u001a7fi&|gnU;dG\u0016\u001c8OZ;m)>tuN\\3ySN$XM\u001c;SKBd\u0017nY1Ue\u0006t7/\u001b;j_:D3\u0001QAO\u0003i\"Xm\u001d;J]Z\fG.\u001b3SKBd\u0017nY1EK2,G/[8o'V\u001c7-Z:tMVdGk\u001c(foJ+\u0007\u000f\\5dCR\u0013\u0018M\\:ji&|g\u000eK\u0002B\u0003;\u000bQ\b^3ti&sg/\u00197jIJ+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cVoY2fgN4W\u000f\u001c+p\u001f:d\u0017N\\3SKBd\u0017nY1Ue\u0006t7/\u001b;j_:D3AQAO\u0003y\"Xm\u001d;J]Z\fG.\u001b3SKBd\u0017nY1EK2,G/[8o'V\u001c7-Z:tMVdGk\\(gM2Lg.\u001a*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\u001a1)!(\u0002\rR,7\u000f^%om\u0006d\u0017\u000e\u001a*fa2L7-\u0019#fY\u0016$\u0018n\u001c8Tk\u000e\u001cWm]:gk2$vNU3qY&\u001c\u0017\rR3mKRLwN\\*uCJ$X\r\u001a+sC:\u001c\u0018\u000e^5p]\"\u001aA)!(\u0002\u0013R,7\u000f^%om\u0006d\u0017\u000e\u001a*fa2L7-\u0019#fY\u0016$\u0018n\u001c8Tk\u000e\u001cWm]:gk2$vNU3qY&\u001c\u0017\rR3mKRLwN\\%oK2Lw-\u001b2mKR\u0013\u0018M\\:ji&|g\u000eK\u0002F\u0003;\u000b!\t^3ti&sg/\u00197jIJ+\u0007\u000f\\5dC\u0012+G.\u001a;j_:Le.\u001a7jO&\u0014G.\u001a+p\u001d>tW\r_5ti\u0016tGOU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\r1\u0015QT\u0001;i\u0016\u001cH/\u00138wC2LGMU3qY&\u001c\u0017\rR3mKRLwN\\%oK2Lw-\u001b2mKR{g*Z<SKBd\u0017nY1Ue\u0006t7/\u001b;j_:D3aRAO\u0003Y\"Xm\u001d;SKBd\u0017nY1EK2,G/[8o\u0013:,G.[4jE2,Gk\\(oY&tWMU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\rA\u0015QT\u0001Gi\u0016\u001cH/\u00138wC2LGMU3qY&\u001c\u0017\rR3mKRLwN\\%oK2Lw-\u001b2mKR{'+\u001a9mS\u000e\fG)\u001a7fi&|gn\u0015;beR,G\r\u0016:b]NLG/[8oQ\rI\u0015QT\u0001Ji\u0016\u001cH/\u00138wC2LGMU3qY&\u001c\u0017\rR3mKRLwN\\%oK2Lw-\u001b2mKR{'+\u001a9mS\u000e\fG)\u001a7fi&|gnU;dG\u0016\u001c8OZ;m)J\fgn]5uS>t\u0007f\u0001&\u0002\u001e\u0006)B/Z:u\u0013:4\u0018\r\\5e)J\fgn]5uS>tG#B3\u0003X\tm\u0003b\u0002B-\u0017\u0002\u0007\u0011\u0011S\u0001\nMJ|Wn\u0015;bi\u0016DqA!\u0018L\u0001\u0004\t\t*A\u0004u_N#\u0018\r^3\u0002#I,\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0003\u0003d\t%\u0004cA/\u0003f%\u0019!q\r(\u0003#I+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000fC\u0004\u0002t1\u0003\rAa\u001b\u0011\r\t5$QPA\f\u001d\u0011\u0011yG!\u001f\u000f\t\tE$qO\u0007\u0003\u0005gR1A!\u001eS\u0003\u0019a$o\\8u}%\tq+C\u0002\u0003|Y\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002d\t}$b\u0001B>-\u0002")
public class ReplicaStateMachineTest {
    private ControllerContext controllerContext = null;
    private KafkaZkClient mockZkClient = null;
    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch = null;
    private ReplicaStateMachine replicaStateMachine = null;
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
    private final int controllerEpoch;
    private final TopicPartition partition = new TopicPartition("t", 0);
    private final scala.collection.immutable.Seq<TopicPartition> partitions = new .colon.colon((Object)this.partition(), (List)Nil$.MODULE$);
    private final PartitionAndReplica replica = new PartitionAndReplica(this.partition(), this.brokerId());
    private final scala.collection.immutable.Seq<PartitionAndReplica> replicas = new .colon.colon((Object)this.replica(), (List)Nil$.MODULE$);

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private void controllerContext_$eq(ControllerContext x$1) {
        this.controllerContext = x$1;
    }

    private KafkaZkClient mockZkClient() {
        return this.mockZkClient;
    }

    private void mockZkClient_$eq(KafkaZkClient x$1) {
        this.mockZkClient = x$1;
    }

    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch() {
        return this.mockControllerBrokerRequestBatch;
    }

    private void mockControllerBrokerRequestBatch_$eq(ControllerBrokerRequestBatch x$1) {
        this.mockControllerBrokerRequestBatch = x$1;
    }

    private ReplicaStateMachine replicaStateMachine() {
        return this.replicaStateMachine;
    }

    private void replicaStateMachine_$eq(ReplicaStateMachine x$1) {
        this.replicaStateMachine = x$1;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private scala.collection.immutable.Seq<TopicPartition> partitions() {
        return this.partitions;
    }

    private PartitionAndReplica replica() {
        return this.replica;
    }

    private scala.collection.immutable.Seq<PartitionAndReplica> replicas() {
        return this.replicas;
    }

    @Before
    public void setUp() {
        this.controllerContext_$eq(new ControllerContext());
        this.controllerContext().epoch_$eq(this.controllerEpoch());
        this.mockZkClient_$eq((KafkaZkClient)EasyMock.createMock(KafkaZkClient.class));
        this.mockControllerBrokerRequestBatch_$eq((ControllerBrokerRequestBatch)EasyMock.createMock(ControllerBrokerRequestBatch.class));
        this.replicaStateMachine_$eq((ReplicaStateMachine)new ZkReplicaStateMachine(this.config(), new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockZkClient(), this.mockControllerBrokerRequestBatch()));
    }

    private ReplicaState replicaState(PartitionAndReplica replica) {
        return this.controllerContext().replicaState(replica);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testStartupOnlinePartition() {
        void apply_elems;
        void $minus$greater$extension_y;
        EndPoint endpoint1 = new EndPoint("localhost", 9997, new ListenerName("blah"), SecurityProtocol.PLAINTEXT);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        Long l = 1L;
        Broker $minus$greater$extension_$this = new Broker(this.brokerId(), (Seq)new .colon.colon((Object)endpoint1, (List)Nil$.MODULE$), (Option)None$.MODULE$);
        Object var3_3 = null;
        l = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map liveBrokerEpochs = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        this.controllerContext().setLiveBrokers((Map)liveBrokerEpochs);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.controllerContext().replicaStates().get((Object)this.replica()));
        this.replicaStateMachine().startup();
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testStartupOfflinePartition() {
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.controllerContext().replicaStates().get((Object)this.replica()));
        this.replicaStateMachine().startup();
        Assert.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testStartupWithReplicaWithoutLeader() {
        void apply_elems;
        void $minus$greater$extension_y;
        int shutdownBrokerId = 100;
        PartitionAndReplica offlineReplica = new PartitionAndReplica(this.partition(), shutdownBrokerId);
        EndPoint endpoint1 = new EndPoint("localhost", 9997, new ListenerName("blah"), SecurityProtocol.PLAINTEXT);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        Long l = 1L;
        Broker $minus$greater$extension_$this = new Broker(this.brokerId(), (Seq)new .colon.colon((Object)endpoint1, (List)Nil$.MODULE$), (Option)None$.MODULE$);
        Object var5_5 = null;
        l = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map liveBrokerEpochs = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        this.controllerContext().setLiveBrokers((Map)liveBrokerEpochs);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{shutdownBrokerId}))));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.controllerContext().replicaStates().get((Object)offlineReplica));
        this.replicaStateMachine().startup();
        Assert.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState(offlineReplica));
    }

    @Test
    public void testNonexistentReplicaToNewReplicaTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)NewReplica$.MODULE$);
        Assert.assertEquals((Object)NewReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToOnlineReplicaTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OnlineReplica$.MODULE$);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToOfflineReplicaTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OfflineReplica$.MODULE$);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToReplicaDeletionStartedTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionStarted$.MODULE$);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToReplicaDeletionIneligibleTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToReplicaDeletionSuccessfulTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNewReplicaToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testNewReplicaToOnlineReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)NewReplica$.MODULE$);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OnlineReplica$.MODULE$);
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNewReplicaToOfflineReplicaTransition() {
        void apply_elems;
        void apply_elems2;
        void $minus$greater$extension_y;
        EndPoint endpoint1 = new EndPoint("localhost", 9997, new ListenerName("blah"), SecurityProtocol.PLAINTEXT);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        Long l = 1L;
        Broker $minus$greater$extension_$this = new Broker(this.brokerId(), (Seq)new .colon.colon((Object)endpoint1, (List)Nil$.MODULE$), (Option)None$.MODULE$);
        Object var3_3 = null;
        l = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map liveBrokerEpochs = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems2);
        this.controllerContext().setLiveBrokers((Map)liveBrokerEpochs);
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)NewReplica$.MODULE$);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addStopReplicaRequestForBrokers((Seq)EasyMock.eq((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), (TopicPartition)EasyMock.eq((Object)this.partition()), EasyMock.eq((boolean)false));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition()});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        this.mockControllerBrokerRequestBatch().addUpdateMetadataRequestForBrokers((Seq)EasyMock.eq((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), (Set)EasyMock.eq((Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockControllerBrokerRequestBatch()});
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OfflineReplica$.MODULE$);
        EasyMock.verify((Object[])new Object[]{this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNewReplicaToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidNewReplicaToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidNewReplicaToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOnlineReplicaToOnlineReplicaTransition() {
        void apply_elems;
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OnlineReplica$.MODULE$);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        List$ list$ = package$.MODULE$.List();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()});
        if (list$ == null) {
            throw null;
        }
        arraySeq = null;
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)IterableFactory.apply$((IterableFactory)list$, (scala.collection.immutable.Seq)apply_elems)), this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OnlineReplica$.MODULE$);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOnlineReplicaToOfflineReplicaTransition() {
        void apply_elems;
        void apply_elems2;
        void $minus$greater$extension_y;
        void apply_elems3;
        void apply_elems4;
        int otherBrokerId = this.brokerId() + 1;
        List$ list$ = package$.MODULE$.List();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId});
        if (list$ == null) {
            throw null;
        }
        arraySeq = null;
        List replicaIds = (List)IterableFactory.apply$((IterableFactory)list$, (scala.collection.immutable.Seq)apply_elems4);
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OnlineReplica$.MODULE$);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)replicaIds));
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), replicaIds);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addStopReplicaRequestForBrokers((Seq)EasyMock.eq((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), (TopicPartition)EasyMock.eq((Object)this.partition()), EasyMock.eq((boolean)false));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        List$ list$2 = package$.MODULE$.List();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId});
        if (list$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        LeaderAndIsr adjustedLeaderAndIsr = leaderAndIsr.newLeaderAndIsr(LeaderAndIsr$.MODULE$.NoLeader(), (List)IterableFactory.apply$((IterableFactory)list$2, (scala.collection.immutable.Seq)apply_elems3));
        LeaderAndIsr updatedLeaderAndIsr = adjustedLeaderAndIsr.withZkVersion(adjustedLeaderAndIsr.zkVersion() + 1);
        LeaderIsrAndControllerEpoch updatedLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch());
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        TopicPartition ArrowAssoc_self = this.partition();
        Object var16_11 = null;
        TopicPartition $minus$greater$extension_$this = ArrowAssoc_self;
        Object var9_12 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)adjustedLeaderAndIsr);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq3 = null;
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Right right = new Right((Object)updatedLeaderAndIsr);
        TopicPartition $minus$greater$extension_$this2 = this.partition();
        Object var10_15 = null;
        right = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq4 = null;
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems2), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems), (Seq)package$.MODULE$.Seq().empty()));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId})), this.partition(), updatedLeaderIsrAndControllerEpoch, this.replicaAssignment((scala.collection.immutable.Seq<Object>)replicaIds), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OfflineReplica$.MODULE$);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)updatedLeaderIsrAndControllerEpoch, (Object)this.controllerContext().partitionLeadershipInfo().apply((Object)this.partition()));
        Assert.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidOnlineReplicaToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    @Test
    public void testInvalidOfflineReplicaToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidOfflineReplicaToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOfflineReplicaToOnlineReplicaTransition() {
        void apply_elems;
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OfflineReplica$.MODULE$);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        List$ list$ = package$.MODULE$.List();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()});
        if (list$ == null) {
            throw null;
        }
        arraySeq = null;
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)IterableFactory.apply$((IterableFactory)list$, (scala.collection.immutable.Seq)apply_elems)), this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OnlineReplica$.MODULE$);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testOfflineReplicaToReplicaDeletionStartedTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OfflineReplica$.MODULE$);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addStopReplicaRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), true);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionStarted$.MODULE$);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)ReplicaDeletionStarted$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testOfflineReplicaToReplicaDeletionIneligibleTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OfflineReplica$.MODULE$);
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
        Assert.assertEquals((Object)ReplicaDeletionIneligible$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidOfflineReplicaToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToOnlineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)OnlineReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToOfflineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)OfflineReplica$.MODULE$);
    }

    @Test
    public void testReplicaDeletionStartedToReplicaDeletionIneligibleTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)ReplicaDeletionStarted$.MODULE$);
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
        Assert.assertEquals((Object)ReplicaDeletionIneligible$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testReplicaDeletionStartedToReplicaDeletionSuccessfulTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)ReplicaDeletionStarted$.MODULE$);
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
        Assert.assertEquals((Object)ReplicaDeletionSuccessful$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testReplicaDeletionSuccessfulToNonexistentReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)NonExistentReplica$.MODULE$);
        Assert.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)this.controllerContext().partitionReplicaAssignment(this.partition()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.controllerContext().replicaStates().get((Object)this.replica()));
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToOnlineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)OnlineReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToOfflineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)OfflineReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReplicaDeletionIneligibleToOnlineReplicaTransition() {
        void apply_elems;
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        List$ list$ = package$.MODULE$.List();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()});
        if (list$ == null) {
            throw null;
        }
        arraySeq = null;
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)IterableFactory.apply$((IterableFactory)list$, (scala.collection.immutable.Seq)apply_elems)), this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OnlineReplica$.MODULE$);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    private void testInvalidTransition(ReplicaState fromState, ReplicaState toState) {
        this.controllerContext().putReplicaState(this.replica(), fromState);
        this.replicaStateMachine().handleStateChanges(this.replicas(), toState);
        Assert.assertEquals((Object)fromState, (Object)this.replicaState(this.replica()));
    }

    private ReplicaAssignment replicaAssignment(scala.collection.immutable.Seq<Object> replicas) {
        Nil$ apply_removingReplicas = Nil$.MODULE$;
        Nil$ apply_addingReplicas = Nil$.MODULE$;
        return new ReplicaAssignment(replicas, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas);
    }

    public ReplicaStateMachineTest() {
        this.brokerId = 5;
        this.controllerEpoch = 50;
    }
}

